/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.io.File;
import org.apache.uima.UIMAFramework;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.CasProcessorFolder;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpModel;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.uima.CasConsumerConfiguration;
import org.apache.uima.caseditor.core.util.MarkerUtil;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ConsumerElement
extends AbstractNlpElement {
    private CasProcessorFolder mParent;
    private IFile mConsumerResource;
    private CasConsumerConfiguration mConsumerConfiguration;

    ConsumerElement(CasProcessorFolder config, IFile consumer) throws CoreException {
        this.mParent = config;
        this.mConsumerResource = consumer;
        this.mConsumerConfiguration = this.createConsumerConfiguration();
    }

    public CasConsumerConfiguration getConsumerConfiguration() {
        return this.mConsumerConfiguration;
    }

    private CasConsumerConfiguration createConsumerConfiguration() throws CoreException {
        CasConsumerDescription casConsumerDesciptor;
        Runnable clearMarkers = new Runnable(){

            public void run() {
                try {
                    MarkerUtil.clearMarkers((IResource)ConsumerElement.this.mConsumerResource, "org.apache.uima.caseditor.problem");
                }
                catch (CoreException e) {
                    CasEditorPlugin.log(e);
                }
            }
        };
        ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(clearMarkers);
        String dataPath = ((IFolder)this.mParent.getResource()).getLocation().toOSString();
        XMLInputSource inCasConsumer = new XMLInputSource(this.mConsumerResource.getContents(), new File(dataPath));
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        try {
            casConsumerDesciptor = (CasConsumerDescription)xmlParser.parse(inCasConsumer);
        }
        catch (InvalidXMLException e) {
            Runnable createMarker = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.createMarker((IResource)ConsumerElement.this.mConsumerResource, e);
                    }
                    catch (CoreException e2) {
                        CasEditorPlugin.log(e2);
                    }
                }
            };
            ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(createMarker);
            return null;
        }
        catch (ClassCastException e) {
            Runnable createMarker = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.createMarker((IResource)ConsumerElement.this.mConsumerResource, "This file must contain a cas consumer!");
                    }
                    catch (CoreException e2) {
                        CasEditorPlugin.log(e2);
                    }
                }
            };
            ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(createMarker);
            return null;
        }
        CasConsumerConfiguration trainerConfiguration = new CasConsumerConfiguration(this, casConsumerDesciptor);
        trainerConfiguration.setBaseFolder((IFolder)this.getParent().getResource());
        return trainerConfiguration;
    }

    void addResource(INlpElementDelta delta, IResource resource) {
    }

    void changedResource(IResource resource, INlpElementDelta delta) throws CoreException {
        this.mConsumerConfiguration = this.createConsumerConfiguration();
    }

    void removeResource(INlpElementDelta delta, IResource resource) {
    }

    public String getName() {
        return this.getResource().getName();
    }

    public NlpProject getNlpProject() {
        return this.getParent().getNlpProject();
    }

    public INlpElement getParent() {
        return this.mParent;
    }

    public IResource getResource() {
        return this.mConsumerResource;
    }
}

