/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.AnnotatorElement;
import org.apache.uima.caseditor.core.model.ConsumerElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasProcessorFolder
extends AbstractNlpElement
implements IAdaptable {
    private static final String CONSUMER_DESCRIPTOR_ID = "org.apache.uima.caseditor.CasConsumerDescriptor";
    private static final String ANALYSIS_ENGINE_DESCRIPTOR_ID = "org.apache.uima.caseditor.AnalysisEngineDescriptor";
    private IFolder mConfigFolder;
    private NlpProject mProject;
    private Collection<AnnotatorElement> mAnnotators;
    private Collection<ConsumerElement> mConsumers;

    CasProcessorFolder(IFolder configFolder, NlpProject project) throws CoreException {
        this.mConfigFolder = configFolder;
        this.mProject = project;
        this.createAnnotatorConfigurations();
        this.createConsumerConfigurations();
    }

    public Collection<AnnotatorElement> getAnnotators() {
        return this.mAnnotators;
    }

    private boolean isConsumerDescriptorFile(IResource resource) throws CoreException {
        IContentDescription contentDescription;
        boolean isConsumerDescritporFile = false;
        if (resource instanceof IFile && (contentDescription = ((IFile)resource).getContentDescription()) != null) {
            IContentType contentType = contentDescription.getContentType();
            isConsumerDescritporFile = contentType != null && CONSUMER_DESCRIPTOR_ID.equals(contentType.getId());
        }
        return isConsumerDescritporFile;
    }

    private boolean isAnalysisEngineDescriptorFile(IResource resource) throws CoreException {
        IContentDescription contentDescription;
        boolean isAnalysisEngineDescriptorFile = false;
        if (resource instanceof IFile && (contentDescription = ((IFile)resource).getContentDescription()) != null) {
            IContentType contentType = contentDescription.getContentType();
            isAnalysisEngineDescriptorFile = contentType != null && ANALYSIS_ENGINE_DESCRIPTOR_ID.equals(contentType.getId());
        }
        return isAnalysisEngineDescriptorFile;
    }

    private void createAnnotatorConfigurations() throws CoreException {
        this.mAnnotators = new LinkedList<AnnotatorElement>();
        for (IResource resource : this.mConfigFolder.members()) {
            if (!this.isAnalysisEngineDescriptorFile(resource)) continue;
            AnnotatorElement annotator = new AnnotatorElement(this, (IFile)resource);
            this.mAnnotators.add(annotator);
        }
    }

    public Collection<ConsumerElement> getConsumers() {
        return this.mConsumers;
    }

    private void createConsumerConfigurations() throws CoreException {
        this.mConsumers = new LinkedList<ConsumerElement>();
        for (IResource resource : this.mConfigFolder.members()) {
            if (!this.isConsumerDescriptorFile(resource)) continue;
            IFile consumerFile = (IFile)resource;
            ConsumerElement consumer = new ConsumerElement(this, consumerFile);
            this.mConsumers.add(consumer);
        }
    }

    public Collection<IResource> getNonNlpResources() throws CoreException {
        LinkedList<IResource> resources = new LinkedList<IResource>();
        for (IResource candidate : this.mConfigFolder.members()) {
            if (this.isConsumerDescriptorFile(candidate) || this.isAnalysisEngineDescriptorFile(candidate)) continue;
            resources.add(candidate);
        }
        return resources;
    }

    @Override
    public NlpProject getNlpProject() {
        return this.mProject;
    }

    @Override
    public INlpElement findMember(IResource resource) {
        if (this.getResource().equals(resource)) {
            return this;
        }
        Collection<ConsumerElement> consumers = this.getConsumers();
        for (ConsumerElement consumer : consumers) {
            boolean isElementFound = consumer.findMember(resource) != null;
            if (!isElementFound) continue;
            return consumer.findMember(resource);
        }
        Collection<AnnotatorElement> annotators = this.getAnnotators();
        for (AnnotatorElement annotator : annotators) {
            boolean isElementFound = annotator.findMember(resource) != null;
            if (!isElementFound) continue;
            return annotator.findMember(resource);
        }
        return null;
    }

    @Override
    public INlpElement getParent() {
        return this.mProject;
    }

    @Override
    public IResource getResource() {
        return this.mConfigFolder;
    }

    @Override
    public INlpElement getParent(IResource resource) throws CoreException {
        INlpElement result = super.getParent(resource);
        for (IResource member : this.mConfigFolder.members()) {
            if (!member.equals(resource)) continue;
            result = this;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.mConfigFolder.getName();
    }

    @Override
    void addResource(INlpElementDelta delta, IResource resource) throws CoreException {
        if (this.isConsumerDescriptorFile(resource)) {
            this.mConsumers.add(new ConsumerElement(this, (IFile)resource));
        } else if (this.isAnalysisEngineDescriptorFile(resource)) {
            this.mAnnotators.add(new AnnotatorElement(this, (IFile)resource));
        }
    }

    @Override
    void changedResource(IResource resource, INlpElementDelta delta) throws CoreException {
        block2: {
            block3: {
                if (!this.isConsumerDescriptorFile(resource)) break block3;
                for (ConsumerElement consumer : this.mConsumers) {
                    if (!consumer.getResource().equals(resource)) continue;
                    consumer.changedResource(resource, delta);
                    break block2;
                }
                break block2;
            }
            if (!this.isAnalysisEngineDescriptorFile(resource)) break block2;
            for (AnnotatorElement annotator : this.mAnnotators) {
                if (!annotator.getResource().equals(resource)) continue;
                annotator.changedResource(resource, delta);
                break;
            }
        }
    }

    @Override
    void removeResource(INlpElementDelta delta, IResource resource) throws CoreException {
        block2: {
            block3: {
                if (!this.isConsumerDescriptorFile(resource)) break block3;
                for (ConsumerElement consumer : this.mConsumers) {
                    if (!consumer.getResource().equals(resource)) continue;
                    this.mConsumers.remove(consumer);
                    break block2;
                }
                break block2;
            }
            if (!this.isAnalysisEngineDescriptorFile(resource)) break block2;
            for (AnnotatorElement annotator : this.mAnnotators) {
                if (!annotator.getResource().equals(resource)) continue;
                this.mAnnotators.remove(annotator);
                break;
            }
        }
    }
}

