/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.io.File;
import org.apache.uima.UIMAFramework;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.CasProcessorFolder;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpModel;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.uima.AnnotatorConfiguration;
import org.apache.uima.caseditor.core.util.MarkerUtil;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class AnnotatorElement
extends AbstractNlpElement {
    private CasProcessorFolder mParent;
    private IFile mAnnotatorResource;
    private AnnotatorConfiguration mAnnotatorConfig;

    AnnotatorElement(CasProcessorFolder config, IFile annotatorFile) {
        this.mParent = config;
        this.mAnnotatorResource = annotatorFile;
        this.mAnnotatorConfig = this.createAnnotatorConfiguration();
    }

    public AnnotatorConfiguration getAnnotatorConfiguration() {
        return this.mAnnotatorConfig;
    }

    private AnnotatorConfiguration createAnnotatorConfiguration() {
        ResourceSpecifier specifier;
        XMLInputSource inAnnotator;
        Runnable clearMarkers = new Runnable(){

            public void run() {
                try {
                    MarkerUtil.clearMarkers((IResource)AnnotatorElement.this.mAnnotatorResource, "org.apache.uima.caseditor.problem");
                }
                catch (CoreException e) {
                    CasEditorPlugin.log(e);
                }
            }
        };
        ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(clearMarkers);
        try {
            String dataPath = ((IFolder)this.mParent.getResource()).getLocation().toOSString();
            inAnnotator = new XMLInputSource(this.mAnnotatorResource.getContents(), new File(dataPath));
        }
        catch (CoreException e2) {
            Runnable createMarker = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.clearMarkers((IResource)AnnotatorElement.this.mAnnotatorResource, e2.getMessage());
                    }
                    catch (CoreException e) {
                        CasEditorPlugin.log(e);
                    }
                }
            };
            ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(createMarker);
            return null;
        }
        try {
            specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(inAnnotator);
        }
        catch (InvalidXMLException e) {
            Runnable createMarker = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.createMarker((IResource)AnnotatorElement.this.mAnnotatorResource, e.getMessage());
                    }
                    catch (CoreException e2) {
                        CasEditorPlugin.log(e2);
                    }
                }
            };
            ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(createMarker);
            return null;
        }
        AnnotatorConfiguration annotatorConfiguration = new AnnotatorConfiguration(this, specifier);
        annotatorConfiguration.setBaseFolder((IFolder)this.mParent.getResource());
        return annotatorConfiguration;
    }

    void addResource(INlpElementDelta delta, IResource resource) {
    }

    void changedResource(IResource resource, INlpElementDelta delta) throws CoreException {
        this.mAnnotatorConfig = this.createAnnotatorConfiguration();
    }

    void removeResource(INlpElementDelta delta, IResource resource) {
    }

    public String getName() {
        return this.getResource().getName();
    }

    public NlpProject getNlpProject() {
        return this.getParent().getNlpProject();
    }

    public INlpElement getParent() {
        return this.mParent;
    }

    public IResource getResource() {
        return this.mAnnotatorResource;
    }
}

