/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpus;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpusSerializer;
import org.apache.uima.caseditor.ide.TypeSystemLocationPropertyPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CasEditorIdePlugin
extends AbstractUIPlugin {
    public static final String ID = "org.apache.uima.caseditor.ide";
    private static CasEditorIdePlugin sPlugin;
    private ResourceBundle mResourceBundle;

    public CasEditorIdePlugin() {
        sPlugin = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        IProject[] projects;
        super.start(context);
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            IFile dotCorpusFile;
            String typeSystemLocation;
            if (!project.isOpen() || !project.hasNature("org.apache.uima.caseditor.NLPProject")) continue;
            try {
                typeSystemLocation = project.getPersistentProperty(new QualifiedName("", "UimaCasEditorTypeSystemPath"));
            }
            catch (CoreException e) {
                typeSystemLocation = null;
            }
            if (typeSystemLocation != null || !(dotCorpusFile = project.getFile(".corpus")).exists()) continue;
            InputStream dotCorpusIn = null;
            try {
                dotCorpusIn = dotCorpusFile.getContents();
            }
            catch (CoreException e) {
                CasEditorIdePlugin.log(e);
            }
            IFile typeSystemFile = null;
            if (dotCorpusIn != null) {
                try {
                    DotCorpus dotCorpus = DotCorpusSerializer.parseDotCorpus((InputStream)dotCorpusIn);
                    if (dotCorpus.getTypeSystemFileName() != null) {
                        typeSystemFile = project.getFile(dotCorpus.getTypeSystemFileName());
                    }
                }
                finally {
                    try {
                        dotCorpusIn.close();
                    }
                    catch (IOException e) {
                        CasEditorIdePlugin.log(e);
                    }
                }
            }
            if (typeSystemFile == null || !typeSystemFile.exists()) continue;
            TypeSystemLocationPropertyPage.setTypeSystemLocation(project, typeSystemFile.getFullPath().toString());
            try {
                dotCorpusFile.copy(project.getFile(typeSystemFile.getParent().getProjectRelativePath() + "/" + ".style-" + typeSystemFile.getName()).getFullPath(), true, null);
                CasEditorPlugin.getDefault().setShowMigrationDialog();
            }
            catch (CoreException e) {
                CasEditorIdePlugin.log(e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        sPlugin = null;
        this.mResourceBundle = null;
    }

    public static CasEditorIdePlugin getDefault() {
        return sPlugin;
    }

    public static void log(Throwable t) {
        CasEditorIdePlugin.getDefault().getLog().log((IStatus)new Status(4, ID, 0, t.getMessage(), t));
    }

    public static void logError(String message) {
        CasEditorIdePlugin.getDefault().getLog().log((IStatus)new Status(4, ID, message));
    }
}

