/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPMChunkTimeoutException;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.EOFToken;
import org.apache.uima.collection.impl.cpm.engine.WorkUnit;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.ChunkMetadata;
import org.apache.uima.collection.impl.cpm.utils.ExpirationTimer;
import org.apache.uima.util.Level;

public class SequencedQueue
extends BoundedWorkQueue {
    private boolean chunkState = false;
    private ChunkMetadata nextChunkMetadata = new ChunkMetadata("", 0, false);
    private HashMap timedOutDocs = new HashMap();
    protected ArrayList statusCbL = new ArrayList();

    public SequencedQueue(int aQueueSize, String aQueueName, CPMEngine aCpmEngine) {
        super(aQueueSize, aQueueName, aCpmEngine);
        this.statusCbL = aCpmEngine.getCallbackListeners();
    }

    private boolean sequenceTimedOut(ChunkMetadata achunkMetadata) {
        boolean returnVal = achunkMetadata != null && this.timedOutDocs.get(achunkMetadata.getDocId()) != null;
        return returnVal;
    }

    private Object timedOutCas(int aQueueIndex) {
        Object anObject = this.queue.remove(aQueueIndex);
        --this.numberElementsInQueue;
        this.notifyAll();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_chunk_state_false_timeout__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
        this.chunkState = false;
        this.nextChunkMetadata = new ChunkMetadata("", 0, false);
        if (anObject instanceof WorkUnit) {
            ((WorkUnit)anObject).setTimedOut();
        }
        return anObject;
    }

    public synchronized Object dequeue() {
        int chunkSequence;
        int queueSize;
        int queueIndex;
        Object anObject;
        block39: {
            if (this.numberElementsInQueue == 0) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_queue_empty__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                return null;
            }
            anObject = null;
            queueIndex = 0;
            queueSize = this.queue.size();
            chunkSequence = this.nextChunkMetadata.getSequence() + 1;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_expected_chunk_sequenece__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(chunkSequence)});
            }
            try {
                anObject = this.queue.get(queueIndex);
                if (anObject instanceof Object[] && ((Object[])anObject)[0] instanceof EOFToken) {
                    anObject = this.queue.remove(queueIndex);
                    --this.numberElementsInQueue;
                    this.notifyAll();
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_eof_token__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                    }
                    return anObject;
                }
                while (queueIndex < this.queue.size()) {
                    anObject = this.queue.get(queueIndex);
                    if (anObject instanceof WorkUnit && ((WorkUnit)anObject).get() instanceof CAS[]) {
                        ChunkMetadata chunkMetadata = CPMUtils.getChunkMetadata(((CAS[])((WorkUnit)anObject).get())[0]);
                        if (chunkMetadata == null) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_chunk_meta_is_null__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                            }
                            break;
                        }
                        if (chunkMetadata.isOneOfMany() && this.sequenceTimedOut(chunkMetadata)) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_sequence_timed_out__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(chunkMetadata.getSequence())});
                            }
                            return this.timedOutCas(queueIndex);
                        }
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_iscas__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                        }
                        if (this.chunkState) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_in_chunk_state__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), this.nextChunkMetadata.getDocId(), chunkMetadata.getDocId(), String.valueOf(chunkSequence), String.valueOf(chunkMetadata.getSequence())});
                            }
                            if (chunkMetadata.getSequence() == chunkSequence) {
                                if (chunkSequence > 1 && !this.nextChunkMetadata.getDocId().equalsIgnoreCase(chunkMetadata.getDocId())) {
                                    ++queueIndex;
                                    continue;
                                }
                                if (chunkMetadata.isLast()) {
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_change_chunk_state__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                                    }
                                    this.chunkState = false;
                                    this.nextChunkMetadata = new ChunkMetadata("", 0, false);
                                } else {
                                    this.nextChunkMetadata = chunkMetadata;
                                }
                                break;
                            }
                        } else {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_not_in_chunk_state__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                            }
                            if (!chunkMetadata.isOneOfMany()) break;
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_begin_chunk_state__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                            }
                            this.chunkState = true;
                            if (chunkMetadata.getSequence() == chunkSequence) {
                                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_in_chunk_state__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), this.nextChunkMetadata.getDocId(), chunkMetadata.getDocId(), String.valueOf(chunkSequence), String.valueOf(chunkMetadata.getSequence())});
                                }
                                if (this.sequenceTimedOut(chunkMetadata)) {
                                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_sequence_timed_out__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(chunkMetadata.getSequence())});
                                    }
                                    return this.timedOutCas(queueIndex);
                                }
                                this.nextChunkMetadata = chunkMetadata;
                                break;
                            }
                            this.nextChunkMetadata = new ChunkMetadata(chunkMetadata.getDocId(), 1, false);
                        }
                    } else {
                        if (anObject != null) {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_not_cas__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), anObject.getClass().getName()});
                            }
                        } else {
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_null_cas__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                            }
                            ++queueIndex;
                        }
                        break;
                    }
                    ++queueIndex;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) break block39;
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "", (Throwable)e);
            }
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_scanning_q__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
        if (queueIndex == queueSize) {
            if (chunkSequence > 0) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_expecte_seq_not_found__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.queue.size())});
                }
                this.nextChunkMetadata = new ChunkMetadata(this.nextChunkMetadata.getDocId(), chunkSequence - 1, false);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_expecte_seq_not_found__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.queue.size())});
            }
            return null;
        }
        anObject = this.queue.remove(queueIndex);
        --this.numberElementsInQueue;
        this.notifyAll();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_queue_capacity__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(queueSize), String.valueOf(this.numberElementsInQueue)});
        }
        return anObject;
    }

    public synchronized Object dequeue(long aTimeout) {
        Object resource = null;
        long startTime = System.currentTimeMillis();
        long expireTime = aTimeout == 0L ? Long.MAX_VALUE : startTime + aTimeout + 1L;
        resource = this.dequeue();
        if (resource == null) {
            try {
                long timeRemaining;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_for_chunk__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                if ((timeRemaining = expireTime - System.currentTimeMillis()) > 0L) {
                    this.wait(timeRemaining);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            resource = this.dequeue();
            if (resource == null && System.currentTimeMillis() > expireTime) {
                String docId = this.nextChunkMetadata.getDocId();
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_timedout_waiting_for_chunk__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), docId});
                }
                if (docId != null && docId.trim().length() > 0 && !this.timedOutDocs.containsKey(docId)) {
                    this.addDocToTimedOutDocs(10000, docId);
                    CPMChunkTimeoutException toe = new CPMChunkTimeoutException(Long.parseLong(docId), this.nextChunkMetadata.getThrottleID(), this.nextChunkMetadata.getURL());
                    EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(null);
                    enProcSt.addEventStatus("Process", "Failed", (Throwable)((Object)toe));
                    this.doNotifyListeners(null, enProcSt);
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_chunk_didnt_arrive__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(aTimeout)});
                }
                this.chunkState = false;
                this.nextChunkMetadata = new ChunkMetadata("", 0, false);
                return null;
            }
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_return_chunk__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.queueMaxSize), String.valueOf(this.numberElementsInQueue)});
        }
        return resource;
    }

    public synchronized void invalidate(CAS[] aCasObjectList) {
        for (int i = 0; aCasObjectList != null && i < aCasObjectList.length && aCasObjectList[i] != null; ++i) {
            ChunkMetadata meta = CPMUtils.getChunkMetadata(aCasObjectList[i]);
            if (meta == null || meta.getDocId().trim().length() <= 0 || meta.getSequence() <= 0) continue;
            if (!this.timedOutDocs.containsKey(meta.getDocId())) {
                this.addDocToTimedOutDocs(10000, meta.getDocId());
            }
            if (!meta.getDocId().equalsIgnoreCase(this.nextChunkMetadata.getDocId()) || !this.chunkState) continue;
            this.chunkState = false;
            this.nextChunkMetadata = new ChunkMetadata("", 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocToTimedOutDocs(int aLifespan, String aDocId) {
        ExpirationTimer eTimer = new ExpirationTimer(aLifespan, this.timedOutDocs, aDocId, this.cpm);
        HashMap hashMap = this.timedOutDocs;
        synchronized (hashMap) {
            this.timedOutDocs.put(aDocId, aDocId);
        }
        eTimer.start();
    }

    protected void doNotifyListeners(Object aCas, EntityProcessStatus aEntityProcStatus) {
        CAS casObjectCopy = (CAS)aCas;
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            StatusCallbackListener statCL = (StatusCallbackListener)this.statusCbL.get(j);
            CPMEngine.callEntityProcessCompleteWithCAS(statCL, casObjectCopy, aEntityProcStatus);
        }
    }
}

