/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.util.Date;
import java.util.LinkedList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.util.Level;

public class ServiceProxyPool {
    private LinkedList mAllInstances = new LinkedList();
    private LinkedList mFreeInstances = new LinkedList();

    public synchronized CasProcessor checkOut() {
        if (!this.mFreeInstances.isEmpty()) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checking_out_cp_from_pool__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            CasProcessor r = (CasProcessor)this.mFreeInstances.remove(0);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_pool_size__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.mAllInstances.size()), String.valueOf(this.mFreeInstances.size())});
            }
            return r;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_pool_empty__WARNING", new Object[]{Thread.currentThread().getName(), String.valueOf(this.mAllInstances.size()), String.valueOf(this.mFreeInstances.size())});
        }
        return null;
    }

    public synchronized void checkIn(CasProcessor aResource) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checking_in_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.mAllInstances.size()), String.valueOf(this.mFreeInstances.size())});
        }
        if (!this.mAllInstances.contains(aResource) || this.mFreeInstances.contains(aResource)) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checking_in_invalid_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            if (!this.mAllInstances.contains(aResource)) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_not_in_pool__FINEST", new Object[]{Thread.currentThread().getName()});
                }
            } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_already_checked_in__FINEST", new Object[]{Thread.currentThread().getName()});
            }
        } else {
            this.mFreeInstances.add(aResource);
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_pool_size__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.mAllInstances.size()), String.valueOf(this.mFreeInstances.size())});
        }
        this.notifyAll();
    }

    public synchronized CasProcessor checkOut(long aTimeout) {
        CasProcessor resource;
        long startTime = new Date().getTime();
        while ((resource = this.checkOut()) == null) {
            try {
                this.wait(aTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (aTimeout <= 0L || new Date().getTime() - startTime < aTimeout) continue;
            return null;
        }
        return resource;
    }

    public synchronized void destroy() {
        this.mAllInstances.clear();
        this.mFreeInstances.clear();
    }

    public synchronized int getSize() {
        return this.mFreeInstances.size();
    }

    public synchronized void addCasProcessor(CasProcessor aCasProcessor) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aCasProcessor.getProcessingResourceMetaData().getName()});
        }
        this.mAllInstances.add(aCasProcessor);
        this.mFreeInstances.add(aCasProcessor);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_pool_size__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.mAllInstances.size()), String.valueOf(this.mFreeInstances.size())});
        }
    }

    public synchronized int getAllInstanceCount() {
        return this.mAllInstances.size();
    }
}

