/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.logging.LogManager;
import junit.framework.Assert;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.test.junit_extension.PerformanceTestResult;
import org.apache.uima.test.junit_extension.PerformanceTestResultImpl;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;

public class AnnotatorPerformanceTester {
    private static HashMap logLevels = new HashMap(9);

    public static PerformanceTestResult runPerformanceTest(boolean repeatSingle, int numsToRun, File taeDescFilePath, File testFileDir, String dataPath, boolean doWarmup) throws Exception {
        PerformanceTestResultImpl result = new PerformanceTestResultImpl();
        Assert.assertNotNull((Object)taeDescFilePath);
        Assert.assertNotNull((Object)testFileDir);
        result.setRepeatSingleMode(repeatSingle);
        result.setDoWarmup(doWarmup);
        result.setNumsToRun(numsToRun);
        result.setAeDescFilePath(taeDescFilePath);
        result.setTestFileDir(testFileDir);
        result.setDatapath(dataPath);
        if (testFileDir == null || !testFileDir.isDirectory() || !testFileDir.canRead()) {
            throw new Exception("test file directory not valid");
        }
        Level defaultLogLevel = (Level)logLevels.get(LogManager.getLogManager().getProperty(".level"));
        if (defaultLogLevel == null) {
            defaultLogLevel = Level.INFO;
        }
        Logger logger = UIMAFramework.getLogger();
        logger.setLevel(Level.OFF);
        Timer globalTimer = new Timer();
        Timer initTimer = new Timer();
        Timer warmupTimer = new Timer();
        Timer ioTimer = new Timer();
        Timer processResetTimer = new Timer();
        Timer cleanupTimer = new Timer();
        Timer documentPreparationTimer = new Timer();
        globalTimer.start();
        initTimer.start();
        ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
        if (dataPath != null) {
            resMgr.setDataPath(dataPath);
        }
        AnalysisEngine ae = null;
        CAS cas = null;
        XMLInputSource in = new XMLInputSource(taeDescFilePath);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, (ResourceManager)resMgr, null);
        Assert.assertNotNull((Object)ae);
        cas = ae.newCAS();
        Assert.assertNotNull((Object)cas);
        cas.getTypeSystem().getFeatureByFullName("uima.tcas.DocumentAnnotation:language");
        initTimer.stop();
        result.setInitTime(initTimer.getTimeSpan());
        if (doWarmup) {
            warmupTimer.start();
            cas.setDocumentLanguage("en");
            cas.setDocumentText("This is a test sentence.");
            ae.process(cas);
            cas.reset();
            warmupTimer.stop();
            result.setWarmupTime(warmupTimer.getTimeSpan());
        }
        ioTimer.start();
        File[] inputFiles = testFileDir.listFiles(new FileFileFilter());
        String[] fileTexts = new String[inputFiles.length];
        String[] languages = new String[inputFiles.length];
        int numChars = 0;
        long fileSize = 0L;
        for (int i = 0; i < inputFiles.length; ++i) {
            languages[i] = inputFiles[i].getName().substring(0, 2);
            fileTexts[i] = FileUtils.file2String((File)inputFiles[i], (String)"UTF-8");
            fileSize += inputFiles[i].length();
            numChars += fileTexts[i].length();
        }
        ioTimer.stop();
        result.setNumberOfFiles(inputFiles.length);
        result.setNumberOfCharacters(numChars);
        result.setTotalFileSize(fileSize);
        result.setIoTime(ioTimer.getTimeSpan());
        int numAnnot = 0;
        if (repeatSingle) {
            for (int i = 0; i < fileTexts.length; ++i) {
                for (int j = 0; j < numsToRun; ++j) {
                    documentPreparationTimer.start();
                    cas.setDocumentLanguage(languages[i]);
                    cas.setDocumentText(fileTexts[i]);
                    documentPreparationTimer.stop();
                    processResetTimer.start();
                    ae.process(cas);
                    processResetTimer.stop();
                    documentPreparationTimer.start();
                    numAnnot += cas.getAnnotationIndex().size();
                    cas.reset();
                    documentPreparationTimer.stop();
                }
            }
        } else {
            for (int j = 0; j < numsToRun; ++j) {
                for (int i = 0; i < fileTexts.length; ++i) {
                    documentPreparationTimer.start();
                    cas.setDocumentLanguage(languages[i]);
                    cas.setDocumentText(fileTexts[i]);
                    documentPreparationTimer.stop();
                    processResetTimer.start();
                    ae.process(cas);
                    processResetTimer.stop();
                    documentPreparationTimer.start();
                    numAnnot += cas.getAnnotationIndex().size();
                    cas.reset();
                    documentPreparationTimer.stop();
                }
            }
        }
        cleanupTimer.start();
        ae.destroy();
        ae = null;
        cleanupTimer.stop();
        globalTimer.stop();
        result.setNumberOfCreatedAnnotations(numAnnot);
        result.setOverallTime(globalTimer.getTimeSpan());
        result.setProcessingTime(processResetTimer.getTimeSpan());
        result.setCleanupTime(cleanupTimer.getTimeSpan());
        result.setDocumentPreparationTime(documentPreparationTimer.getTimeSpan());
        logger.setLevel(defaultLogLevel);
        return result;
    }

    static {
        logLevels.put("OFF", Level.OFF);
        logLevels.put("SEVERE", Level.SEVERE);
        logLevels.put("WARNING", Level.WARNING);
        logLevels.put("INFO", Level.INFO);
        logLevels.put("CONFIG", Level.CONFIG);
        logLevels.put("FINE", Level.FINE);
        logLevels.put("FINER", Level.FINER);
        logLevels.put("FINEST", Level.FINEST);
        logLevels.put("ALL", Level.ALL);
    }

    private static class FileFileFilter
    implements FileFilter {
        private FileFileFilter() {
        }

        public boolean accept(File arg0) {
            return arg0.isFile();
        }
    }
}

