/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.aae.error.UimaASPingTimeout;
import org.apache.uima.aae.error.UimaASProcessCasTimeout;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;

public class ClientServiceDelegate
extends Delegate {
    private static final Class CLASS_NAME = ClientServiceDelegate.class;
    private BaseUIMAAsynchronousEngineCommon_impl clientUimaAsEngine;
    private String applicationName = "UimaAsClient";
    private volatile boolean usesSynchronousAPI;
    private Destination freeCasDestination = null;
    private Object errorMux = new Object();
    private volatile boolean pingTimeout = false;

    public ClientServiceDelegate(String serviceName, String anApplicationName, BaseUIMAAsynchronousEngineCommon_impl engine) {
        this.delegateKey = serviceName;
        this.clientUimaAsEngine = engine;
        if (anApplicationName != null && anApplicationName.trim().length() > 0) {
            this.applicationName = anApplicationName;
        }
    }

    public boolean isSynchronousAPI() {
        return this.usesSynchronousAPI;
    }

    public boolean isPingTimeout() {
        return this.pingTimeout;
    }

    public void resetPingTimeout() {
        this.pingTimeout = false;
    }

    public void setSynchronousAPI() {
        this.usesSynchronousAPI = true;
    }

    public Destination getFreeCasDestination() {
        return this.freeCasDestination;
    }

    public void setFreeCasDestination(Destination freeCasDestination) {
        this.freeCasDestination = freeCasDestination;
    }

    public String getComponentName() {
        return this.applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Exception e, ErrorContext errorContext) {
        String casReferenceId = null;
        CAS cas = null;
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cachedRequest = null;
        casReferenceId = (String)errorContext.get("CasReference");
        Object object = this.errorMux;
        synchronized (object) {
            block30: {
                if (!this.clientUimaAsEngine.running) {
                    this.cancelDelegateTimer();
                    return;
                }
                int command = (Integer)errorContext.get("Command");
                try {
                    if (!(e instanceof MessageTimeoutException)) break block30;
                    switch (command) {
                        case 2000: {
                            if (casReferenceId != null) {
                                cachedRequest = this.clientUimaAsEngine.clientCache.get(casReferenceId);
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING) && this.getEndpoint() != null) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAJMS_process_timeout_WARNING", new Object[]{this.getEndpoint().getEndpoint(), this.clientUimaAsEngine.getBrokerURI(), cachedRequest.getHostIpProcessingCAS()});
                                }
                                if (cachedRequest != null && cachedRequest.isRemote()) {
                                    cas = cachedRequest.getCAS();
                                }
                                boolean isPingTimeout = false;
                                if (errorContext.containsKey("Cause")) {
                                    boolean bl = isPingTimeout = 5001 == (Integer)errorContext.get("Cause");
                                }
                                if (isPingTimeout && this.isAwaitingPingReply()) {
                                    if (this.clientUimaAsEngine.state != BaseUIMAAsynchronousEngineCommon_impl.ClientState.RECONNECTING) {
                                        this.resetAwaitingPingReply();
                                    }
                                    this.pingTimeout = true;
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_ping_timed_out__WARNING", new Object[]{this.getKey()});
                                    this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 3, casReferenceId);
                                } else {
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_process_timeout__WARNING", new Object[]{super.getCasProcessTimeout()});
                                    }
                                    this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 3, casReferenceId);
                                }
                            }
                            this.clientUimaAsEngine.clientSideJmxStats.incrementProcessTimeoutErrorCount();
                            break;
                        }
                        case 2001: {
                            if (this.isAwaitingPingReply()) {
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_ping_timed_out__WARNING", new Object[]{this.clientUimaAsEngine.getEndPointName(), this.getCasPendingDispatchListSize(), this.getCasPendingReplyListSize()});
                                }
                                super.resetAwaitingPingReply();
                                List<Delegate.DelegateEntry> isPingTimeout = this.pendingDispatchList;
                                synchronized (isPingTimeout) {
                                    Iterator<Delegate.DelegateEntry> it = this.getDelegateCasesPendingDispatch().iterator();
                                    while (this.clientUimaAsEngine.running && it.hasNext()) {
                                        Delegate.DelegateEntry de = it.next();
                                        cachedRequest = this.clientUimaAsEngine.getCache().get(de.getCasReferenceId());
                                        if (cachedRequest != null) {
                                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_reject_by_forced_timeout__WARNING", new Object[]{de.getCasReferenceId(), String.valueOf(cachedRequest.getCAS().hashCode())});
                                            }
                                            try {
                                                this.clientUimaAsEngine.handleException(new UimaASProcessCasTimeout("Service Not Responding to Ping - CAS:" + de.getCasReferenceId(), new UimaASPingTimeout("Forced Timeout on CAS in PendingDispatch list. The CAS Has Not Been Dispatched since the Service Appears to be Unavailable")), de.getCasReferenceId(), null, cachedRequest, !cachedRequest.isSynchronousInvocation(), false);
                                            }
                                            catch (Exception ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                        if (!this.clientUimaAsEngine.running) continue;
                                        it.remove();
                                    }
                                    break;
                                }
                            }
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_meta_timeout_WARNING", new Object[]{this.getKey()});
                            }
                            this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 1, casReferenceId);
                            this.clientUimaAsEngine.clientSideJmxStats.incrementMetaTimeoutErrorCount();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block30;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                }
            }
            if (cas != null && !cachedRequest.isSynchronousInvocation()) {
                cas.release();
            }
        }
    }

    public String enrichProcessCASTimeoutMessage(int aCommand, String casReferenceId, long timeToWait, String timeoutMessage) {
        StringBuffer sb = new StringBuffer(timeoutMessage);
        try {
            BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cr;
            if (casReferenceId != null && this.clientUimaAsEngine.getCache().containsKey(casReferenceId) && (cr = this.clientUimaAsEngine.getCache().get(casReferenceId)) != null) {
                sb.append(". Process CAS on host: " + cr.getHostIpProcessingCAS() + " exceeded configured timeout threshold of " + timeToWait + " ms");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

