/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.jms.client.BaseMessageSender;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.util.Level;

public class ActiveMQMessageSender
extends BaseMessageSender {
    private static final Class CLASS_NAME = ActiveMQMessageSender.class;
    private volatile Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private String destinationName = null;
    private ConcurrentHashMap<Destination, MessageProducer> producerMap = new ConcurrentHashMap();

    public ActiveMQMessageSender(Connection aConnection, String aDestinationName, BaseUIMAAsynchronousEngineCommon_impl engine) throws Exception {
        super(engine);
        this.connection = aConnection;
        this.destinationName = aDestinationName;
    }

    public synchronized MessageProducer getMessageProducer(Destination destination) throws Exception {
        if (this.producerMap.containsKey(destination)) {
            return this.producerMap.get(destination);
        }
        this.createSession();
        MessageProducer mProducer = this.session.createProducer(destination);
        mProducer.setDeliveryMode(1);
        this.producerMap.put(destination, mProducer);
        return mProducer;
    }

    public void setConnection(Connection aConnection) {
        block2: {
            this.connection = aConnection;
            this.cleanup();
            try {
                this.initializeProducer();
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "setConnection", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    private String getBrokerURL() {
        try {
            return ((ActiveMQConnection)this.connection).getBrokerInfo().getBrokerURL();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void createSession() throws Exception {
        String broker = this.getBrokerURL();
        try {
            if (this.session == null || !this.engine.producerInitialized) {
                this.session = this.connection.createSession(false, 1);
            }
        }
        catch (JMSException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_failed_creating_session_INFO", new Object[]{this.destinationName, broker});
            }
            if (this.connection == null) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_connection_not_ready_INFO", new Object[]{broker});
                }
            } else if ((((ActiveMQConnection)this.connection).isClosed() || ((ActiveMQConnection)this.connection).isClosing()) && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_connection_closed_INFO", new Object[]{this.destinationName, broker});
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void initializeProducer() throws Exception {
        this.createSession();
        this.producer = this.getMessageProducer((Destination)this.session.createQueue(this.destinationName));
    }

    protected String getDestinationEndpoint() throws Exception {
        return ((ActiveMQDestination)this.producer.getDestination()).getPhysicalName();
    }

    public MessageProducer getMessageProducer() {
        block3: {
            if (this.engine.running && !this.engine.producerInitialized) {
                try {
                    this.setConnection(this.engine.lookupConnection(this.getBrokerURL()).getConnection());
                    this.initializeProducer();
                    this.engine.producerInitialized = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "getMessageProducer", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
        return this.producer;
    }

    public TextMessage createTextMessage() throws Exception {
        if (this.session == null) {
            this.initializeProducer();
        }
        return this.session.createTextMessage("");
    }

    public BytesMessage createBytesMessage() throws Exception {
        if (this.session == null) {
            this.initializeProducer();
        }
        return this.session.createBytesMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.producer != null) {
                this.producer.close();
                this.producer = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.producerMap.clear();
        }
    }
}

