/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UIDGenerator;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.ControllerLifecycle;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.UimacppServiceController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.adapter.jms.activemq.JmsInputChannel;
import org.apache.uima.adapter.jms.activemq.JmsOutputChannel;
import org.apache.uima.adapter.jms.activemq.TempDestinationResolver;
import org.apache.uima.adapter.jms.activemq.UimaDefaultMessageListenerContainer;
import org.apache.uima.adapter.jms.activemq.UimaEEAdminSpringContext;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringContainerDeployer
implements ControllerCallbackListener {
    private static final Class CLASS_NAME = SpringContainerDeployer.class;
    private static final int MAX_PREFETCH_FOR_CAS_NOTIFICATION_Q = 10;
    public static final int QUIESCE_AND_STOP = 1000;
    public static final int STOP_NOW = 1001;
    private volatile boolean serviceInitializationCompleted;
    private volatile boolean serviceInitializationException;
    private Semaphore serviceInitializationSemaphore = new Semaphore(1);
    private ConcurrentHashMap springContainerRegistry = null;
    private FileSystemXmlApplicationContext context = null;
    private Object mux = new Object();
    private AnalysisEngineController topLevelController = null;
    private Exception cause = null;

    public SpringContainerDeployer() {
    }

    public SpringContainerDeployer(ConcurrentHashMap aSpringContainerRegistry) {
        this.springContainerRegistry = aSpringContainerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UimaDefaultMessageListenerContainer produceListenerConnector(ActiveMQConnectionFactory cf, AnalysisEngineController ctrl) {
        TempDestinationResolver resolver = new TempDestinationResolver();
        UimaDefaultMessageListenerContainer connector = new UimaDefaultMessageListenerContainer(true);
        connector.setConnectionFactory((ConnectionFactory)cf);
        connector.setConcurrentConsumers(1);
        connector.setDestinationResolver(resolver);
        connector.setController(ctrl);
        connector.setMessageListener((JmsInputChannel)ctrl.getInputChannel());
        connector.initializeContainer();
        connector.getDestination();
        connector.afterPropertiesSet(false);
        connector.start();
        Object object = this.mux;
        synchronized (object) {
            while (connector.getListenerEndpoint() == null) {
                try {
                    this.mux.wait(50L);
                }
                catch (InterruptedException e) {}
            }
        }
        return connector;
    }

    private ActiveMQConnectionFactory getTopLevelQueueConnectionFactory(ApplicationContext ctx) {
        ActiveMQConnectionFactory factory = null;
        String[] inputChannelBeanIds = ctx.getBeanNamesForType(JmsInputChannel.class);
        Object beanId = null;
        for (int i = 0; i < inputChannelBeanIds.length; ++i) {
            JmsInputChannel inputChannel = (JmsInputChannel)ctx.getBean(inputChannelBeanIds[i]);
            if (!inputChannel.getName().startsWith("top_level_input_queue_service")) continue;
            while ((factory = inputChannel.getConnectionFactory()) == null) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception e) {}
            }
            break;
        }
        return factory;
    }

    private ActiveMQPrefetchPolicy getPrefetchPolicy(int aPrefetchSize) {
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(aPrefetchSize);
        return prefetchPolicy;
    }

    private ActiveMQConnectionFactory getNewConnectionFactory(ApplicationContext ctx) throws Exception {
        ActiveMQConnectionFactory factory = this.getTopLevelQueueConnectionFactory(ctx);
        if (factory != null) {
            String brokerURL = factory.getBrokerURL();
            factory = new ActiveMQConnectionFactory(brokerURL);
        }
        return factory;
    }

    private int getConcurrentConsumerCount(ApplicationContext ctx) {
        String[] listenerBeanIds = ctx.getBeanNamesForType(UimaDefaultMessageListenerContainer.class);
        Object beanId = null;
        int concurrentConsumerCount = -1;
        for (int i = 0; i < listenerBeanIds.length; ++i) {
            UimaDefaultMessageListenerContainer lsnr = (UimaDefaultMessageListenerContainer)((Object)ctx.getBean(listenerBeanIds[i]));
            if (!lsnr.getDestinationName().startsWith("asynAggr_retQ")) continue;
            return lsnr.getConcurrentConsumers();
        }
        return -1;
    }

    public AnalysisEngineController getTopLevelController() {
        return this.topLevelController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTopLevelController(AnalysisEngineController cntlr, ApplicationContext ctx) throws Exception {
        ((FileSystemXmlApplicationContext)ctx).setDisplayName(cntlr.getComponentName());
        cntlr.addControllerCallbackListener(this);
        String inputQueueName = cntlr.getServiceEndpointName();
        if (inputQueueName != null) {
            if (ctx.containsBean(inputQueueName)) {
                ActiveMQQueue queue = (ActiveMQQueue)ctx.getBean(inputQueueName);
                if (cntlr.getServiceInfo() != null) {
                    cntlr.getServiceInfo().setInputQueueName(queue.getQueueName());
                }
            } else if (cntlr.getServiceInfo() != null) {
                cntlr.getServiceInfo().setInputQueueName(inputQueueName);
            }
        }
        if (cntlr.isCasMultiplier()) {
            ActiveMQConnectionFactory cf = this.getNewConnectionFactory(ctx);
            ActiveMQPrefetchPolicy prefetchPolicy = this.getPrefetchPolicy(10);
            cf.setPrefetchPolicy(prefetchPolicy);
            UimaDefaultMessageListenerContainer connector = this.produceListenerConnector(cf, cntlr);
            ((JmsInputChannel)cntlr.getInputChannel()).setListenerContainer(connector);
            ((JmsOutputChannel)cntlr.getOutputChannel()).setFreeCasQueue(connector.getListenerEndpoint());
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initializeTopLevelController", "jms_adapter_messages", "UIMAJMS_activated_fcq__CONFIG", new Object[]{cntlr.getComponentName(), connector.getEndpointName()});
            }
        }
        if (cntlr instanceof AggregateAnalysisEngineController) {
            Map destinationMap = ((AggregateAnalysisEngineController)cntlr).getDestinations();
            Set set = destinationMap.entrySet();
            for (Map.Entry entry : set) {
                Endpoint endpoint = (Endpoint)entry.getValue();
                if (endpoint == null || !endpoint.isTempReplyDestination()) continue;
                while (!endpoint.replyDestinationFailed() && endpoint.getDestination() == null) {
                    Endpoint endpoint2 = endpoint;
                    synchronized (endpoint2) {
                        try {
                            endpoint.wait(200L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                Delegate delegate = ((AggregateAnalysisEngineController)cntlr).lookupDelegate(endpoint.getDelegateKey());
                int cc = 1;
                if (delegate != null) {
                    cc = delegate.getEndpoint().getConcurrentReplyConsumers();
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "initializeTopLevelController", "jms_adapter_messages", "UIMAJMS_replyq__INFO", new Object[]{endpoint.getDelegateKey(), endpoint.getDestination(), cc});
            }
            int concurrentConsumerCountOnReplies = this.getConcurrentConsumerCount(ctx);
            ((AggregateAnalysisEngineController)cntlr).initializeVMTransport(concurrentConsumerCountOnReplies);
            ((AggregateAnalysisEngineController)cntlr).sendRequestForMetadataToRemoteDelegates();
        }
    }

    private String initializeContainer(ApplicationContext ctx) throws Exception {
        this.serviceInitializationCompleted = false;
        this.serviceInitializationException = false;
        UimaEEAdminSpringContext springAdminContext = new UimaEEAdminSpringContext((FileSystemXmlApplicationContext)ctx);
        String[] controllers = ctx.getBeanNamesForType(AnalysisEngineController.class);
        for (int i = 0; controllers != null && i < controllers.length; ++i) {
            AnalysisEngineController cntlr = (AnalysisEngineController)ctx.getBean(controllers[i]);
            if (cntlr instanceof UimacppServiceController) {
                cntlr.addControllerCallbackListener(this);
                this.topLevelController = cntlr;
                continue;
            }
            cntlr.setUimaEEAdminContext(springAdminContext);
            if (!cntlr.isTopLevelComponent()) continue;
            this.topLevelController = cntlr;
            this.initializeTopLevelController(cntlr, ctx);
        }
        try {
            this.serviceInitializationSemaphore.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.waitForServiceNotification();
            this.startListeners();
        }
        catch (Exception e) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initializeContainer", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            String[] asyncServiceList = ctx.getBeanNamesForType(ControllerLifecycle.class);
            if (asyncServiceList != null && asyncServiceList.length > 0) {
                ControllerLifecycle ctrer = (ControllerLifecycle)ctx.getBean(asyncServiceList[0]);
                if (ctrer instanceof AnalysisEngineController) {
                    ((AnalysisEngineController)ctrer).getControllerLatch().release();
                }
                ctrer.terminate();
            }
            if (ctx instanceof FileSystemXmlApplicationContext) {
                ((FileSystemXmlApplicationContext)ctx).destroy();
            }
            throw e;
        }
        String containerId = new UIDGenerator().nextId();
        if (this.springContainerRegistry != null) {
            this.springContainerRegistry.put(containerId, springAdminContext);
        }
        return containerId;
    }

    private void doStartListeners(String[] listeners, FileSystemXmlApplicationContext ctx) throws Exception {
        for (int i = 0; listeners != null && i < listeners.length; ++i) {
            UimaDefaultMessageListenerContainer listener = (UimaDefaultMessageListenerContainer)((Object)ctx.getBean(listeners[i]));
            if (listener == null || listener.isRunning()) continue;
            if (this.topLevelController != null) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "doStartListeners", "jms_adapter_messages", "UIMAJMS_starting_listener__INFO", new Object[]{this.topLevelController.getComponentName(), listener.getDestination(), listener.getMessageSelector(), listener.getBrokerUrl()});
                }
                this.topLevelController.changeState(BaseAnalysisEngineController.ServiceState.RUNNING);
            }
            listener.start();
        }
    }

    public void startListeners() throws Exception {
        if (this.springContainerRegistry == null || this.springContainerRegistry.size() == 0) {
            if (this.context != null) {
                String[] listeners = this.context.getBeanNamesForType(UimaDefaultMessageListenerContainer.class);
                this.doStartListeners(listeners, this.context);
            }
        } else {
            for (String id : this.springContainerRegistry.keySet()) {
                FileSystemXmlApplicationContext ctx;
                UimaEEAdminSpringContext springAdminContext = (UimaEEAdminSpringContext)this.springContainerRegistry.get(id);
                if (springAdminContext == null || (ctx = (FileSystemXmlApplicationContext)springAdminContext.getSpringContainer()) == null) continue;
                String[] listeners = ctx.getBeanNamesForType(UimaDefaultMessageListenerContainer.class);
                this.doStartListeners(listeners, ctx);
            }
        }
    }

    public String deploy(String springContextFile) throws ResourceInitializationException {
        if (springContextFile == null) {
            throw new ResourceInitializationException((Throwable)new Exception("Spring Context File Not Specified"));
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_deploy_container__CONFIG", new Object[]{springContextFile});
        }
        try {
            if (!springContextFile.startsWith("file:")) {
                springContextFile = "file:" + springContextFile;
            }
            this.context = new FileSystemXmlApplicationContext(springContextFile);
            return this.initializeContainer((ApplicationContext)this.context);
        }
        catch (ResourceInitializationException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public String deploy(String[] springContextFiles) throws ResourceInitializationException {
        if (springContextFiles == null) {
            throw new ResourceInitializationException((Throwable)new Exception("Spring Context File List is Empty"));
        }
        for (int i = 0; i < springContextFiles.length; ++i) {
            if (!springContextFiles[i].startsWith("file:")) {
                springContextFiles[i] = "file:" + springContextFiles[i];
            }
            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) continue;
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_deploy_container__CONFIG", new Object[]{springContextFiles[i]});
        }
        try {
            this.context = new FileSystemXmlApplicationContext(springContextFiles);
            return this.initializeContainer((ApplicationContext)this.context);
        }
        catch (ResourceInitializationException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "deploy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void undeploy(int stop_level) throws Exception {
        switch (stop_level) {
            case 1000: {
                this.getTopLevelController().quiesceAndStop();
                break;
            }
            case 1001: {
                this.getTopLevelController().terminate();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported argument value in the undeploy() call. Please use stop level 1000 OR 1001 as an argument to undeploy() method.");
            }
        }
        if (this.context != null) {
            this.context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForServiceNotification() throws Exception {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "waitForServiceNotification", "jms_adapter_messages", "UIMAJMS_awaiting_container_init__INFO", new Object[0]);
        }
        try {
            this.serviceInitializationSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.serviceInitializationSemaphore.release();
        }
        if (this.serviceInitializationException) {
            if (this.cause != null) {
                throw new ResourceInitializationException((Throwable)this.cause);
            }
            throw new ResourceInitializationException((Throwable)new Exception("Details of failure(s) written to UIMA log"));
        }
    }

    public void notifyOnInitializationFailure(AnalysisEngineController aController, Exception e) {
        this.cause = e;
        this.serviceInitializationException = true;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "notifyOnInitializationFailure", "jms_adapter_messages", "UIMAJMS_container_init_exception__WARNING", (Throwable)e);
        }
        this.serviceInitializationSemaphore.release();
    }

    public void notifyOnInitializationSuccess(AnalysisEngineController aController) {
        this.serviceInitializationCompleted = true;
        this.serviceInitializationSemaphore.release();
    }

    public void notifyOnInitializationFailure(Exception e) {
        this.notifyOnInitializationFailure(null, e);
    }

    public void notifyOnInitializationSuccess() {
        this.notifyOnInitializationSuccess(null);
    }

    public void notifyOnTermination(String message) {
    }

    public FileSystemXmlApplicationContext getSpringContext() {
        return this.context;
    }

    public boolean isInitialized() {
        return this.serviceInitializationCompleted;
    }

    public boolean initializationFailed() {
        return this.serviceInitializationException;
    }

    public void notifyOnTermination(String aServiceName, String aCasReferenceId, Exception cause) {
    }

    public void notifyOnReconnecting(String aMessage) {
    }

    public void notifyOnReconnectionSuccess() {
    }
}

