/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.management.ServiceNotFoundException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.OutputChannel;
import org.apache.uima.aae.SerializerCache;
import org.apache.uima.aae.UimaSerializer;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.aae.error.UimaEEServiceException;
import org.apache.uima.aae.jmx.PrimitiveServiceInfo;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.adapter.jms.activemq.JmsEndpointConnection_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;

public class JmsOutputChannel
implements OutputChannel {
    private static final Class CLASS_NAME = JmsOutputChannel.class;
    private static final long INACTIVITY_TIMEOUT = 1800000L;
    private CountDownLatch controllerLatch = new CountDownLatch(1);
    private ActiveMQConnectionFactory connectionFactory;
    private String serviceInputEndpoint;
    private String controllerInputEndpoint;
    private String secondaryInputEndpoint;
    private AnalysisEngineController analysisEngineController;
    private ConcurrentHashMap connectionMap = new ConcurrentHashMap();
    private String serverURI;
    private String serviceProtocolList = "";
    private volatile boolean aborting = false;
    private Destination freeCASTempQueue;
    private String hostIP = null;
    private volatile boolean addTimeToLive = true;
    private XStream xstream = new XStream();

    public JmsOutputChannel() {
        try {
            this.hostIP = System.getenv("IP") != null ? System.getenv("IP") : InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (System.getProperty("NoTTL") != null) {
            this.addTimeToLive = false;
        }
    }

    public void setServerURI(String aServerURI) {
        this.serverURI = aServerURI;
    }

    protected void setFreeCasQueue(Destination destination) {
        this.freeCASTempQueue = destination;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getName() {
        return "";
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setServiceInputEndpoint(String anEnpoint) {
        this.serviceInputEndpoint = anEnpoint;
    }

    public void setSecondaryInputQueue(String anEndpoint) {
        this.secondaryInputEndpoint = anEndpoint;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void initialize() throws AsynchAEException {
        if (this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "initialize", "jms_adapter_messages", "UIMAJMS_connector_list__FINE", new Object[]{System.getProperty("ActiveMQConnectors")});
            }
            this.serviceProtocolList = System.getProperty("ActiveMQConnectors");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String serializeCAS(boolean isReply, CAS aCAS, String aCasReferenceId, String aSerializerKey) throws Exception {
        String serializedCas;
        long start;
        block15: {
            UimaSerializer serializer;
            block14: {
                start = this.getAnalysisEngineController().getCpuTime();
                serializedCas = null;
                serializer = SerializerCache.lookupSerializerByThreadId();
                if (!isReply && !"xmi".equalsIgnoreCase(aSerializerKey)) break block14;
                InProcessCache.CacheEntry cacheEntry = this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "serializeCAS", "jms_adapter_messages", "UIMAJMS_serialize_cas__FINE", new Object[]{aCasReferenceId});
                }
                if (isReply) {
                    XmiSerializationSharedData serSharedData = cacheEntry.getDeserSharedData();
                    if (cacheEntry.acceptsDeltaCas() && cacheEntry.getMarker() != null && cacheEntry.getMarker().isValid()) {
                        serializedCas = serializer.serializeCasToXmi(aCAS, serSharedData, cacheEntry.getMarker());
                        cacheEntry.setSentDeltaCas(true);
                    } else {
                        serializedCas = serializer.serializeCasToXmi(aCAS, serSharedData);
                        cacheEntry.setSentDeltaCas(false);
                    }
                    if (cacheEntry.getMarker() != null && !cacheEntry.getMarker().isValid()) {
                        cacheEntry.setMarker(aCAS.createMarker());
                    }
                    if (!cacheEntry.sentDeltaCas() && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "serializeCAS", "jms_adapter_messages", "UIMAJMS_serialize_cas__FINEST", new Object[]{aCasReferenceId, "FULL Cas serialized and sent."});
                    }
                    break block15;
                } else {
                    XmiSerializationSharedData serSharedData = cacheEntry.getDeserSharedData();
                    if (serSharedData == null) {
                        serSharedData = new XmiSerializationSharedData();
                        cacheEntry.setXmiSerializationData(serSharedData);
                    }
                    serializedCas = serializer.serializeCasToXmi(aCAS, serSharedData);
                    int maxOutgoingXmiId = serSharedData.getMaxXmiId();
                    this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId).setHighWaterMark(maxOutgoingXmiId);
                }
                break block15;
            }
            if ("xcas".equalsIgnoreCase(aSerializerKey)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    serializer.serializeToXCAS(bos, aCAS, null, null, null);
                    serializedCas = bos.toString();
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    bos.close();
                    throw throwable;
                }
                bos.close();
            }
        }
        LongNumericStatistic statistic = this.getAnalysisEngineController().getMonitor().getLongNumericStatistic("", "TotalSerializeTime");
        if (statistic != null) {
            statistic.increment(this.getAnalysisEngineController().getCpuTime() - start);
        }
        return serializedCas;
    }

    public void bindWithClientEndpoint(Endpoint anEndpoint) throws Exception {
        if (anEndpoint.getDestination() != null) {
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            TextMessage tm = endpointConnection.produceTextMessage("");
            endpointConnection.send((Message)tm, 0L, false);
        }
    }

    private long getInactivityTimeout(String destination, String brokerURL) {
        if (System.getProperty("SessionTimeoutOverride") != null) {
            try {
                long overrideTimeoutValue = Long.parseLong(System.getProperty("SessionTimeoutOverride"));
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_override_connection_timeout__FINE", new Object[]{this.analysisEngineController, overrideTimeoutValue, destination, brokerURL});
                }
                return overrideTimeoutValue;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_connection_timeout__FINE", new Object[]{this.analysisEngineController, 1800000L, destination, brokerURL});
        }
        return 1800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invalidateConnectionAndEndpoints(BrokerConnectionEntry brokerConnectionEntry) {
        block10: {
            Connection conn = brokerConnectionEntry.getConnection();
            try {
                try {
                    if (conn != null && ((ActiveMQConnection)conn).isClosed()) {
                        brokerConnectionEntry.getConnection().stop();
                        brokerConnectionEntry.getConnection().close();
                        brokerConnectionEntry.setConnection(null);
                        for (Map.Entry<Object, JmsEndpointConnection_impl> endpoints : brokerConnectionEntry.endpointMap.entrySet()) {
                            endpoints.getValue().close();
                        }
                    }
                    Object var6_6 = null;
                    brokerConnectionEntry.endpointMap.clear();
                    this.connectionMap.remove(brokerConnectionEntry.getBrokerURL());
                }
                catch (Exception exception) {
                    Object var6_7 = null;
                    brokerConnectionEntry.endpointMap.clear();
                    this.connectionMap.remove(brokerConnectionEntry.getBrokerURL());
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "invalidateConnectionAndEndpoints", "jms_adapter_messages", "UIMAJMS_service_closing_connection__INFO", new Object[]{this.getAnalysisEngineController().getComponentName(), brokerConnectionEntry.getBrokerURL()});
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                brokerConnectionEntry.endpointMap.clear();
                this.connectionMap.remove(brokerConnectionEntry.getBrokerURL());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "invalidateConnectionAndEndpoints", "jms_adapter_messages", "UIMAJMS_service_closing_connection__INFO", new Object[]{this.getAnalysisEngineController().getComponentName(), brokerConnectionEntry.getBrokerURL()});
                }
                throw throwable;
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "invalidateConnectionAndEndpoints", "jms_adapter_messages", "UIMAJMS_service_closing_connection__INFO", new Object[]{this.getAnalysisEngineController().getComponentName(), brokerConnectionEntry.getBrokerURL()});
            }
        }
        brokerConnectionEntry.setConnection(null);
    }

    private String getDestinationName(Endpoint anEndpoint) {
        String destination = anEndpoint.getEndpoint();
        if (anEndpoint.getDestination() != null && anEndpoint.getDestination() instanceof ActiveMQDestination) {
            destination = ((ActiveMQDestination)anEndpoint.getDestination()).getPhysicalName();
        }
        return destination;
    }

    private String getLookupKey(Endpoint anEndpoint) {
        String key = anEndpoint.getEndpoint() + anEndpoint.getServerURI();
        String destination = this.getDestinationName(anEndpoint);
        key = anEndpoint.getDelegateKey() != null ? anEndpoint.getDelegateKey() + "-" + destination : "Client-" + destination;
        return key;
    }

    private BrokerConnectionEntry createConnectionEntry(String brokerURL) {
        BrokerConnectionEntry brokerConnectionEntry = new BrokerConnectionEntry();
        this.connectionMap.put(brokerURL, brokerConnectionEntry);
        ConnectionTimer connectionTimer = new ConnectionTimer(brokerConnectionEntry);
        connectionTimer.setAnalysisEngineController(this.getAnalysisEngineController());
        brokerConnectionEntry.setConnectionTimer(connectionTimer);
        return brokerConnectionEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized JmsEndpointConnection_impl getEndpointConnection(Endpoint anEndpoint) throws AsynchAEException, ServiceShutdownException, ConnectException {
        try {
            this.controllerLatch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        JmsEndpointConnection_impl endpointConnection = null;
        String brokerConnectionURL = null;
        brokerConnectionURL = anEndpoint.isFreeCasEndpoint() && anEndpoint.isCasMultiplier() && anEndpoint.isReplyEndpoint() ? anEndpoint.getServerURI() : (anEndpoint.isReplyEndpoint() ? this.serverURI : anEndpoint.getServerURI());
        BrokerConnectionEntry brokerConnectionEntry = null;
        if (this.connectionMap.containsKey(brokerConnectionURL)) {
            brokerConnectionEntry = (BrokerConnectionEntry)this.connectionMap.get(brokerConnectionURL);
            if (brokerConnectionEntry == null) {
                throw new AsynchAEException("Controller:" + this.getAnalysisEngineController().getComponentName() + " Unable to Lookup Broker Connection For URL:" + brokerConnectionURL);
            }
            brokerConnectionEntry.setBrokerURL(brokerConnectionURL);
            if (JmsEndpointConnection_impl.connectionClosedOrFailed(brokerConnectionEntry)) {
                this.invalidateConnectionAndEndpoints(brokerConnectionEntry);
                brokerConnectionEntry = this.createConnectionEntry(brokerConnectionURL);
            }
        } else {
            brokerConnectionEntry = this.createConnectionEntry(brokerConnectionURL);
        }
        String key = this.getLookupKey(anEndpoint);
        String destination = this.getDestinationName(anEndpoint);
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_acquiring_connection_to_endpoint__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), destination, brokerConnectionURL});
        }
        if (!brokerConnectionEntry.endpointExists(key)) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_create_new_connection__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), destination, brokerConnectionURL});
            }
            Endpoint masterEndpoint = null;
            if (this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController && !anEndpoint.isReplyEndpoint() && (masterEndpoint = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).lookUpEndpoint(anEndpoint.getDelegateKey(), false)) != null) {
                Endpoint endpoint = masterEndpoint;
                synchronized (endpoint) {
                    if (masterEndpoint.getStatus() == 2) {
                        InputChannel iC = this.getAnalysisEngineController().getReplyInputChannel(anEndpoint.getDelegateKey());
                        if (iC == null) throw new AsynchAEException("Aggregate:" + this.getAnalysisEngineController() + " Has not yet recovered a listener for delegate: " + anEndpoint.getDelegateKey());
                        try {
                            iC.createListener(anEndpoint.getDelegateKey(), anEndpoint);
                            iC.removeDelegateFromFailedList(masterEndpoint.getDelegateKey());
                        }
                        catch (Exception exx) {
                            throw new AsynchAEException(exx);
                        }
                    } else if (!masterEndpoint.isFreeCasEndpoint()) {
                        anEndpoint.setDestination(masterEndpoint.getDestination());
                    }
                }
            }
            endpointConnection = new JmsEndpointConnection_impl(brokerConnectionEntry, anEndpoint, this.getAnalysisEngineController());
            brokerConnectionEntry.addEndpointConnection(key, endpointConnection);
            long replyQueueInactivityTimeout = this.getInactivityTimeout(destination, brokerConnectionURL);
            brokerConnectionEntry.getConnectionTimer().setInactivityTimeout(replyQueueInactivityTimeout);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_open_new_connection_to_endpoint__FINE", new Object[]{this.getDestinationName(anEndpoint), brokerConnectionURL});
            }
            endpointConnection.open();
            brokerConnectionEntry.getConnectionTimer().setConnectionCreationTimestamp(JmsEndpointConnection_impl.connectionCreationTimestamp);
            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) return endpointConnection;
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_connection_opened_to_endpoint__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), destination, brokerConnectionURL});
            return endpointConnection;
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_reusing_existing_connection__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), destination, brokerConnectionURL});
        }
        if ((endpointConnection = brokerConnectionEntry.getEndpointConnection(key)) == null || endpointConnection.isOpen()) return endpointConnection;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getEndpointConnection", "jms_adapter_messages", "UIMAJMS_connection_closed_reopening_endpoint__FINE", new Object[]{destination});
        }
        endpointConnection.open();
        if (!endpointConnection.isOpen()) return endpointConnection;
        brokerConnectionEntry.getConnectionTimer().setConnectionCreationTimestamp(System.nanoTime());
        if (!(this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController) || anEndpoint.getDelegateKey() == null) return endpointConnection;
        Endpoint masterEndpoint = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).lookUpEndpoint(anEndpoint.getDelegateKey(), false);
        masterEndpoint.setStatus(1);
        return endpointConnection;
    }

    private void logRequest(String key, Endpoint anEndpoint) {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendRequest", "uimaee_messages", "key", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getDelegateKey()});
        }
    }

    private Delegate startGetMetaTimerAndGetDelegate(Endpoint anEndpoint) {
        Delegate delegate = null;
        if (anEndpoint.getDestination() != null) {
            String replyQueueName = ((ActiveMQDestination)anEndpoint.getDestination()).getPhysicalName().replaceAll(":", "_");
            if (this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController) {
                String delegateKey = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).lookUpDelegateKey(anEndpoint.getEndpoint());
                PrimitiveServiceInfo serviceInfo = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).getDelegateServiceInfo(delegateKey);
                if (serviceInfo != null) {
                    serviceInfo.setReplyQueueName(replyQueueName);
                    serviceInfo.setServiceKey(delegateKey);
                }
                if ((delegate = this.lookupDelegate(delegateKey)).getGetMetaTimeout() > 0L) {
                    delegate.startGetMetaRequestTimer();
                }
            }
        }
        return delegate;
    }

    public void sendRequest(int aCommand, String aCasReferenceId, Endpoint anEndpoint) throws AsynchAEException {
        Delegate delegate = null;
        try {
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            TextMessage tm = endpointConnection.produceTextMessage("");
            tm.setIntProperty("Payload", 1005);
            switch (aCommand) {
                case 2002: {
                    this.logRequest("UIMAEE_send_cpc_req__FINE", anEndpoint);
                    break;
                }
                case 2005: {
                    tm.setStringProperty("CasReference", aCasReferenceId);
                    this.logRequest("UIMAJMS_releasecas_request__endpoint__FINEST", anEndpoint);
                    break;
                }
                case 2001: {
                    delegate = this.startGetMetaTimerAndGetDelegate(anEndpoint);
                    this.logRequest("UIMAEE_service_sending_getmeta_request__FINE", anEndpoint);
                    break;
                }
                case 2006: {
                    tm.setStringProperty("CasReference", aCasReferenceId);
                    this.logRequest("UIMAEE_service_sending_stop_request__FINE", anEndpoint);
                    break;
                }
                case 2000: {
                    this.logRequest("UIMAEE_service_sending_process_request__FINE", anEndpoint);
                    this.serializeCasAndSend(this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId), anEndpoint);
                    return;
                }
            }
            this.populateHeaderWithRequestContext((Message)tm, anEndpoint, aCommand);
            tm.setStringProperty("EndpointServer", anEndpoint.getServerURI());
            if (!endpointConnection.send((Message)tm, 0L, true)) {
                throw new ServiceNotFoundException();
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            if (delegate != null && aCommand == 2001) {
                delegate.cancelDelegateGetMetaTimer();
            }
            ErrorContext errorContext = new ErrorContext();
            errorContext.add("Command", aCommand);
            errorContext.add("Endpoint", anEndpoint);
            this.getAnalysisEngineController().getErrorHandlerChain().handle(e, errorContext, this.getAnalysisEngineController());
        }
    }

    private void serializeCasAndSend(InProcessCache.CacheEntry entry, Endpoint anEndpoint) throws Exception {
        if (anEndpoint.getSerializer().equals("xmi")) {
            String serializedCAS = this.getSerializedCasAndReleaseIt(false, entry.getCasReferenceId(), anEndpoint, anEndpoint.isRetryEnabled());
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "sendRequest", "jms_adapter_messages", "UIMAJMS_sending_serialized_cas__FINEST", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getDelegateKey(), entry.getCasReferenceId(), serializedCAS});
            }
            this.sendCasToRemoteEndpoint(true, serializedCAS, entry, anEndpoint, true);
        } else {
            byte[] serializedCAS = this.getBinaryCasAndReleaseIt(false, entry.getCasReferenceId(), anEndpoint, anEndpoint.isRetryEnabled());
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "sendRequest", "jms_adapter_messages", "UIMAJMS_sending_binary_cas__FINEST", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getDelegateKey(), entry.getCasReferenceId(), serializedCAS});
            }
            this.sendCasToRemoteEndpoint(true, serializedCAS, entry, anEndpoint, true);
        }
    }

    public void sendReply(InProcessCache.CacheEntry entry, Endpoint anEndpoint) throws AsynchAEException {
        try {
            anEndpoint.setReplyEndpoint(true);
            if (anEndpoint.isRemote()) {
                if (anEndpoint.getSerializer().equals("xmi")) {
                    String serializedCAS = this.getSerializedCas(true, entry.getCasReferenceId(), anEndpoint, anEndpoint.isRetryEnabled());
                    this.sendCasToRemoteEndpoint(false, serializedCAS, entry, anEndpoint, false);
                } else {
                    byte[] binaryCas = this.getBinaryCas(true, entry.getCasReferenceId(), anEndpoint, anEndpoint.isRetryEnabled());
                    if (binaryCas == null) {
                        return;
                    }
                    this.sendCasToRemoteEndpoint(false, binaryCas, entry, anEndpoint, false);
                }
            }
        }
        catch (ServiceShutdownException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    public void sendReply(int aCommand, Endpoint anEndpoint, String aCasReferenceId, boolean notifyOnJmsException) throws AsynchAEException {
        try {
            if (this.aborting) {
                return;
            }
            anEndpoint.setReplyEndpoint(true);
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            TextMessage tm = endpointConnection.produceTextMessage("");
            tm.setIntProperty("Payload", 1005);
            this.populateHeaderWithResponseContext((Message)tm, anEndpoint, aCommand);
            if (aCasReferenceId != null) {
                tm.setStringProperty("CasReference", aCasReferenceId);
            }
            if (aCommand == 2008 && this.getAnalysisEngineController().isCasMultiplier() && this.freeCASTempQueue != null) {
                tm.setJMSReplyTo(this.freeCASTempQueue);
            }
            if (!endpointConnection.send((Message)tm, 0L, false, notifyOnJmsException) && notifyOnJmsException) {
                throw new JMSException("JMS Send Failed. Check UIMA Log For Details.");
            }
            this.addIdleTime((Message)tm);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_cpc_reply_sent__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getEndpoint()});
            }
        }
        catch (JMSException e) {
            if (notifyOnJmsException) {
                throw new AsynchAEException(e);
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        catch (ServiceShutdownException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    public void sendReply(Throwable t, String aCasReferenceId, String aParentCasReferenceId, Endpoint anEndpoint, int aCommand) throws AsynchAEException {
        anEndpoint.setReplyEndpoint(true);
        try {
            UimaEEServiceException wrapper = null;
            if (!(t instanceof UimaEEServiceException)) {
                wrapper = t instanceof AsynchAEException && t.getCause() != null ? new UimaEEServiceException(t.getCause()) : new UimaEEServiceException(t);
            }
            if (this.aborting) {
                return;
            }
            anEndpoint.setReplyEndpoint(true);
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            ObjectMessage om = endpointConnection.produceObjectMessage();
            try {
                if (wrapper == null) {
                    om.setObject((Serializable)t);
                } else {
                    om.setObject((Serializable)wrapper);
                }
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof NotSerializableException) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    wrapper = new UimaEEServiceException(sw.toString());
                    om.setObject((Serializable)wrapper);
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            this.populateHeaderWithResponseContext((Message)om, anEndpoint, aCommand);
            om.setIntProperty("Payload", 1003);
            if (aCasReferenceId != null) {
                om.setStringProperty("CasReference", aCasReferenceId);
                if (aParentCasReferenceId != null) {
                    om.setStringProperty("InputCasReference", aParentCasReferenceId);
                }
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_sending_exception__FINE", new Object[]{this.getAnalysisEngineController().getName(), anEndpoint.getEndpoint()});
            }
            endpointConnection.send((Message)om, 0L, false);
            this.addIdleTime((Message)om);
        }
        catch (JMSException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_unable_to_connect__INFO", new Object[]{this.getAnalysisEngineController().getName(), anEndpoint.getEndpoint()});
            }
        }
        catch (ServiceShutdownException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
        catch (AsynchAEException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_unable_to_connect__INFO", new Object[]{this.getAnalysisEngineController().getName(), anEndpoint.getEndpoint()});
            }
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    /*
     * Loose catch block
     */
    public void sendReply(ProcessingResourceMetaData aProcessingResourceMetadata, Endpoint anEndpoint, boolean serialize) throws AsynchAEException {
        block21: {
            if (this.aborting) {
                return;
            }
            long msgSize = 0L;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            anEndpoint.setReplyEndpoint(true);
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_produce_txt_msg__FINE", new Object[0]);
            }
            TextMessage tm = endpointConnection.produceTextMessage("");
            if (serialize) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_serializing_meta__FINE", new Object[0]);
                }
                aProcessingResourceMetadata.toXML((OutputStream)bos);
                tm.setText(bos.toString());
                msgSize = bos.toString().length();
            }
            tm.setIntProperty("Payload", 1002);
            tm.setIntProperty("Serialization", 4001);
            this.populateHeaderWithResponseContext((Message)tm, anEndpoint, 2001);
            if (this.freeCASTempQueue != null) {
                tm.setJMSReplyTo(this.freeCASTempQueue);
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_metadata_reply__endpoint__FINEST", new Object[]{this.serviceInputEndpoint, anEndpoint.getEndpoint()});
            }
            endpointConnection.send((Message)tm, msgSize, false);
            Object var10_11 = null;
            try {
                bos.close();
            }
            catch (Exception e2) {}
            break block21;
            {
                catch (JMSException e) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_unable_to_connect__INFO", new Object[]{this.getAnalysisEngineController().getName(), anEndpoint.getEndpoint()});
                    }
                    Object var10_12 = null;
                    try {
                        bos.close();
                    }
                    catch (Exception e2) {}
                    break block21;
                }
                catch (ServiceShutdownException e) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                    Object var10_13 = null;
                    try {
                        bos.close();
                    }
                    catch (Exception e2) {}
                    break block21;
                }
                catch (Exception e) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                    throw new AsynchAEException(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    bos.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private byte[] getBinaryCas(boolean isReply, String aCasReferenceId, Endpoint anEndpoint, boolean cacheSerializedCas) throws Exception {
        CAS cas = null;
        try {
            byte[] serializedCAS = null;
            cas = this.getAnalysisEngineController().getInProcessCache().getCasByReference(aCasReferenceId);
            ServicePerformance casStats = this.getAnalysisEngineController().getCasStatistics(aCasReferenceId);
            InProcessCache.CacheEntry entry = this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
            long t1 = this.getAnalysisEngineController().getCpuTime();
            String serializerType = anEndpoint.getSerializer();
            if (cas == null || entry == null) {
                return null;
            }
            UimaSerializer serializer = SerializerCache.lookupSerializerByThreadId();
            if (serializerType.equals("binary")) {
                if (entry.acceptsDeltaCas() && isReply) {
                    if (entry.getMarker() != null && entry.getMarker().isValid()) {
                        serializedCAS = serializer.serializeCasToBinary(cas, entry.getMarker());
                        entry.setSentDeltaCas(true);
                    } else {
                        serializedCAS = serializer.serializeCasToBinary(cas);
                        entry.setSentDeltaCas(false);
                    }
                } else {
                    serializedCAS = serializer.serializeCasToBinary(cas);
                    entry.setSentDeltaCas(false);
                    if (isReply && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getBinaryCas", "jms_adapter_messages", "UIMAJMS_serialize_cas__FINEST", new Object[]{aCasReferenceId, "FULL Cas serialized and sent."});
                    }
                }
                if (entry.getMarker() != null && !entry.getMarker().isValid()) {
                    entry.setMarker(cas.createMarker());
                }
            } else {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "getBinaryCas", "jms_adapter_messages", "UIMAJMS_invalid_serializer__WARNING", new Object[]{this.getAnalysisEngineController().getName(), serializerType, anEndpoint.getEndpoint()});
                }
                throw new UimaEEServiceException("Invalid Serializer:" + serializerType + " For Endpoint:" + anEndpoint.getEndpoint());
            }
            long timeToSerializeCas = this.getAnalysisEngineController().getCpuTime() - t1;
            this.getAnalysisEngineController().incrementSerializationTime(timeToSerializeCas);
            entry.incrementTimeToSerializeCAS(timeToSerializeCas);
            casStats.incrementCasSerializationTime(timeToSerializeCas);
            this.getAnalysisEngineController().getServicePerformance().incrementCasSerializationTime(timeToSerializeCas);
            return serializedCAS;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private String getSerializedCas(boolean isReply, String aCasReferenceId, Endpoint anEndpoint, boolean cacheSerializedCas) throws Exception {
        CAS cas = null;
        try {
            String serializedCAS = null;
            cas = this.getAnalysisEngineController().getInProcessCache().getCasByReference(aCasReferenceId);
            ServicePerformance casStats = this.getAnalysisEngineController().getCasStatistics(aCasReferenceId);
            if (cas == null) {
                serializedCAS = this.getAnalysisEngineController().getInProcessCache().getSerializedCAS(aCasReferenceId);
            } else {
                InProcessCache.CacheEntry entry = this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
                long t1 = this.getAnalysisEngineController().getCpuTime();
                String serializer = anEndpoint.getSerializer();
                if (serializer == null || serializer.trim().length() == 0) {
                    serializer = "xmi";
                }
                serializedCAS = this.serializeCAS(isReply, cas, aCasReferenceId, serializer);
                long timeToSerializeCas = this.getAnalysisEngineController().getCpuTime() - t1;
                this.getAnalysisEngineController().incrementSerializationTime(timeToSerializeCas);
                entry.incrementTimeToSerializeCAS(timeToSerializeCas);
                casStats.incrementCasSerializationTime(timeToSerializeCas);
                this.getAnalysisEngineController().getServicePerformance().incrementCasSerializationTime(timeToSerializeCas);
                if (cacheSerializedCas) {
                    this.getAnalysisEngineController().getInProcessCache().saveSerializedCAS(aCasReferenceId, serializedCAS);
                }
            }
            return serializedCAS;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private byte[] getBinaryCasAndReleaseIt(boolean isReply, String aCasReferenceId, Endpoint anEndpoint, boolean cacheSerializedCas) throws Exception {
        byte[] byArray;
        try {
            byArray = this.getBinaryCas(isReply, aCasReferenceId, anEndpoint, cacheSerializedCas);
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw new AsynchAEException(e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (!(this.getAnalysisEngineController() instanceof PrimitiveAnalysisEngineController) || !anEndpoint.isRemote()) break block5;
                    this.getAnalysisEngineController().dropCAS(aCasReferenceId, true);
                }
                throw throwable;
            }
        }
        if (this.getAnalysisEngineController() instanceof PrimitiveAnalysisEngineController && anEndpoint.isRemote()) {
            this.getAnalysisEngineController().dropCAS(aCasReferenceId, true);
        }
        return byArray;
    }

    private String getSerializedCasAndReleaseIt(boolean isReply, String aCasReferenceId, Endpoint anEndpoint, boolean cacheSerializedCas) throws Exception {
        String string;
        try {
            string = this.getSerializedCas(isReply, aCasReferenceId, anEndpoint, cacheSerializedCas);
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw new AsynchAEException(e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (!(this.getAnalysisEngineController() instanceof PrimitiveAnalysisEngineController) || !anEndpoint.isRemote()) break block5;
                    this.getAnalysisEngineController().dropCAS(aCasReferenceId, true);
                }
                throw throwable;
            }
        }
        if (this.getAnalysisEngineController() instanceof PrimitiveAnalysisEngineController && anEndpoint.isRemote()) {
            this.getAnalysisEngineController().dropCAS(aCasReferenceId, true);
        }
        return string;
    }

    private void populateStats(Message aTextMessage, Endpoint anEndpoint, String aCasReferenceId, int anAdminCommand, boolean isRequest) throws Exception {
        if (anEndpoint.isFinal()) {
            aTextMessage.setLongProperty("SENT-TIME", System.nanoTime());
        }
        if (anAdminCommand == 2000) {
            if (isRequest) {
                long departureTime = System.nanoTime();
                this.getAnalysisEngineController().saveTime(departureTime, aCasReferenceId, anEndpoint.getEndpoint());
            } else {
                try {
                    InProcessCache.CacheEntry entry;
                    if (this.getAnalysisEngineController().getInProcessCache().entryExists(aCasReferenceId) && (entry = this.getAnalysisEngineController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId)).getDelegateMetrics().size() > 0) {
                        aTextMessage.setStringProperty("CASPerComponentMetrics", this.xstream.toXML(entry.getDelegateMetrics()));
                    }
                }
                catch (Exception ex) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "populateStats", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                }
                ServicePerformance casStats = this.getAnalysisEngineController().getCasStatistics(aCasReferenceId);
                aTextMessage.setLongProperty("TimeToSerializeCAS", casStats.getRawCasSerializationTime());
                aTextMessage.setLongProperty("TimeToDeserializeCAS", casStats.getRawCasDeserializationTime());
                aTextMessage.setLongProperty("TimeInProcessCAS", casStats.getRawAnalysisTime());
                aTextMessage.setLongProperty("TimeWaitingForCAS", this.getAnalysisEngineController().getServicePerformance().getTimeWaitingForCAS());
                long iT = this.getAnalysisEngineController().getIdleTimeBetweenProcessCalls(2000);
                aTextMessage.setLongProperty("IdleTime", iT);
                String lookupKey = this.getAnalysisEngineController().getName();
                long arrivalTime = this.getAnalysisEngineController().getTime(aCasReferenceId, lookupKey);
                long timeInService = this.getAnalysisEngineController().getCpuTime() - arrivalTime;
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "populateStats", "jms_adapter_messages", "UIMAJMS_timein_service__FINEST", new Object[]{this.serviceInputEndpoint, (double)timeInService / 1000000.0});
                }
            }
        }
    }

    private long getCommandTimeoutValue(Endpoint anEndpoint, int aCommand) {
        switch (aCommand) {
            case 2001: {
                return anEndpoint.getMetadataRequestTimeout();
            }
            case 2000: {
                return anEndpoint.getProcessRequestTimeout();
            }
        }
        return 0L;
    }

    private void populateHeaderWithRequestContext(Message aMessage, Endpoint anEndpoint, int aCommand) throws Exception {
        aMessage.setIntProperty("MessageType", 3000);
        aMessage.setIntProperty("Command", aCommand);
        aMessage.setBooleanProperty("AcceptsDeltaCas", true);
        long timeout = this.getCommandTimeoutValue(anEndpoint, aCommand);
        if (timeout > 0L && this.addTimeToLive) {
            Delegate delegate = this.lookupDelegate(anEndpoint.getDelegateKey());
            long ttl = timeout;
            int currentOutstandingCasListSize = delegate.getCasPendingReplyListSize();
            if (currentOutstandingCasListSize > 0) {
                ttl *= (long)currentOutstandingCasListSize;
            }
            aMessage.setJMSExpiration(ttl);
        }
        if (this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController) {
            aMessage.setStringProperty("MessageFrom", this.controllerInputEndpoint);
            if (anEndpoint.isRemote()) {
                Object destination;
                String protocol = this.serviceProtocolList;
                if (anEndpoint.getServerURI().trim().toLowerCase().startsWith("http") || anEndpoint.getReplyToEndpoint() != null && anEndpoint.getReplyToEndpoint().trim().length() > 0) {
                    protocol = anEndpoint.getServerURI().trim();
                    String replyTo = anEndpoint.getReplyToEndpoint();
                    if (replyTo == null && anEndpoint.getDestination() == null) {
                        throw new AsynchAEException("replyTo endpoint name not specified for HTTP-based endpoint:" + anEndpoint.getEndpoint());
                    }
                    if (replyTo == null) {
                        replyTo = "";
                    }
                    aMessage.setStringProperty("MessageFrom", replyTo);
                }
                if ((destination = anEndpoint.getDestination()) != null) {
                    aMessage.setJMSReplyTo((Destination)destination);
                    aMessage.setStringProperty("ServerURI", anEndpoint.getServerURI());
                } else {
                    aMessage.setStringProperty("ServerURI", protocol);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "populateHeaderWithRequestContext", "jms_adapter_messages", "UIMAJMS_sending_new_msg_to_remote_FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getServerURI(), anEndpoint.getEndpoint()});
                }
            } else {
                aMessage.setStringProperty("ServerURI", anEndpoint.getServerURI());
            }
        }
    }

    private void populateHeaderWithResponseContext(Message aMessage, Endpoint anEndpoint, int aCommand) throws Exception {
        aMessage.setIntProperty("MessageType", 3001);
        aMessage.setIntProperty("Command", aCommand);
        aMessage.setStringProperty("MessageFrom", this.serviceInputEndpoint);
        if (anEndpoint.isRemote()) {
            aMessage.setStringProperty("ServerURI", this.getServerURI());
            if (this.hostIP != null) {
                aMessage.setStringProperty("ServerIP", this.hostIP);
                if (this.getAnalysisEngineController() != null) {
                    aMessage.setStringProperty("ProcessPID", this.getAnalysisEngineController().getPID() + ":" + Thread.currentThread().getId());
                }
            }
            if (anEndpoint.getEndpointServer() != null) {
                aMessage.setStringProperty("EndpointServer", anEndpoint.getEndpointServer());
            }
        } else {
            aMessage.setStringProperty("ServerURI", anEndpoint.getServerURI());
        }
    }

    public AnalysisEngineController getAnalysisEngineController() {
        return this.analysisEngineController;
    }

    public void setController(AnalysisEngineController analysisEngineController) {
        this.analysisEngineController = analysisEngineController;
        this.controllerLatch.countDown();
    }

    public String getControllerInputEndpoint() {
        return this.controllerInputEndpoint;
    }

    public void setControllerInputEndpoint(String controllerInputEndpoint) {
        this.controllerInputEndpoint = controllerInputEndpoint;
    }

    private void dispatch(Message aMessage, Endpoint anEndpoint, InProcessCache.CacheEntry entry, boolean isRequest, JmsEndpointConnection_impl endpointConnection, long msgSize) throws Exception {
        boolean startConnectionTimer;
        String brokerConnectionURL;
        if (anEndpoint == null) {
            throw new UimaEEServiceException("UIMA AS service:" + this.getAnalysisEngineController().getComponentName() + " unable to dispatch request to a remote delegate. Endpoint is null. This is an invalid state.");
        }
        this.populateStats(aMessage, anEndpoint, entry.getCasReferenceId(), 2000, isRequest);
        String string = brokerConnectionURL = anEndpoint.isReplyEndpoint() ? this.serverURI : anEndpoint.getServerURI();
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dispatch", "jms_adapter_messages", "UIMAJMS_sending_new_msg_to_remote_FINE", new Object[]{this.getAnalysisEngineController().getName(), brokerConnectionURL, endpointConnection.getEndpoint()});
        }
        boolean bl = startConnectionTimer = !isRequest;
        if (isRequest) {
            anEndpoint.setWaitingForResponse(true);
            this.addCasToOutstandingList(entry, isRequest, anEndpoint.getDelegateKey());
        } else {
            this.addIdleTime(aMessage);
        }
        if (!endpointConnection.send(aMessage, msgSize, startConnectionTimer)) {
            if (isRequest && anEndpoint.getDelegateKey() != null) {
                BrokerConnectionEntry brokerConnectionEntry;
                Endpoint master = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).lookUpEndpoint(anEndpoint.getDelegateKey(), false);
                master.setStatus(2);
                String key = this.getLookupKey(anEndpoint);
                if (this.connectionMap.containsKey(brokerConnectionURL) && (brokerConnectionEntry = (BrokerConnectionEntry)this.connectionMap.get(brokerConnectionURL)) != null && brokerConnectionEntry.endpointExists(key)) {
                    brokerConnectionEntry.removeEndpoint(key);
                }
                RecoveryThread recoveryThread = new RecoveryThread(this, anEndpoint, entry, isRequest, this.getAnalysisEngineController());
                Thread t = new Thread(Thread.currentThread().getThreadGroup().getParent(), recoveryThread);
                t.start();
            } else {
                try {
                    Object clientDestination;
                    LocalCache.CasStateEntry casStateEntry = this.getAnalysisEngineController().getLocalCache().lookupEntry(entry.getCasReferenceId());
                    casStateEntry.setDeliveryToClientFailed();
                    if (anEndpoint != null && (clientDestination = anEndpoint.getDestination()) != null && clientDestination instanceof TemporaryQueue && !this.getAnalysisEngineController().getDeadClientMap().containsKey(clientDestination.toString())) {
                        this.getAnalysisEngineController().getDeadClientMap().put(clientDestination.toString(), clientDestination.toString());
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "dispatch", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "dispatch", "jms_adapter_messages", "UIMAJMS_send_reply_failed__INFO", new Object[]{this.getAnalysisEngineController().getComponentName(), brokerConnectionURL, endpointConnection.getEndpoint()});
                }
            }
        }
    }

    private void sendCasToRemoteEndpoint(boolean isRequest, Object aSerializedCAS, InProcessCache.CacheEntry entry, Endpoint anEndpoint, boolean startTimer) throws AsynchAEException, ServiceShutdownException {
        LocalCache.CasStateEntry casStateEntry = null;
        long msgSize = 0L;
        try {
            if (this.aborting) {
                return;
            }
            String brokerConnectionURL = anEndpoint.isReplyEndpoint() ? this.serverURI : anEndpoint.getServerURI();
            casStateEntry = this.getAnalysisEngineController().getLocalCache().lookupEntry(entry.getCasReferenceId());
            if (casStateEntry == null) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendCasToRemoteDelegate", "jms_adapter_messages", "UIMAJMS_unable_to_send_reply__WARNING", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getDestination(), brokerConnectionURL, entry.getInputCasReferenceId() == null ? "" : entry.getInputCasReferenceId(), entry.getCasReferenceId(), 0, new Exception("Unable to lookup entry in Local Cache for a given Cas Id")});
                return;
            }
            JmsEndpointConnection_impl endpointConnection = this.getEndpointConnection(anEndpoint);
            if (!endpointConnection.isOpen() && !isRequest) {
                return;
            }
            TextMessage tm = null;
            try {
                if (anEndpoint.getSerializer().equals("xmi")) {
                    tm = endpointConnection.produceTextMessage((String)aSerializedCAS);
                    if (aSerializedCAS != null) {
                        msgSize = ((String)aSerializedCAS).length();
                    }
                    tm.setIntProperty("Payload", 1000);
                } else {
                    tm = endpointConnection.produceByteMessage((byte[])aSerializedCAS);
                    if (aSerializedCAS != null) {
                        msgSize = ((byte[])aSerializedCAS).length;
                    }
                    tm.setIntProperty("Payload", 1006);
                }
            }
            catch (AsynchAEException ex) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendCasToRemoteDelegate", "jms_adapter_messages", "UIMAJMS_unable_to_send_reply__WARNING", new Object[]{this.getAnalysisEngineController().getComponentName(), anEndpoint.getDestination(), brokerConnectionURL, entry.getInputCasReferenceId() == null ? "" : entry.getInputCasReferenceId(), entry.getCasReferenceId(), 0, ex});
                return;
            }
            tm.setStringProperty("CasReference", entry.getCasReferenceId());
            if (isRequest) {
                this.populateHeaderWithRequestContext((Message)tm, anEndpoint, 2000);
            } else {
                this.populateHeaderWithResponseContext((Message)tm, anEndpoint, 2000);
                tm.setBooleanProperty("SentDeltaCas", entry.sentDeltaCas());
            }
            if (casStateEntry.isSubordinate() && !isRequest) {
                tm.setIntProperty("MessageType", 3000);
                isRequest = true;
                tm.setStringProperty("InputCasReference", this.getTopParentCasReferenceId(entry.getCasReferenceId()));
                tm.setLongProperty("CasSequence", entry.getCasSequence());
                if (this.freeCASTempQueue != null) {
                    tm.setJMSReplyTo(this.freeCASTempQueue);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendCasToRemoteEndpoint", "jms_adapter_messages", "UIMAJMS_send_cas_to_collocated_service_detail__FINE", new Object[]{this.getAnalysisEngineController().getComponentName(), "Remote", anEndpoint.getEndpoint(), entry.getCasReferenceId(), entry.getInputCasReferenceId(), entry.getInputCasReferenceId()});
                }
            }
            this.dispatch((Message)tm, anEndpoint, entry, isRequest, endpointConnection, msgSize);
        }
        catch (JMSException e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "sendCasToRemoteDelegate", "jms_adapter_messages", "UIMAJMS_unable_to_connect__INFO", new Object[]{this.getAnalysisEngineController().getName(), anEndpoint.getEndpoint()});
            }
        }
        catch (ServiceShutdownException e) {
            throw e;
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private Delegate lookupDelegate(String aDelegateKey) {
        if (this.getAnalysisEngineController() instanceof AggregateAnalysisEngineController) {
            Delegate delegate = ((AggregateAnalysisEngineController)this.getAnalysisEngineController()).lookupDelegate(aDelegateKey);
            return delegate;
        }
        return null;
    }

    private void addCasToOutstandingList(InProcessCache.CacheEntry entry, boolean isRequest, String aDelegateKey) {
        Delegate delegate = null;
        if (isRequest && (delegate = this.lookupDelegate(aDelegateKey)) != null) {
            delegate.addCasToOutstandingList(entry.getCasReferenceId(), entry.getCas().hashCode());
        }
    }

    private void removeCasFromOutstandingList(InProcessCache.CacheEntry entry, boolean isRequest, String aDelegateKey) {
        Delegate delegate = null;
        if (isRequest && (delegate = this.lookupDelegate(aDelegateKey)) != null) {
            delegate.removeCasFromOutstandingList(entry.getCasReferenceId());
        }
    }

    private String getTopParentCasReferenceId(String casReferenceId) throws Exception {
        if (!this.getAnalysisEngineController().getLocalCache().containsKey(casReferenceId)) {
            return null;
        }
        LocalCache.CasStateEntry casStateEntry = this.getAnalysisEngineController().getLocalCache().lookupEntry(casReferenceId);
        if (casStateEntry.isSubordinate()) {
            return this.getTopParentCasReferenceId(casStateEntry.getInputCasReferenceId());
        }
        return casStateEntry.getCasReferenceId();
    }

    private void addIdleTime(Message aMessage) {
        long t = System.nanoTime();
        this.getAnalysisEngineController().saveReplyTime(t, "");
    }

    public void stop() {
        this.stop(0, true);
    }

    public void stop(boolean shutdownNow) {
        this.stop(0, shutdownNow);
    }

    public void stop(int channelsToClose, boolean shutdownNow) {
        block8: {
            this.aborting = true;
            try {
                Iterator it = this.connectionMap.keySet().iterator();
                JmsEndpointConnection_impl endpointConnection = null;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    Object value = this.connectionMap.get(key);
                    if (!(value instanceof BrokerConnectionEntry)) continue;
                    BrokerConnectionEntry brokerConnectionEntry = (BrokerConnectionEntry)value;
                    Iterator<Object> replyEndpointIterator = brokerConnectionEntry.endpointMap.keySet().iterator();
                    while (replyEndpointIterator.hasNext()) {
                        endpointConnection = brokerConnectionEntry.endpointMap.get(replyEndpointIterator.next());
                        endpointConnection.abort();
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_forced_endpoint_close__INFO", new Object[]{this.getAnalysisEngineController().getName(), endpointConnection.getEndpoint(), endpointConnection.getServerUri()});
                    }
                    if (brokerConnectionEntry == null) continue;
                    if (brokerConnectionEntry.getConnectionTimer() != null) {
                        brokerConnectionEntry.getConnectionTimer().cancelTimer();
                    }
                    if (brokerConnectionEntry.getConnection() == null) continue;
                    try {
                        brokerConnectionEntry.getConnection().close();
                    }
                    catch (Exception ex) {}
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_output_channel_aborted__INFO", new Object[]{this.getAnalysisEngineController().getName()});
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block8;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendReply", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getAnalysisEngineController().getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void cancelTimers() {
        if (this.connectionMap.size() > 0) {
            for (String key : this.connectionMap.keySet()) {
                BrokerConnectionEntry ce = (BrokerConnectionEntry)this.connectionMap.get(key);
                if (ce == null || ce.getConnectionTimer() == null) continue;
                ce.getConnectionTimer().cancelTimer();
            }
        }
    }

    private static class RecoveryThread
    implements Runnable {
        Endpoint endpoint;
        InProcessCache.CacheEntry entry;
        boolean isRequest;
        AnalysisEngineController controller;
        JmsOutputChannel outputChannel;

        public RecoveryThread(JmsOutputChannel channel, Endpoint anEndpoint, InProcessCache.CacheEntry anEntry, boolean isRequest, AnalysisEngineController aController) {
            this.endpoint = anEndpoint;
            this.entry = anEntry;
            this.controller = aController;
            this.isRequest = isRequest;
            this.outputChannel = channel;
        }

        public void run() {
            Delegate delegate = this.outputChannel.lookupDelegate(this.endpoint.getDelegateKey());
            this.outputChannel.removeCasFromOutstandingList(this.entry, this.isRequest, this.endpoint.getDelegateKey());
            if (delegate != null) {
                delegate.getEndpoint().setStatus(2);
                InputChannel ic = this.controller.getInputChannel(delegate.getEndpoint().getDestination().toString());
                if (ic != null && delegate != null && delegate.getEndpoint() != null) {
                    ic.destroyListener(delegate.getEndpoint().getDestination().toString(), this.endpoint.getDelegateKey());
                }
                ErrorContext errorContext = new ErrorContext();
                errorContext.add("Command", 2000);
                errorContext.add("CasReference", this.entry.getCasReferenceId());
                errorContext.add("Endpoint", this.endpoint);
                errorContext.handleSilently(true);
                delegate.handleError(new MessageTimeoutException(), errorContext);
            }
        }
    }

    protected class ConnectionTimer {
        private final Class CLASS_NAME = ConnectionTimer.class;
        private Timer timer;
        private long inactivityTimeout;
        private AnalysisEngineController controller;
        private BrokerConnectionEntry brokerDestinations;
        private long connectionCreationTimestamp;
        private String componentName = "";

        public ConnectionTimer(BrokerConnectionEntry aBrokerDestinations) {
            this.brokerDestinations = aBrokerDestinations;
        }

        public void setInactivityTimeout(long anInactivityTimeout) {
            this.inactivityTimeout = anInactivityTimeout;
        }

        public void setAnalysisEngineController(AnalysisEngineController aController) {
            this.controller = aController;
            if (this.controller != null) {
                this.componentName = this.controller.getComponentName();
            }
        }

        public void setConnectionCreationTimestamp(long aConnectionCreationTimestamp) {
            this.connectionCreationTimestamp = aConnectionCreationTimestamp;
        }

        public void startTimer(long aConnectionCreationTimestamp, Endpoint endpoint) {
            this.startTimer(aConnectionCreationTimestamp, endpoint, this.inactivityTimeout, this.componentName);
        }

        public synchronized void startTimer(long aConnectionCreationTimestamp, final Endpoint endpoint, long currentInactivityTimeout, String aComponentName) {
            final long cachedConnectionCreationTimestamp = aConnectionCreationTimestamp;
            Date timeToRun = new Date(System.currentTimeMillis() + currentInactivityTimeout);
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = this.controller != null ? new Timer("Controller:" + aComponentName + ":Reply TimerThread-:" + endpoint + ":" + System.nanoTime()) : new Timer("Reply TimerThread-:" + endpoint + ":" + System.nanoTime());
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block19: {
                        if (UIMAFramework.getLogger((Class)ConnectionTimer.this.CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)ConnectionTimer.this.CLASS_NAME).logrb(Level.INFO, ConnectionTimer.this.CLASS_NAME.getName(), "startTimer", "jms_adapter_messages", "UIMAJMS_inactivity_timer_expired__INFO", new Object[]{Thread.currentThread().getName(), ConnectionTimer.this.componentName, ConnectionTimer.this.inactivityTimeout, endpoint});
                        }
                        if (ConnectionTimer.this.connectionCreationTimestamp <= cachedConnectionCreationTimestamp) {
                            try {
                                block17: {
                                    if (ConnectionTimer.this.brokerDestinations.getConnection() != null && !((ActiveMQConnection)ConnectionTimer.this.brokerDestinations.getConnection()).isClosed()) {
                                        for (Map.Entry<Object, JmsEndpointConnection_impl> endpoints : ((ConnectionTimer)ConnectionTimer.this).brokerDestinations.endpointMap.entrySet()) {
                                            endpoints.getValue().close();
                                        }
                                        Object var4_5 = null;
                                        try {
                                            ConnectionTimer.this.brokerDestinations.getConnection().stop();
                                            ConnectionTimer.this.brokerDestinations.getConnection().close();
                                            ConnectionTimer.this.brokerDestinations.setConnection(null);
                                        }
                                        catch (Exception e2) {
                                            // empty catch block
                                        }
                                        String brokerConnectionURL = endpoint.isReplyEndpoint() ? JmsOutputChannel.this.serverURI : endpoint.getServerURI();
                                        ((ConnectionTimer)ConnectionTimer.this).brokerDestinations.endpointMap.clear();
                                        JmsOutputChannel.this.connectionMap.remove(brokerConnectionURL);
                                        {
                                            break block17;
                                            catch (Exception e) {
                                                Object var4_6 = null;
                                                try {
                                                    ConnectionTimer.this.brokerDestinations.getConnection().stop();
                                                    ConnectionTimer.this.brokerDestinations.getConnection().close();
                                                    ConnectionTimer.this.brokerDestinations.setConnection(null);
                                                }
                                                catch (Exception e2) {
                                                    // empty catch block
                                                }
                                                brokerConnectionURL = endpoint.isReplyEndpoint() ? JmsOutputChannel.this.serverURI : endpoint.getServerURI();
                                                ((ConnectionTimer)ConnectionTimer.this).brokerDestinations.endpointMap.clear();
                                                JmsOutputChannel.this.connectionMap.remove(brokerConnectionURL);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var4_7 = null;
                                            try {
                                                ConnectionTimer.this.brokerDestinations.getConnection().stop();
                                                ConnectionTimer.this.brokerDestinations.getConnection().close();
                                                ConnectionTimer.this.brokerDestinations.setConnection(null);
                                            }
                                            catch (Exception e2) {
                                                // empty catch block
                                            }
                                            brokerConnectionURL = endpoint.isReplyEndpoint() ? JmsOutputChannel.this.serverURI : endpoint.getServerURI();
                                            ((ConnectionTimer)ConnectionTimer.this).brokerDestinations.endpointMap.clear();
                                            JmsOutputChannel.this.connectionMap.remove(brokerConnectionURL);
                                            throw throwable;
                                        }
                                    }
                                }
                                ConnectionTimer.this.brokerDestinations.setConnection(null);
                                Object var7_12 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_14 = null;
                                ConnectionTimer.this.removeDestinationFromManagedList(ConnectionTimer.this.brokerDestinations, endpoint);
                                throw throwable;
                            }
                            ConnectionTimer.this.removeDestinationFromManagedList(ConnectionTimer.this.brokerDestinations, endpoint);
                            {
                                break block19;
                                catch (Exception exception) {
                                    Object var7_13 = null;
                                    ConnectionTimer.this.removeDestinationFromManagedList(ConnectionTimer.this.brokerDestinations, endpoint);
                                }
                            }
                        }
                    }
                    ConnectionTimer.this.cancelTimer();
                }
            }, timeToRun);
        }

        private void removeDestinationFromManagedList(BrokerConnectionEntry brokerDestinations, Endpoint endpoint) {
            String brokerConnectionURL = endpoint.isReplyEndpoint() ? JmsOutputChannel.this.serverURI : endpoint.getServerURI();
            String key = endpoint.getEndpoint() + brokerConnectionURL;
            String destination = endpoint.getEndpoint();
            if (endpoint.getDestination() != null && endpoint.getDestination() instanceof ActiveMQDestination) {
                key = destination = ((ActiveMQDestination)endpoint.getDestination()).getPhysicalName();
            }
            if (brokerDestinations.endpointExists(key)) {
                brokerDestinations.removeEndpoint(key);
            }
        }

        private void cancelTimer() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
            }
        }

        public synchronized void stopTimer() {
            this.cancelTimer();
            this.timer = null;
        }
    }

    public static class BrokerConnectionEntry {
        private String brokerURL;
        private Connection connection;
        private ConnectionTimer connectionTimer;
        Map<Object, JmsEndpointConnection_impl> endpointMap = new ConcurrentHashMap<Object, JmsEndpointConnection_impl>();

        public String getBrokerURL() {
            return this.brokerURL;
        }

        public void setConnectionTimer(ConnectionTimer aConnectionTimer) {
            this.connectionTimer = aConnectionTimer;
        }

        public ConnectionTimer getConnectionTimer() {
            return this.connectionTimer;
        }

        public void setBrokerURL(String brokerURL) {
            this.brokerURL = brokerURL;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public void addEndpointConnection(Object key, JmsEndpointConnection_impl endpointConnection) {
            this.endpointMap.put(key, endpointConnection);
        }

        public JmsEndpointConnection_impl getEndpointConnection(Object key) {
            return this.endpointMap.get(key);
        }

        public boolean endpointExists(Object key) {
            return this.endpointMap.containsKey(key);
        }

        public void removeEndpoint(Object key) {
            this.endpointMap.remove(key);
        }
    }
}

