/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.Endpoint_impl;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.InvalidMessageException;
import org.apache.uima.aae.handler.Handler;
import org.apache.uima.aae.handler.HandlerBase;
import org.apache.uima.aae.jmx.RemoteJMXServer;
import org.apache.uima.aae.jmx.ServiceInfo;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.adapter.jms.activemq.JmsInputChannelMBean;
import org.apache.uima.adapter.jms.activemq.TempDestinationResolver;
import org.apache.uima.adapter.jms.activemq.UimaDefaultMessageListenerContainer;
import org.apache.uima.adapter.jms.message.JmsMessageContext;
import org.apache.uima.util.Level;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class JmsInputChannel
implements InputChannel,
JmsInputChannelMBean,
SessionAwareMessageListener {
    private static final long serialVersionUID = -3318400773113552290L;
    private static final Class CLASS_NAME = JmsInputChannel.class;
    private final transient CountDownLatch msgHandlerLatch = new CountDownLatch(1);
    private final transient CountDownLatch controllerLatch = new CountDownLatch(1);
    private transient Handler handler;
    private String endpointName;
    private transient AnalysisEngineController controller;
    private int sessionAckMode;
    private transient UimaDefaultMessageListenerContainer messageListener;
    private transient Session jmsSession;
    private String brokerURL = "";
    private ServiceInfo serviceInfo = null;
    private volatile boolean stopped = false;
    private volatile boolean channelRegistered = false;
    private List listenerContainerList = new ArrayList();
    private Object mux = new Object();
    private transient RemoteJMXServer remoteJMXServer = null;
    private Object brokerMux = new Object();
    private ConcurrentHashMap<String, UimaDefaultMessageListenerContainer> failedListenerMap = new ConcurrentHashMap();
    public static transient boolean attachToBrokerMBeanServer = true;

    public AnalysisEngineController getController() {
        return this.controller;
    }

    public String getName() {
        return this.endpointName;
    }

    public void setController(AnalysisEngineController aController) throws Exception {
        this.controller = aController;
        if (!this.channelRegistered) {
            this.controller.addInputChannel(this);
        }
        this.controller.setInputChannel(this);
        this.controllerLatch.countDown();
    }

    public void setMessageHandler(Handler aHandler) {
        this.handler = aHandler;
        this.msgHandlerLatch.countDown();
    }

    public void setEndpointName(String anEndpointName) {
        this.endpointName = anEndpointName;
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "setEndpointName", "jms_adapter_messages", "UIMAJMS_service_listening__INFO", new Object[]{anEndpointName});
        }
    }

    private boolean validMessageType(Message aMessage, Map properties) throws Exception {
        if (properties.containsKey("MessageType")) {
            int msgType = aMessage.getIntProperty("MessageType");
            if (msgType != 3001 && msgType != 3000) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessageType", "jms_adapter_messages", "UIMAJMS_invalid_msgtype_in_message__INFO", new Object[]{msgType, this.endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessageType", "jms_adapter_messages", "UIMAJMS_msgtype_notin_message__INFO", new Object[]{this.endpointName});
            }
            return false;
        }
        return true;
    }

    private boolean isProcessRequest(Message aMessage) throws Exception {
        Map properties = ((ActiveMQMessage)aMessage).getProperties();
        if (properties.containsKey("MessageType") && properties.containsKey("Command")) {
            int msgType = aMessage.getIntProperty("MessageType");
            int command = aMessage.getIntProperty("Command");
            return msgType == 3000 && command == 2000;
        }
        return false;
    }

    private boolean isRemoteRequest(Message aMessage) throws Exception {
        if (aMessage.propertyExists("CasSequence")) {
            return false;
        }
        Map properties = ((ActiveMQMessage)aMessage).getProperties();
        if (properties.containsKey("MessageType") && properties.containsKey("Command") && properties.containsKey("ServerURI")) {
            boolean isRemote;
            int msgType = aMessage.getIntProperty("MessageType");
            int command = aMessage.getIntProperty("Command");
            boolean bl = isRemote = !aMessage.getStringProperty("ServerURI").startsWith("vm");
            if (isRemote && msgType == 3000 && (command == 2000 || command == 2002)) {
                return true;
            }
        }
        return false;
    }

    private boolean acceptsDeltaCas(Message aMessage) throws Exception {
        Map properties = ((ActiveMQMessage)aMessage).getProperties();
        boolean acceptsDeltaCas = false;
        if (properties.containsKey("AcceptsDeltaCas")) {
            acceptsDeltaCas = aMessage.getBooleanProperty("AcceptsDeltaCas");
        }
        return acceptsDeltaCas;
    }

    private boolean validCommand(Message aMessage, Map properties) throws Exception {
        if (properties.containsKey("Command")) {
            int command = aMessage.getIntProperty("Command");
            if (command != 2000 && command != 2001 && command != 2005 && command != 2006 && command != 2007 && command != 2008 && command != 2002) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validCommand", "jms_adapter_messages", "UIMAJMS_invalid_command_in_message__INFO", new Object[]{command, this.endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validCommand", "jms_adapter_messages", "UIMAJMS_command_notin_message__INFO", new Object[]{this.endpointName});
            }
            return false;
        }
        return true;
    }

    private boolean validPayload(Message aMessage, Map properties) throws Exception {
        int command;
        if (properties.containsKey("Command") && ((command = aMessage.getIntProperty("Command")) == 2001 || command == 2002 || command == 2006 || command == 2007 || command == 2008 || command == 2005)) {
            return true;
        }
        if (properties.containsKey("Payload")) {
            int payload = aMessage.getIntProperty("Payload");
            if (payload != 1000 && payload != 1006 && payload != 1001 && payload != 1003 && payload != 1002) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validPayload", "jms_adapter_messages", "UIMAJMS_invalid_payload_in_message__INFO", new Object[]{payload, this.endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validPayload", "jms_adapter_messages", "UIMAJMS_payload_notin_message__INFO", new Object[]{this.endpointName});
            }
            return false;
        }
        return true;
    }

    private boolean isStaleMessage(Message aMessage) throws JMSException {
        int command = aMessage.getIntProperty("Command");
        int msgType = aMessage.getIntProperty("MessageType");
        if (this.isStopped() || this.getController() == null || this.getController().getInProcessCache() == null) {
            return true;
        }
        if (command == 2000 && msgType == 3001) {
            String casReferenceId = aMessage.getStringProperty("CasReference");
            if (!this.getController().getInProcessCache().entryExists(casReferenceId)) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "isStaleMessage", "jms_adapter_messages", "UIMAJMS_stale_message__FINE", new Object[]{this.endpointName, casReferenceId, aMessage.getStringProperty("MessageFrom")});
                }
                return true;
            }
        }
        return false;
    }

    public boolean validMessage(Message aMessage) throws Exception {
        if (aMessage instanceof ActiveMQMessage) {
            Map properties = ((ActiveMQMessage)aMessage).getProperties();
            if (!this.validMessageType(aMessage, properties)) {
                int msgType = 0;
                if (properties.containsKey("MessageType")) {
                    msgType = aMessage.getIntProperty("MessageType");
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessage", "jms_adapter_messages", "UIMAJMS_invalid_msg_type__INFO", new Object[]{this.getController().getComponentName(), msgType});
                }
                return false;
            }
            if (!this.validCommand(aMessage, properties)) {
                int command = 0;
                if (properties.containsKey("Command")) {
                    command = aMessage.getIntProperty("Command");
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessage", "jms_adapter_messages", "UIMAJMS_invalid_cmd_type__INFO", new Object[]{this.getController().getComponentName(), command});
                }
                return false;
            }
            if (!this.validPayload(aMessage, properties)) {
                int payload = 0;
                if (properties.containsKey("Payload")) {
                    payload = aMessage.getIntProperty("Payload");
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessage", "jms_adapter_messages", "UIMAJMS_invalid_payload_type__INFO", new Object[]{this.getController().getComponentName(), payload});
                }
                return false;
            }
            if (this.isStaleMessage(aMessage)) {
                if (this.sessionAckMode == 2) {
                    aMessage.acknowledge();
                }
                return false;
            }
        }
        return true;
    }

    public void abort() {
    }

    private String decodeIntToString(String aTypeToDecode, int aValueToDecode) {
        if ("MessageType".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 3000: {
                    return "Request";
                }
                case 3001: {
                    return "Response";
                }
            }
        } else if ("Command".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 2000: {
                    return "Process";
                }
                case 2001: {
                    return "GetMetadata";
                }
                case 2002: {
                    return "CollectionProcessComplete";
                }
                case 2005: {
                    return "ReleaseCAS";
                }
                case 2006: {
                    return "Stop";
                }
                case 2007: {
                    return "Ping";
                }
                case 2008: {
                    return "ServiceInfo";
                }
            }
        } else if ("Payload".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 1000: {
                    return "XMIPayload";
                }
                case 1006: {
                    return "BinaryPayload";
                }
                case 1001: {
                    return "CASRefID";
                }
                case 1002: {
                    return "Metadata";
                }
                case 1003: {
                    return "Exception";
                }
                case 1004: {
                    return "XCASPayload";
                }
                case 1005: {
                    return "None";
                }
            }
        }
        return "UNKNOWN";
    }

    private boolean ackMessageNow(Message aMessage) throws JMSException {
        if (this.sessionAckMode != 2) {
            return false;
        }
        return aMessage.getIntProperty("Command") == 2001 || aMessage.getIntProperty("Command") == 2002 || aMessage.getIntProperty("Command") == 2005 || aMessage.getIntProperty("Command") == 2004;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCheckpointWorthy(Message aMessage) throws Exception {
        Object object = this.mux;
        synchronized (object) {
            if (aMessage.propertyExists("CasSequence")) {
                return false;
            }
            Map properties = ((ActiveMQMessage)aMessage).getProperties();
            if (properties.containsKey("MessageType") && properties.containsKey("Command") && properties.containsKey("ServerURI")) {
                int msgType = aMessage.getIntProperty("MessageType");
                int command = aMessage.getIntProperty("Command");
                if (msgType == 3000 && (command == 2000 || command == 2002)) {
                    return true;
                }
            }
            return false;
        }
    }

    private boolean isReplyRequired(Message aMessage) {
        try {
            int command = aMessage.getIntProperty("Command");
            if (aMessage.getIntProperty("MessageType") == 3000 && (command == 2000 || command == 2001 || command == 2002)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean validEndpoint(JmsMessageContext messageContext) {
        return messageContext.getEndpoint() != null && messageContext.getEndpoint().getDestination() != null;
    }

    private boolean processRequestMessage(Message aMessage, JmsMessageContext messageContext) throws Exception {
        if (this.isReplyRequired(aMessage) && !messageContext.propertyExists("CasSequence") && this.validEndpoint(messageContext)) {
            String queueName = this.remoteJMXServer.normalize(messageContext.getEndpoint().getDestination().toString());
            return this.remoteJMXServer.isClientReplyQueueAvailable(queueName);
        }
        return true;
    }

    private boolean ackClient(JmsMessageContext messageContext) throws Exception {
        return !messageContext.propertyExists("CasSequence") && !messageContext.getMessageStringProperty("ServerURI").startsWith("vm") && this.validEndpoint(messageContext) && this.isReplyRequired((Message)messageContext.getRawMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message aMessage, Session aJmsSession) {
        int requestType;
        boolean doCheckpoint;
        String casRefId;
        block33: {
            casRefId = null;
            if (this.isStopped()) {
                return;
            }
            try {
                this.msgHandlerLatch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.controllerLatch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long idleTime = 0L;
            doCheckpoint = false;
            String eN = this.endpointName;
            if (this.getController() != null && (eN = this.getController().getComponentName()) == null) {
                eN = "";
            }
            String command = "N/A";
            String messageType = "N/A";
            JmsMessageContext messageContext = null;
            requestType = 0;
            try {
                messageContext = new JmsMessageContext(aMessage, this.endpointName);
                casRefId = aMessage.getStringProperty("CasReference") == null ? "CasReferenceId Not In Message" : aMessage.getStringProperty("CasReference");
                if (this.validMessage(aMessage)) {
                    command = this.decodeIntToString("Command", aMessage.getIntProperty("Command"));
                    messageType = this.decodeIntToString("MessageType", aMessage.getIntProperty("MessageType"));
                    String msgSentFromIP = null;
                    if (aMessage.getIntProperty("MessageType") == 3001 && aMessage.propertyExists("ServerIP")) {
                        msgSentFromIP = aMessage.getStringProperty("ServerIP");
                    }
                    String msgFrom = aMessage.getStringProperty("MessageFrom");
                    if (this.controller != null && msgFrom != null) {
                        if (this.ackClient(messageContext)) {
                            try {
                                this.getController().getOutputChannel().sendReply(2008, messageContext.getEndpoint(), aMessage.getStringProperty("CasReference"), true);
                            }
                            catch (Exception ex) {
                                if (doCheckpoint && this.getController() instanceof PrimitiveAnalysisEngineController) {
                                    this.getController().endProcess(requestType);
                                }
                                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) return;
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_msg_processed__FINE", new Object[]{this.getController().getComponentName(), casRefId});
                                return;
                            }
                        }
                        if (msgSentFromIP != null) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_recvd_new_message_with_ip__FINE", new Object[]{this.controller.getComponentName(), msgFrom, msgSentFromIP, messageType, command, casRefId});
                            }
                        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_recvd_new_message__FINE", new Object[]{this.controller.getComponentName(), msgFrom, messageType, command, casRefId});
                        }
                    }
                    try {
                        if (this.isRemoteRequest(aMessage)) {
                            idleTime = this.getController().getIdleTime();
                            messageContext.getEndpoint().setIdleTime(idleTime);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    doCheckpoint = this.isCheckpointWorthy(aMessage);
                    requestType = aMessage.getIntProperty("Command");
                    if (doCheckpoint) {
                        this.getController().beginProcess(requestType);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_new_msg_in__FINEST", new Object[]{this.getController().getComponentName(), msgFrom, command, messageType, casRefId});
                    }
                    if (this.handler != null) {
                        this.handler.handle(messageContext);
                    }
                    break block33;
                }
                if (this.isStaleMessage(aMessage)) break block33;
                this.controller.getErrorHandlerChain().handle(new InvalidMessageException(), HandlerBase.populateErrorContext(messageContext), this.controller);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof Error) {
                        t.printStackTrace();
                        System.err.println("\n\n\n\tUIMA AS Service Caught Java Error. Exiting via System.exit(2)");
                        System.err.flush();
                        System.exit(2);
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", t);
                    }
                    this.controller.getErrorHandlerChain().handle(t, HandlerBase.populateErrorContext(messageContext), this.controller);
                }
                catch (Throwable throwable) {
                    if (doCheckpoint && this.getController() instanceof PrimitiveAnalysisEngineController) {
                        this.getController().endProcess(requestType);
                    }
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) throw throwable;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_msg_processed__FINE", new Object[]{this.getController().getComponentName(), casRefId});
                    throw throwable;
                }
                if (doCheckpoint && this.getController() instanceof PrimitiveAnalysisEngineController) {
                    this.getController().endProcess(requestType);
                }
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) return;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_msg_processed__FINE", new Object[]{this.getController().getComponentName(), casRefId});
                return;
            }
        }
        if (doCheckpoint && this.getController() instanceof PrimitiveAnalysisEngineController) {
            this.getController().endProcess(requestType);
        }
        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) return;
        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_msg_processed__FINE", new Object[]{this.getController().getComponentName(), casRefId});
        return;
    }

    private String extractNodeName(String url) {
        int startPos = url.indexOf("//");
        String temp = url.substring(startPos + 2);
        int endPos = temp.indexOf(":");
        return temp.substring(0, endPos).trim();
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public String getServerUri() {
        return this.brokerURL;
    }

    public synchronized void setListenerContainer(UimaDefaultMessageListenerContainer messageListener) {
        this.messageListener = messageListener;
        System.setProperty("BrokerURI", messageListener.getBrokerUrl());
        if (messageListener.getMessageSelector() != null && messageListener.getMessageSelector().equals("Command=2001")) {
            this.brokerURL = messageListener.getBrokerUrl();
            this.getController().getOutputChannel().setServerURI(this.brokerURL);
        }
        if (!this.listenerContainerList.contains((Object)messageListener)) {
            this.listenerContainerList.add(messageListener);
        }
        if (this.getController() != null) {
            try {
                this.getController().addInputChannel(this);
                messageListener.setController(this.getController());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        if (this.messageListener == null) {
            return null;
        }
        return (ActiveMQConnectionFactory)this.messageListener.getConnectionFactory();
    }

    public void ackMessage(MessageContext aMessageContext) {
        block3: {
            if (aMessageContext != null && this.sessionAckMode == 2) {
                try {
                    ((Message)aMessageContext.getRawMessage()).acknowledge();
                }
                catch (Exception e) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "ackMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "ackMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public String getInputQueueName() {
        if (this.messageListener != null) {
            if (this.messageListener.getDestination() != null) {
                return this.messageListener.getDestination().toString();
            }
            return this.messageListener.getDestinationName();
        }
        return "";
    }

    public ServiceInfo getServiceInfo() {
        if (this.serviceInfo == null) {
            this.serviceInfo = new ServiceInfo(false, this.controller);
            this.serviceInfo.setBrokerURL(this.getBrokerURL());
            this.serviceInfo.setInputQueueName(this.getName());
            if (this.controller == null) {
                this.serviceInfo.setState(BaseAnalysisEngineController.ServiceState.INITIALIZING.name());
            } else if (this.controller.isCasMultiplier()) {
                this.serviceInfo.setCASMultiplier();
            }
        }
        return this.serviceInfo;
    }

    public void setServerUri(String serverUri) {
        this.brokerURL = serverUri;
        if (this.getController() != null && this.getController() instanceof AggregateAnalysisEngineController) {
            ((AggregateAnalysisEngineController)this.getController()).getServiceInfo().setBrokerURL(this.brokerURL);
        } else {
            ((PrimitiveAnalysisEngineController)this.getController()).getServiceInfo().setBrokerURL(this.brokerURL);
        }
    }

    private void stopChannel(UimaDefaultMessageListenerContainer mL, boolean shutdownNow) throws Exception {
        String eName = mL.getEndpointName();
        if (eName != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stopChannel", "jms_adapter_messages", "UIMAJMS_stopping_jms_transport__INFO", new Object[]{eName, shutdownNow});
        }
        mL.delegateStop();
        if (shutdownNow) {
            mL.destroy(shutdownNow);
        }
        String selector = "";
        if (mL.getMessageSelector() != null) {
            selector = " Selector:" + mL.getMessageSelector();
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stopChannel", "jms_adapter_messages", "UIMAJMS_stopped_jms_transport__INFO", new Object[]{this.getController().getComponentName(), mL.getDestination(), selector});
        }
    }

    private boolean doCloseChannel(UimaDefaultMessageListenerContainer mL, int channelsToClose) {
        ActiveMQDestination destination;
        return channelsToClose != 1 || (destination = (ActiveMQDestination)mL.getListenerEndpoint()) == null || !destination.isTemporary();
    }

    public void stop(boolean shutdownNow) throws Exception {
        this.stop(0, shutdownNow);
        this.listenerContainerList.clear();
        this.failedListenerMap.clear();
        if (this.remoteJMXServer != null) {
            this.remoteJMXServer.disconnect();
            this.remoteJMXServer = null;
        }
    }

    public void disconnectListenersFromQueue() throws Exception {
        for (Object listenerObject : this.listenerContainerList) {
            UimaDefaultMessageListenerContainer mL = (UimaDefaultMessageListenerContainer)((Object)listenerObject);
            this.stopChannel(mL, false);
        }
    }

    public void setTerminating() {
        if (this.listenerContainerList.size() > 0) {
            ((UimaDefaultMessageListenerContainer)((Object)this.listenerContainerList.get(0))).setTerminating();
        }
    }

    public void terminate() {
        try {
            if (this.listenerContainerList.size() > 0) {
                ((UimaDefaultMessageListenerContainer)((Object)this.listenerContainerList.get(0))).closeConnection();
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "terminate", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
        }
    }

    public synchronized void stop(int channelsToClose, boolean shutdownNow) throws Exception {
        ArrayList<UimaDefaultMessageListenerContainer> listenersToRemove = new ArrayList<UimaDefaultMessageListenerContainer>();
        for (Object listenerObject : this.listenerContainerList) {
            UimaDefaultMessageListenerContainer mL = (UimaDefaultMessageListenerContainer)((Object)listenerObject);
            if (mL != null && this.doCloseChannel(mL, channelsToClose)) {
                this.stopChannel(mL, shutdownNow);
                if (!this.listenerContainerList.contains((Object)mL)) continue;
                if (this.listenerContainerList.size() == 1) {
                    try {
                        mL.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                listenersToRemove.add(mL);
                continue;
            }
            if (this.getController() == null || !UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) continue;
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "stop", "jms_adapter_messages", "UIMAJMS_transport_not_stopped__INFO", new Object[]{this.getController().getComponentName()});
        }
        for (UimaDefaultMessageListenerContainer mL : listenersToRemove) {
            if (this.listenerContainerList.size() == 1) {
                ((UimaDefaultMessageListenerContainer)((Object)this.listenerContainerList.get(0))).closeConnection();
            }
            this.listenerContainerList.remove((Object)mL);
        }
        listenersToRemove.clear();
        if (channelsToClose == 0) {
            this.stopped = true;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getConcurrentConsumerCount() {
        return this.messageListener.getConcurrentConsumers();
    }

    private void testIfBrokerRunning(String aBrokerUrl) throws Exception {
        ActiveMQConnectionFactory f = new ActiveMQConnectionFactory(aBrokerUrl);
        Connection testConnection = null;
        try {
            testConnection = f.createConnection();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (testConnection != null) {
                testConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createListener(String aDelegateKey, Endpoint endpointToUpdate) throws Exception {
        Delegate delegate;
        if (this.getController() instanceof AggregateAnalysisEngineController && (delegate = ((AggregateAnalysisEngineController)this.getController()).lookupDelegate(aDelegateKey)) != null) {
            UimaDefaultMessageListenerContainer newListener = new UimaDefaultMessageListenerContainer();
            this.testIfBrokerRunning(delegate.getEndpoint().getServerURI());
            ActiveMQConnectionFactory f = new ActiveMQConnectionFactory(delegate.getEndpoint().getServerURI());
            newListener.setConnectionFactory((ConnectionFactory)f);
            newListener.setMessageListener(this);
            newListener.setController(this.getController());
            TempDestinationResolver resolver = new TempDestinationResolver();
            resolver.setConnectionFactory(f);
            resolver.setListener(newListener);
            newListener.setDestinationResolver(resolver);
            newListener.setAcceptMessagesWhileStopping(true);
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(delegate.getEndpoint().getConcurrentReplyConsumers());
            executor.setMaxPoolSize(delegate.getEndpoint().getConcurrentReplyConsumers());
            executor.setQueueCapacity(delegate.getEndpoint().getConcurrentReplyConsumers());
            executor.initialize();
            newListener.setConcurrentConsumers(delegate.getEndpoint().getConcurrentReplyConsumers());
            newListener.setTaskExecutor((TaskExecutor)executor);
            newListener.initialize();
            newListener.start();
            while (newListener.getDestination() == null) {
                UimaDefaultMessageListenerContainer uimaDefaultMessageListenerContainer = newListener;
                synchronized (uimaDefaultMessageListenerContainer) {
                    ((Object)((Object)newListener)).wait(100L);
                }
            }
            newListener.afterPropertiesSet();
            if (this.controller != null && this.controller.isStopped()) {
                newListener.destroy(true);
                return;
            }
            Endpoint endpoint = ((AggregateAnalysisEngineController)this.getController()).lookUpEndpoint(aDelegateKey, false);
            endpoint.setDestination(newListener.getDestination());
            if (endpointToUpdate != null) {
                endpointToUpdate.setDestination(newListener.getDestination());
            }
            Object clone = ((Endpoint_impl)endpoint).clone();
            newListener.setTargetEndpoint((Endpoint)clone);
            endpoint.setStatus(1);
        }
    }

    public boolean isListenerActiveOnDestination(Destination destination) {
        for (int i = 0; i < this.listenerContainerList.size(); ++i) {
            UimaDefaultMessageListenerContainer mListener = (UimaDefaultMessageListenerContainer)((Object)this.listenerContainerList.get(i));
            if (mListener.getDestination() == null || mListener.getDestination() != destination || !mListener.isRunning()) continue;
            return true;
        }
        return false;
    }

    private UimaDefaultMessageListenerContainer[] getListenersForEndpoint(String anEndpointName) {
        ArrayList<UimaDefaultMessageListenerContainer> listeners = new ArrayList<UimaDefaultMessageListenerContainer>();
        for (int i = 0; i < this.listenerContainerList.size(); ++i) {
            UimaDefaultMessageListenerContainer mListener = (UimaDefaultMessageListenerContainer)((Object)this.listenerContainerList.get(i));
            if (mListener.getDestinationName() != null && mListener.getDestinationName().equals(anEndpointName)) {
                listeners.add(mListener);
                continue;
            }
            if (mListener.getDestination() == null || !mListener.getDestination().toString().equals(anEndpointName)) continue;
            listeners.add(mListener);
        }
        if (listeners.size() > 0) {
            UimaDefaultMessageListenerContainer[] listenerArray = new UimaDefaultMessageListenerContainer[listeners.size()];
            listeners.toArray(listenerArray);
            return listenerArray;
        }
        return null;
    }

    public void destroyListener(String anEndpointName, String aDelegateKey) {
        if (this.failedListenerMap.containsKey(aDelegateKey)) {
            return;
        }
        UimaDefaultMessageListenerContainer[] mListeners = this.getListenersForEndpoint(anEndpointName);
        if (mListeners == null) {
            return;
        }
        for (UimaDefaultMessageListenerContainer mListener : mListeners) {
            if (!mListener.isRunning()) continue;
            try {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO) && mListener.getDestination() != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "destroyListener", "jms_adapter_messages", "UIMAJMS_stop_listener__INFO", new Object[]{mListener.getDestination().toString()});
                }
                mListener.stop();
                if (this.getController() == null) continue;
                Endpoint endpoint = ((AggregateAnalysisEngineController)this.getController()).lookUpEndpoint(aDelegateKey, false);
                endpoint.setStatus(2);
                if (mListener.getConnectionFactory() == null || !(this.getController() instanceof AggregateAnalysisEngineController) || this.failedListenerMap.containsKey(aDelegateKey)) continue;
                this.failedListenerMap.put(aDelegateKey, mListener);
                this.listenerContainerList.remove((Object)mListener);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "destroyListener", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "destroyListener", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public boolean isFailed(String aDelegateKey) {
        return this.failedListenerMap.containsKey(aDelegateKey);
    }

    public void removeDelegateFromFailedList(String aDelegateKey) {
        if (this.failedListenerMap.containsKey(aDelegateKey)) {
            this.failedListenerMap.remove(aDelegateKey);
        }
    }

    public boolean isListenerForDestination(String anEndpointName) {
        UimaDefaultMessageListenerContainer[] mListeners = this.getListenersForEndpoint(anEndpointName);
        return mListeners != null;
    }
}

