/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.spi.transport.vm;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaAsContext;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.handler.Handler;
import org.apache.uima.aae.handler.input.MetadataRequestHandler_impl;
import org.apache.uima.aae.handler.input.MetadataResponseHandler_impl;
import org.apache.uima.aae.handler.input.ProcessRequestHandler_impl;
import org.apache.uima.aae.handler.input.ProcessResponseHandler;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.aae.message.UimaMessageValidator;
import org.apache.uima.aae.spi.transport.UimaMessage;
import org.apache.uima.aae.spi.transport.UimaMessageListener;
import org.apache.uima.util.Level;

public class UimaVmMessageListener
implements UimaMessageListener {
    private static final Class CLASS_NAME = UimaVmMessageListener.class;
    private AnalysisEngineController controller;
    private transient Handler handler;
    private CountDownLatch latch = new CountDownLatch(1);
    private ConcurrentHashMap<Long, String> concurrentThreads = new ConcurrentHashMap();

    public UimaVmMessageListener(AnalysisEngineController aController) {
        this.controller = aController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(UimaMessage aMessage) {
        boolean doCheckpoint = false;
        int requestType = 0;
        try {
            this.latch.await();
            if (this.controller != null && this.controller.isStopped()) {
                return;
            }
            if (UimaMessageValidator.isValidMessage(aMessage, this.controller)) {
                MessageContext msgContext = aMessage.toMessageContext(this.controller.getName());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "onMessage", "uimaee_messages", "UIMAEE_new_msg_recvd__FINEST", new Object[]{this.controller.getComponentName(), aMessage.toString()});
                }
                if (!this.concurrentThreads.containsKey(Thread.currentThread().getId())) {
                    Thread.currentThread().setName(Thread.currentThread().getName() + "::" + this.controller.getComponentName() + "::" + Thread.currentThread().getId());
                    this.concurrentThreads.put(Thread.currentThread().getId(), Thread.currentThread().getName());
                }
                if ((requestType = aMessage.getIntProperty("Command")) == 2006) {
                    return;
                }
                doCheckpoint = this.isCheckpointWorthy(aMessage);
                if (doCheckpoint) {
                    this.controller.beginProcess(requestType);
                }
                this.handler.handle(msgContext);
            }
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                if (this.controller != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "onMessage", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        finally {
            if (doCheckpoint && this.controller instanceof PrimitiveAnalysisEngineController) {
                this.controller.endProcess(requestType);
            }
        }
    }

    public void initialize(UimaAsContext context) throws Exception {
        MetadataRequestHandler_impl metaRequestHandler = new MetadataRequestHandler_impl("MetadataRequestHandler");
        ProcessRequestHandler_impl processRequestHandler = new ProcessRequestHandler_impl("ProcessRequestHandler");
        metaRequestHandler.setController(this.controller);
        processRequestHandler.setController(this.controller);
        this.handler = processRequestHandler;
        if (this.controller instanceof AggregateAnalysisEngineController) {
            ProcessResponseHandler processResponseHandler = new ProcessResponseHandler("ProcessResponseHandler");
            processResponseHandler.setController(this.controller);
            processResponseHandler.setDelegate(metaRequestHandler);
            processRequestHandler.setDelegate(processResponseHandler);
            MetadataResponseHandler_impl metadataResponseHandler = new MetadataResponseHandler_impl("MetadataResponseHandler");
            metadataResponseHandler.setController(this.controller);
            metaRequestHandler.setDelegate(metadataResponseHandler);
        } else {
            processRequestHandler.setDelegate(metaRequestHandler);
        }
        this.latch.countDown();
    }

    private boolean isCheckpointWorthy(UimaMessage aMessage) throws Exception {
        if (aMessage.containsProperty("CasSequence")) {
            return false;
        }
        if (aMessage.containsProperty("MessageType") && aMessage.containsProperty("Command") && aMessage.containsProperty("ServerURI")) {
            int msgType = aMessage.getIntProperty("MessageType");
            int command = aMessage.getIntProperty("Command");
            if (msgType == 3000 && (command == 2000 || command == 2002)) {
                return true;
            }
        }
        return false;
    }

    public void startIt() {
    }

    public void stopIt() {
    }
}

