/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.handler.input;

import java.util.concurrent.Semaphore;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.SerializerCache;
import org.apache.uima.aae.UimaSerializer;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController_impl;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.Endpoint_impl;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.InvalidMessageException;
import org.apache.uima.aae.handler.HandlerBase;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.aae.monitor.statistics.DelegateStats;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.aae.monitor.statistics.TimerStats;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.util.Level;

public class ProcessRequestHandler_impl
extends HandlerBase {
    private static final Class CLASS_NAME = ProcessRequestHandler_impl.class;
    final ThreadLocal<Semaphore> threadCompletionMonitor = new ThreadLocal();
    private Object mux = new Object();

    public ProcessRequestHandler_impl(String aName) {
        super(aName);
    }

    private void cacheStats(String aCasReferenceId, long aTimeWaitingForCAS, long aTimeToDeserializeCAS) throws Exception {
        InProcessCache.CacheEntry entry = this.getController().getInProcessCache().getCacheEntryForCAS(aCasReferenceId);
        entry.incrementTimeWaitingForCAS(aTimeWaitingForCAS);
        entry.incrementTimeToDeserializeCAS(aTimeToDeserializeCAS);
    }

    private boolean messageContainsXMI(MessageContext aMessageContext, String casReferenceId) throws Exception {
        String xmi = aMessageContext.getStringMessage();
        if (xmi == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithXMI", "uimaee_messages", "UIMAEE_message_has_no_cargo__INFO", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
            }
            LocalCache.CasStateEntry stateEntry = null;
            String parentCasReferenceId = null;
            try {
                stateEntry = this.getController().getLocalCache().lookupEntry(casReferenceId);
                if (stateEntry != null && stateEntry.isSubordinate()) {
                    LocalCache.CasStateEntry topParentEntry = this.getController().getLocalCache().getTopCasAncestor(casReferenceId);
                    parentCasReferenceId = topParentEntry.getCasReferenceId();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.getController().getOutputChannel().sendReply(new InvalidMessageException("No XMI data in message"), casReferenceId, parentCasReferenceId, aMessageContext.getEndpoint(), 2000);
            return false;
        }
        return true;
    }

    private synchronized CAS getCAS(boolean fetchCASFromShadowCasPool, String shadowCasPoolKey, String casReceivedFrom) {
        CAS cas = null;
        if (fetchCASFromShadowCasPool) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "getCAS", "uimaee_messages", "UIMAEE_request_cas_cm__FINE", new Object[]{shadowCasPoolKey});
            }
            ((AggregateAnalysisEngineController)this.getController()).getDelegateServicePerformance(shadowCasPoolKey).beginWaitOnShadowCASPool();
            cas = this.getController().getCasManagerWrapper().getNewCas(shadowCasPoolKey);
            ((AggregateAnalysisEngineController)this.getController()).getDelegateServicePerformance(shadowCasPoolKey).endWaitOnShadowCASPool();
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getCAS", "uimaee_messages", "UIMAEE_request_cas_granted_cm__FINE", new Object[]{shadowCasPoolKey});
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "getCAS", "uimaee_messages", "UIMAEE_request_cas__FINE", new Object[]{casReceivedFrom});
            }
            this.getController().getServicePerformance().beginWaitOnCASPool();
            cas = this.getController().getCasManagerWrapper().getNewCas();
            this.getController().getServicePerformance().endWaitOnCASPool();
            ServicePerformance sp = this.getController().getServicePerformance();
            sp.incrementCasPoolWaitTime(sp.getTimeWaitingForCAS());
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "getCAS", "uimaee_messages", "UIMAEE_request_cas_granted__FINE", new Object[]{casReceivedFrom});
            }
        }
        return cas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InProcessCache.CacheEntry deserializeCASandRegisterWithCache(String casReferenceId, Endpoint freeCasEndpoint, String shadowCasPoolKey, MessageContext aMessageContext) throws Exception {
        long inTime = System.nanoTime();
        boolean casRegistered = false;
        long t1 = this.getController().getCpuTime();
        Endpoint endpoint = aMessageContext.getEndpoint();
        CAS cas = null;
        InProcessCache.CacheEntry entry = null;
        try {
            cas = this.getCAS(aMessageContext.propertyExists("CasSequence"), shadowCasPoolKey, endpoint.getEndpoint());
            long timeWaitingForCAS = this.getController().getCpuTime() - t1;
            if (this.getController().isStopped()) {
                this.getController().dropCAS(cas);
                return null;
            }
            t1 = this.getController().getCpuTime();
            String serializationStrategy = endpoint.getSerializer();
            XmiSerializationSharedData deserSharedData = null;
            UimaSerializer uimaSerializer = SerializerCache.lookupSerializerByThreadId();
            if (serializationStrategy.equals("xmi")) {
                String xmi = aMessageContext.getStringMessage();
                deserSharedData = new XmiSerializationSharedData();
                uimaSerializer.deserializeCasFromXmi(xmi, cas, deserSharedData, true, -1);
            } else if (serializationStrategy.equals("binary")) {
                byte[] binarySource = aMessageContext.getByteMessage();
                uimaSerializer.deserializeCasFromBinary(binarySource, cas);
            }
            boolean acceptsDeltaCas = false;
            Marker marker = null;
            if (aMessageContext.propertyExists("AcceptsDeltaCas") && (acceptsDeltaCas = aMessageContext.getMessageBooleanProperty("AcceptsDeltaCas"))) {
                marker = cas.createMarker();
            }
            entry = this.getController().getInProcessCache().register(cas, aMessageContext, deserSharedData, casReferenceId, marker, acceptsDeltaCas);
            if (!this.getController().isPrimitive()) {
                Semaphore semaphore = new Semaphore(0);
                this.threadCompletionMonitor.set(semaphore);
                entry.setThreadCompletionSemaphore(semaphore);
            }
            long timeToDeserializeCAS = this.getController().getCpuTime() - t1;
            this.getController().incrementDeserializationTime(timeToDeserializeCAS);
            LongNumericStatistic statistic = this.getController().getMonitor().getLongNumericStatistic("", "TotalDeserializeTime");
            if (statistic != null) {
                statistic.increment(timeToDeserializeCAS);
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithXMI", "uimaee_messages", "UIMAEE_deserialize_cas_time_FINE", new Object[]{(double)timeToDeserializeCAS / 1000000.0});
            }
            ServicePerformance casStats = this.getController().getCasStatistics(casReferenceId);
            casStats.incrementCasDeserializationTime(timeToDeserializeCAS);
            if (this.getController().isTopLevelComponent()) {
                Object object = this.mux;
                synchronized (object) {
                    this.getController().getServicePerformance().incrementCasDeserializationTime(timeToDeserializeCAS);
                }
            }
            this.getController().saveTime(inTime, casReferenceId, this.getController().getName());
            if (this.getController() instanceof AggregateAnalysisEngineController) {
                if (aMessageContext.propertyExists("CasSequence")) {
                    String inputCasReferenceId = aMessageContext.getMessageStringProperty("InputCasReference");
                    if (shadowCasPoolKey != null) {
                        entry.setCasProducerKey(shadowCasPoolKey);
                    }
                    entry.setInputCasReferenceId(inputCasReferenceId);
                    entry.setFreeCasEndpoint(freeCasEndpoint);
                    this.cacheStats(inputCasReferenceId, timeWaitingForCAS, timeToDeserializeCAS);
                } else {
                    this.cacheStats(casReferenceId, timeWaitingForCAS, timeToDeserializeCAS);
                }
                DelegateStats stats = new DelegateStats();
                if (entry.getStat() == null) {
                    entry.setStat(stats);
                    stats.put(this.getController().getServiceEndpointName(), new TimerStats());
                } else if (!stats.containsKey(this.getController().getServiceEndpointName())) {
                    stats.put(this.getController().getServiceEndpointName(), new DelegateStats());
                }
            } else {
                this.cacheStats(casReferenceId, timeWaitingForCAS, timeToDeserializeCAS);
            }
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithXMI", "uimaee_messages", "UIMAEE_deserialized_cas_ready_to_process_FINE", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
            }
            this.cacheProcessCommandInClientEndpoint();
        }
        catch (Exception e) {
            if (cas != null) {
                cas.release();
            }
            throw e;
        }
        return entry;
    }

    private String getCasReferenceId(MessageContext aMessageContext) throws Exception {
        if (!aMessageContext.propertyExists("CasReference")) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_message_has_cas_refid__INFO", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
            }
            this.getController().getOutputChannel().sendReply(new InvalidMessageException("No Cas Reference Id Received From Delegate In message"), null, null, aMessageContext.getEndpoint(), 2000);
            return null;
        }
        return aMessageContext.getMessageStringProperty("CasReference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessRequestFromRemoteClient(MessageContext aMessageContext) throws AsynchAEException {
        block27: {
            InProcessCache.CacheEntry entry = null;
            String casReferenceId = null;
            if (aMessageContext.getMessageIntProperty("Payload") == 1000 && aMessageContext.getStringMessage() == null) {
                return;
            }
            try {
                String newCASProducedBy = null;
                casReferenceId = this.getCasReferenceId(aMessageContext);
                if (casReferenceId == null) {
                    return;
                }
                String inputCasReferenceId = casReferenceId;
                Endpoint freeCasEndpoint = null;
                LocalCache.CasStateEntry inputCasStateEntry = null;
                if (aMessageContext.propertyExists("CasSequence")) {
                    Endpoint casMultiplierEndpoint;
                    String cmEndpointName = aMessageContext.getMessageStringProperty("MessageFrom");
                    newCASProducedBy = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(cmEndpointName);
                    inputCasReferenceId = aMessageContext.getMessageStringProperty("InputCasReference");
                    InProcessCache.CacheEntry inputCasCacheEntry = this.getController().getInProcessCache().getCacheEntryForCAS(inputCasReferenceId);
                    freeCasEndpoint = aMessageContext.getEndpoint();
                    freeCasEndpoint = (Endpoint)((Endpoint_impl)freeCasEndpoint).clone();
                    if (this.getController() instanceof AggregateAnalysisEngineController) {
                        inputCasStateEntry = ((AggregateAnalysisEngineController)this.getController()).getLocalCache().lookupEntry(inputCasReferenceId);
                        inputCasStateEntry.setFreeCasNotificationEndpoint(freeCasEndpoint);
                    }
                    this.computeStats(aMessageContext, inputCasReferenceId);
                    aMessageContext.getEndpoint().setDestination(null);
                    Endpoint replyToEndpoint = inputCasCacheEntry.getMessageOrigin();
                    aMessageContext.getEndpoint().setEndpoint(replyToEndpoint.getEndpoint());
                    aMessageContext.getEndpoint().setServerURI(replyToEndpoint.getServerURI());
                    if (this.getController() instanceof AggregateAnalysisEngineController && (casMultiplierEndpoint = ((AggregateAnalysisEngineController)this.getController()).lookUpEndpoint(newCASProducedBy, false)) != null) {
                        freeCasEndpoint.setServerURI(casMultiplierEndpoint.getServerURI());
                    }
                } else if (this.getController().isTopLevelComponent() && this.getController() instanceof AggregateAnalysisEngineController) {
                    ((AggregateAnalysisEngineController)this.getController()).addMessageOrigin(casReferenceId, aMessageContext.getEndpoint());
                }
                if (!this.getController().getInProcessCache().entryExists(casReferenceId)) {
                    LocalCache.CasStateEntry cse = null;
                    if (this.getController().getLocalCache().lookupEntry(casReferenceId) == null) {
                        cse = this.getController().getLocalCache().createCasStateEntry(casReferenceId);
                        if (aMessageContext.propertyExists("CasSequence")) {
                            cse.setInputCasReferenceId(inputCasReferenceId);
                        }
                    } else {
                        cse = this.getController().getLocalCache().lookupEntry(casReferenceId);
                    }
                    if (this.getController() instanceof AggregateAnalysisEngineController && aMessageContext.propertyExists("CasSequence")) {
                        String delegateInputQueueName = aMessageContext.getMessageStringProperty("MessageFrom");
                        String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(delegateInputQueueName);
                        if (delegateKey != null) {
                            Delegate delegate = ((AggregateAnalysisEngineController)this.getController()).lookupDelegate(delegateKey);
                            cse.setLastDelegate(delegate);
                            if (!delegate.hasConcurrentConsumersOnReplyQueue()) {
                                inputCasStateEntry.incrementSubordinateCasInPlayCount();
                            }
                        }
                    }
                    entry = this.deserializeCASandRegisterWithCache(casReferenceId, freeCasEndpoint, newCASProducedBy, aMessageContext);
                    if (this.getController().isStopped() || entry == null || entry.getCas() == null) {
                        if (entry != null) {
                            this.getController().dropCAS(entry.getCasReferenceId(), true);
                            entry = null;
                        }
                        return;
                    }
                    this.invokeProcess(entry.getCas(), inputCasReferenceId, casReferenceId, aMessageContext, newCASProducedBy);
                    if (this.getController().isPrimitive()) break block27;
                    Semaphore completionSemaphore = this.threadCompletionMonitor.get();
                    try {
                        completionSemaphore.acquire();
                        break block27;
                    }
                    catch (InterruptedException ex) {
                        break block27;
                    }
                    finally {
                        this.threadCompletionMonitor.remove();
                    }
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestFromRemoteClient", "uimaee_messages", "UIMAEE_duplicate_request__INFO", new Object[]{casReferenceId});
                }
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    if (this.getController() != null) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessRequestFromRemoteClient", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                    }
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleProcessRequestFromRemoteClient", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
                ErrorContext errorContext = new ErrorContext();
                errorContext.add("Endpoint", aMessageContext.getEndpoint());
                errorContext.add("Command", 2000);
                errorContext.add("CasReference", casReferenceId);
                if (entry != null) {
                    this.getController().dropCAS(entry.getCas());
                }
                this.getController().getErrorHandlerChain().handle(e, errorContext, this.getController());
            }
        }
    }

    private void handleProcessRequestWithCASReference(MessageContext aMessageContext) throws AsynchAEException {
        boolean isNewCAS = false;
        String newCASProducedBy = null;
        try {
            String inputCasReferenceId = null;
            CAS cas = null;
            LocalCache.CasStateEntry cse = null;
            String casReferenceId = this.getCasReferenceId(aMessageContext);
            cse = this.getController().getLocalCache().lookupEntry(casReferenceId);
            if (cse == null) {
                cse = this.getController().getLocalCache().createCasStateEntry(casReferenceId);
            }
            if (aMessageContext.propertyExists("CasSequence")) {
                Endpoint casMultiplierEndpoint;
                block33: {
                    isNewCAS = true;
                    casMultiplierEndpoint = aMessageContext.getEndpoint();
                    if (casMultiplierEndpoint == null) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_no_endpoint_for_reply__INFO", new Object[]{casReferenceId});
                        }
                        return;
                    }
                    inputCasReferenceId = aMessageContext.getMessageStringProperty("InputCasReference");
                    if (cse.getInputCasReferenceId() == null) {
                        cse.setInputCasReferenceId(inputCasReferenceId);
                    }
                    if (this.getController() instanceof AggregateAnalysisEngineController) {
                        LocalCache.CasStateEntry parentCasEntry = this.getController().getLocalCache().lookupEntry(inputCasReferenceId);
                        if (parentCasEntry != null && parentCasEntry.isFailed()) {
                            this.getController().process(null, casReferenceId);
                            return;
                        }
                        String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(aMessageContext.getEndpoint().getEndpoint());
                        Delegate delegate = ((AggregateAnalysisEngineController)this.getController()).lookupDelegate(delegateKey);
                        cse.setLastDelegate(delegate);
                        newCASProducedBy = delegate.getKey();
                        casMultiplierEndpoint.setIsCasMultiplier(true);
                        try {
                            this.getController().getInProcessCache().setCasProducer(casReferenceId, newCASProducedBy);
                        }
                        catch (Exception e) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                if (this.getController() != null) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                                }
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                            }
                            return;
                        }
                        if (inputCasReferenceId != null) {
                            try {
                                Endpoint endp = null;
                                if (endp == null) {
                                    InProcessCache.CacheEntry entry;
                                    boolean gotTheEndpoint = false;
                                    String parentCasId = inputCasReferenceId;
                                    while (!gotTheEndpoint && (endp = ((AggregateAnalysisEngineController)this.getController()).getMessageOrigin(parentCasId)) == null && (parentCasId = (entry = this.getController().getInProcessCache().getCacheEntryForCAS(parentCasId)).getInputCasReferenceId()) != null) {
                                    }
                                }
                                if (endp == null) {
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_msg_origin_not_found__INFO", new Object[]{this.getController().getComponentName(), inputCasReferenceId});
                                    }
                                } else {
                                    ((AggregateAnalysisEngineController)this.getController()).addMessageOrigin(casReferenceId, endp);
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_msg_origin_added__FINEST", new Object[]{this.getController().getComponentName(), casReferenceId, newCASProducedBy});
                                    }
                                }
                                break block33;
                            }
                            catch (Exception e) {
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                    if (this.getController() != null) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                                    }
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                                }
                                break block33;
                            }
                        }
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_input_cas_invalid__INFO", new Object[]{this.getController().getComponentName(), newCASProducedBy, casReferenceId});
                        }
                    }
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_new_cas__FINE", new Object[]{casReferenceId, newCASProducedBy});
                }
                aMessageContext.getEndpoint().setEndpoint(casMultiplierEndpoint.getEndpoint());
                aMessageContext.getEndpoint().setServerURI(casMultiplierEndpoint.getServerURI());
            } else if (this.getController() instanceof AggregateAnalysisEngineController) {
                ((AggregateAnalysisEngineController)this.getController()).addMessageOrigin(casReferenceId, aMessageContext.getEndpoint());
            }
            cas = this.getController().getInProcessCache().getCasByReference(casReferenceId);
            long arrivalTime = System.nanoTime();
            this.getController().saveTime(arrivalTime, casReferenceId, this.getController().getName());
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithCASReference", "uimaee_messages", "UIMAEE_analyzing_cas__FINE", new Object[]{casReferenceId});
            }
            this.cacheProcessCommandInClientEndpoint();
            if (this.getController().isStopped()) {
                return;
            }
            if (isNewCAS) {
                this.invokeProcess(cas, inputCasReferenceId, casReferenceId, aMessageContext, newCASProducedBy);
            } else {
                this.invokeProcess(cas, casReferenceId, null, aMessageContext, newCASProducedBy);
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private void handleProcessRequestWithXCAS(MessageContext aMessageContext) throws AsynchAEException {
        try {
            String casReferenceId;
            String inputCasReferenceId = casReferenceId = this.getCasReferenceId(aMessageContext);
            String newCASProducedBy = null;
            if (aMessageContext.propertyExists("CasSequence")) {
                Endpoint replyToEndpoint = this.getController().getInProcessCache().getCacheEntryForCAS(casReferenceId).getMessageOrigin();
                if (this.getController() instanceof AggregateAnalysisEngineController) {
                    newCASProducedBy = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(replyToEndpoint.getEndpoint());
                }
                aMessageContext.getEndpoint().setEndpoint(replyToEndpoint.getEndpoint());
                aMessageContext.getEndpoint().setServerURI(replyToEndpoint.getServerURI());
                inputCasReferenceId = String.valueOf(casReferenceId);
                casReferenceId = null;
            }
            long arrivalTime = System.nanoTime();
            this.getController().saveTime(arrivalTime, casReferenceId, this.getController().getName());
            if (casReferenceId == null || !this.getController().getInProcessCache().entryExists(casReferenceId)) {
                String xmi = aMessageContext.getStringMessage();
                if (xmi == null) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithXCAS", "uimaee_messages", "UIMAEE_message_has_no_cargo__INFO", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
                    }
                    this.getController().getOutputChannel().sendReply(new InvalidMessageException("No XMI data in message"), casReferenceId, null, aMessageContext.getEndpoint(), 2000);
                    return;
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithXCAS", "uimaee_messages", "UIMAEE_request_cas__FINE", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
                }
                CAS cas = this.getController().getCasManagerWrapper().getNewCas();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithXCAS", "uimaee_messages", "UIMAEE_request_cas_granted__FINE", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
                }
                UimaSerializer uimaSerializer = SerializerCache.lookupSerializerByThreadId();
                XmiSerializationSharedData deserSharedData = new XmiSerializationSharedData();
                uimaSerializer.deserializeCasFromXmi(xmi, cas, deserSharedData, true, -1);
                if (casReferenceId == null) {
                    InProcessCache.CacheEntry entry = this.getController().getInProcessCache().register(cas, aMessageContext, deserSharedData);
                    casReferenceId = entry.getCasReferenceId();
                } else if (this.getController() instanceof PrimitiveAnalysisEngineController) {
                    this.getController().getInProcessCache().register(cas, aMessageContext, deserSharedData, casReferenceId);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessRequestWithXCAS", "uimaee_messages", "UIMAEE_deserialized_cas_ready_to_process_FINE", new Object[]{aMessageContext.getEndpoint().getEndpoint()});
                }
                this.cacheProcessCommandInClientEndpoint();
                this.invokeProcess(cas, inputCasReferenceId, casReferenceId, aMessageContext, newCASProducedBy);
            } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessRequestWithXCAS", "uimaee_messages", "UIMAEE_duplicate_request__INFO", new Object[]{casReferenceId});
            }
        }
        catch (AsynchAEException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsynchAEException(e);
        }
    }

    private void cacheProcessCommandInClientEndpoint() {
        Endpoint clientEndpoint = this.getController().getClientEndpoint();
        if (clientEndpoint != null) {
            clientEndpoint.setCommand(2000);
        }
    }

    private void handleCollectionProcessCompleteRequest(MessageContext aMessageContext) throws AsynchAEException {
        Endpoint replyToEndpoint = aMessageContext.getEndpoint();
        this.getController().collectionProcessComplete(replyToEndpoint);
    }

    private void handleReleaseCASRequest(MessageContext aMessageContext) throws AsynchAEException {
        String casReferenceId = aMessageContext.getMessageStringProperty("CasReference");
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleReleaseCASRequest", "uimaee_messages", "UIMAEE_release_cas_req__FINE", new Object[]{this.getController().getName(), casReferenceId});
        }
        this.getController().releaseNextCas(casReferenceId);
    }

    private void handlePingRequest(MessageContext aMessageContext) {
        block3: {
            try {
                this.getController().getOutputChannel().sendReply(2007, aMessageContext.getEndpoint(), null, false);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                if (this.getController() != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handlePingRequest", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handlePingRequest", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    private void handleStopRequest(MessageContext aMessageContext) {
        try {
            String casReferenceId = aMessageContext.getMessageStringProperty("CasReference");
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleStopRequest", "uimaee_messages", "UIMAEE_received_stop_request__INFO", new Object[]{this.getController().getComponentName(), casReferenceId});
            }
            if (this.getController() instanceof PrimitiveAnalysisEngineController) {
                this.getController().addAbortedCasReferenceId(casReferenceId);
            } else if (this.getController() instanceof AggregateAnalysisEngineController_impl) {
                try {
                    LocalCache.CasStateEntry casStateEntry = this.getController().getLocalCache().lookupEntry(casReferenceId);
                    casStateEntry.setFailed();
                    ((AggregateAnalysisEngineController_impl)this.getController()).stopCasMultipliers();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handle(Object anObjectToHandle) {
        try {
            super.validate(anObjectToHandle);
            MessageContext messageContext = (MessageContext)anObjectToHandle;
            if (this.isHandlerForMessage(messageContext, 3000, 2000) || this.isHandlerForMessage(messageContext, 3000, 2002) || this.isHandlerForMessage(messageContext, 3000, 2005) || this.isHandlerForMessage(messageContext, 3000, 2006)) {
                int payload = messageContext.getMessageIntProperty("Payload");
                int command = messageContext.getMessageIntProperty("Command");
                this.getController().getControllerLatch().waitUntilInitialized();
                if (messageContext.getMessageIntProperty("MessageType") == 3000 && command == 2000 && !messageContext.propertyExists("CasSequence")) {
                    this.getController().getServicePerformance().incrementNumberOfCASesProcessed();
                }
                if (this.getController().isStopped()) {
                    return;
                }
                if (1001 == payload) {
                    if (this.getCasReferenceId(messageContext) == null) {
                        return;
                    }
                    this.handleProcessRequestWithCASReference(messageContext);
                } else if (1000 == payload || 1006 == payload) {
                    if (this.getCasReferenceId(messageContext) == null) {
                        return;
                    }
                    this.handleProcessRequestFromRemoteClient(messageContext);
                } else if (1004 == payload) {
                    if (this.getCasReferenceId(messageContext) == null) {
                        return;
                    }
                    this.handleProcessRequestWithXCAS(messageContext);
                } else if (1005 == payload && 2002 == command) {
                    this.handleCollectionProcessCompleteRequest(messageContext);
                } else if (1005 == payload && 2005 == command) {
                    this.handleReleaseCASRequest(messageContext);
                } else if (1005 == payload && 2006 == command) {
                    this.handleStopRequest(messageContext);
                } else if (1005 == payload && 2007 == command) {
                    this.handlePingRequest(messageContext);
                }
                return;
            }
            super.delegate(messageContext);
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                if (this.getController() != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handle", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handle", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            this.getController().getErrorHandlerChain().handle(e, HandlerBase.populateErrorContext((MessageContext)anObjectToHandle), this.getController());
        }
    }
}

