/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error.handler;

import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ErrorHandler;
import org.apache.uima.aae.error.ErrorHandlerBase;
import org.apache.uima.aae.error.ExpiredMessageException;
import org.apache.uima.aae.error.InvalidMessageException;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.aae.error.Threshold;
import org.apache.uima.aae.error.UimaEEServiceException;
import org.apache.uima.aae.jmx.ServiceErrors;
import org.apache.uima.aae.spi.transport.UimaTransport;
import org.apache.uima.aae.spi.transport.vm.UimaVmMessage;
import org.apache.uima.util.Level;

public class ProcessCasErrorHandler
extends ErrorHandlerBase
implements ErrorHandler {
    private static final Class CLASS_NAME = ProcessCasErrorHandler.class;
    private Map delegateMap = null;
    private Object monitor = new Object();

    public ProcessCasErrorHandler() {
        this.delegateMap = new HashMap();
    }

    public ProcessCasErrorHandler(Map aDelegateMap) {
        this.delegateMap = aDelegateMap;
        for (Map.Entry entry : this.delegateMap.entrySet()) {
            entry.setValue(((Threshold)entry.getValue()).initialize());
        }
    }

    private Endpoint getDestination(AnalysisEngineController aController, ErrorContext anErrorContext) {
        Endpoint endpoint = null;
        String casReferenceId = (String)anErrorContext.get("CasReference");
        if (aController instanceof AggregateAnalysisEngineController) {
            endpoint = ((AggregateAnalysisEngineController)aController).getMessageOrigin(casReferenceId);
            if (endpoint != null && aController.isTopLevelComponent()) {
                ((AggregateAnalysisEngineController)aController).removeMessageOrigin(casReferenceId);
            }
        } else if (anErrorContext.containsKey("Endpoint")) {
            endpoint = (Endpoint)anErrorContext.get("Endpoint");
        }
        return endpoint;
    }

    private boolean isDisabled(AggregateAnalysisEngineController aController, String aDelegateKey) {
        return aController.isDelegateDisabled(aDelegateKey);
    }

    private boolean ignoreError(Throwable t, ErrorContext anErrorContext, boolean isClient) {
        return t instanceof InvalidMessageException || t instanceof ExpiredMessageException || isClient && t.getCause() != null && t.getCause() instanceof ConnectException;
    }

    private void sendExceptionToClient(Throwable t, String aCasReferenceId, Endpoint anEndpoint, AnalysisEngineController aController) throws Exception {
        block13: {
            if (anEndpoint != null && aCasReferenceId != null && !anEndpoint.isCasMultiplier()) {
                try {
                    if (!anEndpoint.isRemote()) {
                        anEndpoint.setReplyEndpoint(true);
                        UimaTransport vmTransport = aController.getTransport(anEndpoint.getEndpoint());
                        UimaVmMessage message = vmTransport.produceMessage(2000, 3001, aController.getName());
                        message.addIntProperty("Payload", 1003);
                        message.addStringProperty("CasReference", aCasReferenceId);
                        UimaEEServiceException wrapper = null;
                        if (!(t instanceof UimaEEServiceException)) {
                            wrapper = t instanceof AsynchAEException && t.getCause() != null ? new UimaEEServiceException(t.getCause()) : new UimaEEServiceException(t);
                        }
                        if (wrapper == null) {
                            message.addObjectProperty("Cargo", t);
                        } else {
                            message.addObjectProperty("Cargo", wrapper);
                        }
                        if (!aController.isStopped()) {
                            vmTransport.getUimaMessageDispatcher(anEndpoint.getEndpoint()).dispatch(message);
                            aController.dropStats(aCasReferenceId, aController.getName());
                        }
                        break block13;
                    }
                    LocalCache.CasStateEntry stateEntry = null;
                    String parentCasReferenceId = null;
                    try {
                        stateEntry = aController.getLocalCache().lookupEntry(aCasReferenceId);
                        if (stateEntry != null && stateEntry.isSubordinate()) {
                            LocalCache.CasStateEntry topParentEntry = aController.getLocalCache().getTopCasAncestor(aCasReferenceId);
                            parentCasReferenceId = topParentEntry.getCasReferenceId();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!aController.isStopped()) {
                        aController.getOutputChannel().sendReply(t, aCasReferenceId, parentCasReferenceId, anEndpoint, 2000);
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block13;
                    if (aController != null) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "sendExceptionToParent", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                    }
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "sendExceptionToParent", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
    }

    private boolean isClient(Endpoint anEndpoint, AnalysisEngineController aController, String aCasReferenceId) {
        Endpoint clientEndpoint = null;
        if (aController.isTopLevelComponent()) {
            clientEndpoint = aController.getInProcessCache().getEndpoint(null, aCasReferenceId);
        } else if (aController instanceof AggregateAnalysisEngineController) {
            clientEndpoint = ((AggregateAnalysisEngineController)aController).getMessageOrigin(aCasReferenceId);
        }
        if (anEndpoint != null && clientEndpoint != null) {
            return anEndpoint.getEndpoint().equalsIgnoreCase(clientEndpoint.getEndpoint());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleError(Throwable t, ErrorContext anErrorContext, AnalysisEngineController aController) {
        block102: {
            LocalCache.CasStateEntry casStateEntry;
            int totalNumberOfParallelDelegatesProcessingCas;
            boolean disabledDueToExceededThreshold;
            String key;
            String casReferenceId;
            String delegateKey;
            LocalCache.CasStateEntry parentCasStateEntry;
            block101: {
                InProcessCache.CacheEntry cacheEntry;
                Threshold threshold;
                block97: {
                    boolean isEndpointTheClient;
                    int msgType;
                    parentCasStateEntry = null;
                    delegateKey = null;
                    if (!this.isHandlerForError(anErrorContext, 2000)) {
                        return false;
                    }
                    casReferenceId = null;
                    if (!anErrorContext.containsKey("CasReference")) {
                        return true;
                    }
                    casReferenceId = (String)anErrorContext.get("CasReference");
                    boolean isRequest = false;
                    if (anErrorContext.containsKey("MessageType") && (msgType = ((Integer)anErrorContext.get("MessageType")).intValue()) == 3000) {
                        isRequest = true;
                    }
                    if (this.ignoreError(t, anErrorContext, isEndpointTheClient = this.isClient((Endpoint)anErrorContext.get("Endpoint"), aController, casReferenceId))) {
                        LocalCache.CasStateEntry casStateEntry2;
                        if (t instanceof Error) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", t);
                        }
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_ignore_error__INFO", new Object[]{aController.getComponentName(), t.getClass().getName()});
                        }
                        if (casReferenceId != null && (casStateEntry2 = aController.getLocalCache().lookupEntry(casReferenceId)) != null && casStateEntry2.getSubordinateCasInPlayCount() == 0) {
                            try {
                                if (aController instanceof AggregateAnalysisEngineController) {
                                    ((AggregateAnalysisEngineController)aController).dropFlow(casReferenceId, true);
                                    ((AggregateAnalysisEngineController)aController).removeMessageOrigin(casReferenceId);
                                }
                                aController.dropStats(casReferenceId, aController.getName());
                            }
                            catch (Exception e) {
                            }
                            finally {
                                if (aController.isTopLevelComponent()) {
                                    aController.dropCAS(casReferenceId, true);
                                }
                            }
                        }
                        return true;
                    }
                    if (!anErrorContext.silentHandling() && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        if (aController != null) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                        }
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", t);
                    }
                    key = "";
                    threshold = null;
                    boolean delegateDisabled = false;
                    Delegate delegate = null;
                    if (!isEndpointTheClient && aController instanceof AggregateAnalysisEngineController) {
                        Endpoint endpoint = null;
                        if (anErrorContext.get("Endpoint") != null) {
                            endpoint = (Endpoint)anErrorContext.get("Endpoint");
                            key = ((AggregateAnalysisEngineController)aController).lookUpDelegateKey(endpoint.getEndpoint());
                            delegate = ((AggregateAnalysisEngineController)aController).lookupDelegate(key);
                        }
                        threshold = super.getThreshold(endpoint, this.delegateMap, aController);
                        if (endpoint != null) {
                            delegateDisabled = ((AggregateAnalysisEngineController)aController).isDelegateDisabled(key);
                            if (threshold != null && threshold.getMaxRetries() > 0 && !delegateDisabled) {
                                if (super.retryLastCommand(2000, endpoint, aController, key, threshold, anErrorContext)) {
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_retry_cas__FINE", new Object[]{aController.getComponentName(), key, casReferenceId});
                                    }
                                    return true;
                                }
                            } else if (threshold == null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_no_threshold_for_endpoint__CONFIG", new Object[]{aController.getComponentName(), "Process", key});
                            }
                            if (delegate != null) {
                                delegate.removeCasFromOutstandingList(casReferenceId);
                            }
                        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_no_endpoint_provided__INFO", new Object[]{aController.getComponentName()});
                        }
                    } else if (this.delegateMap != null && this.delegateMap.containsKey(key)) {
                        threshold = (Threshold)this.delegateMap.get(key);
                    }
                    if (key != null && key.trim().length() > 0 && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_cas_retries_exceeded__FINE", new Object[]{aController.getComponentName(), key, casReferenceId});
                    }
                    disabledDueToExceededThreshold = false;
                    if (!(key == null || aController.isStopped() || !isRequest && isEndpointTheClient)) {
                        Object object = this.monitor;
                        synchronized (object) {
                            if (!delegateDisabled) {
                                ServiceErrors serviceErrs;
                                Endpoint endpoint;
                                super.incrementStatistic(aController.getMonitor(), key, "ProcessErrorCount");
                                super.incrementStatistic(aController.getMonitor(), key, "TotalProcessErrorCount");
                                aController.getServiceErrors().incrementProcessErrors();
                                if (aController instanceof AggregateAnalysisEngineController && anErrorContext.get("Endpoint") != null && (endpoint = (Endpoint)anErrorContext.get("Endpoint")).isRemote() && (serviceErrs = ((AggregateAnalysisEngineController)aController).getDelegateServiceErrors(key)) != null) {
                                    serviceErrs.incrementProcessErrors();
                                }
                                long procCount = aController.getMonitor().getLongNumericStatistic(key, "ProcessCount").getValue();
                                if (threshold != null && threshold.exceededWindow(procCount)) {
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_process_cas_exceeded_threshold__INFO", new Object[]{aController.getComponentName(), key, casReferenceId, threshold.getThreshold(), threshold.getAction()});
                                    }
                                    if (disabledDueToExceededThreshold = "Disable".equalsIgnoreCase(threshold.getAction())) {
                                        delegateKey = key;
                                        anErrorContext.add("SkipPendingLists", "true");
                                    }
                                    if ("Terminate".equalsIgnoreCase(threshold.getAction())) {
                                        anErrorContext.add("ThrowableError", t);
                                        if (casReferenceId != null) {
                                            try {
                                                LocalCache.CasStateEntry casStateEntry3 = aController.getLocalCache().lookupEntry(casReferenceId);
                                                if (casStateEntry3 != null && casStateEntry3.isSubordinate()) {
                                                    LocalCache.CasStateEntry parenCasStateEntry = aController.getLocalCache().getTopCasAncestor(casReferenceId);
                                                    anErrorContext.remove("CasReference");
                                                    anErrorContext.add("CasReference", parenCasStateEntry.getCasReferenceId());
                                                }
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    aController.takeAction(threshold.getAction(), key, anErrorContext);
                                    if ("Continue".equalsIgnoreCase(threshold.getAction()) && anErrorContext.containsKey("ErrorHandled") && ((Boolean)anErrorContext.get("ErrorHandled")).booleanValue()) {
                                        return true;
                                    }
                                }
                            } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_delegate_already_disabled__INFO", new Object[]{aController.getComponentName(), key, casReferenceId});
                            }
                        }
                    }
                    Endpoint endpt = (Endpoint)anErrorContext.get("Endpoint");
                    if (endpt != null && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_process_exception__INFO", new Object[]{aController.getComponentName(), endpt.getEndpoint(), casReferenceId});
                    }
                    totalNumberOfParallelDelegatesProcessingCas = 1;
                    cacheEntry = null;
                    casStateEntry = null;
                    try {
                        casStateEntry = aController.getLocalCache().lookupEntry(casReferenceId);
                        cacheEntry = aController.getInProcessCache().getCacheEntryForCAS(casReferenceId);
                        if (cacheEntry != null) {
                            totalNumberOfParallelDelegatesProcessingCas = casStateEntry.getNumberOfParallelDelegates();
                        }
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block97;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_parent_cas_notin_cache__INFO", new Object[]{aController.getComponentName(), casReferenceId});
                    }
                }
                Endpoint endpoint = this.getDestination(aController, anErrorContext);
                if (casStateEntry != null && totalNumberOfParallelDelegatesProcessingCas > 1 && casStateEntry.howManyDelegatesResponded() < totalNumberOfParallelDelegatesProcessingCas) {
                    casStateEntry.incrementHowManyDelegatesResponded();
                }
                if (aController instanceof AggregateAnalysisEngineController && t instanceof Exception) {
                    block100: {
                        boolean flowControllerContinueFlag;
                        block98: {
                            flowControllerContinueFlag = false;
                            if (threshold != null && threshold.getContinueOnRetryFailure()) {
                                try {
                                    flowControllerContinueFlag = ((AggregateAnalysisEngineController)aController).continueOnError(casReferenceId, key, (Exception)t);
                                }
                                catch (Exception exc) {
                                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block98;
                                    if (aController != null) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                                    }
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)exc);
                                }
                            }
                        }
                        boolean doSendReplyToClient = true;
                        if (!flowControllerContinueFlag && !anErrorContext.containsKey("SkipSubordinateCountUpdate")) {
                            doSendReplyToClient = false;
                            if (casStateEntry != null && casStateEntry.isSubordinate()) {
                                String parentCasReferenceId = casStateEntry.getInputCasReferenceId();
                                if (parentCasReferenceId != null) {
                                    try {
                                        InProcessCache.CacheEntry parentCasCacheEntry = aController.getInProcessCache().getCacheEntryForCAS(parentCasReferenceId);
                                        parentCasStateEntry = aController.getLocalCache().lookupEntry(parentCasReferenceId);
                                        String cmEndpointName = cacheEntry.getCasProducerKey();
                                        String cmKey = ((AggregateAnalysisEngineController)aController).lookUpDelegateKey(cmEndpointName);
                                        if (cmKey == null) {
                                            cmKey = cacheEntry.getCasProducerKey();
                                        }
                                        Delegate delegateCM = ((AggregateAnalysisEngineController)aController).lookupDelegate(cmKey);
                                        LocalCache.CasStateEntry casStateEntry4 = parentCasStateEntry;
                                        synchronized (casStateEntry4) {
                                            if (!parentCasStateEntry.isFailed()) {
                                                LocalCache.CasStateEntry predecessorCas = parentCasStateEntry;
                                                parentCasStateEntry.setFailed();
                                                while (predecessorCas != null && predecessorCas.isSubordinate()) {
                                                    predecessorCas = aController.getLocalCache().lookupEntry(predecessorCas.getInputCasReferenceId());
                                                    predecessorCas.setFailed();
                                                }
                                                predecessorCas.addThrowable(t);
                                                ((AggregateAnalysisEngineController)aController).stopCasMultiplier(delegateCM, parentCasCacheEntry.getCasReferenceId());
                                            }
                                            parentCasStateEntry.addThrowable(t);
                                            casStateEntry.setReplyReceived();
                                            casStateEntry.setFailed();
                                            if (parentCasStateEntry.getSubordinateCasInPlayCount() == 0 && parentCasStateEntry.isPendingReply()) {
                                                aController.process(parentCasCacheEntry.getCas(), parentCasCacheEntry.getCasReferenceId());
                                            } else {
                                                aController.process(null, casStateEntry.getCasReferenceId());
                                            }
                                        }
                                    }
                                    catch (Exception ex) {}
                                }
                            } else if (casStateEntry != null) {
                                casStateEntry.setFailed();
                                casStateEntry.addThrowable(t);
                                aController.process(null, casStateEntry.getCasReferenceId());
                            }
                            return true;
                        }
                        if (threshold != null && flowControllerContinueFlag) {
                            if (disabledDueToExceededThreshold && delegateKey != null) {
                                aController.forceTimeoutOnPendingCases(delegateKey);
                            }
                            if (totalNumberOfParallelDelegatesProcessingCas == 1 || casStateEntry.howManyDelegatesResponded() == totalNumberOfParallelDelegatesProcessingCas) {
                                aController.process(aController.getInProcessCache().getCasByReference(casReferenceId), casReferenceId);
                            }
                            return true;
                        }
                        if (doSendReplyToClient) {
                            try {
                                if (casStateEntry != null && !casStateEntry.isSubordinate() && this.deliverExceptionToClient(t)) {
                                    this.sendExceptionToClient(t, casReferenceId, endpoint, aController);
                                }
                            }
                            catch (Exception e) {
                                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block100;
                                if (aController != null) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                                }
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                            }
                        }
                    }
                    try {
                        Endpoint cmEndpoint;
                        String casProducerKey;
                        if (cacheEntry != null && aController.getName().equalsIgnoreCase(cacheEntry.getCasProducerAggregateName()) && (casProducerKey = cacheEntry.getCasProducerKey()) != null && (cmEndpoint = ((AggregateAnalysisEngineController)aController).lookUpEndpoint(casProducerKey, true)) != null && cmEndpoint.isCasMultiplier() && cmEndpoint.isRemote()) {
                            cmEndpoint.setReplyEndpoint(true);
                            cmEndpoint.setIsCasMultiplier(true);
                            cmEndpoint.setFreeCasEndpoint(true);
                            aController.getOutputChannel().sendRequest(2005, cacheEntry.getCasReferenceId(), cmEndpoint);
                        }
                        break block101;
                    }
                    catch (Exception e) {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            if (aController != null) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                            }
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                        }
                        break block101;
                    }
                }
                try {
                    if (this.deliverExceptionToClient(t)) {
                        this.sendExceptionToClient(t, casReferenceId, endpoint, aController);
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block101;
                    if (aController != null) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                    }
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
            if (disabledDueToExceededThreshold && delegateKey != null) {
                aController.forceTimeoutOnPendingCases(delegateKey);
            }
            try {
                if (aController.isTopLevelComponent() && (totalNumberOfParallelDelegatesProcessingCas == 1 || casStateEntry.howManyDelegatesResponded() == totalNumberOfParallelDelegatesProcessingCas)) {
                    aController.takeAction("DropCas", key, anErrorContext);
                }
                if (casReferenceId != null && aController instanceof AggregateAnalysisEngineController) {
                    if (parentCasStateEntry != null && parentCasStateEntry.getSubordinateCasInPlayCount() == 0 && parentCasStateEntry.isPendingReply()) {
                        ((AggregateAnalysisEngineController)aController).finalStep(parentCasStateEntry.getFinalStep(), parentCasStateEntry.getCasReferenceId());
                    }
                    ((AggregateAnalysisEngineController)aController).dropFlow(casReferenceId, true);
                    ((AggregateAnalysisEngineController)aController).removeMessageOrigin(casReferenceId);
                }
                aController.dropStats(casReferenceId, aController.getName());
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block102;
                if (aController != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)aController.getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        return true;
    }

    private boolean deliverExceptionToClient(Throwable t) {
        return !(t instanceof MessageTimeoutException) && (!(t instanceof UimaEEServiceException) || t.getCause() == null || !(t.getCause() instanceof MessageTimeoutException));
    }
}

