/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import javax.jms.Destination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;

public class ClientServiceDelegate
extends Delegate {
    private static final Class CLASS_NAME = ClientServiceDelegate.class;
    private BaseUIMAAsynchronousEngineCommon_impl clientUimaAsEngine;
    private String applicationName = "UimaAsClient";
    private volatile boolean usesSynchronousAPI;
    private Destination freeCasDestination = null;
    private Object errorMux = new Object();
    private volatile boolean pingTimeout = false;

    public ClientServiceDelegate(String serviceName, String anApplicationName, BaseUIMAAsynchronousEngineCommon_impl engine) {
        this.delegateKey = serviceName;
        this.clientUimaAsEngine = engine;
        if (anApplicationName != null && anApplicationName.trim().length() > 0) {
            this.applicationName = anApplicationName;
        }
    }

    public boolean isSynchronousAPI() {
        return this.usesSynchronousAPI;
    }

    public boolean isPingTimeout() {
        return this.pingTimeout;
    }

    public void resetPingTimeout() {
        this.pingTimeout = false;
    }

    public void setSynchronousAPI() {
        this.usesSynchronousAPI = true;
    }

    public Destination getFreeCasDestination() {
        return this.freeCasDestination;
    }

    public void setFreeCasDestination(Destination freeCasDestination) {
        this.freeCasDestination = freeCasDestination;
    }

    public String getComponentName() {
        return this.applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Exception e, ErrorContext errorContext) {
        String casReferenceId = null;
        CAS cas = null;
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cachedRequest = null;
        Object object = this.errorMux;
        synchronized (object) {
            block24: {
                if (!this.clientUimaAsEngine.running) {
                    this.cancelDelegateTimer();
                    return;
                }
                int command = (Integer)errorContext.get("Command");
                try {
                    if (e instanceof MessageTimeoutException) {
                        switch (command) {
                            case 2000: {
                                casReferenceId = (String)errorContext.get("CasReference");
                                if (casReferenceId != null) {
                                    cachedRequest = this.clientUimaAsEngine.clientCache.get(casReferenceId);
                                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING) && this.getEndpoint() != null) {
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAJMS_process_timeout_WARNING", new Object[]{this.getEndpoint().getEndpoint()});
                                    }
                                    if (cachedRequest != null && cachedRequest.isRemote()) {
                                        cas = cachedRequest.getCAS();
                                    }
                                    boolean isPingTimeout = false;
                                    if (errorContext.containsKey("Cause")) {
                                        boolean bl = isPingTimeout = 5001 == (Integer)errorContext.get("Cause");
                                    }
                                    if (isPingTimeout && this.isAwaitingPingReply()) {
                                        if (this.clientUimaAsEngine.state != BaseUIMAAsynchronousEngineCommon_impl.ClientState.RECONNECTING) {
                                            this.resetAwaitingPingReply();
                                        }
                                        this.pingTimeout = true;
                                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_ping_timed_out__WARNING", new Object[]{this.getKey()});
                                        this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 3, casReferenceId);
                                    } else {
                                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_client_process_timeout__WARNING", new Object[]{super.getCasProcessTimeout()});
                                        }
                                        this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 3, casReferenceId);
                                    }
                                }
                                this.clientUimaAsEngine.clientSideJmxStats.incrementProcessTimeoutErrorCount();
                                break;
                            }
                            case 2001: {
                                if (this.isAwaitingPingReply()) {
                                    this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 4, casReferenceId);
                                } else {
                                    this.clientUimaAsEngine.notifyOnTimout(cas, this.clientUimaAsEngine.getEndPointName(), 1, casReferenceId);
                                    this.clientUimaAsEngine.clientSideJmxStats.incrementMetaTimeoutErrorCount();
                                }
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_meta_timeout_WARNING", new Object[]{this.getKey()});
                                }
                                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleError", "jms_adapter_messages", "UIMAJMS_service_not_responding_to_ping__WARNING", new Object[]{this.clientUimaAsEngine.getEndPointName()});
                                }
                                this.clientUimaAsEngine.stop();
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block24;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleError", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)ex);
                }
            }
            if (cas != null && !cachedRequest.isSynchronousInvocation()) {
                cas.release();
            }
        }
    }
}

