/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.monitor;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.aae.monitor.Monitor;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.aae.monitor.statistics.Statistic;
import org.apache.uima.aae.monitor.statistics.Statistics;

public class MonitorBaseImpl
implements Monitor {
    private Map componentStatistics = new HashMap();
    private Map thresholds = null;

    public void setThresholds(Map aThresholdMap) {
        this.thresholds = aThresholdMap;
    }

    public Map getThresholds() {
        return this.thresholds;
    }

    public void addStatistic(String aComponentName, Statistic aStatistic) {
        if (this.componentStatistics.containsKey(aComponentName)) {
            Statistics stats = this.getStatistics(aComponentName);
            if (!stats.containsKey(aStatistic.getName())) {
                stats.put(aStatistic.getName(), aStatistic);
            }
        } else {
            Statistics stats = new Statistics();
            stats.put(aStatistic.getName(), aStatistic);
            this.componentStatistics.put(aComponentName, stats);
        }
    }

    public LongNumericStatistic getLongNumericStatistic(String aComponent, String aStatisticName) {
        LongNumericStatistic countStat = (LongNumericStatistic)this.getStatistic(aComponent, aStatisticName);
        if (countStat == null) {
            countStat = new LongNumericStatistic(aStatisticName);
            this.addStatistic(aComponent, countStat);
        }
        return countStat;
    }

    public synchronized void incrementCount(String aComponent, String aStatisticName) {
        LongNumericStatistic countStat = this.getLongNumericStatistic(aComponent, aStatisticName);
        if (countStat == null) {
            countStat = new LongNumericStatistic(aStatisticName);
            this.addStatistic(aComponent, countStat);
        }
        countStat.increment();
    }

    public Statistics getStatistics(String aComponentName) {
        return (Statistics)this.componentStatistics.get(aComponentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetCountingStatistic(String aComponent, String aStatisticName) {
        LongNumericStatistic countStat = this.getLongNumericStatistic(aComponent, aStatisticName);
        if (countStat != null) {
            LongNumericStatistic longNumericStatistic = countStat;
            synchronized (longNumericStatistic) {
                countStat.reset();
            }
        }
    }

    public Statistic getStatistic(String aComponentName, String aStatisticName) {
        if (this.componentStatistics.containsKey(aComponentName)) {
            Statistics stats = this.getStatistics(aComponentName);
            if (stats.containsKey(aStatisticName)) {
                return (Statistic)stats.get(aStatisticName);
            }
        } else {
            LongNumericStatistic countStat = new LongNumericStatistic(aStatisticName);
            this.addStatistic(aComponentName, countStat);
            return countStat;
        }
        return null;
    }

    public long componentMapSize() {
        if (this.componentStatistics != null) {
            return this.componentStatistics.size();
        }
        return 0L;
    }

    public long thresholdMapSize() {
        if (this.thresholds != null) {
            return this.thresholds.size();
        }
        return 0L;
    }
}

