/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.delegate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.MessageTimeoutException;
import org.apache.uima.util.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Delegate {
    public static final int OK_STATE = 1;
    public static final int TIMEOUT_STATE = 2;
    public static final int DISABLED_STATE = 3;
    private static final Class CLASS_NAME = Delegate.class;
    protected String delegateKey;
    private int state = 1;
    private List<DelegateEntry> outstandingCasList = new ArrayList<DelegateEntry>();
    private Endpoint endpoint;
    private Timer timer;
    private long casProcessTimeout = 0L;
    private long getMetaTimeout = 0L;
    private long cpcTimeout = 0L;
    private Object stateMux = new Object();
    private List<DelegateEntry> pendingDispatchList = new ArrayList<DelegateEntry>();
    private volatile boolean awaitingPingReply;
    private volatile boolean concurrentConsumersOnReplyQueue;
    private Endpoint notificationEndpoint = null;

    public Endpoint getNotificationEndpoint() {
        return this.notificationEndpoint;
    }

    public void setNotificationEndpoint(Endpoint notificationEndpoint) {
        this.notificationEndpoint = notificationEndpoint;
    }

    public boolean isAwaitingPingReply() {
        return this.awaitingPingReply;
    }

    public void setAwaitingPingReply() {
        this.awaitingPingReply = true;
    }

    public void resetAwaitingPingReply() {
        this.awaitingPingReply = false;
    }

    public String getKey() {
        return this.delegateKey;
    }

    public void setEndpoint(Endpoint anEndpoint) {
        this.endpoint = anEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTimerForOldestCasInOutstandingList() {
        DelegateEntry entry = null;
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            if (!this.outstandingCasList.isEmpty() && (entry = this.outstandingCasList.get(0)) != null) {
                this.restartTimerForCas(entry);
            }
        }
    }

    private void restartTimerForCas(DelegateEntry entry) {
        if (this.getCasProcessTimeout() > 0L) {
            entry.incrementRetryCount();
            this.startDelegateTimer(entry.getCasReferenceId(), 2000);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "restartTimerForCas", "uimaee_messages", "UIMAEE_restart_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, entry.getCasReferenceId(), this.getCasProcessTimeout()});
            }
        }
    }

    public List<DelegateEntry> getDelegateCasesPendingReply() {
        return this.outstandingCasList;
    }

    public List<DelegateEntry> getDelegateCasesPendingDispatch() {
        return this.pendingDispatchList;
    }

    public void addNewCasToOutstandingList(String aCasReferenceId) {
        this.addNewCasToOutstandingList(aCasReferenceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewCasToOutstandingList(String aCasReferenceId, boolean isCasGeneratingChildren) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = null;
            entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry == null) {
                entry = new DelegateEntry(aCasReferenceId);
                entry.setCommand(2000);
                if (isCasGeneratingChildren) {
                    entry.setGeneratingChildren(true);
                }
                this.outstandingCasList.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCasToOutstandingList(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = null;
            if (!this.outstandingCasList.isEmpty() && (entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList)) != null) {
                this.restartTimerForCas(entry);
            } else {
                entry = new DelegateEntry(aCasReferenceId);
                entry.setCommand(2000);
                if (this.outstandingCasList.isEmpty() && this.getCasProcessTimeout() > 0L) {
                    this.startDelegateTimer(aCasReferenceId, 2000);
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "addCasToOutstandingList", "uimaee_messages", "UIMAEE_start_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, this.getCasProcessTimeout()});
                    }
                }
                this.outstandingCasList.add(entry);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "addCasToOutstandingList", "uimaee_messages", "UIMAEE_add_cas_to_delegate_pending_reply_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, this.outstandingCasList.size()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCasToPendingDispatchList(String aCasReferenceId) {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            DelegateEntry entry = null;
            entry = new DelegateEntry(aCasReferenceId);
            entry.setCommand(2000);
            this.pendingDispatchList.add(entry);
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                this.dumpDelayedList();
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "addCasToPendingDispatchList", "uimaee_messages", "UIMAEE_add_cas_to_delegate_pending_dispatch_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, this.pendingDispatchList.size()});
            }
            return this.pendingDispatchList.size();
        }
    }

    private void dumpDelayedList() {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            for (DelegateEntry entry : this.pendingDispatchList) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "dumpDelayedList", "uimaee_messages", "UIMAEE_dump_cas_pending_dispatch__FINE", new Object[]{this.getComponentName(), entry.getCasReferenceId(), this.delegateKey});
            }
        }
    }

    private void dumpPendingReplyList() {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            for (DelegateEntry entry : this.outstandingCasList) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "dumpPendingReplyList", "uimaee_messages", "UIMAEE_dump_cas_pending_reply__FINE", new Object[]{this.getComponentName(), entry.getCasReferenceId(), this.delegateKey});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRetryCount(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                entry.incrementRetryCount();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "incrementRetryCount", "uimaee_messages", "UIMAEE_increment_retry_count_FINE", new Object[]{this.getComponentName(), this.delegateKey, aCasReferenceId, entry.getRetryCount()});
                }
            }
        }
    }

    private DelegateEntry lookupEntry(String aCasReferenceId, List<DelegateEntry> list) {
        for (DelegateEntry entry : list) {
            if (!entry.getCasReferenceId().equals(aCasReferenceId)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeOldestFromPendingDispatchList() {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            if (this.pendingDispatchList.size() > 0) {
                String casReferenceId = this.pendingDispatchList.remove(0).getCasReferenceId();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeOldestFromPendingDispatchList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_pending_dispatch_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, casReferenceId, this.pendingDispatchList.size()});
                }
                return casReferenceId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCasFromPendingDispatchList(String aCasReferenceId) {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.pendingDispatchList);
            if (entry != null) {
                this.pendingDispatchList.remove(entry);
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromPendingDispatchList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_pending_dispatch_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, entry.getCasReferenceId(), this.pendingDispatchList.size()});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCasFromOutstandingList(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                this.removeCasFromOutstandingList(entry);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeOldestCasFromOutstandingList() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            this.dumpPendingReplyList();
            return this.outstandingCasList.remove(0).getCasReferenceId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldestCasIdFromOutstandingList() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            return this.outstandingCasList.get(0).getCasReferenceId();
        }
    }

    private void removeCasFromOutstandingList(DelegateEntry aDelegateEntry) {
        DelegateEntry oldestEntry = this.outstandingCasList.get(0);
        boolean doStartDelegateTimer = oldestEntry.equals(aDelegateEntry) && this.getCasProcessTimeout() > 0L;
        this.outstandingCasList.remove(aDelegateEntry);
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromOutstandingList", "uimaee_messages", "UIMAEE_removed_cas_from_delegate_list__FINE", new Object[]{this.getComponentName(), this.delegateKey, aDelegateEntry.getCasReferenceId(), this.outstandingCasList.size()});
        }
        if (doStartDelegateTimer) {
            this.cancelDelegateTimer();
            if (!this.outstandingCasList.isEmpty()) {
                DelegateEntry delegateEntry = this.outstandingCasList.get(0);
                this.startDelegateTimer(delegateEntry.getCasReferenceId(), delegateEntry.getCommand());
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "removeCasFromOutstandingList", "uimaee_messages", "UIMAEE_restart_timer_FINE", new Object[]{this.getComponentName(), this.delegateKey, delegateEntry.getCasReferenceId(), this.getCasProcessTimeout()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.cancelDelegateTimer();
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            this.outstandingCasList.clear();
        }
        list = this.pendingDispatchList;
        synchronized (list) {
            this.pendingDispatchList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCasPendingReplyListSize() {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            return this.outstandingCasList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCasPendingDispatchListSize() {
        List<DelegateEntry> list = this.pendingDispatchList;
        synchronized (list) {
            return this.pendingDispatchList.size();
        }
    }

    public synchronized void cancelDelegateTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    private long getTimeoutValueForCommand(int aCommand) {
        switch (aCommand) {
            case 2000: {
                return this.getCasProcessTimeout();
            }
            case 2001: {
                return this.getGetMetaTimeout();
            }
            case 2002: {
                return this.getCpcTimeout();
            }
        }
        return -1L;
    }

    public void startGetMetaRequestTimer() {
        this.startDelegateTimer(null, 2001);
    }

    private synchronized void startDelegateTimer(final String aCasReferenceId, final int aCommand) {
        final long timeToWait = this.getTimeoutValueForCommand(aCommand);
        Date timeToRun = new Date(System.currentTimeMillis() + timeToWait);
        this.timer = new Timer("Controller:" + this.getComponentName() + ":Request TimerThread-Endpoint_impl:" + this.endpoint + ":" + System.nanoTime() + ":Cmd:" + aCommand);
        final Delegate delegate = this;
        this.timer.schedule(new TimerTask(){

            public void run() {
                delegate.setState(2);
                ErrorContext errorContext = new ErrorContext();
                errorContext.add("Command", aCommand);
                MessageTimeoutException cause = new MessageTimeoutException("Delegate Service:" + Delegate.this.delegateKey + " Has Timed Out While Processing CAS:" + aCasReferenceId);
                if (2000 == aCommand) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_cas_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait, aCasReferenceId});
                    }
                    errorContext.add("CasReference", aCasReferenceId);
                    errorContext.add("ThrowableError", cause);
                    if (Delegate.this.isAwaitingPingReply() && Delegate.this.getCasPendingReplyListSize() > 0) {
                        String casReferenceId = Delegate.this.getOldestCasIdFromOutstandingList();
                        errorContext.add("CasReference", casReferenceId);
                        errorContext.add("Command", 2000);
                        errorContext.add("Cause", 5001);
                    }
                } else if (2001 == aCommand) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_meta_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait});
                    }
                } else if (2002 == aCommand && UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "Delegate.TimerTask.run", "uimaee_messages", "UIMAEE_cpc_timeout_no_reply__WARNING", new Object[]{delegate.getKey(), timeToWait});
                }
                errorContext.add("Endpoint", Delegate.this.getEndpoint());
                Delegate.this.handleError(cause, errorContext);
            }
        }, timeToRun);
    }

    public long getCasProcessTimeout() {
        return this.casProcessTimeout;
    }

    public void setCasProcessTimeout(long casProcessTimeout) {
        this.casProcessTimeout = casProcessTimeout;
    }

    public long getGetMetaTimeout() {
        return this.getMetaTimeout;
    }

    public void setGetMetaTimeout(long getMetaTimeout) {
        this.getMetaTimeout = getMetaTimeout;
    }

    public long getCpcTimeout() {
        return this.cpcTimeout;
    }

    public void setCpcTimeout(long cpcTimeout) {
        this.cpcTimeout = cpcTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateMux;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int aState) {
        Object object = this.stateMux;
        synchronized (object) {
            if (aState == 2 && this.state != 1) {
                return;
            }
            this.state = aState;
        }
    }

    public void setConcurrentConsumersOnReplyQueue() {
        this.concurrentConsumersOnReplyQueue = true;
    }

    public boolean hasConcurrentConsumersOnReplyQueue() {
        return this.concurrentConsumersOnReplyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratingChildrenFrom(String aCasReferenceId) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry == null) {
                return false;
            }
            return entry.isGeneratingChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneratingChildrenFrom(String aCasReferenceId, boolean tOf) {
        List<DelegateEntry> list = this.outstandingCasList;
        synchronized (list) {
            DelegateEntry entry = this.lookupEntry(aCasReferenceId, this.outstandingCasList);
            if (entry != null) {
                entry.setGeneratingChildren(tOf);
            }
        }
    }

    public abstract void handleError(Exception var1, ErrorContext var2);

    public abstract String getComponentName();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ArrayList<DelegateEntry> copyOfOutstandingCASes = new ArrayList<DelegateEntry>(this.outstandingCasList);
        for (DelegateEntry entry : copyOfOutstandingCASes) {
            if (entry == null || entry.getCasReferenceId() == null) continue;
            sb.append("[" + entry.getCasReferenceId() + "]");
        }
        return sb.toString();
    }

    public static class DelegateEntry {
        private String casReferenceId;
        private int command;
        private int retryCount = 0;
        private volatile boolean generatingChildren = false;

        public DelegateEntry(String aCasReferenceId) {
            this.casReferenceId = aCasReferenceId;
        }

        public boolean isGeneratingChildren() {
            return this.generatingChildren;
        }

        public void setGeneratingChildren(boolean tOf) {
            this.generatingChildren = tOf;
        }

        public int getCommand() {
            return this.command;
        }

        public void setCommand(int command) {
            this.command = command;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void incrementRetryCount() {
            ++this.retryCount;
        }

        public void resetRetryCount() {
            this.retryCount = 0;
        }

        public String getCasReferenceId() {
            return this.casReferenceId;
        }
    }
}

