/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.IOException;
import java.util.List;
import org.apache.uima.aae.controller.ControllerCallbackListener;
import org.apache.uima.aae.controller.UimacppServiceController;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

class WaitThread
implements Runnable {
    public Process uimacppProcess;
    private Logger uimaLogger;
    private List<ControllerCallbackListener> listeners;
    private UimacppServiceController controller;

    public WaitThread(Process aprocess, Logger logger, UimacppServiceController cntlr) throws IOException {
        this.uimacppProcess = aprocess;
        this.uimaLogger = logger;
        this.controller = cntlr;
        this.listeners = this.controller.getCallbackListeners();
    }

    public void run() {
        block5: {
            String message = "WaitThread calling UIMA C++ service shutdown.";
            try {
                int rc = this.uimacppProcess.waitFor();
                message = message + "rc=" + rc;
                this.controller.setStopped();
                if (this.listeners != null) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ControllerCallbackListener listener = this.listeners.get(i);
                        if (listener == null) continue;
                        listener.notifyOnTermination(message);
                    }
                    this.listeners.clear();
                }
            }
            catch (InterruptedException e) {
                this.uimaLogger.log(Level.INFO, e.getMessage());
                message = message + e.getMessage();
                if (this.listeners == null) break block5;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ControllerCallbackListener listener = this.listeners.get(i);
                    if (listener == null) continue;
                    listener.notifyOnTermination(message);
                }
                this.listeners.clear();
            }
        }
    }
}

