/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.uima.aae.controller.UimacppServiceManagementMBean;

public class UimacppServiceManagement
implements UimacppServiceManagementMBean {
    private static final long serialVersionUID = -2507413276728501209L;
    private static final long MAX_TIME_VALID = 500L;
    private static long lastRefreshTime;
    HashMap<String, String> jmxInfo;
    private String uniqueMBeanName;
    private String aeDescriptor;
    private int aeInstances;
    private String queueBrokerURL;
    private String queueName;
    Socket socket;
    BufferedReader rdr;
    PrintWriter writer;

    public UimacppServiceManagement(String domainName, Socket sock, String aeDescriptor, int numInstances, String brokerURL, String queueName) throws IOException {
        if (domainName == null || domainName.length() == 0) {
            domainName = "org.apache.uima:type=ee.jms.services,s=" + queueName + " Uima EE Service,";
        }
        this.uniqueMBeanName = domainName + "name=" + queueName + "_Service";
        this.socket = sock;
        this.rdr = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new PrintWriter(this.socket.getOutputStream(), true);
        this.aeDescriptor = aeDescriptor;
        this.queueBrokerURL = brokerURL;
        this.queueName = queueName;
        this.aeInstances = numInstances;
        this.jmxInfo = new HashMap();
        lastRefreshTime = 0L;
    }

    public synchronized String quiesceAndStop() throws IOException {
        if (this.socket != null) {
            this.writer.write("QUIESCEANDSTOP");
            this.writer.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c >= 0) {
                sb.append((char)c);
                c = in.read();
                if (c != 10) continue;
            }
            System.out.println("UimacppServiceManagement service reports QuiesceAndStop " + sb.toString());
            return sb.toString();
        }
        throw new IOException("Error: no socket connection.");
    }

    public synchronized String getStatisticsAsString() throws IOException {
        if (this.socket != null) {
            this.writer.write("GETSTATS");
            this.writer.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c >= 0) {
                sb.append((char)c);
                c = in.read();
                if (c != 10) continue;
            }
            lastRefreshTime = System.currentTimeMillis();
            return sb.toString();
        }
        throw new IOException("Error: no socket connection.");
    }

    public synchronized void getStatistics() throws IOException {
        String stats = this.getStatisticsAsString();
        String name = null;
        String value = null;
        if (stats != null) {
            StringTokenizer tokenizer = new StringTokenizer(stats);
            while (tokenizer.hasMoreTokens()) {
                String aStat = tokenizer.nextToken();
                StringTokenizer st2 = new StringTokenizer(aStat, "=");
                name = null;
                value = null;
                if (st2.hasMoreElements()) {
                    name = st2.nextToken();
                }
                if (st2.hasMoreElements()) {
                    value = st2.nextToken();
                }
                if (name == null) {
                    throw new IOException("Statistic name is not set.");
                }
                if (value == null) {
                    throw new IOException("Statistic value is not set for " + name);
                }
                this.jmxInfo.put(name, value);
            }
        }
    }

    public synchronized String getQueueBrokerURL() throws IOException {
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        return this.queueBrokerURL;
    }

    public synchronized String getQueueName() throws IOException {
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        return this.queueName;
    }

    public synchronized String getAEDescriptor() throws IOException {
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        return this.aeDescriptor;
    }

    public synchronized int getAEInstances() throws IOException {
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        return this.aeInstances;
    }

    public synchronized long getErrorsGetMeta() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("GETMETAERRORS")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getErrorsProcessCas() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("PROCESSCASERRORS")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getErrorsCPC() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("CPCERRORS")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTotalNumCasProcessed() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("NUMCASPROCESSED")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingGetMeta() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("GETMETATIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingCPC() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("CPCTIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingSerialization() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("SERIALIZETIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingAnnotatorProcess() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("ANNOTATORTIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingDeserialization() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("DESERIALIZETIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingMessageProcessing() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("MESSAGEPROCESSTIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized long getTimingIdle() throws IOException {
        String v;
        if (System.currentTimeMillis() - lastRefreshTime > 500L) {
            this.getStatistics();
        }
        if ((v = this.jmxInfo.get("IDLETIME")) == null) {
            return -1L;
        }
        return Long.valueOf(v);
    }

    public synchronized void resetStats() throws IOException {
        this.writer.write("RESET");
        this.writer.flush();
        this.getStatistics();
    }

    public void increaseAEInstances(int num) {
    }

    public void decreaseAEInstances(int num) {
    }

    public synchronized void shutdown() throws IOException {
        if (this.socket != null) {
            this.writer.write("SHUTDOWN");
            this.writer.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c >= 0) {
                sb.append((char)c);
                c = in.read();
                if (c != 10) continue;
            }
            System.out.println("UimacppServiceManagement service reports shutdown " + sb.toString());
            return;
        }
        System.err.println("Error no connection");
    }

    public String getUniqueMBeanName() {
        return this.uniqueMBeanName;
    }

    public synchronized void quiesceAndShutdown() throws IOException {
        this.quiesceAndStop();
    }
}

