/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.util.ProcessTrace;

public class UimaASProcessStatusImpl
implements UimaASProcessStatus {
    private static final long serialVersionUID = -5101356145458558249L;
    ProcessTrace prT;
    HashMap eventMap = new HashMap();
    List exceptionList = new ArrayList();
    List failedList = new ArrayList();
    HashMap resultHM = new HashMap();
    private boolean isSkipped = false;
    public boolean isProcessed = true;
    private String casReferenceId;
    private String parentCasId;

    public UimaASProcessStatusImpl(ProcessTrace p) {
        this(p, null);
    }

    public UimaASProcessStatusImpl(ProcessTrace p, String aCasReferenceId) {
        this(p, aCasReferenceId, null);
    }

    public UimaASProcessStatusImpl(ProcessTrace p, String aCasReferenceId, String aParentCasReferenceId) {
        this.prT = p;
        this.casReferenceId = aCasReferenceId;
        this.parentCasId = aParentCasReferenceId;
    }

    public UimaASProcessStatusImpl(ProcessTrace p, boolean aSkip) {
        this.prT = p;
        this.isSkipped = aSkip;
    }

    public boolean isException() {
        return this.failedList.size() > 0;
    }

    public String getStatusMessage() {
        if (this.failedList.size() > 0) {
            return "failed";
        }
        return "success";
    }

    public List getExceptions() {
        return this.exceptionList;
    }

    public List getFailedComponentNames() {
        return this.failedList;
    }

    public void addEventStatus(String aEventName, String aResultS, Throwable aE) {
        EventLog eL = new EventLog(aResultS, aE);
        this.eventMap.put(aEventName, eL);
        if (!aResultS.equalsIgnoreCase("success")) {
            this.failedList.add(aEventName);
            this.exceptionList.add(aE);
        }
        this.resultHM.put(aEventName, aE);
    }

    public ProcessTrace getProcessTrace() {
        return this.prT;
    }

    public void printEventLog() {
        for (Map.Entry obj : this.eventMap.entrySet()) {
            String key = (String)obj.getKey();
            EventLog eL = (EventLog)obj.getValue();
            System.out.println(" EVENT " + key + "  Result " + eL.status);
            if (eL.exception == null) continue;
            eL.exception.printStackTrace();
        }
        for (int j = 0; j < this.failedList.size(); ++j) {
            System.out.println(" failed component name " + this.failedList.get(j));
        }
    }

    public boolean isEntitySkipped() {
        return this.isSkipped;
    }

    public String getCasReferenceId() {
        return this.casReferenceId;
    }

    public String getParentCasReferenceId() {
        return this.parentCasId;
    }

    public String toString() {
        Field[] fields;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" Object {");
        sb.append(System.getProperty("line.separator"));
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            sb.append("  ");
            try {
                sb.append(field.getName());
                sb.append(": ");
                sb.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                System.out.println(ex);
            }
            sb.append(System.getProperty("line.separator"));
        }
        sb.append("}");
        return sb.toString();
    }

    static class EventLog {
        String status;
        Throwable exception;

        public EventLog(String stats, Throwable e) {
            this.status = stats;
            this.exception = e;
        }
    }
}

