/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class UimaSerializer {
    private final ThreadLocal<XMLReader> localXmlReader = new ThreadLocal();

    public OutOfTypeSystemData deSerialiazeFromXCAS(String anXcas, CAS aCas) throws Exception {
        OutOfTypeSystemData otsd = new OutOfTypeSystemData();
        TypeSystem typesToLoad2 = aCas.getTypeSystem();
        ByteArrayInputStream bis = new ByteArrayInputStream(anXcas.getBytes());
        XCASDeserializer deser2 = new XCASDeserializer(typesToLoad2);
        DefaultHandler deserHandler2 = deser2.getXCASHandler(aCas, otsd);
        SAXParserFactory fact2 = SAXParserFactory.newInstance();
        SAXParser parser2 = fact2.newSAXParser();
        XMLReader xmlReader2 = parser2.getXMLReader();
        xmlReader2.setContentHandler(deserHandler2);
        xmlReader2.parse(new InputSource(bis));
        return otsd;
    }

    public void serializeToXCAS(OutputStream stream, CAS aCAS, String encoding, TypeSystem typeSystem, OutOfTypeSystemData otsd) throws IOException, SAXException {
        if (typeSystem == null) {
            typeSystem = aCAS.getTypeSystem();
        }
        XMLSerializer xmlSer = new XMLSerializer(stream, false);
        if (encoding != null) {
            xmlSer.setOutputProperty("encoding", encoding);
        }
        XCASSerializer ser = new XCASSerializer(typeSystem);
        ser.serialize(aCAS, xmlSer.getContentHandler(), false, otsd);
    }

    public void serializeToXMI(OutputStream stream, CAS aCAS, String encoding, TypeSystem typeSystem, OutOfTypeSystemData otsd) throws IOException, SAXException {
        if (typeSystem == null) {
            typeSystem = aCAS.getTypeSystem();
        }
        XMLSerializer xmlSer = new XMLSerializer(stream, false);
        if (encoding != null) {
            xmlSer.setOutputProperty("encoding", encoding);
        }
        XmiCasSerializer ser = new XmiCasSerializer(typeSystem);
        ser.serialize(aCAS, xmlSer.getContentHandler());
    }

    public String serializeCasToXmi(CAS aCAS, XmiSerializationSharedData serSharedData) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            XMLSerializer xmlSer = new XMLSerializer((Writer)writer, false);
            XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
            ser.serialize(aCAS, xmlSer.getContentHandler(), null, serSharedData);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (SAXException e) {
            throw e;
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public String serializeCasToXmi(CAS aCAS, XmiSerializationSharedData serSharedData, Marker aMarker) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            XMLSerializer xmlSer = new XMLSerializer((Writer)writer, false);
            XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
            ser.serialize(aCAS, xmlSer.getContentHandler(), null, serSharedData, aMarker);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (SAXException e) {
            throw e;
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void deserializeCasFromXmi(String anXmlStr, CAS aCAS, XmiSerializationSharedData aSharedData, boolean aLenient, int aMergePoint) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (this.localXmlReader.get() == null) {
            this.localXmlReader.set(XMLReaderFactory.createXMLReader());
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        StringReader reader = new StringReader(anXmlStr);
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(reader));
    }

    public void deserializeCasFromXmi(String anXmlStr, CAS aCAS, XmiSerializationSharedData aSharedData, boolean aLenient, int aMergePoint, AllowPreexistingFS allow) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (this.localXmlReader.get() == null) {
            this.localXmlReader.set(XMLReaderFactory.createXMLReader());
        }
        XMLReader xmlReader = this.localXmlReader.get();
        StringReader reader = new StringReader(anXmlStr);
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint, allow);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(reader));
    }

    public void deserializeCasFromBinary(byte[] binarySource, CAS aCAS) throws Exception {
        ByteArrayInputStream fis = null;
        try {
            fis = new ByteArrayInputStream(binarySource);
            Serialization.deserializeCAS((CAS)aCAS, (InputStream)fis);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public byte[] serializeCasToBinary(CAS aCAS) throws Exception {
        ByteArrayOutputStream fos = null;
        try {
            fos = new ByteArrayOutputStream();
            Serialization.serializeCAS((CAS)aCAS, (OutputStream)fos);
            byte[] byArray = fos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public byte[] serializeCasToBinary(CAS aCAS, Marker aMark) throws Exception {
        ByteArrayOutputStream fos = null;
        try {
            fos = new ByteArrayOutputStream();
            Serialization.serializeCAS((CAS)aCAS, (OutputStream)fos, (Marker)aMark);
            byte[] byArray = fos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

