/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.util.Level;

public class UimaAsThreadFactory
implements ThreadFactory {
    private static final Class CLASS_NAME = UimaAsThreadFactory.class;
    private static final String THREAD_POOL = "[UIMA AS ThreadPool ";
    private PrimitiveAnalysisEngineController controller;
    private ThreadGroup theThreadGroup;
    private String threadNamePrefix = null;
    private boolean isDaemon;
    public static AtomicInteger poolIdGenerator = new AtomicInteger();
    private final int poolId = poolIdGenerator.incrementAndGet();

    public UimaAsThreadFactory(ThreadGroup tGroup) {
        this(tGroup, null);
    }

    public UimaAsThreadFactory(ThreadGroup tGroup, PrimitiveAnalysisEngineController aController) {
        this.controller = aController;
        this.theThreadGroup = tGroup;
    }

    public void setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
    }

    public void setThreadGroup(ThreadGroup tGroup) {
        this.theThreadGroup = tGroup;
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    public void stop() {
    }

    public Thread newThread(final Runnable r) {
        Thread newThread;
        block4: {
            newThread = null;
            try {
                newThread = new Thread(this.theThreadGroup, new Runnable(){

                    public void run() {
                        if (UimaAsThreadFactory.this.threadNamePrefix == null) {
                            if (UimaAsThreadFactory.this.controller != null) {
                                UimaAsThreadFactory.this.threadNamePrefix = UimaAsThreadFactory.THREAD_POOL + UimaAsThreadFactory.this.poolId + "] " + UimaAsThreadFactory.this.controller.getComponentName() + " Process Thread";
                            } else {
                                UimaAsThreadFactory.this.threadNamePrefix = UimaAsThreadFactory.THREAD_POOL + UimaAsThreadFactory.this.poolId + "] ";
                            }
                        }
                        Thread.currentThread().setName(UimaAsThreadFactory.this.threadNamePrefix + " - " + Thread.currentThread().getId());
                        try {
                            if (UimaAsThreadFactory.this.controller != null && !UimaAsThreadFactory.this.controller.threadAssignedToAE()) {
                                UimaAsThreadFactory.this.controller.initializeAnalysisEngine();
                            }
                            r.run();
                        }
                        catch (Throwable e) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_exception__WARNING", e);
                            if (UimaAsThreadFactory.this.controller != null) {
                                Exception ex = e instanceof Exception ? (Exception)e : new Exception(e);
                                UimaAsThreadFactory.this.controller.notifyListenersWithInitializationStatus(ex);
                            }
                            return;
                        }
                    }
                });
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                if (this.controller != null) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "UimaAsThreadFactory", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
        if (newThread != null) {
            newThread.setDaemon(this.isDaemon);
        }
        return newThread;
    }
}

