/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InProcessCacheMBean;
import org.apache.uima.aae.UIDGenerator;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.EventSubscriber;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.aae.monitor.statistics.DelegateStats;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.util.Level;

public class InProcessCache
implements InProcessCacheMBean {
    private static final long serialVersionUID = 1L;
    private static final Class CLASS_NAME = InProcessCache.class;
    public static final int NotifyWhenRegistering = 1;
    private transient UIDGenerator idGenerator = new UIDGenerator();
    private ConcurrentHashMap cache = new ConcurrentHashMap();
    private String name = "InProcessCache";
    private List callbackListeners = new ArrayList();
    int size = 0;

    public void registerCallbackWhenCacheEmpty(EventSubscriber aController) {
        this.registerCallbackWhenCacheEmpty(aController, 0);
    }

    public void registerCallbackWhenCacheEmpty(EventSubscriber aController, int notification) {
        if (!this.callbackListeners.isEmpty()) {
            for (EventSubscriber es : this.callbackListeners) {
                if (es != aController) continue;
                return;
            }
        } else if (notification == 1 && this.isEmpty()) {
            aController.onCacheEmpty();
        }
        if (!this.callbackListeners.contains(aController)) {
            this.callbackListeners.add(aController);
        }
    }

    public void destroy() {
        this.callbackListeners.clear();
        Set set = this.cache.entrySet();
        for (Map.Entry entry : set) {
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            if (cacheEntry == null || cacheEntry.getCas() == null) continue;
            try {
                cacheEntry.getCas().release();
            }
            catch (Exception e) {}
        }
        this.cache.clear();
    }

    public boolean isInputCASPendingReply(String anInputCASReferenceId) throws Exception {
        if (anInputCASReferenceId == null) {
            return false;
        }
        CacheEntry inputCASEntry = this.getCacheEntryForCAS(anInputCASReferenceId);
        return inputCASEntry.isPendingReply();
    }

    public boolean producedCASesStillInPlay(String anInputCASReferenceId, String aSubordinateCASReferenceId) throws Exception {
        for (String key : this.cache.keySet()) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry != null && aSubordinateCASReferenceId != null && aSubordinateCASReferenceId.equals(key) || entry == null || !anInputCASReferenceId.equals(entry.getInputCasReferenceId())) continue;
            return true;
        }
        return false;
    }

    public void releaseCASesProducedFromInputCAS(String anInputCASReferenceId) {
        if (anInputCASReferenceId == null) {
            return;
        }
        for (String key : this.cache.keySet()) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry == null || !anInputCASReferenceId.equals(key) && !anInputCASReferenceId.equals(entry.getInputCasReferenceId())) continue;
            if (entry.getCas() != null) {
                entry.getCas().release();
            }
            this.remove(key);
        }
    }

    public void releaseAllCASes() {
        for (String key : this.cache.keySet()) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry != null && entry.getCas() != null) {
                try {
                    entry.getCas().release();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.cache.remove(key);
        }
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void cancelTimers() {
    }

    public boolean isEmpty() {
        return this.cache.size() == 0;
    }

    public void reset() {
        this.size = 0;
    }

    public int getSize() {
        return this.cache.size();
    }

    public void setSize(int i) {
        this.size = i;
    }

    public synchronized void dumpContents(String aControllerName) {
        boolean count = false;
    }

    public synchronized void remove(String aCasReferenceId) {
        if (aCasReferenceId != null && this.cache.containsKey(aCasReferenceId)) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_remove_cache_entry_for_cas__FINE", new Object[]{aCasReferenceId});
            }
            this.cache.remove(aCasReferenceId);
            this.notifyAll();
        } else if (aCasReferenceId == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_cas_is_null_remove_from_cache_failed__FINE");
            }
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_cas_is_invalid_remove_from_cache_failed__FINE", new Object[]{aCasReferenceId});
        }
        if (this.cache.size() == 0 && this.callbackListeners.size() > 0) {
            for (int i = 0; i < this.callbackListeners.size(); ++i) {
                ((EventSubscriber)this.callbackListeners.get(i)).onCacheEmpty();
            }
        }
    }

    public void removeCas(String aCasReferenceId) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return;
        }
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        casRefEntry.deleteCAS();
    }

    public synchronized CacheEntry[] getCacheEntriesForEndpoint(String anEndpointName) {
        ArrayList<CacheEntry> list = new ArrayList<CacheEntry>();
        for (String key : this.cache.keySet()) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry == null || entry.getEndpoint(anEndpointName) == null) continue;
            list.add(entry);
        }
        if (list.size() > 0) {
            CacheEntry[] entries = new CacheEntry[list.size()];
            list.toArray(entries);
            return entries;
        }
        return null;
    }

    public void saveSerializedCAS(String aCasReferenceId, String anXCAS) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return;
        }
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        casRefEntry.setSerializedCas(anXCAS);
    }

    public String getSerializedCAS(String aCasReferenceId) {
        if (this.cache.containsKey(aCasReferenceId)) {
            CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
            return casRefEntry.getSerializedCas();
        }
        return null;
    }

    public void setCasProducer(String aCasReferenceId, String aCasProducerKey) {
        if (this.cache.containsKey(aCasReferenceId)) {
            CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
            casRefEntry.setCasProducerKey(aCasProducerKey);
        }
    }

    public String getCasProducer(String aCasReferenceId) {
        if (this.cache.containsKey(aCasReferenceId)) {
            CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
            return casRefEntry.getCasProducerKey();
        }
        return null;
    }

    public synchronized CAS getCasByReference(String aCasReferenceId) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return null;
        }
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        return casRefEntry.getCas();
    }

    public MessageContext getMessageAccessorByReference(String aCasReferenceId) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return null;
        }
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        return casRefEntry.getMessageAccessor();
    }

    public OutOfTypeSystemData getOutOfTypeSystemData(String aCasReferenceId) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return null;
        }
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        return casRefEntry.getOtsd();
    }

    private synchronized CacheEntry getEntry(String aCasReferenceId) {
        if (!this.cache.containsKey(aCasReferenceId)) {
            return null;
        }
        return (CacheEntry)this.cache.get(aCasReferenceId);
    }

    public void addEndpoint(Endpoint anEndpoint, String aCasReferenceId) {
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        if (!casRefEntry.getEndpointMap().containsKey(anEndpoint.getEndpoint())) {
            casRefEntry.addEndpoint(anEndpoint);
        }
    }

    public Endpoint getEndpoint(String anEndpointName, String aCasReferenceId) {
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        if (anEndpointName == null && casRefEntry != null) {
            return casRefEntry.getMessageOrigin();
        }
        if (casRefEntry == null) {
            return null;
        }
        return casRefEntry.getEndpoint(anEndpointName);
    }

    public void removeEndpoint(String anEndpointName, String aCasReferenceId) {
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        casRefEntry.deleteEndpoint(anEndpointName);
    }

    public long getStartTime(String aCasReferenceId) {
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        return casRefEntry.getStartTime();
    }

    public synchronized boolean entryExists(String aCasReferenceId) {
        try {
            CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
            if (casRefEntry == null) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public CacheEntry register(CAS aCAS, MessageContext aMessageContext, OutOfTypeSystemData otsd) throws AsynchAEException {
        return this.register(aCAS, aMessageContext, otsd, this.idGenerator.nextId());
    }

    public CacheEntry register(CAS aCAS, MessageContext aMessageContext, XmiSerializationSharedData sharedData) throws AsynchAEException {
        return this.register(aCAS, aMessageContext, sharedData, this.idGenerator.nextId());
    }

    public CacheEntry register(CAS aCAS, MessageContext aMessageContext, OutOfTypeSystemData otsd, String aCasReferenceId) throws AsynchAEException {
        return this.registerCacheEntry(aCasReferenceId, new CacheEntry(aCAS, aCasReferenceId, aMessageContext, otsd));
    }

    public CacheEntry register(CAS aCAS, MessageContext aMessageContext, XmiSerializationSharedData sharedData, String aCasReferenceId) throws AsynchAEException {
        return this.registerCacheEntry(aCasReferenceId, new CacheEntry(aCAS, aCasReferenceId, aMessageContext, sharedData));
    }

    public CacheEntry register(CAS aCAS, MessageContext aMessageContext, XmiSerializationSharedData sharedData, String aCasReferenceId, Marker marker, boolean acceptsDeltaCas) throws AsynchAEException {
        return this.registerCacheEntry(aCasReferenceId, new CacheEntry(aCAS, aCasReferenceId, aMessageContext, sharedData, marker, acceptsDeltaCas));
    }

    private synchronized CacheEntry registerCacheEntry(String aCasReferenceId, CacheEntry entry) {
        this.cache.put(aCasReferenceId, entry);
        return entry;
    }

    public boolean hasNoSubordinates(String aCasReferenceId) {
        for (String key : this.cache.keySet()) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry == null || entry.getInputCasReferenceId() == null || !entry.getInputCasReferenceId().equals(aCasReferenceId)) continue;
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "hasNoSubordinates", "uimaee_messages", "UIMAEE_cache_entry_exists___FINE", new Object[]{entry.getCasReferenceId(), entry.getInputCasReferenceId()});
            }
            return false;
        }
        return true;
    }

    public Endpoint getTopAncestorEndpoint(CacheEntry anEntry) throws Exception {
        if (anEntry == null) {
            return null;
        }
        if (anEntry.getInputCasReferenceId() == null) {
            return anEntry.getMessageOrigin();
        }
        CacheEntry parentEntry = this.getCacheEntryForCAS(anEntry.getInputCasReferenceId());
        return this.getTopAncestorEndpoint(parentEntry);
    }

    public synchronized CacheEntry getCacheEntryForCAS(String aCasReferenceId) throws AsynchAEException {
        CacheEntry casRefEntry = this.getEntry(aCasReferenceId);
        if (casRefEntry == null) {
            throw new AsynchAEException("Cas Not Found In CasManager Cache. CasReferenceId::" + aCasReferenceId + " is Invalid");
        }
        return casRefEntry;
    }

    public static class CacheEntry {
        public static final int FINAL_STATE = 1;
        private CAS cas;
        private boolean newCas;
        private String casReferenceId;
        private String inputCasReferenceId;
        private String remoteCMCasReferenceId;
        private DelegateStats stats;
        private MessageContext messageAccessor;
        private OutOfTypeSystemData otsd;
        private String serializedCas;
        private String casProducerKey;
        private Map endpointMap;
        private final long timeIn;
        private Endpoint messageOrigin;
        private Stack originStack;
        private int highWaterMark;
        private XmiSerializationSharedData deserSharedData;
        private String aggregateProducingTheCas;
        private long timeWaitingForCAS;
        private long timeToDeserializeCAS;
        private long timeToSerializeCAS;
        private long timeToProcessCAS;
        private long totalTimeToProcessCAS;
        private String casMultiplierKey;
        private boolean sendRequestToFreeCas;
        private boolean aborted;
        private boolean pendingReply;
        private long sequence;
        private Endpoint freeCasEndpoint;
        private Marker marker;
        private boolean acceptsDeltaCas;
        private boolean sentDeltaCas;
        private List delayedSingleStepList;

        protected CacheEntry(CAS aCas, String aCasReferenceId, MessageContext aMessageAccessor, OutOfTypeSystemData aotsd) {
            this(aCas, aCasReferenceId, aMessageAccessor);
            this.messageAccessor = aMessageAccessor;
        }

        protected CacheEntry(CAS aCas, String aCasReferenceId, MessageContext aMessageAccessor, XmiSerializationSharedData sdata) {
            this(aCas, aCasReferenceId, aMessageAccessor);
            this.deserSharedData = sdata;
        }

        protected CacheEntry(CAS aCas, String aCasReferenceId, MessageContext aMessageAccessor, XmiSerializationSharedData sdata, Marker aMarker, boolean acceptsDeltaCas) {
            this(aCas, aCasReferenceId, aMessageAccessor);
            this.deserSharedData = sdata;
            this.marker = aMarker;
            this.acceptsDeltaCas = acceptsDeltaCas;
        }

        private CacheEntry(CAS aCas, String aCasReferenceId, MessageContext aMessageAccessor) {
            block4: {
                this.otsd = null;
                this.endpointMap = new HashMap();
                this.timeIn = System.nanoTime();
                this.originStack = new Stack();
                this.timeWaitingForCAS = 0L;
                this.timeToDeserializeCAS = 0L;
                this.timeToSerializeCAS = 0L;
                this.timeToProcessCAS = 0L;
                this.totalTimeToProcessCAS = 0L;
                this.sendRequestToFreeCas = true;
                this.aborted = false;
                this.pendingReply = false;
                this.sequence = 0L;
                this.marker = null;
                this.acceptsDeltaCas = false;
                this.sentDeltaCas = false;
                this.delayedSingleStepList = null;
                this.cas = aCas;
                this.messageAccessor = aMessageAccessor;
                if (aMessageAccessor != null) {
                    this.messageOrigin = aMessageAccessor.getEndpoint();
                }
                this.casReferenceId = aCasReferenceId;
                try {
                    if (aMessageAccessor != null && aMessageAccessor.propertyExists("CasSequence")) {
                        this.sequence = aMessageAccessor.getMessageLongProperty("CasSequence");
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "CacheEntry", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }

        public String getCasReferenceId() {
            return this.casReferenceId;
        }

        public Map getEndpointMap() {
            return this.endpointMap;
        }

        public String getInputCasReferenceId() {
            return this.inputCasReferenceId;
        }

        public void setInputCasReferenceId(String anInputCasReferenceId) {
            this.inputCasReferenceId = anInputCasReferenceId;
        }

        public void setStat(DelegateStats aStat) {
            this.stats = aStat;
        }

        public DelegateStats getStat() {
            return this.stats;
        }

        public void incrementTimeWaitingForCAS(long aTimeWaitingForCAS) {
            this.timeWaitingForCAS += aTimeWaitingForCAS;
        }

        public void incrementTimeToDeserializeCAS(long aTimeToDeserializeCAS) {
            this.timeToDeserializeCAS += aTimeToDeserializeCAS;
        }

        public void incrementTimeToProcessCAS(long aTimeToProcessCAS) {
            this.timeToProcessCAS += aTimeToProcessCAS;
        }

        public void setCasMultiplierKey(String aKey) {
            this.casMultiplierKey = aKey;
        }

        public String getCasMultiplierKey() {
            return this.casMultiplierKey;
        }

        public void incrementTimeToSerializeCAS(long aTimeToSerializeCAS) {
            this.timeToSerializeCAS += aTimeToSerializeCAS;
        }

        public long getTimeWaitingForCAS() {
            return this.timeWaitingForCAS;
        }

        public long getTimeToDeserializeCAS() {
            return this.timeToDeserializeCAS;
        }

        public long getTimeToSerializeCAS() {
            return this.timeToSerializeCAS;
        }

        public Endpoint getMessageOrigin() {
            return this.messageOrigin;
        }

        public void addOrigin(Endpoint anEndpoint) {
            this.originStack.push(anEndpoint);
        }

        protected long getStartTime() {
            return this.timeIn;
        }

        protected void addEndpoint(Endpoint anEndpoint) {
            this.endpointMap.put(anEndpoint.getEndpoint(), anEndpoint);
        }

        protected Endpoint getEndpoint(String anEndpointName) {
            return (Endpoint)this.endpointMap.get(anEndpointName);
        }

        protected void deleteEndpoint(String anEndpointName) {
            if (this.endpointMap.containsKey(anEndpointName)) {
                this.endpointMap.remove(anEndpointName);
            }
        }

        protected void deleteCAS() {
            this.cas = null;
            this.otsd = null;
        }

        public CAS getCas() {
            return this.cas;
        }

        protected void setCas(CAS aCAS, OutOfTypeSystemData aotsd) {
            this.cas = aCAS;
            this.otsd = aotsd;
        }

        protected void setCas(CAS aCAS) {
            this.cas = aCAS;
        }

        protected void setSerializedCas(String aSerializedCas) {
            this.serializedCas = aSerializedCas;
        }

        protected String getSerializedCas() {
            return this.serializedCas;
        }

        protected MessageContext getMessageAccessor() {
            return this.messageAccessor;
        }

        public OutOfTypeSystemData getOtsd() {
            return this.otsd;
        }

        public int getHighWaterMark() {
            return this.highWaterMark;
        }

        public void setHighWaterMark(int aHighWaterMark) {
            this.highWaterMark = aHighWaterMark;
        }

        public boolean isNewCas() {
            return this.newCas;
        }

        public void setNewCas(boolean newCas, String producedIn) {
            this.newCas = newCas;
            this.aggregateProducingTheCas = producedIn;
        }

        public XmiSerializationSharedData getDeserSharedData() {
            return this.deserSharedData;
        }

        public void setXmiSerializationData(XmiSerializationSharedData anXmiSerializationData) {
            this.deserSharedData = anXmiSerializationData;
        }

        public String getCasProducerAggregateName() {
            return this.aggregateProducingTheCas;
        }

        public void setCasProducerKey(String aCasProducerKey) {
            this.casProducerKey = aCasProducerKey;
        }

        public String getCasProducerKey() {
            return this.casProducerKey;
        }

        public String getRemoteCMCasReferenceId() {
            return this.remoteCMCasReferenceId;
        }

        public void setRemoteCMCasReferenceId(String remoteCMCasReferenceId) {
            this.remoteCMCasReferenceId = remoteCMCasReferenceId;
        }

        public boolean shouldSendRequestToFreeCas() {
            return this.sendRequestToFreeCas;
        }

        public void setSendRequestToFreeCas(boolean sendRequestToFreeCas) {
            this.sendRequestToFreeCas = sendRequestToFreeCas;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setAborted(boolean aborted) {
            this.aborted = aborted;
        }

        public long getTimeToProcessCAS() {
            return this.timeToProcessCAS;
        }

        public void setTimeToProcessCAS(long aTimeToProcessCAS) {
            this.timeToProcessCAS = aTimeToProcessCAS;
            this.totalTimeToProcessCAS += aTimeToProcessCAS;
        }

        public long getTotalTimeToProcessCAS() {
            return this.totalTimeToProcessCAS;
        }

        public boolean isPendingReply() {
            return this.pendingReply;
        }

        public void setPendingReply(boolean pendingReply) {
            this.pendingReply = pendingReply;
        }

        public long getCasSequence() {
            return this.sequence;
        }

        public void setCasSequence(long sequence) {
            this.sequence = sequence;
        }

        public void setFreeCasEndpoint(Endpoint aFreeCasEndpoint) {
            this.freeCasEndpoint = aFreeCasEndpoint;
        }

        public Endpoint getFreeCasEndpoint() {
            return this.freeCasEndpoint;
        }

        public boolean acceptsDeltaCas() {
            return this.acceptsDeltaCas;
        }

        public void setAcceptsDeltaCas(boolean accepts) {
            this.acceptsDeltaCas = accepts;
        }

        public void setSentDeltaCas(boolean sendingDeltaCas) {
            this.sentDeltaCas = sendingDeltaCas;
        }

        public boolean sentDeltaCas() {
            return this.sentDeltaCas;
        }

        public Marker getMarker() {
            return this.marker;
        }

        public void setDelayedSingleStepList(List aList) {
            this.delayedSingleStepList = aList;
        }

        public List getDelayedSingleStepList() {
            return this.delayedSingleStepList;
        }

        public void setMarker(Marker mark) {
            this.marker = mark;
        }
    }
}

