/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.io.InvalidClassException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaAsThreadFactory;
import org.apache.uima.aae.UimaBlockingExecutor;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.util.Level;
import org.springframework.jms.listener.SessionAwareMessageListener;

public class ConcurrentMessageListener
implements SessionAwareMessageListener {
    private static final Class CLASS_NAME = ConcurrentMessageListener.class;
    private SessionAwareMessageListener delegateListener;
    private int concurrentThreadCount = 0;
    private AnalysisEngineController controller;
    private ThreadPoolExecutor executor = null;
    private UimaBlockingExecutor blockingExecutor;
    private LinkedBlockingQueue<Runnable> workQueue;
    private CountDownLatch controllerLatch = new CountDownLatch(1);

    public ConcurrentMessageListener(int concurrentThreads, Object delegateListener, String destination, ThreadGroup threadGroup, String threadPrefix) throws InvalidClassException {
        if (!(delegateListener instanceof SessionAwareMessageListener)) {
            throw new InvalidClassException("Invalid Delegate Listener. Expected Object of Type:" + SessionAwareMessageListener.class + " Received:" + delegateListener.getClass());
        }
        this.concurrentThreadCount = concurrentThreads;
        this.delegateListener = (SessionAwareMessageListener)delegateListener;
        if (concurrentThreads > 1) {
            this.workQueue = new LinkedBlockingQueue();
            this.executor = new ThreadPoolExecutor(concurrentThreads, concurrentThreads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, this.workQueue);
            UimaAsThreadFactory tf = new UimaAsThreadFactory(threadGroup);
            tf.setDaemon(true);
            tf.setThreadNamePrefix(threadPrefix);
            this.executor.setThreadFactory((ThreadFactory)tf);
            this.executor.prestartAllCoreThreads();
            this.blockingExecutor = destination != null ? new UimaBlockingExecutor(this.executor, concurrentThreads, destination) : new UimaBlockingExecutor(this.executor, concurrentThreads);
        }
    }

    public ThreadPoolExecutor getTaskExecutor() {
        return this.executor;
    }

    public void stop() {
        this.blockingExecutor.stop();
    }

    public void setAnalysisEngineController(AnalysisEngineController controller) {
        this.controller = controller;
        this.controllerLatch.countDown();
    }

    private boolean isMessageFromCasMultiplier(Message message) throws JMSException {
        return message.propertyExists("CasSequence");
    }

    public void onMessage(final Message message, final Session session) throws JMSException {
        block11: {
            try {
                this.controllerLatch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.isMessageFromCasMultiplier(message)) {
                int command = message.getIntProperty("Command");
                int messageType = message.getIntProperty("MessageType");
                if (command == 2000 && messageType == 3000) {
                    String delegateKey;
                    String msgFrom = message.getStringProperty("MessageFrom");
                    if (msgFrom != null && this.controller instanceof AggregateAnalysisEngineController && (delegateKey = ((AggregateAnalysisEngineController)this.controller).lookUpDelegateKey(msgFrom)) != null) {
                        Delegate delegate = ((AggregateAnalysisEngineController)this.controller).lookupDelegate(delegateKey);
                        delegate.setConcurrentConsumersOnReplyQueue();
                    }
                    try {
                        String parentCasReferenceId = message.getStringProperty("InputCasReference");
                        LocalCache.CasStateEntry parentEntry = this.controller.getLocalCache().lookupEntry(parentCasReferenceId);
                        parentEntry.incrementSubordinateCasInPlayCount();
                        parentEntry.incrementOutstandingFlowCounter();
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block11;
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }
        if (this.concurrentThreadCount > 1) {
            try {
                this.blockingExecutor.submitTask(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                ConcurrentMessageListener.this.delegateListener.onMessage(message, session);
                            }
                            catch (Exception e) {
                                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)ConcurrentMessageListener.this.controller.getComponentName());
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                            }
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onMessage", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        } else {
            this.delegateListener.onMessage(message, session);
        }
    }
}

