/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.as;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.springframework.jmx.JmxException;

public class GetMetaRequest {
    private static MBeanServerConnection brokerMBeanServer = null;
    private static String brokerName;
    private static JMXConnector jmxc;
    private static boolean initialized;
    private static String jmxPort;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Need arguments: brokerURI serviceName [-verbose]");
            System.exit(1);
        }
        String brokerURI = args[0];
        String queueName = args[1];
        boolean printReply = false;
        if (args.length > 2) {
            if (args[2].equalsIgnoreCase("-verbose")) {
                printReply = true;
            } else {
                System.err.println("Unknown argument: " + args[2]);
                System.exit(1);
            }
        }
        Session producerSession = null;
        Queue producerQueue = null;
        Session consumerSession = null;
        TemporaryQueue consumerDestination = null;
        long startTime = 0L;
        jmxPort = System.getProperty("activemq.broker.jmx.port");
        if (jmxPort == null || jmxPort.trim().length() == 0) {
            jmxPort = "1099";
        }
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerURI);
            final Connection connection = factory.createConnection();
            connection.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                public void run() {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        if (jmxc != null) {
                            jmxc.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }));
            URI target = new URI(brokerURI);
            String brokerHost = target.getHost();
            GetMetaRequest.attachToRemoteBrokerJMXServer(brokerURI);
            if (GetMetaRequest.isQueueAvailable(queueName) == QueueState.exists) {
                System.out.println("Queue " + queueName + " found on " + brokerURI);
                System.out.println("Sending getMeta...");
            } else if (GetMetaRequest.isQueueAvailable(queueName) == QueueState.existsnot) {
                System.err.println("Queue " + queueName + " does not exist on " + brokerURI);
                System.exit(1);
            } else {
                System.out.println("Cannot see queues on JMX port " + brokerHost + ":" + jmxPort);
                System.out.println("Sending getMeta anyway...");
            }
            producerSession = connection.createSession(false, 1);
            producerQueue = producerSession.createQueue(queueName);
            MessageProducer producer = producerSession.createProducer((Destination)producerQueue);
            consumerSession = connection.createSession(false, 1);
            consumerDestination = consumerSession.createTemporaryQueue();
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerDestination, "Command=2001");
            TextMessage msg = producerSession.createTextMessage();
            msg.setStringProperty("MessageFrom", consumerDestination.getQueueName());
            msg.setStringProperty("ServerURI", brokerURI);
            msg.setIntProperty("MessageType", 3000);
            msg.setIntProperty("Command", 2001);
            msg.setJMSReplyTo((Destination)consumerDestination);
            msg.setText("");
            producer.send((Message)msg);
            startTime = System.nanoTime();
            System.out.println("Sent getMeta request to " + queueName + " at " + brokerURI);
            System.out.println("Waiting for getMeta reply...");
            ActiveMQTextMessage reply = (ActiveMQTextMessage)consumer.receive();
            long waitTime = (System.nanoTime() - startTime) / 1000000L;
            System.out.println("Reply from " + reply.getStringProperty("ServerIP") + " received in " + waitTime + " ms");
            if (printReply) {
                System.out.println("Reply MessageText: " + reply.getText());
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        System.exit(0);
    }

    private static void attachToRemoteBrokerJMXServer(String brokerUri) throws Exception {
        String jmxAMQDomain = System.getProperty("activemq.broker.jmx.domain");
        if (jmxAMQDomain == null) {
            jmxAMQDomain = "org.apache.activemq";
        }
        String brokerHostname = "";
        URI target = new URI(brokerUri);
        brokerHostname = target.getHost();
        GetMetaRequest.initialize(jmxAMQDomain, brokerHostname, jmxPort);
    }

    private static void initialize(String jmxDomain, String remoteJMXServerHostname, String remoteJMXServerPort) throws Exception {
        String remoteJmxUrl = "service:jmx:rmi:///jndi/rmi://" + remoteJMXServerHostname + ":" + remoteJMXServerPort + "/jmxrmi";
        try {
            JMXServiceURL url = new JMXServiceURL(remoteJmxUrl);
            jmxc = JMXConnectorFactory.connect(url, null);
            brokerMBeanServer = jmxc.getMBeanServerConnection();
            Set<ObjectName> queueSet = brokerMBeanServer.queryNames(new ObjectName(jmxDomain + ":*,Type=Queue"), null);
            if (queueSet.isEmpty()) {
                throw new JmxException("ActiveMQ Broker Not Configured With JMX Support");
            }
        }
        catch (Exception e) {
            return;
        }
        for (ObjectName nameObject : brokerMBeanServer.queryNames(new ObjectName(jmxDomain + ":*,Type=Broker"), null)) {
            ObjectName brokerObjectName = nameObject;
            if (!brokerObjectName.getCanonicalName().endsWith("Type=Broker")) continue;
            brokerName = brokerObjectName.getCanonicalName().substring(0, brokerObjectName.getCanonicalName().indexOf(","));
            initialized = true;
            break;
        }
    }

    private static boolean isServerAvailable() {
        try {
            brokerMBeanServer.getMBeanCount();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static QueueState isQueueAvailable(String queueName) throws Exception {
        if (!initialized) {
            return QueueState.jmxnot;
        }
        ObjectName uimaServiceQueuePattern = new ObjectName(brokerName + ",Type=Queue,Destination=" + queueName);
        if (GetMetaRequest.isServerAvailable() && GetMetaRequest.getQueueMBean(queueName, uimaServiceQueuePattern) == null) {
            return QueueState.existsnot;
        }
        return QueueState.exists;
    }

    private static QueueViewMBean getQueueMBean(String key, ObjectName matchPattern) throws Exception {
        HashSet<ObjectName> queues = new HashSet<ObjectName>(brokerMBeanServer.queryNames(matchPattern, null));
        Iterator i$ = queues.iterator();
        if (i$.hasNext()) {
            ObjectName name = (ObjectName)i$.next();
            return MBeanServerInvocationHandler.newProxyInstance(brokerMBeanServer, name, QueueViewMBean.class, true);
        }
        return null;
    }

    static {
        jmxc = null;
        initialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueueState {
        exists,
        existsnot,
        jmxnot;

    }
}

