/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.jmx.monitor;

import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.jmx.ServiceInfoMBean;
import org.apache.uima.aae.jmx.ServicePerformanceMBean;
import org.apache.uima.aae.jmx.monitor.BasicUimaJmxMonitorListener;
import org.apache.uima.aae.jmx.monitor.JmxMonitorListener;
import org.apache.uima.aae.jmx.monitor.ServiceMetrics;
import org.apache.uima.aae.spi.transport.vm.UimaVmQueueMBean;
import org.apache.uima.util.Level;
import org.apache.uima.util.impl.CasPoolManagementImplMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxMonitor
implements Runnable {
    private static final Class CLASS_NAME = JmxMonitor.class;
    public static final String SamplingInterval = "uima.jmx.monitor.interval";
    public static final String FormatterListener = "uima.jmx.monitor.formatter";
    private boolean running = false;
    private MBeanServerConnection mbsc;
    private ObjectName uimaServicePattern;
    private ObjectName uimaServiceQueuePattern;
    private ObjectName uimaServiceTempQueuePattern;
    private Set<ObjectName> servicePerformanceNames;
    private long interval;
    private ConcurrentHashMap<ObjectName, StatEntry> stats = new ConcurrentHashMap();
    private long startTime = System.nanoTime();
    private List<JmxMonitorListener> listeners = new ArrayList<JmxMonitorListener>();
    private int maxNameLength = 0;
    private boolean verbose = false;
    private ThreadMXBean threads = null;
    private RuntimeMXBean runtime = null;
    private OperatingSystemMXBean os = null;
    private int serviceCount = 0;

    private MBeanServerConnection getServerConnection(String remoteServerURI) throws Exception {
        JMXServiceURL url = new JMXServiceURL(remoteServerURI);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection server = jmxc.getMBeanServerConnection();
        return server;
    }

    public void addJmxMonitorListener(JmxMonitorListener listener) {
        this.listeners.add(listener);
    }

    private void showServerEnvironment(RuntimeMXBean runtime) {
        JmxMonitor.echo("\nRemote JVM Info: \n\tJVM::" + runtime.getVmName() + "\n\tJVM Vendor::" + runtime.getVmVendor() + "\n\tJVM Version::" + runtime.getVmVersion() + "\n\n");
    }

    public void notifyListeners(long uptime, ServiceMetrics[] metrics) {
        for (JmxMonitorListener listener : this.listeners) {
            listener.onNewMetrics(uptime, metrics);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public int getMaxServiceNameLength() {
        return this.maxNameLength;
    }

    private CasPoolManagementImplMBean getServiceCasPoolMBean(String labelToMatch, Set<ObjectName> names) {
        for (ObjectName name : names) {
            if (!name.toString().endsWith(labelToMatch.trim())) continue;
            return MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, CasPoolManagementImplMBean.class, true);
        }
        return null;
    }

    public void initialize(String serverUri, long samplingInterval) throws Exception {
        this.interval = samplingInterval;
        try {
            this.mbsc = this.getServerConnection(serverUri);
        }
        catch (Exception e) {
            System.out.println("Unable to Connect To Jmx Server. URL:" + serverUri);
            throw e;
        }
        System.out.println(">>> Connected To Jmx Server. URL:" + serverUri);
        ObjectName runtimeObjName = new ObjectName("java.lang:type=Runtime");
        ObjectName threadObjName = new ObjectName("java.lang:type=Threading");
        ObjectName osObjName = new ObjectName("java.lang:type=OperatingSystem");
        Set<ObjectName> mbeans = this.mbsc.queryNames(threadObjName, null);
        mbeans = this.mbsc.queryNames(runtimeObjName, null);
        for (ObjectName name : mbeans) {
            this.runtime = MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, RuntimeMXBean.class, true);
        }
        mbeans = this.mbsc.queryNames(osObjName, null);
        for (ObjectName name : mbeans) {
            this.os = MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, OperatingSystemMXBean.class, true);
        }
        System.out.println(this.runtime.getVmName() + "::" + this.runtime.getVmVendor() + "::" + this.runtime.getVmVersion());
        this.uimaServicePattern = new ObjectName("org.apache.uima:type=ee.jms.services,*");
        this.uimaServiceQueuePattern = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=Queue,*");
        this.uimaServiceTempQueuePattern = new ObjectName("org.apache.activemq:BrokerName=localhost,Type=TempQueue,*");
        HashSet<ObjectName> names = new HashSet<ObjectName>(this.mbsc.queryNames(this.uimaServicePattern, null));
        String key = "";
        if (this.verbose) {
            System.out.println("\nFound UIMA AS Services Managed by JMX Server:" + serverUri);
        }
        for (ObjectName name : names) {
            String perfKey = "_Service Performance";
            if (!name.toString().endsWith(perfKey)) continue;
            if (this.servicePerformanceNames == null) {
                this.servicePerformanceNames = new HashSet<ObjectName>();
            }
            this.servicePerformanceNames.add(name);
            ServicePerformanceMBean perfMBeanProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, ServicePerformanceMBean.class, true);
            int beginIndx = name.toString().indexOf(perfKey);
            key = name.toString().substring(0, beginIndx);
            int nameLen = name.getKeyProperty("name").length();
            if (nameLen > this.maxNameLength) {
                this.maxNameLength = nameLen;
            }
            ServiceInfoMBean infoMBeanProxy = this.getServiceInfoMBean(names, key);
            key = key.substring(key.indexOf(",name=") + ",name=".length());
            CasPoolManagementImplMBean casPoolMBeanProxy = null;
            if (infoMBeanProxy.isTopLevel()) {
                casPoolMBeanProxy = infoMBeanProxy.isAggregate() ? this.getServiceCasPoolMBean("AggregateContext", names) : this.getServiceCasPoolMBean("PrimitiveAEService", names);
            }
            StatEntry entry = null;
            entry = casPoolMBeanProxy != null ? new StatEntry(perfMBeanProxy, infoMBeanProxy, casPoolMBeanProxy) : new StatEntry(perfMBeanProxy, infoMBeanProxy);
            String location = "Collocated";
            if (infoMBeanProxy.getBrokerURL().startsWith("Embedded Broker")) {
                UimaVmQueueMBean replyQueueProxy;
                UimaVmQueueMBean queueProxy;
                CasPoolManagementImplMBean casPoolMBean;
                if (infoMBeanProxy.isCASMultiplier() && (casPoolMBean = this.getServiceCasPoolMBean(infoMBeanProxy.getCmRegisteredName(), names)) != null) {
                    entry.setCasPoolMBean(casPoolMBean);
                }
                if ((queueProxy = this.getQueueMBean(this.mbsc, infoMBeanProxy.getInputQueueName())) != null) {
                    entry.setInputQueueInfo(queueProxy);
                }
                if ((replyQueueProxy = this.getQueueMBean(this.mbsc, infoMBeanProxy.getReplyQueueName())) != null) {
                    entry.setReplyQueueInfo(replyQueueProxy);
                }
            } else {
                String remoteJMX;
                MBeanServerConnection remoteServer;
                QueueViewMBean inputQueueProxy;
                location = "Remote";
                int spos = infoMBeanProxy.getBrokerURL().indexOf("//");
                int endpos = infoMBeanProxy.getBrokerURL().lastIndexOf(":");
                String remoteHostname = infoMBeanProxy.getBrokerURL().substring(spos + 2, endpos);
                if (this.verbose) {
                    System.out.println("Connecting to a remote JMX Server: " + remoteHostname + " key:" + key);
                }
                if ((inputQueueProxy = this.getQueueMBean(remoteServer = this.getServerConnection(remoteJMX = "service:jmx:rmi:///jndi/rmi://" + remoteHostname + ":1099/jmxrmi"), infoMBeanProxy.getInputQueueName(), this.uimaServiceQueuePattern)) != null) {
                    entry.setInputQueueInfo(inputQueueProxy);
                } else {
                    System.out.println("Unable to find Input Queue:" + infoMBeanProxy.getInputQueueName() + " In JMX Registry:" + remoteJMX);
                }
                QueueViewMBean replyQueueProxy = null;
                replyQueueProxy = infoMBeanProxy.isAggregate() ? this.getQueueMBean(this.mbsc, infoMBeanProxy.getReplyQueueName(), this.uimaServiceQueuePattern) : this.getQueueMBean(remoteServer, infoMBeanProxy.getReplyQueueName(), this.uimaServiceTempQueuePattern);
                if (replyQueueProxy != null) {
                    entry.setReplyQueueInfo(replyQueueProxy);
                } else {
                    System.out.println("Unable to find Reply Queue:" + infoMBeanProxy.getReplyQueueName() + " In JMX Registry:" + remoteJMX);
                }
            }
            if (this.verbose) {
                System.out.println("\nUIMA AS Service:" + key + "[>>> " + location + " <<<]\n\tService Broker:" + infoMBeanProxy.getBrokerURL() + "\n\tQueue Name:" + infoMBeanProxy.getInputQueueName());
            }
            ++this.serviceCount;
            this.stats.put(name, entry);
        }
    }

    protected int getServiceCount() {
        return this.serviceCount;
    }

    private ServiceInfoMBean getServiceInfoMBean(Set<ObjectName> names, String key) {
        String target = key + "_Service Info";
        for (ObjectName name : names) {
            if (!name.toString().equals(target)) continue;
            return MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, ServiceInfoMBean.class, true);
        }
        return null;
    }

    private CasPoolManagementImplMBean getCasPoolMBean(Set<ObjectName> names, String target) {
        for (ObjectName name : names) {
            if (!name.toString().endsWith(target)) continue;
            return MBeanServerInvocationHandler.newProxyInstance(this.mbsc, name, CasPoolManagementImplMBean.class, true);
        }
        return null;
    }

    private QueueViewMBean getQueueMBean(MBeanServerConnection server, String key, ObjectName matchPattern) throws Exception {
        HashSet<ObjectName> queues = new HashSet<ObjectName>(server.queryNames(matchPattern, null));
        String target = "Destination=" + key;
        for (ObjectName name : queues) {
            if (!name.toString().endsWith(target)) continue;
            System.out.println("Creating Proxy for Queue:" + name.toString());
            return MBeanServerInvocationHandler.newProxyInstance(server, name, QueueViewMBean.class, true);
        }
        return null;
    }

    private UimaVmQueueMBean getQueueMBean(MBeanServerConnection server, String aPattern) throws Exception {
        ObjectName name = new ObjectName(aPattern);
        System.out.println("Creating Proxy for Queue:" + name.toString());
        return MBeanServerInvocationHandler.newProxyInstance(server, name, UimaVmQueueMBean.class, true);
    }

    protected ServiceMetrics[] collectStats(boolean initial, long uptime) {
        int cmFreeCasInstanceCount = 0;
        ServiceMetrics[] metrics = null;
        boolean index = false;
        ArrayList<ServiceMetrics> metricsList = new ArrayList<ServiceMetrics>();
        for (ObjectName name : this.servicePerformanceNames) {
            try {
                StatEntry entry = this.stats.get(name);
                if (entry == null) continue;
                ServiceInfoMBean serviceInfo = entry.getServiceInfoMBeanProxy();
                CasPoolManagementImplMBean getServiceCasPoolMBeanProxy = entry.getServiceCasPoolMBeanProxy();
                boolean isRemote = serviceInfo.getBrokerURL().startsWith("tcp:");
                boolean topLevel = serviceInfo.isTopLevel();
                double idleTime = entry.getServicePerformanceMBeanProxy().getIdleTime();
                double casPoolWaitTime = entry.getServicePerformanceMBeanProxy().getCasPoolWaitTime();
                double shadowCasPoolWaitTime = entry.getServicePerformanceMBeanProxy().getShadowCasPoolWaitTime();
                double analysisTime = entry.getServicePerformanceMBeanProxy().getAnalysisTime();
                long processCount = entry.getServicePerformanceMBeanProxy().getNumberOfCASesProcessed();
                QueueViewMBean inputQueueInfo = entry.getInputQueueInfo();
                QueueViewMBean replyQueueInfo = entry.getReplyQueueInfo();
                cmFreeCasInstanceCount = -1;
                if (serviceInfo.isCASMultiplier() && !isRemote && entry.getCasPoolMBean() != null) {
                    try {
                        cmFreeCasInstanceCount = entry.getCasPoolMBean().getAvailableInstances();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                long inputQueueDepth = -1L;
                UimaVmQueueMBean vmInputQueueInfo = null;
                if (entry.isVmQueue) {
                    vmInputQueueInfo = entry.getVmInputQueueInfo();
                    if (vmInputQueueInfo != null) {
                        inputQueueDepth = vmInputQueueInfo.getQueueSize();
                    }
                } else {
                    inputQueueInfo = entry.getInputQueueInfo();
                    if (inputQueueInfo != null) {
                        inputQueueDepth = inputQueueInfo.getQueueSize();
                    }
                }
                long replyQueueDepth = -1L;
                UimaVmQueueMBean vmReplyQueueInfo = null;
                if (entry.isVmQueue) {
                    vmReplyQueueInfo = entry.getVmReplyQueueInfo();
                    if (vmReplyQueueInfo != null) {
                        replyQueueDepth = vmReplyQueueInfo.getQueueSize();
                    }
                } else {
                    replyQueueInfo = entry.getReplyQueueInfo();
                    if (replyQueueInfo != null) {
                        replyQueueDepth = replyQueueInfo.getQueueSize();
                    }
                }
                double deltaIdleTime = 0.0;
                if (!initial) {
                    deltaIdleTime = idleTime - entry.getIdleTime();
                }
                double deltaAnalysisTime = 0.0;
                if (analysisTime > 0.0) {
                    deltaAnalysisTime = analysisTime - entry.getAnalysisTime();
                }
                ServiceMetrics serviceMetrics = new ServiceMetrics();
                serviceMetrics.setCasMultiplier(entry.getServiceInfoMBeanProxy().isCASMultiplier());
                serviceMetrics.setServiceRemote(isRemote);
                serviceMetrics.setTopLevelService(topLevel);
                serviceMetrics.setTimestamp((double)uptime / 1000000.0);
                serviceMetrics.setIdleTime(deltaIdleTime);
                serviceMetrics.setServiceName(name.getKeyProperty("name"));
                serviceMetrics.setProcessCount(processCount - entry.getLastCASCount());
                serviceMetrics.setInputQueueDepth(inputQueueDepth);
                serviceMetrics.setReplyQueueDepth(replyQueueDepth);
                serviceMetrics.setProcessThreadCount(entry.getServicePerformanceMBeanProxy().getProcessThreadCount());
                serviceMetrics.setAnalysisTime(deltaAnalysisTime);
                serviceMetrics.setCmFreeCasInstanceCount(cmFreeCasInstanceCount);
                serviceMetrics.setSvcFreeCasInstanceCount(-1);
                if (getServiceCasPoolMBeanProxy != null) {
                    try {
                        serviceMetrics.setSvcFreeCasInstanceCount(getServiceCasPoolMBeanProxy.getAvailableInstances());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (entry.getServiceInfoMBeanProxy().isCASMultiplier() && isRemote && !topLevel) {
                    serviceMetrics.setShadowCasPoolWaitTime(shadowCasPoolWaitTime - entry.getTotalSCPWaitTime());
                    entry.setSCPWaitTime(shadowCasPoolWaitTime);
                } else {
                    serviceMetrics.setCasPoolWaitTime(casPoolWaitTime - entry.getTotalCPWaitTime());
                    entry.setCPWaitTime(casPoolWaitTime);
                }
                metricsList.add(serviceMetrics);
                entry.setIdleTime(idleTime);
                entry.incrementCASCount(processCount);
                entry.incrementAnalysisTime(analysisTime);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) continue;
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "collectStats", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
        if (metricsList.size() > 0) {
            metrics = new ServiceMetrics[metricsList.size()];
            metricsList.toArray(metrics);
        }
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        boolean initial = true;
        while (this.running) {
            long time2wait;
            long sampleEnd;
            long timeLost;
            long uptime;
            long sampleStart;
            block12: {
                sampleStart = System.nanoTime();
                uptime = sampleStart - this.startTime;
                try {
                    if (this.mbsc != null) {
                        this.mbsc.getMBeanCount();
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block12;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
            ServiceMetrics[] metrics = this.collectStats(initial, uptime);
            if (metrics != null) {
                initial = false;
                this.notifyListeners(uptime, metrics);
            }
            if (this.interval > (timeLost = (200000L + (sampleEnd = System.nanoTime()) - sampleStart) / 1000000L)) {
                time2wait = this.interval - timeLost;
            } else {
                long newInterval = this.interval * (1L + timeLost / this.interval);
                time2wait = newInterval - timeLost;
            }
            JmxMonitor jmxMonitor = this;
            synchronized (jmxMonitor) {
                try {
                    this.wait(time2wait);
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void doStop() {
        this.running = false;
    }

    public static void main(String[] args) throws Exception {
        JmxMonitor monitor = new JmxMonitor();
        if (System.getProperty("verbose") != null) {
            monitor.setVerbose();
        }
        long samplingFrequency = 1000L;
        if (args.length == 0 || args.length > 2) {
            JmxMonitor.printUsage();
            System.exit(-1);
        }
        if (args.length == 3) {
            samplingFrequency = Long.parseLong(args[2]);
        }
        JmxMonitor.echo("\nJMX Sampling Frequency:" + samplingFrequency);
        monitor.initialize(args[0], samplingFrequency);
        BasicUimaJmxMonitorListener listener = new BasicUimaJmxMonitorListener(monitor.getMaxServiceNameLength());
        monitor.addJmxMonitorListener((JmxMonitorListener)listener);
        Thread t = new Thread(monitor);
        t.start();
    }

    private static void printUsage() {
        System.out.println("Usage: \njava -cp %UIMA_HOME%/lib/*;%UIMA_HOME%/apache-activemq-5.4.1/* -Djava.util.logging.config.file=%UIMA_HOME%/config/MonitorLogger.properties    org.apache.uima.aae.jmx.monitor.JmxMonitor uri <frequency>\nuri - jmx server URI- required\nfrequency - how often the checkpoint is done. Default: 1000ms - optional");
    }

    private static void echo(String msg) {
        System.out.println(msg);
    }

    private static class StatEntry {
        ServicePerformanceMBean servicePerformanceMBeanProxy;
        ServiceInfoMBean serviceInfoMBeanProxy;
        QueueViewMBean inputQueueInfo;
        UimaVmQueueMBean vmInputQueueInfo;
        QueueViewMBean replyQueueInfo;
        UimaVmQueueMBean vmReplyQueueInfo;
        CasPoolManagementImplMBean casPoolMBeanProxy;
        CasPoolManagementImplMBean serviceCasPoolMBeanProxy;
        String name = "";
        boolean isVmQueue = true;
        double lastIdleTime = 0.0;
        double waitTimeOnCMGetNext = 0.0;
        long casProcessedCount = 0L;
        double cpWaitTime;
        double scpWaitTime;
        double analysisTime = 0.0;

        public StatEntry(ServicePerformanceMBean perfBean, ServiceInfoMBean infoBean) {
            this(perfBean, infoBean, null);
        }

        public StatEntry(ServicePerformanceMBean perfBean, ServiceInfoMBean infoBean, CasPoolManagementImplMBean casPoolMBeanProxy) {
            this.servicePerformanceMBeanProxy = perfBean;
            this.serviceCasPoolMBeanProxy = casPoolMBeanProxy;
            this.serviceInfoMBeanProxy = infoBean;
            if (!infoBean.getBrokerURL().startsWith("Embedded Broker")) {
                this.isVmQueue = false;
            }
        }

        public CasPoolManagementImplMBean getServiceCasPoolMBeanProxy() {
            return this.serviceCasPoolMBeanProxy;
        }

        public void setInputQueueInfo(QueueViewMBean queueView) {
            this.inputQueueInfo = queueView;
        }

        public void setInputQueueInfo(UimaVmQueueMBean queueView) {
            this.vmInputQueueInfo = queueView;
        }

        public QueueViewMBean getInputQueueInfo() {
            return this.inputQueueInfo;
        }

        public UimaVmQueueMBean getVmInputQueueInfo() {
            return this.vmInputQueueInfo;
        }

        public void setReplyQueueInfo(QueueViewMBean queueView) {
            this.replyQueueInfo = queueView;
        }

        public void setReplyQueueInfo(UimaVmQueueMBean queueView) {
            this.vmReplyQueueInfo = queueView;
        }

        public QueueViewMBean getReplyQueueInfo() {
            return this.replyQueueInfo;
        }

        public UimaVmQueueMBean getVmReplyQueueInfo() {
            return this.vmReplyQueueInfo;
        }

        public void setCasPoolMBean(CasPoolManagementImplMBean anMBean) {
            this.casPoolMBeanProxy = anMBean;
        }

        public CasPoolManagementImplMBean getCasPoolMBean() {
            return this.casPoolMBeanProxy;
        }

        public double getIdleTime() {
            return this.lastIdleTime;
        }

        public void incrementCASCount(long aCASCount) {
            this.casProcessedCount = aCASCount;
        }

        public long getLastCASCount() {
            return this.casProcessedCount;
        }

        public void setIdleTime(double lastIdleTime) {
            this.lastIdleTime = lastIdleTime;
        }

        public ServicePerformanceMBean getServicePerformanceMBeanProxy() {
            return this.servicePerformanceMBeanProxy;
        }

        public ServiceInfoMBean getServiceInfoMBeanProxy() {
            return this.serviceInfoMBeanProxy;
        }

        public void setName(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public void incrementWaitTimeOnCMGetNext(double aWaitTimeOnCMGetNext) {
            this.waitTimeOnCMGetNext = aWaitTimeOnCMGetNext;
        }

        public double getWaitTimeOnCMGetNext() {
            return this.waitTimeOnCMGetNext;
        }

        public double getTotalCPWaitTime() {
            return this.cpWaitTime;
        }

        public void setCPWaitTime(double aWaitTime) {
            this.cpWaitTime = aWaitTime;
        }

        public double getTotalSCPWaitTime() {
            return this.scpWaitTime;
        }

        public void setSCPWaitTime(double aWaitTime) {
            this.scpWaitTime = aWaitTime;
        }

        public double getAnalysisTime() {
            return this.analysisTime;
        }

        public void incrementAnalysisTime(double anAnalysisTime) {
            this.analysisTime = anAnalysisTime;
        }
    }
}

