/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.spring;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.util.Level;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContextResourceManager
extends ResourceManager_impl
implements ApplicationContextAware {
    private ApplicationContext context;
    private boolean autowireEnabled = false;

    public void initializeExternalResources(ResourceManagerConfiguration aConfiguration, String aQualifiedContextName, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        for (String name : BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)this.context)) {
            Object registration = this.mInternalResourceRegistrationMap.get(name);
            if (registration == null) {
                try {
                    ResourceManager_impl.ResourceRegistration reg = new ResourceManager_impl.ResourceRegistration(this.context.getBean(name), null, aQualifiedContextName);
                    this.mInternalResourceRegistrationMap.put(name, reg);
                    if (!this.isAutowireEnabled()) continue;
                    this.mResourceMap.put(aQualifiedContextName + name, this.context.getBean(name));
                    continue;
                }
                catch (Exception e1) {
                    throw new ResourceInitializationException((Throwable)e1);
                }
            }
            try {
                Object desc = SpringContextResourceManager.getFieldValue(registration, "description");
                if (desc == null) continue;
                String definingContext = (String)SpringContextResourceManager.getFieldValue(registration, "definingContext");
                if (aQualifiedContextName.startsWith(definingContext)) {
                    UIMAFramework.getLogger().logrb(Level.CONFIG, ResourceManager_impl.class.getName(), "initializeExternalResources", "org.apache.uima.impl.log_messages", "UIMA_overridden_resource__CONFIG", new Object[]{name, aQualifiedContextName, definingContext});
                    continue;
                }
                UIMAFramework.getLogger().logrb(Level.WARNING, ResourceManager_impl.class.getName(), "initializeExternalResources", "org.apache.uima.impl.log_messages", "UIMA_duplicate_resource_name__WARNING", new Object[]{name, definingContext, aQualifiedContextName});
            }
            catch (Exception e1) {
                throw new ResourceInitializationException((Throwable)e1);
            }
        }
        super.initializeExternalResources(aConfiguration, aQualifiedContextName, aAdditionalParams);
    }

    public void setApplicationContext(ApplicationContext aApplicationContext) throws BeansException {
        this.context = aApplicationContext;
    }

    private static <T> T newInstance(String aClassName, Object ... aArgs) throws ResourceInitializationException {
        Constructor<?> constr = null;
        try {
            Class<?> cl = Class.forName(aClassName);
            ArrayList<Class> types = new ArrayList<Class>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < aArgs.length; i += 2) {
                types.add((Class)aArgs[i]);
                values.add(aArgs[i + 1]);
            }
            constr = cl.getDeclaredConstructor(types.toArray(new Class[types.size()]));
            constr.setAccessible(true);
            Object obj = constr.newInstance(values.toArray(new Object[values.size()]));
            return (T)obj;
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            if (constr != null) {
                constr.setAccessible(false);
            }
        }
    }

    private static <T> T getFieldValue(Object aObject, String aFieldName) {
        return (T)PropertyAccessorFactory.forDirectFieldAccess((Object)aObject).getPropertyValue(aFieldName);
    }

    public void setAutowireEnabled(boolean aAutowireEnabled) {
        this.autowireEnabled = aAutowireEnabled;
    }

    public boolean isAutowireEnabled() {
        return this.autowireEnabled;
    }
}

