/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.maven.util;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.uima.fit.maven.util.ComponentType;

public final class Util {
    private Util() {
    }

    public static JavaSource parseSource(String aSourceFile, String aEncoding) throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.setEncoding(aEncoding);
        builder.addSource((Reader)new FileReader(aSourceFile));
        return builder.getSources()[0];
    }

    public static String getComponentDocumentation(JavaSource aAst, String aComponentTypeName) {
        for (JavaClass clazz : aAst.getClasses()) {
            if (!clazz.asType().getFullyQualifiedName().equals(aComponentTypeName)) continue;
            return Util.postProcessJavaDoc(clazz.getComment());
        }
        return null;
    }

    public static String postProcessJavaDoc(String aJavaDoc) {
        if (aJavaDoc == null) {
            return null;
        }
        return aJavaDoc.replaceAll("\\{@[^ ]+ ([^}]+)\\}", "$1");
    }

    public static String getParameterDocumentation(JavaSource aAst, String aParameterField, String aParameterNameConstantField) {
        JavaField field;
        String javadoc = null;
        JavaClass clazz = aAst.getClasses()[0];
        if (aParameterNameConstantField != null) {
            field = clazz.getFieldByName(aParameterNameConstantField);
            if (field == null) {
                throw new IllegalArgumentException("Parameter name constant [" + aParameterNameConstantField + "] not found in class [" + clazz.asType().getFullyQualifiedName() + "]");
            }
            javadoc = field.getComment();
        }
        if (javadoc == null) {
            field = clazz.getFieldByName(aParameterField);
            if (field == null) {
                throw new IllegalArgumentException("No parameter field [" + aParameterField + "] in class [" + clazz.asType().getFullyQualifiedName() + "]");
            }
            javadoc = field.getComment();
        }
        return Util.postProcessJavaDoc(javadoc);
    }

    public static String getClassName(MavenProject aProject, String aFile) {
        String base = aFile.substring(0, aFile.length() - 6);
        String clazzPath = base.substring(aProject.getBuild().getOutputDirectory().length() + 1);
        return clazzPath.replace(File.separator, ".");
    }

    public static URLClassLoader getClassloader(MavenProject aProject, Log aLog, String aIncludeScopeThreshold) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (Object object : aProject.getCompileClasspathElements()) {
                String path = (String)object;
                aLog.debug((CharSequence)("Classpath entry: " + object));
                urls.add(new File(path).toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to assemble classpath: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to resolve dependencies: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)((Object)e));
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter(aIncludeScopeThreshold);
        for (Artifact dep : aProject.getArtifacts()) {
            try {
                if (!filter.include(dep)) {
                    aLog.debug((CharSequence)("Not generating classpath entry for out-of-scope artifact: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + " (" + dep.getScope() + ")"));
                    continue;
                }
                if (dep.getFile() == null) {
                    aLog.debug((CharSequence)("Not generating classpath entry for unresolved artifact: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + " (" + dep.getScope() + ")"));
                    continue;
                }
                aLog.debug((CharSequence)("Classpath entry: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + " -> " + dep.getFile()));
                urls.add(dep.getFile().toURI().toURL());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable get dependency artifact location for " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Util.class.getClassLoader());
    }

    public static boolean isComponent(ClassLoader aClassLoader, Class aClass) throws ClassNotFoundException {
        return Util.getType(aClassLoader, aClass) != ComponentType.NONE;
    }

    public static ComponentType getType(ClassLoader aClassLoader, Class aClass) throws ClassNotFoundException {
        Class<?> iCR = aClassLoader.loadClass("org.apache.uima.collection.CollectionReader");
        Class<?> iAE = aClassLoader.loadClass("org.apache.uima.analysis_component.AnalysisComponent");
        if (iCR.isAssignableFrom(aClass)) {
            return ComponentType.COLLECTION_READER;
        }
        if (iAE.isAssignableFrom(aClass)) {
            return ComponentType.ANALYSIS_ENGINE;
        }
        return ComponentType.NONE;
    }
}

