/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.CasFactory;
import org.apache.uima.fit.validation.ValidationException;
import org.apache.uima.fit.validation.ValidationResult;
import org.apache.uima.fit.validation.ValidationSummary;
import org.apache.uima.fit.validation.Validator;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public final class ManagedCas
implements TestWatcher,
AfterTestExecutionCallback,
AfterAllCallback {
    private final ThreadLocal<CAS> casHolder;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<CAS> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Validator defaultValidator = new Validator.Builder().build();
    private Validator validator = null;

    public ManagedCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas();
                this.managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                return (CAS)Assertions.fail((String)"Unable to initialize managed CAS", (Throwable)e);
            }
        });
    }

    public ManagedCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas((TypeSystemDescription)aTypeSystemDescription);
                this.managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                return (CAS)Assertions.fail((String)"Unable to initialize managed CAS", (Throwable)e);
            }
        });
    }

    public CAS get() {
        return this.casHolder.get();
    }

    public void afterAll(ExtensionContext aContext) throws Exception {
        this.casHolder.remove();
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        try {
            this.managedCases.forEach(this::assertValid);
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.validator = null;
        for (CAS cas : this.managedCases) {
            try {
                cas.reset();
            }
            catch (Exception e) {
                LOG.error((Throwable)e, () -> "Unable to reset managed CAS");
            }
        }
    }

    public ManagedCas skipValidation() {
        this.validator = new Validator.Builder().withoutAutoDetectedChecks().build();
        return this;
    }

    public ManagedCas withoutDefaultValidator() {
        this.defaultValidator = new Validator.Builder().withoutAutoDetectedChecks().build();
        return this;
    }

    public ManagedCas withDefaultValidator(Validator aValidator) {
        this.defaultValidator = aValidator;
        return this;
    }

    public ManagedCas withValidator(Validator aValidator) {
        this.validator = aValidator;
        return this;
    }

    Validator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        return this.defaultValidator;
    }

    private void assertValid(CAS aCas) {
        Validator activeValidator = this.getValidator();
        if (this.getValidator() == null) {
            return;
        }
        try {
            ValidationSummary summary = activeValidator.check(aCas);
            String messageBuffer = summary.getResults().stream().filter(r -> r.getSeverity().isEquallyOrMoreSevereThan(ValidationResult.Severity.ERROR)).map(r -> String.format("[%s] %s", r.getSource(), r.getMessage())).collect(Collectors.joining("\n"));
            if (messageBuffer.length() > 0) {
                Assertions.fail((String)messageBuffer);
            }
        }
        catch (ValidationException e) {
            Assertions.fail((String)"Unable to validate CAS", (Throwable)e);
        }
    }

    static {
        try {
            CasCreationUtils.createCas();
        }
        catch (Exception e) {
            Assertions.fail((String)"Unable to initialize UIMA");
        }
    }
}

