/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.uima.ducc.common.ConvertSafely;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SynchronizedSimpleDateFormat;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.Constants;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.TimeWindow;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.DuccMachinesDataHelper;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.server.AlienTextFile;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.apache.uima.ducc.ws.utils.LinuxSignals;
import org.apache.uima.ducc.ws.utils.UrlHelper;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;
import org.apache.uima.ducc.ws.utils.alien.FileInfo;
import org.apache.uima.ducc.ws.utils.alien.OsProxy;

public class Helper {
    private static DuccLogger duccLogger = DuccLogger.getLogger(Helper.class);
    private static DuccId jobid = null;
    public static String notAvailable = "N/A";
    private static DecimalFormat sizeFormatter = new DecimalFormat("##0.00");
    private static SynchronizedSimpleDateFormat dateFormat = new SynchronizedSimpleDateFormat("HH:mm:ss");
    private static DecimalFormat formatter = new DecimalFormat("##0.0");
    public static String duccFilePager = "/file.pager.html";

    public static DuccWorkJob getJob(String jobNo) {
        DuccWorkJob job = null;
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        if (duccWorkMap.getJobKeySet().size() > 0) {
            Iterator iterator = null;
            for (DuccId jobId : duccWorkMap.getJobKeySet()) {
                String fid = "" + jobId.getFriendly();
                if (!jobNo.equals(fid)) continue;
                job = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                break;
            }
        }
        return job;
    }

    public static DuccWorkJob getManagedReservation(String reservationNo) {
        DuccWorkJob managedReservation = null;
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        if (duccWorkMap.getServiceKeySet().size() > 0) {
            Iterator iterator = null;
            for (DuccId jobId : duccWorkMap.getServiceKeySet()) {
                String fid = "" + jobId.getFriendly();
                if (!reservationNo.equals(fid)) continue;
                managedReservation = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                break;
            }
        }
        return managedReservation;
    }

    public static String getDuration(DuccId jobId, String millisV2, String millisV1, FormatHelper.Precision precision) {
        String methodName = "getDuration";
        String retVal = "";
        try {
            long d2 = Long.parseLong(millisV2);
            long d1 = Long.parseLong(millisV1);
            long diff = d2 - d1;
            if (diff < 0L) {
                diff = 0L;
            }
            retVal = FormatHelper.duration(diff, precision);
        }
        catch (Exception e) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", e});
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, null, new Object[]{"no worries", t});
        }
        return retVal;
    }

    public static SizeBytes getSummaryReserve() {
        String methodName = "getSummaryReserve";
        long sumReserve = 0L;
        DuccMachinesData instance = DuccMachinesData.getInstance();
        Map<MachineInfo, NodeId> machines = instance.getMachines();
        if (!machines.isEmpty()) {
            for (Map.Entry<MachineInfo, NodeId> entry : machines.entrySet()) {
                MachineInfo machineInfo = entry.getKey();
                if (!DuccMachinesDataHelper.isUp(machineInfo)) continue;
                try {
                    sumReserve += ConvertSafely.String2Long((String)machineInfo.getMemReserve());
                }
                catch (Exception e) {
                    duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
                }
            }
        }
        SizeBytes retVal = new SizeBytes(SizeBytes.Type.GBytes, sumReserve);
        return retVal;
    }

    public static Map<String, FileInfo> getFileInfoMap(EffectiveUser eu, String directory) {
        String location = "";
        TreeMap<String, FileInfo> map = new TreeMap();
        try {
            map = OsProxy.getFilesInDirectory(eu, directory);
        }
        catch (Throwable t) {
            duccLogger.error(location, jobid, t, new Object[0]);
        }
        return map;
    }

    public static String getLogFileDirectory(IDuccWorkJob job) {
        String retVal = "";
        if (job != null) {
            retVal = job.getLogDirectory();
        }
        return retVal;
    }

    public static String getLogFileName(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        String retVal = "";
        if (process != null) {
            switch (type) {
                case UIMA: {
                    retVal = job.getDuccId().getFriendly() + "-" + LogType.UIMA.name() + "-" + process.getNodeIdentity().getName() + "-" + process.getPID() + ".log";
                    break;
                }
                case MR: {
                    retVal = job.getDuccId().getFriendly() + "-" + LogType.POP.name() + "-" + process.getNodeIdentity().getName() + "-" + process.getPID() + ".log";
                    break;
                }
                case SPU: {
                    retVal = job.getDuccId().getFriendly() + "-" + LogType.UIMA.name() + "-" + process.getNodeIdentity().getName() + "-" + process.getPID() + ".log";
                    break;
                }
                case SPC: {
                    retVal = job.getDuccId().getFriendly() + "-" + LogType.POP.name() + "-" + process.getNodeIdentity().getName() + "-" + process.getPID() + ".log";
                    break;
                }
                case JD: {
                    retVal = "jd.out.log";
                    String node = process.getNodeIdentity().getName();
                    String pid = process.getPID();
                    retVal = job.getDuccId() + "-JD-" + node + "-" + pid + ".log";
                }
            }
        }
        return retVal;
    }

    public static String getLogFileSize(IDuccWorkJob job, IDuccProcess process, String log_file, Map<String, FileInfo> fileInfoMap) {
        String location = "getLogFileSize";
        String retVal = "0";
        try {
            String dir_name = job.getUserLogDir();
            String file_name = dir_name + log_file;
            long size = Helper.getFileSize(file_name, fileInfoMap);
            retVal = Helper.normalize(size);
        }
        catch (Exception e) {
            duccLogger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public static String normalize(long fileSize) {
        String location = "normalize";
        String retVal = "0";
        try {
            double size = fileSize;
            retVal = sizeFormatter.format(size /= (double)Constants.MB);
        }
        catch (Exception e) {
            duccLogger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public static long getFileSize(String filename, Map<String, FileInfo> fileInfoMap) {
        FileInfo fileInfo;
        long retVal = 0L;
        if (filename != null && fileInfoMap != null && (fileInfo = fileInfoMap.get(filename)) != null) {
            retVal = fileInfo.length;
        }
        return retVal;
    }

    public static String getHostname(IDuccWorkJob job, IDuccProcess process) {
        String name;
        NodeIdentity ni;
        StringBuffer sb = new StringBuffer();
        if (process != null && (ni = process.getNodeIdentity()) != null && (name = ni.getName()) != null) {
            sb.append(name);
        }
        return sb.toString();
    }

    public static String getPid(IDuccWorkJob job, IDuccProcess process) {
        String pid;
        StringBuffer sb = new StringBuffer();
        if (process != null && (pid = process.getPID()) != null) {
            sb.append(pid);
        }
        return sb.toString();
    }

    public static String getSchedulerState(IDuccWorkJob job, IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            sb.append(process.getResourceState());
        }
        return sb.toString();
    }

    private static String getRmReason(IDuccWorkJob job) {
        StringBuffer sb = new StringBuffer();
        String rmReason = job.getRmReason();
        if (rmReason != null) {
            sb.append("<span>");
            sb.append(rmReason);
            sb.append("</span>");
        }
        return sb.toString();
    }

    private static String getProcessReason(IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            block0 : switch (process.getProcessState()) {
                case Starting: 
                case Started: 
                case Initializing: 
                case Running: {
                    break;
                }
                default: {
                    IResourceState.ProcessDeallocationType deallocationType = process.getProcessDeallocationType();
                    switch (deallocationType) {
                        case Undefined: {
                            break block0;
                        }
                    }
                    sb.append(process.getProcessDeallocationType());
                }
            }
        }
        return sb.toString();
    }

    public static String getSchedulerReason(IDuccWorkJob job, IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        if (job.isOperational()) {
            switch (job.getJobState()) {
                case WaitingForResources: {
                    sb.append(Helper.getRmReason(job));
                    break;
                }
                default: {
                    sb.append(Helper.getProcessReason(process));
                    break;
                }
            }
        } else {
            sb.append(Helper.getProcessReason(process));
        }
        return sb.toString();
    }

    public static String getAgentState(IDuccWorkJob job, IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IProcessState.ProcessState ps = process.getProcessState();
            switch (ps) {
                case Undefined: {
                    break;
                }
                default: {
                    sb.append(ps);
                }
            }
        }
        return sb.toString();
    }

    public static String getAgentReason(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        if (process != null) {
            retVal = process.getReasonForStoppingProcess();
        }
        return retVal;
    }

    public static String getAgentReasonExtended(IDuccWorkJob job, IDuccProcess process) {
        String retVal = null;
        if (process != null) {
            retVal = process.getExtendedReasonForStoppingProcess();
        }
        return retVal;
    }

    public static String getExit(IDuccWorkJob job, IDuccProcess process) {
        boolean suppressExitCode;
        StringBuffer sb = new StringBuffer();
        if (process != null && !(suppressExitCode = false)) {
            switch (process.getProcessState()) {
                case LaunchFailed: 
                case Stopped: 
                case Failed: 
                case FailedInitialization: 
                case InitializationTimeout: 
                case Killed: {
                    int code = process.getProcessExitCode();
                    if (LinuxSignals.isSignal(code)) {
                        LinuxSignals.Signal signal = LinuxSignals.lookup(code);
                        if (signal != null) {
                            sb.append(signal.name() + "(" + signal.number() + ")");
                            break;
                        }
                        sb.append("UnknownSignal(" + LinuxSignals.getValue(code) + ")");
                        break;
                    }
                    sb.append("ExitCode=" + code);
                    break;
                }
            }
        }
        return sb.toString();
    }

    public static String getTimeInit(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        String location = "getTimeInit";
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (type) {
                case MR: {
                    break;
                }
                default: {
                    String initTime = "00";
                    try {
                        TimeWindow t = (TimeWindow)process.getTimeWindowInit();
                        if (t != null) {
                            long now = System.currentTimeMillis();
                            String tS = t.getStart("" + now);
                            String tE = t.getEnd("" + now);
                            initTime = Helper.getDuration(jobid, tE, tS, FormatHelper.Precision.Whole);
                        }
                    }
                    catch (Exception e) {
                        duccLogger.trace(location, jobid, new Object[]{"no worries", e});
                    }
                    catch (Throwable t) {
                        duccLogger.trace(location, jobid, new Object[]{"no worries", t});
                    }
                    sb.append(initTime);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isTimeInitEstimated(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        String location = "isTimeInitEstimated";
        boolean retVal = false;
        if (process != null) {
            switch (type) {
                case MR: {
                    break;
                }
                default: {
                    try {
                        TimeWindow t = (TimeWindow)process.getTimeWindowInit();
                        if (t == null || !t.isEstimated()) break;
                        retVal = true;
                        break;
                    }
                    catch (Exception e) {
                        duccLogger.trace(location, jobid, new Object[]{"no worries", e});
                        break;
                    }
                    catch (Throwable t) {
                        duccLogger.trace(location, jobid, new Object[]{"no worries", t});
                    }
                }
            }
        }
        return retVal;
    }

    public static long getTimeStart(IDuccProcess process) {
        String location = "getTimeStart";
        long retVal = -1L;
        if (process != null) {
            try {
                TimeWindow t = (TimeWindow)process.getTimeWindowRun();
                if (t != null) {
                    retVal = t.getStartLong();
                }
            }
            catch (Exception e) {
                duccLogger.trace(location, jobid, new Object[]{"no worries", e});
            }
        }
        return retVal;
    }

    public static String getTimeRun(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        String location = "getTimeRun";
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            String runTime = "00";
            boolean useTimeRun = true;
            switch (type) {
                case SPC: {
                    break;
                }
                case SPU: {
                    break;
                }
                case MR: {
                    break;
                }
                case JD: {
                    break;
                }
                case UIMA: {
                    if (process.isAssignedWork()) break;
                    useTimeRun = false;
                    break;
                }
            }
            if (useTimeRun) {
                try {
                    TimeWindow t = (TimeWindow)process.getTimeWindowRun();
                    if (t != null) {
                        long now = System.currentTimeMillis();
                        String tS = t.getStart("" + now);
                        String tE = t.getEnd("" + now);
                        runTime = Helper.getDuration(jobid, tE, tS, FormatHelper.Precision.Whole);
                    }
                }
                catch (Exception e) {
                    duccLogger.trace(location, jobid, new Object[]{"no worries", e});
                }
                catch (Throwable t) {
                    duccLogger.trace(location, jobid, new Object[]{"no worries", t});
                }
            }
            sb.append(runTime);
        }
        return sb.toString();
    }

    public static boolean isTimeRunEstimated(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        String location = "isTimeRunEstimated";
        boolean retVal = false;
        if (process != null) {
            boolean useTimeRun = true;
            switch (type) {
                case SPC: {
                    break;
                }
                case SPU: {
                    break;
                }
                case MR: {
                    break;
                }
                case JD: {
                    break;
                }
                case UIMA: {
                    if (process.isAssignedWork()) break;
                    useTimeRun = false;
                    break;
                }
            }
            if (useTimeRun) {
                try {
                    TimeWindow t = (TimeWindow)process.getTimeWindowRun();
                    if (t != null && t.isEstimated()) {
                        retVal = true;
                    }
                }
                catch (Exception e) {
                    duccLogger.trace(location, jobid, new Object[]{"no worries", e});
                }
                catch (Throwable t) {
                    duccLogger.trace(location, jobid, new Object[]{"no worries", t});
                }
            }
        }
        return retVal;
    }

    private static String chomp(String leading, String whole) {
        String retVal = whole;
        while (retVal.length() > leading.length() && retVal.startsWith(leading)) {
            retVal = retVal.replaceFirst(leading, "");
        }
        return retVal;
    }

    public static String getTimeGC(IDuccWorkJob job, IDuccProcess process, AllocationType type) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (type) {
                case MR: {
                    break;
                }
                default: {
                    long timeGC = 0L;
                    try {
                        timeGC = process.getGarbageCollectionStats().getCollectionTime();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (timeGC < 0L) {
                        sb.append("<span class=\"health_black\">");
                        sb.append(notAvailable);
                        sb.append("</span>");
                        break;
                    }
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    String displayGC = dateFormat.format(new Date(timeGC));
                    displayGC = Helper.chomp("00:", displayGC);
                    sb.append(displayGC);
                }
            }
        }
        return sb.toString();
    }

    public static String getPgIn(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (sType) {
                default: 
            }
            long faults = 0L;
            try {
                faults = process.getMajorFaults();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (faults < 0L) {
                sb.append("<span class=\"health_black\">");
                sb.append(notAvailable);
                sb.append("</span>");
            } else {
                double swap = process.getSwapUsageMax();
                if (swap * (double)faults > 0.0) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_black\">");
                }
                sb.append(faults);
                sb.append("</span>");
            }
        }
        return sb.toString();
    }

    public static boolean isSwapping(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        boolean retVal = false;
        if (process != null) {
            switch (sType) {
                default: 
            }
            if (!process.isActive()) {
                double swap = process.getSwapUsageMax();
                if (swap > 0.0) {
                    retVal = true;
                }
            } else {
                double swap = process.getSwapUsage();
                if (swap > 0.0) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    public static String getSwap(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (sType) {
                default: 
            }
            if (!process.isActive()) {
                double swap = process.getSwapUsageMax();
                if (swap < 0.0) {
                    sb.append(notAvailable);
                } else {
                    String displaySwap = formatter.format(swap /= (double)Constants.GB);
                    sb.append(displaySwap);
                }
            } else {
                double swap = process.getSwapUsage();
                if (swap < 0.0) {
                    sb.append(notAvailable);
                } else {
                    String displaySwap = formatter.format(swap /= (double)Constants.GB);
                    sb.append(displaySwap);
                }
            }
        }
        return sb.toString();
    }

    public static String getSwapMax(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        String retVal = null;
        if (process != null) {
            double swap;
            switch (sType) {
                default: 
            }
            if (process.isActive() && !((swap = (double)process.getSwapUsage()) < 0.0)) {
                String displaySwapMax;
                double swapMax = process.getSwapUsageMax();
                retVal = displaySwapMax = formatter.format(swapMax /= (double)Constants.GB);
            }
        }
        return retVal;
    }

    private static String formatPctCpu(double pctCpu) {
        String retVal = "";
        retVal = pctCpu < 0.0 ? "N/A" : formatter.format(pctCpu);
        return retVal;
    }

    public static String getPctCpuOverall(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null && process.getDataVersion() >= 1L) {
            switch (sType) {
                default: 
            }
            double pctCPU_overall = process.getCpuTime();
            String fmtCPU_overall = Helper.formatPctCpu(pctCPU_overall);
            sb.append(fmtCPU_overall);
        }
        return sb.toString();
    }

    public static String getPctCpuCurrent(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null && process.getDataVersion() >= 1L) {
            switch (sType) {
                default: 
            }
            double pctCPU_current = process.getCurrentCPU();
            String fmtCPU_current = Helper.formatPctCpu(pctCPU_current);
            sb.append(fmtCPU_current);
        }
        return sb.toString();
    }

    public static String getRss(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (sType) {
                default: 
            }
            if (process.isComplete()) {
                double rss = process.getResidentMemoryMax();
                if (rss < 0.0) {
                    sb.append(notAvailable);
                } else {
                    String displayRss = formatter.format(rss /= (double)Constants.GB);
                    sb.append(displayRss);
                }
            } else {
                double rss = process.getResidentMemory();
                if (rss < 0.0) {
                    sb.append(notAvailable);
                } else {
                    String displayRss = formatter.format(rss /= (double)Constants.GB);
                    sb.append(displayRss);
                }
            }
        }
        return sb.toString();
    }

    public static String getRssMax(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        String retVal = null;
        if (process != null) {
            double rss;
            switch (sType) {
                default: 
            }
            if (!process.isComplete() && !((rss = (double)process.getResidentMemory()) < 0.0)) {
                String displayRssMax;
                double rssMax = process.getResidentMemoryMax();
                retVal = displayRssMax = formatter.format(rssMax /= (double)Constants.GB);
            }
        }
        return retVal;
    }

    public static String getWiTimeAvg(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    case JD: {
                        if (pwi == null) break;
                        String value = "" + job.getWiMillisAvg() / 1000L;
                        sb.append(value);
                        break;
                    }
                    default: {
                        if (pwi == null) break;
                        String value = "" + pwi.getSecsAvg();
                        sb.append(value);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String getWiTimeMax(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getSecsMax();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiTimeMin(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getSecsMin();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiDone(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getCountDone();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiError(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getCountError();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiDispatch(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getCountDispatch();
                    if (job.isCompleted()) {
                        value = "0";
                    }
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiRetry(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getCountRetry();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getWiPreempt(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            IDuccProcessWorkItems pwi = process.getProcessWorkItems();
            if (sType != null) {
                switch (sType) {
                    default: 
                }
                if (pwi != null) {
                    String value = "" + pwi.getCountPreempt();
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public static String getJConsoleUrl(IDuccWorkJob job, IDuccProcess process, AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (process.getProcessState()) {
                case Initializing: 
                case Running: {
                    String jmxUrl = process.getProcessJmxUrl();
                    if (jmxUrl == null) break;
                    sb.append(jmxUrl);
                    break;
                }
            }
        }
        return sb.toString();
    }

    public static String getFilePagerUrl(EffectiveUser eu, String file_name) {
        AlienTextFile atf = new AlienTextFile(eu, file_name);
        int pages = atf.getPageCount();
        return Helper.getFilePagerUrl(file_name, pages);
    }

    public static String getFilePagerUrl(String file_name, int pages) {
        String encoded_file_name = UrlHelper.encode(file_name);
        String parms = "?fname=" + encoded_file_name + "&pages=" + pages;
        String url = duccFilePager + parms;
        return url;
    }

    public static enum LogType {
        POP,
        UIMA;

    }

    public static enum AllocationType {
        JD,
        MR,
        SPC,
        SPU,
        UIMA;

    }
}

