/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.config;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.ObjectMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.util.ByteSequence;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.config.DuccBlastGuardPredicate;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.ws.DuccBoot;
import org.apache.uima.ducc.ws.WebServerComponent;
import org.apache.uima.ducc.ws.event.WebServerEventListener;
import org.apache.uima.ducc.ws.self.message.WebServerStateProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class WebServerConfiguration {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration webServerTransport;
    private DuccLogger duccLogger = DuccLogger.getLogger(WebServerConfiguration.class);
    private DuccId jobid = null;
    private AtomicBoolean singleton = new AtomicBoolean(false);

    public WebServerEventListener webServerDelegateListener(WebServerComponent ws) {
        WebServerEventListener wsel = new WebServerEventListener(ws);
        return wsel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final WebServerEventListener delegate) {
        return new RouteBuilder(){
            Processor p;
            {
                this.p = new AccessJmsBody();
            }

            public void configure() {
                ((RouteDefinition)this.from(endpoint).process(this.p)).bean((Object)delegate);
            }
        };
    }

    private RouteBuilder routeBuilderForWebServerStatePost(final String targetEndpointToReceiveWebServerStateUpdate, final int statePublishRate) throws Exception {
        final WebServerStateProcessor wssp = new WebServerStateProcessor();
        return new RouteBuilder(){

            public void configure() {
                DuccBlastGuardPredicate blastFilter = new DuccBlastGuardPredicate(WebServerConfiguration.this.duccLogger);
                ((ExpressionNode)this.from("timer:webserverStateDumpTimer?fixedRate=true&period=" + statePublishRate).filter((Predicate)blastFilter).process((Processor)wssp)).to(targetEndpointToReceiveWebServerStateUpdate);
            }
        };
    }

    @Bean
    public WebServerComponent webServer() throws Exception {
        String methodName = "webServer";
        WebServerComponent ws = null;
        try {
            if (this.singleton.getAndSet(true)) {
                try {
                    throw new RuntimeException("singleton already present!");
                }
                catch (RuntimeException e) {
                    this.duccLogger.error(methodName, this.jobid, (Throwable)e, new Object[0]);
                    throw e;
                }
            }
            ws = new WebServerComponent(this.common.camelContext(), this.common);
            ws.setStateChangeEndpoint(this.common.daemonsStateChangeEndpoint);
            DuccBoot.boot(this.common);
            WebServerEventListener delegateListener = this.webServerDelegateListener(ws);
            DuccEventDispatcher eventDispatcher = this.webServerTransport.duccEventDispatcher(this.common.orchestratorStateUpdateEndpoint, ws.getContext());
            ws.setDuccEventDispatcher(eventDispatcher);
            delegateListener.setDuccEventDispatcher(eventDispatcher);
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.orchestratorStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.nodeMetricsEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.rmStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.smStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.pmStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.agentRequestEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.wsStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForWebServerStatePost(this.common.wsStateUpdateEndpoint, Integer.parseInt(this.common.wsStatePublishRate)));
            String dbEndpoint = this.common.dbComponentStateUpdateEndpoint;
            if (dbEndpoint != null) {
                ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.dbComponentStateUpdateEndpoint, delegateListener));
            } else {
                this.duccLogger.warn(methodName, this.jobid, new Object[]{"db endpoint not configured"});
            }
        }
        catch (Throwable t) {
            this.duccLogger.error(methodName, this.jobid, t, new Object[0]);
        }
        return ws;
    }

    public class AccessJmsBody
    implements Processor {
        int msglen = 0;
        String objectName = "unknown";

        public void process(Exchange exchange) throws Exception {
            String location = "AccessJmsBody:process";
            try {
                ActiveMQMessage amqMessage;
                JmsMessage msg;
                Message o = exchange.getIn();
                if (o instanceof JmsMessage && (o = (msg = (JmsMessage)o).getJmsMessage()) instanceof ActiveMQMessage && (amqMessage = (ActiveMQMessage)o) instanceof ObjectMessage) {
                    Serializable body = ((ObjectMessage)amqMessage).getObject();
                    ByteSequence bs = amqMessage.getContent();
                    this.msglen = bs.getLength();
                    this.objectName = body.getClass().getName();
                }
                Long pubSize = new Long(this.msglen);
                exchange.getIn().setHeader("pubSize", (Object)pubSize);
                String text = "Message length is " + this.msglen + " for " + this.objectName;
                WebServerConfiguration.this.duccLogger.debug(location, WebServerConfiguration.this.jobid, new Object[]{text});
            }
            catch (Throwable t) {
                WebServerConfiguration.this.duccLogger.error(location, WebServerConfiguration.this.jobid, t, new Object[0]);
            }
        }
    }
}

