/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.ws.registry.IServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.server.DuccCookies;

public class DuccWebUtil {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccWebUtil.class.getName());
    private static String key_user = IServicesRegistry.user;
    private static String key_state = IServicesRegistry.service_state;
    private static String value_NotAvailable = "NotAvailable";

    public static final void noCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setDateHeader("Expires", 0L);
    }

    private static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, String user) {
        DuccCookies.FilterUsersStyle filterUsersStyle = DuccCookies.getFilterUsersStyle(request);
        boolean retVal = false;
        if (maxRecords == 0 || counter < maxRecords) {
            if (users.isEmpty()) {
                retVal = true;
            } else {
                switch (filterUsersStyle) {
                    case IncludePlusActive: 
                    case Include: {
                        if (!users.contains(user)) break;
                        retVal = true;
                        break;
                    }
                    case ExcludePlusActive: 
                    case Exclude: {
                        if (users.contains(user)) break;
                        retVal = true;
                    }
                }
            }
        }
        return retVal;
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, IDuccWork dw) {
        String user = dw.getStandardInfo().getUser().trim();
        return DuccWebUtil.isListable(request, users, maxRecords, counter, user);
    }

    public static boolean isAvailable(Properties propertiesMeta) {
        boolean retVal = true;
        try {
            String state = propertiesMeta.getProperty(key_state).trim();
            if (state.equalsIgnoreCase(value_NotAvailable)) {
                retVal = false;
            }
        }
        catch (Exception e) {
            retVal = false;
        }
        return retVal;
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, IServiceAdapter serviceAdapter) {
        Properties propertiesMeta = serviceAdapter.getMeta();
        return DuccWebUtil.isListable(request, users, maxRecords, counter, propertiesMeta);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, ServicesRegistryMapPayload entry) {
        Properties propertiesMeta = entry.get("meta");
        return DuccWebUtil.isListable(request, users, maxRecords, counter, propertiesMeta);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, StateServicesSet entry) {
        DuccProperties propertiesMeta = entry.get("meta");
        return DuccWebUtil.isListable(request, users, maxRecords, counter, (Properties)propertiesMeta);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, Properties propertiesMeta) {
        String user = propertiesMeta.getProperty(key_user);
        return DuccWebUtil.isListable(request, users, maxRecords, counter, user);
    }

    public static ArrayList<String> getRemotePids(DuccId duccId, Map<DuccId, IDuccProcess> map) {
        String location = "getRemotePids";
        ArrayList<String> list = new ArrayList<String>();
        if (map != null) {
            if (map.size() > 0) {
                for (Map.Entry<DuccId, IDuccProcess> entry : map.entrySet()) {
                    String pid;
                    IDuccProcess proc = entry.getValue();
                    NodeIdentity nodeIdentity = proc.getNodeIdentity();
                    String host = nodeIdentity.getName();
                    if (host == null || (pid = proc.getPID()) == null) continue;
                    String remotePid = pid + "@" + host;
                    list.add(remotePid);
                    duccLogger.debug(location, duccId, new Object[]{remotePid});
                }
            } else {
                duccLogger.debug(location, duccId, new Object[]{"map is empty"});
            }
        } else {
            duccLogger.debug(location, duccId, new Object[]{"map is null"});
        }
        return list;
    }
}

