/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccWebProperties {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccWebProperties.class.getName());
    private static DuccId jobid = null;
    private static String dir_home = Utils.findDuccHome();
    private static String dir_resources = "resources";
    private static String ducc_properties_filename = dir_home + File.separator + dir_resources + File.separator + "ducc.properties";
    private static long default_ducc_ws_monitored_daemon_down_millis_expiry = 120000L;

    public static Properties get() {
        Properties currentProperties = new Properties();
        try {
            File file = new File(ducc_properties_filename);
            FileInputStream fis = new FileInputStream(file);
            currentProperties.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return currentProperties;
    }

    public static String getProperty(String key, String defaultValue) {
        String value = defaultValue;
        Properties currentProperties = DuccWebProperties.get();
        if (currentProperties != null && currentProperties.containsKey(key)) {
            value = currentProperties.getProperty(key).trim();
        }
        return value;
    }

    public static String getProperty(String key) {
        return DuccWebProperties.getProperty(key, null);
    }

    public static long getPropertyLong(String key, long defaultValue) {
        String location = "getPropertyLong";
        long retVal = defaultValue;
        try {
            String pval = DuccWebProperties.getProperty(key);
            if (pval != null) {
                retVal = Long.parseLong(pval);
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public static long get_ducc_ws_monitored_daemon_down_millis_expiry() {
        String key = "ducc.ws.monitored.daemon.down.millis.expiry";
        long dval = default_ducc_ws_monitored_daemon_down_millis_expiry;
        long retVal = DuccWebProperties.getPropertyLong(key, dval);
        return retVal;
    }
}

