/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.ConvertSafely;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.ComponentHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdReservation;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.JdReservationBean;
import org.apache.uima.ducc.ws.Distiller;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.DuccMachinesDataHelper;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.helper.BrokerHelper;
import org.apache.uima.ducc.ws.helper.DatabaseHelper;
import org.apache.uima.ducc.ws.registry.ServiceInterpreter;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.ServicesHelper;
import org.apache.uima.ducc.ws.registry.sort.ServicesSortCache;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccHandlerUtils;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebServerHelper;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.server.IWebMonitor;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.eclipse.jetty.server.Request;

public class DuccHandlerClassic
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerClassic.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    private static BrokerHelper brokerHelper = BrokerHelper.getInstance();
    private static DatabaseHelper databaseHelper = DatabaseHelper.getInstance();
    public final String classicJobs = "/ducc-servlet/classic-jobs-data";
    public final String classicReservations = "/ducc-servlet/classic-reservations-data";
    public final String classicServices = "/ducc-servlet/classic-services-data";
    public final String classicSystemClasses = "/ducc-servlet/classic-system-classes-data";
    public final String classicSystemDaemons = "/ducc-servlet/classic-system-daemons-data";
    public final String classicSystemMachines = "/ducc-servlet/classic-system-machines-data";
    public final String classicSystemBroker = "/ducc-servlet/classic-system-broker-data";
    private static DecimalFormat formatter1 = new DecimalFormat("##0.0");
    private static DecimalFormat formatter3 = new DecimalFormat("##0.000");

    public DuccHandlerClassic(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    public String getFileName() {
        return this.dir_home + File.separator + this.dir_resources + File.separator + this.getDuccWebServer().getClassDefinitionFile();
    }

    private void buildJobsListEntry(HttpServletRequest request, StringBuffer sb, DuccId duccId, IDuccWorkJob job, DuccData duccData, long now, ServicesRegistry servicesRegistry) {
        String decoratedDuration;
        String duration;
        String id = this.normalize(duccId);
        sb.append("<td valign=\"bottom\" class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !job.isFinished()) {
            sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_job(" + id + ")\" value=\"Terminate\" " + this.getDisabledWithHover(request, (IDuccWork)job) + "/>");
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        sb.append("<a href=\"job.details.html?id=" + id + "\">" + id + "</a>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, job.getDuccId(), job.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        if (job.isCompleted()) {
            duration = this.getDuration(request, (IDuccWork)job, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span>");
            sb.append(decoratedDuration);
            sb.append("</span>");
        } else {
            duration = this.getDuration(request, (IDuccWork)job, now, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span class=\"health_green\">");
            sb.append(decoratedDuration);
            sb.append("</span>");
            String projection = this.getProjection(request, job, FormatHelper.Precision.Whole);
            sb.append(projection);
        }
        sb.append("</td>");
        String title = "";
        String submitter = job.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\" ";
        }
        sb.append("<td " + title + "valign=\"bottom\">");
        sb.append(job.getStandardInfo().getUser());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        String schedulingClass = this.stringNormalize(job.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"));
        long debugPortDriver = job.getDebugPortDriver();
        long debugPortProcess = job.getDebugPortProcess();
        title = "debug ports:";
        if (debugPortDriver >= 0L) {
            title = title + " driver=" + debugPortDriver;
        }
        if (debugPortProcess >= 0L) {
            title = title + " process=" + debugPortProcess;
        }
        switch (DuccCookies.getDisplayStyle(request)) {
            default: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\">DEBUG</div>");
                sb.append("</span>");
                break;
            }
            case Visual: {
                String key = "bug";
                String bugFile = DuccWebServerHelper.getImageFileName(key);
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                if (bugFile != null) {
                    sb.append("<div title=\"" + title + "\"><img src=\"" + bugFile + "\"></div>");
                }
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        if (duccData.isLive(duccId)) {
            if (job.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
        } else {
            sb.append("<span class=\"historic_state\">");
        }
        sb.append(job.getStateObject().toString());
        if (duccData.isLive(duccId)) {
            sb.append("</span>");
        }
        sb.append("</td>");
        String reason = this.getReason(job, IWebMonitor.MonitorType.Job).toString();
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(reason);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.evaluateServices(job, servicesRegistry));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        if (duccData.isLive(duccId)) {
            sb.append(job.getProcessMap().getAliveProcessCount());
        } else {
            sb.append("0");
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        long initFails = job.getProcessInitFailureCount();
        if (initFails > 0L) {
            if (job.getSchedulingInfo().getLongProcessesMax() < 0L) {
                DuccCookies.DisplayStyle style = DuccCookies.getDisplayStyle(request);
                String key = "cap.small";
                String capFile = DuccWebServerHelper.getImageFileName(key);
                switch (style) {
                    case Visual: {
                        if (capFile != null) break;
                        style = DuccCookies.DisplayStyle.Textual;
                        break;
                    }
                }
                switch (style) {
                    default: {
                        sb.append(this.buildInitializeFailuresLink(job));
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<sup>");
                        sb.append("<small>");
                        sb.append("capped");
                        sb.append("</small>");
                        sb.append("<sup>");
                        sb.append("</span>");
                        sb.append("<br>");
                        break;
                    }
                    case Visual: {
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<img src=\"" + capFile + "\">");
                        sb.append("</span>");
                        sb.append("<br>");
                        sb.append(this.buildInitializeFailuresLink(job));
                        break;
                    }
                }
            } else {
                sb.append(this.buildInitializeFailuresLink(job));
            }
        } else {
            sb.append("" + initFails);
        }
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.buildRuntimeFailuresLink(job));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        long faults = 0L;
        try {
            faults = job.getPgInCount();
        }
        catch (Exception capFile) {
            // empty catch block
        }
        int ifaults = (int)faults;
        switch (ifaults) {
            case -3: {
                sb.append("<span title=\"incomplete\" class=\"health_red\">");
                sb.append("INC");
                break;
            }
            case -2: {
                sb.append("<span title=\"incomplete\" class=\"health_black\">");
                sb.append("INC");
                break;
            }
            case -1: {
                sb.append("<span title=\"not available\" class=\"health_black\">");
                sb.append("N/A");
                break;
            }
            default: {
                double swapping = job.getSwapUsageGbMax();
                if (swapping * (double)faults > 0.0) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_black\">");
                }
                sb.append(faults);
            }
        }
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        String swapSizeDisplay = "";
        String swapSizeHover = "";
        title = "";
        double swap = 0.0;
        swap = job.isCompleted() ? job.getSwapUsageGbMax() : job.getSwapUsageGb();
        int iswap = (int)swap;
        switch (iswap) {
            case -3: {
                sb.append("<span title=\"incomplete\" class=\"health_red\">");
                sb.append("INC");
                break;
            }
            case -2: {
                sb.append("<span title=\"incomplete\" class=\"health_black\">");
                sb.append("INC");
                break;
            }
            case -1: {
                sb.append("<span title=\"not available\" class=\"health_black\">");
                sb.append("N/A");
                break;
            }
            default: {
                double swapBytes = swap * DuccHandlerUtils.GB;
                swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                title = "title=\"" + swapSizeHover + "\"";
                if (swapBytes > 0.0) {
                    sb.append("<span " + title + " " + "class=\"health_red\"" + ">");
                } else {
                    sb.append("<span " + title + " " + "class=\"health_black\"" + ">");
                }
                sb.append(swapSizeDisplay);
            }
        }
        sb.append("</span>");
        sb.append("</td>");
        IDuccSchedulingInfo si = job.getSchedulingInfo();
        SizeBytes sizeBytes = new SizeBytes(SizeBytes.Type.Bytes, si.getMemorySizeAllocatedInBytes());
        String actual = this.getProcessMemorySize(duccId, sizeBytes);
        sizeBytes = new SizeBytes(si.getMemoryUnits().name(), Long.parseLong(si.getMemorySizeRequested()));
        String requested = this.getProcessMemorySize(duccId, sizeBytes);
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append("<span title=\"requested: " + requested + "\">");
        sb.append(actual);
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsTotal());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        IDuccPerWorkItemStatistics perWorkItemStatistics = job.getSchedulingInfo().getPerWorkItemStatistics();
        String done = job.getSchedulingInfo().getWorkItemsCompleted();
        if (perWorkItemStatistics != null) {
            double max = (double)Math.round(perWorkItemStatistics.getMax() / 100.0) / 10.0;
            double min = (double)Math.round(perWorkItemStatistics.getMin() / 100.0) / 10.0;
            double avg = (double)Math.round(perWorkItemStatistics.getMean() / 100.0) / 10.0;
            double dev = (double)Math.round(perWorkItemStatistics.getStandardDeviation() / 100.0) / 10.0;
            done = "<span title=\"seconds-per-work-item Max:" + max + " " + "Min:" + min + " " + "Avg:" + avg + " " + "StdDev:" + dev + "\"" + ">" + done + "</span>";
        }
        sb.append(done);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(this.buildErrorLink(job));
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        String d0 = "<span>";
        String d1 = "0";
        String d2 = "</span>";
        if (duccData.isLive(duccId)) {
            int dispatch = 0;
            int unassigned = job.getSchedulingInfo().getCasQueuedMap().size();
            try {
                dispatch = Integer.parseInt(job.getSchedulingInfo().getWorkItemsDispatched()) - unassigned;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dispatch < 0) {
                d0 = "<span class=\"health_red\" title=\"unassigned location count: " + (0 - dispatch) + "\">";
            } else {
                d1 = "" + dispatch;
            }
        }
        sb.append(d0);
        sb.append(d1);
        sb.append(d2);
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsRetry());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\" align=\"right\">");
        sb.append(job.getSchedulingInfo().getWorkItemsPreempt());
        sb.append("</td>");
        sb.append("<td valign=\"bottom\">");
        String description = this.stringNormalize(job.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void handleServletClassicJobs(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicJobs";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        long now = System.currentTimeMillis();
        int maxRecords = this.getJobsMax(request);
        ArrayList<String> users = this.getJobsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = duccData.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, (IDuccWork)job);
                if (!list) continue;
                sb.append(this.trGet(++counter));
                this.buildJobsListEntry(request, sb, job.getDuccId(), (IDuccWorkJob)job, duccData, now, servicesRegistry);
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no jobs"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void buildReservationsListEntry(HttpServletRequest request, StringBuffer sb, DuccId duccId, IDuccWork duccwork, DuccData duccData, long now) {
        DuccWorkJob job;
        Object rationale;
        Object jdReservation;
        String decoratedDuration;
        String duration;
        String id = this.normalize(duccId);
        String reservationType = "Unmanaged";
        if (duccwork instanceof DuccWorkJob) {
            reservationType = "Managed";
        }
        sb.append("<td class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !duccwork.isCompleted()) {
            DuccPropertiesResolver dpr;
            String jdHostUser;
            String disabled = this.getDisabledWithHover(request, duccwork);
            String user = duccwork.getStandardInfo().getUser();
            if (user != null && user.equals(jdHostUser = (dpr = DuccPropertiesResolver.getInstance()).getCachedProperty("ducc.jd.host.user"))) {
                disabled = "disabled=\"disabled\"";
            }
            if (duccwork instanceof DuccWorkReservation) {
                sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_reservation(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
            } else if (duccwork instanceof DuccWorkJob) {
                sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_service(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
            }
        }
        sb.append("</td>");
        if (reservationType.equals("Managed")) {
            sb.append("<td valign=\"bottom\">");
            sb.append("<a href=\"reservation.details.html?id=" + id + "\">" + id + "</a>");
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append(id);
            sb.append("</td>");
        }
        sb.append("<td>");
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, duccwork.getDuccId(), duccwork.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            switch (reservation.getReservationState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)reservation, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)reservation, now, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
            }
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job2 = (DuccWorkJob)duccwork;
            switch (job2.getJobState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)job2, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job2, duration, FormatHelper.Precision.Whole);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)job2, now, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job2, duration, FormatHelper.Precision.Whole);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                }
            }
        }
        sb.append("</td>");
        String title = "";
        String submitter = duccwork.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\"";
        }
        sb.append("<td " + title + ">");
        UserId userId = new UserId(duccwork.getStandardInfo().getUser());
        sb.append(userId.toString());
        sb.append("</td>");
        sb.append("<td>");
        sb.append(this.stringNormalize(duccwork.getSchedulingInfo().getSchedulingClass(), messages.fetch("default")));
        sb.append("</td>");
        sb.append("<td>");
        sb.append(reservationType);
        sb.append("</td>");
        sb.append("<td>");
        if (duccData.isLive(duccId)) {
            if (duccwork.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
        } else {
            sb.append("<span class=\"historic_state\">");
        }
        sb.append(duccwork.getStateObject().toString());
        if (duccData.isLive(duccId)) {
            sb.append("</span>");
        }
        sb.append("</td>");
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            sb.append("<td>");
            block8 : switch (reservation.getReservationState()) {
                case WaitingForResources: {
                    String rmReason = reservation.getRmReason();
                    if (rmReason == null) break;
                    sb.append("<span>");
                    sb.append(rmReason);
                    sb.append("</span>");
                    break;
                }
                case Assigned: {
                    List list = reservation.getJdReservationBeanList();
                    long inuse = 0L;
                    long total = 0L;
                    if (list == null) break;
                    for (JdReservationBean jdReservationBean : list) {
                        jdReservation = (JdReservation)jdReservationBean;
                        inuse += jdReservation.getSlicesInuse().longValue();
                        total += jdReservation.getSlicesTotal().longValue();
                    }
                    title = "title=\"the number of job driver allocations inuse for this reservation\"";
                    sb.append("<span " + title + ">");
                    sb.append("inuse: " + inuse);
                    sb.append("</span>");
                    sb.append(" ");
                    title = "title=\"the number of job driver allocations maximum capacity for this reservation\"";
                    sb.append("<span " + title + ">");
                    sb.append("limit: " + total);
                    sb.append("</span>");
                    break;
                }
                default: {
                    switch (reservation.getCompletionType()) {
                        case Undefined: {
                            break block8;
                        }
                        case CanceledByUser: 
                        case CanceledByAdmin: {
                            try {
                                String cancelUser = duccwork.getStandardInfo().getCancelUser();
                                if (cancelUser != null) {
                                    sb.append("<span title=\"canceled by " + cancelUser + "\">");
                                    sb.append(duccwork.getCompletionTypeObject().toString());
                                    sb.append("</span>");
                                    break block8;
                                }
                                rationale = reservation.getCompletionRationale();
                                if (rationale != null) {
                                    sb.append("<span title=" + rationale.getTextQuoted() + ">");
                                    sb.append(duccwork.getCompletionTypeObject().toString());
                                    sb.append("</span>");
                                    break block8;
                                }
                                sb.append(duccwork.getCompletionTypeObject().toString());
                            }
                            catch (Exception e) {
                                rationale = reservation.getCompletionRationale();
                                if (rationale != null) {
                                    sb.append("<span title=" + rationale.getTextQuoted() + ">");
                                    sb.append(duccwork.getCompletionTypeObject().toString());
                                    sb.append("</span>");
                                    break block8;
                                }
                                sb.append(duccwork.getCompletionTypeObject().toString());
                            }
                            break block8;
                        }
                    }
                    IRationale rationale2 = reservation.getCompletionRationale();
                    if (rationale2 != null) {
                        sb.append("<span title=" + rationale2.getTextQuoted() + ">");
                        sb.append(duccwork.getCompletionTypeObject().toString());
                        sb.append("</span>");
                        break;
                    }
                    sb.append(duccwork.getCompletionTypeObject().toString());
                }
            }
            sb.append("</td>");
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job3 = (DuccWorkJob)duccwork;
            String reason = this.getReason((IDuccWorkJob)job3, IWebMonitor.MonitorType.ManagedReservation).toString();
            sb.append("<td>");
            sb.append(reason);
            sb.append("</td>");
        }
        sb.append("<td align=\"right\">");
        TreeMap<String, Integer> nodeMap = new TreeMap<String, Integer>();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            if (!reservation.getReservationMap().isEmpty()) {
                IDuccReservationMap map = reservation.getReservationMap();
                for (DuccId key : map.keySet()) {
                    IDuccReservation value = (IDuccReservation)reservation.getReservationMap().get((Object)key);
                    String node = value.getNodeIdentity().getName();
                    if (!nodeMap.containsKey(node)) {
                        nodeMap.put(node, new Integer(0));
                    }
                    Integer count = (Integer)nodeMap.get(node);
                    rationale = count;
                    count = count + 1;
                    jdReservation = count;
                    nodeMap.put(node, count);
                }
            }
            boolean qualify = false;
            if (!nodeMap.isEmpty() && nodeMap.keySet().size() > 1) {
                qualify = true;
            }
            ArrayList<String> qualifiedPids = new ArrayList<String>();
            if (duccwork.isOperational()) {
                DuccMachinesData machinesData = DuccMachinesData.getInstance();
                for (String node : nodeMap.keySet()) {
                    NodeId nodeId = new NodeId(node);
                    List<String> nodePids = machinesData.getPids(nodeId, userId);
                    for (String pid : nodePids) {
                        if (qualify) {
                            qualifiedPids.add(node + ":" + pid);
                            continue;
                        }
                        qualifiedPids.add(pid);
                    }
                }
            }
            if (qualifiedPids.size() > 0) {
                String list = "";
                for (String entry : qualifiedPids) {
                    list = list + entry + " ";
                }
                sb.append("<span title=\"" + list.trim() + "\">");
                sb.append("" + qualifiedPids.size());
                sb.append("</span>");
            } else {
                sb.append("" + qualifiedPids.size());
            }
        } else {
            job = (DuccWorkJob)duccwork;
            if (job.isOperational()) {
                sb.append(duccwork.getSchedulingInfo().getInstancesCount());
            } else {
                sb.append("0");
            }
            for (DuccId processId : job.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)job.getProcessMap().get((Object)processId);
                String node = process.getNodeIdentity().getName();
                nodeMap.put(node, 1);
            }
        }
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        if (duccwork instanceof DuccWorkJob) {
            job = (DuccWorkJob)duccwork;
            long faults = 0L;
            try {
                faults = job.getPgInCount();
            }
            catch (Exception process) {
                // empty catch block
            }
            int ifaults = (int)faults;
            switch (ifaults) {
                case -3: {
                    sb.append("<span title=\"incomplete\" class=\"health_red\">");
                    sb.append("INC");
                    break;
                }
                case -2: {
                    sb.append("<span title=\"incomplete\" class=\"health_black\">");
                    sb.append("INC");
                    break;
                }
                case -1: {
                    sb.append("<span title=\"not available\" class=\"health_black\">");
                    sb.append("N/A");
                    break;
                }
                default: {
                    double swapping = job.getSwapUsageGbMax();
                    if (swapping * (double)faults > 0.0) {
                        sb.append("<span class=\"health_red\">");
                    } else {
                        sb.append("<span class=\"health_black\">");
                    }
                    sb.append(faults);
                }
            }
            sb.append("</span>");
        }
        sb.append("</td>");
        sb.append("<td align=\"right\">");
        if (duccwork instanceof DuccWorkJob) {
            job = (DuccWorkJob)duccwork;
            String swapSizeDisplay = "";
            String swapSizeHover = "";
            title = "";
            double swap = 0.0;
            swap = job.isCompleted() ? job.getSwapUsageGbMax() : job.getSwapUsageGb();
            int iswap = (int)swap;
            switch (iswap) {
                case -3: {
                    sb.append("<span title=\"incomplete\" class=\"health_red\">");
                    sb.append("INC");
                    break;
                }
                case -2: {
                    sb.append("<span title=\"incomplete\" class=\"health_black\">");
                    sb.append("INC");
                    break;
                }
                case -1: {
                    sb.append("<span title=\"not available\" class=\"health_black\">");
                    sb.append("N/A");
                    break;
                }
                default: {
                    double swapBytes = swap * DuccHandlerUtils.GB;
                    swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                    swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                    title = "title=\"" + swapSizeHover + "\"";
                    if (swapBytes > 0.0) {
                        sb.append("<span " + title + " " + "class=\"health_red\"" + ">");
                    } else {
                        sb.append("<span " + title + " " + "class=\"health_black\"" + ">");
                    }
                    sb.append(swapSizeDisplay);
                }
            }
            sb.append("</span>");
        }
        sb.append("</td>");
        IDuccSchedulingInfo si = duccwork.getSchedulingInfo();
        SizeBytes sizeBytes = new SizeBytes(SizeBytes.Type.Bytes, si.getMemorySizeAllocatedInBytes());
        String actual = this.getProcessMemorySize(duccId, sizeBytes);
        sizeBytes = new SizeBytes(si.getMemoryUnits().name(), Long.parseLong(si.getMemorySizeRequested()));
        String requested = this.getProcessMemorySize(duccId, sizeBytes);
        sb.append("<td align=\"right\">");
        sb.append("<span title=\"requested: " + requested + "\">");
        sb.append(actual);
        sb.append("</span>");
        sb.append("</td>");
        sb.append("<td>");
        if (!nodeMap.isEmpty()) {
            boolean useList = false;
            if (nodeMap.size() > 1) {
                useList = true;
            }
            if (useList) {
                sb.append("<select>");
            }
            Iterator i$ = nodeMap.keySet().iterator();
            while (i$.hasNext()) {
                String node;
                String option = node = (String)i$.next();
                Integer count = (Integer)nodeMap.get(node);
                if (count > 1) {
                    option = option + " [" + count + "]";
                }
                if (useList) {
                    sb.append("<option>");
                }
                sb.append(option);
                if (!useList) continue;
                sb.append("</option>");
            }
            if (useList) {
                sb.append("</select>");
            }
        }
        sb.append("</td>");
        sb.append("<td>");
        String description = this.stringNormalize(duccwork.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void handleServletClassicReservations(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicReservations";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        int maxRecords = this.getReservationsMax(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = duccData.getSortedCombinedReservations();
        ArrayList<String> users = this.getReservationsUsers(request);
        long now = System.currentTimeMillis();
        if (sortedCombinedReservations.size() > 0) {
            int counter = 0;
            Iterator<Map.Entry<Info, Info>> iR = sortedCombinedReservations.entrySet().iterator();
            while (iR.hasNext()) {
                Info info = iR.next().getValue();
                IDuccWork dw = info.getDuccWork();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, dw);
                if (!list) continue;
                ++counter;
                if (dw instanceof DuccWorkReservation) {
                    DuccWorkReservation reservation = (DuccWorkReservation)dw;
                    sb.append(this.trGet(counter));
                    this.buildReservationsListEntry(request, sb, reservation.getDuccId(), (IDuccWork)reservation, duccData, now);
                    continue;
                }
                if (!(dw instanceof DuccWorkJob)) continue;
                DuccWorkJob job = (DuccWorkJob)dw;
                sb.append(this.trGet(counter));
                this.buildReservationsListEntry(request, sb, job.getDuccId(), (IDuccWork)job, duccData, now);
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no reservations"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicServices(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicServices";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        ServicesSortCache servicesSortCache = ServicesSortCache.getInstance();
        Collection<IServiceAdapter> servicesSortedCollection = servicesSortCache.getSortedCollection();
        if (!servicesSortedCollection.isEmpty()) {
            int maxRecords = this.getServicesMax(request);
            ArrayList<String> users = this.getServicesUsers(request);
            int counter = 0;
            for (IServiceAdapter service : servicesSortedCollection) {
                String schedulingClass;
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, service);
                if (!list) continue;
                ++counter;
                sb.append("<tr>");
                int sid = service.getId();
                String user = service.getUser();
                long deployments = service.getDeployments();
                long instances = service.getInstances();
                sb.append("<td valign=\"bottom\" class=\"ducc-col-start\">");
                if (service.isRegistered() && this.buttonsEnabled && service.isDisabled()) {
                    sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_enable(" + sid + ")\" value=\"Enable\" " + this.getDisabledWithHover(request, user) + "/>");
                }
                sb.append("</td>");
                sb.append("<td valign=\"bottom\" class=\"ducc-col-stop\">");
                if (service.isRegistered() && this.buttonsEnabled) {
                    if (service.isPingOnly()) {
                        if (service.isPingActive()) {
                            sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                        }
                    } else if (deployments != 0L) {
                        sb.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                    }
                }
                sb.append("</td>");
                String name = service.getName();
                sb.append("<td align=\"right\">");
                String id = "<a href=\"service.details.html?name=" + name + "\">" + sid + "</a>";
                sb.append("" + id);
                sb.append("</td>");
                sb.append("<td>");
                sb.append(name);
                sb.append("</td>");
                sb.append("<td>");
                String state = service.getState();
                boolean alert = service.isAlert();
                boolean available = service.isStateAvailable();
                if (alert) {
                    state = state + "+Alert";
                }
                String style = "class=\"health_black\";";
                if (alert) {
                    style = "class=\"health_red\"";
                } else if (available) {
                    style = "class=\"health_green\"";
                }
                String stateHover = ServicesHelper.getInstance().getStateHover(service);
                if (stateHover.length() > 0) {
                    stateHover = "title=\"" + stateHover + "\"";
                }
                sb.append("<span " + style + " " + stateHover + ">");
                sb.append(state);
                sb.append("</span>");
                sb.append("</td>");
                sb.append("<td>");
                long lastUse = service.getLastUse();
                if (lastUse > 0L) {
                    sb.append(this.getTimeStamp(request, jobid, "" + lastUse));
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(instances);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(deployments);
                sb.append("</td>");
                ServiceInterpreter.StartState startState = service.getStartState();
                sb.append("<td align=\"right\">");
                sb.append("<span>");
                sb.append(startState.name());
                if (service.isDisabled()) {
                    sb.append("<br>");
                    String health = "class=\"health_red\"";
                    String reason = "title=\"" + service.getDisableReason() + "\"";
                    sb.append("<span " + health + " " + reason + ">");
                    sb.append("Disabled");
                    sb.append("</span>");
                }
                sb.append("</span>");
                sb.append("</td>");
                sb.append("<td>");
                sb.append(user);
                sb.append("</td>");
                sb.append("<td>");
                if (service.isPingOnly()) {
                    schedulingClass = service.getSchedulingClass();
                    sb.append("<span title=\"" + schedulingClass + "\">");
                    String serviceType = "ping-only";
                    sb.append("<span>");
                    sb.append(serviceType);
                } else {
                    schedulingClass = service.getSchedulingClass();
                    sb.append(schedulingClass);
                }
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                long faults = 0L;
                try {
                    faults = service.getPgIn();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int ifaults = (int)faults;
                switch (ifaults) {
                    case -3: {
                        sb.append("<span title=\"incomplete\" class=\"health_red\">");
                        sb.append("INC");
                        break;
                    }
                    case -2: {
                        sb.append("<span title=\"incomplete\" class=\"health_black\">");
                        sb.append("INC");
                        break;
                    }
                    case -1: {
                        sb.append("<span title=\"not available\" class=\"health_black\">");
                        sb.append("N/A");
                        break;
                    }
                    default: {
                        double swapping = service.getSwap();
                        if (swapping * (double)faults > 0.0) {
                            sb.append("<span class=\"health_red\">");
                        } else {
                            sb.append("<span class=\"health_black\">");
                        }
                        sb.append(faults);
                    }
                }
                sb.append("</span>");
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                String swapSizeDisplay = "";
                String swapSizeHover = "";
                String title = "";
                double swap = service.getSwap();
                int iswap = (int)swap;
                switch (iswap) {
                    case -3: {
                        sb.append("<span title=\"incomplete\" class=\"health_red\">");
                        sb.append("INC");
                        break;
                    }
                    case -2: {
                        sb.append("<span title=\"incomplete\" class=\"health_black\">");
                        sb.append("INC");
                        break;
                    }
                    case -1: {
                        sb.append("<span title=\"not available\" class=\"health_black\">");
                        sb.append("N/A");
                        break;
                    }
                    default: {
                        double swapBytes = swap;
                        swapSizeDisplay = DuccHandlerUtils.getSwapSizeDisplay(swapBytes);
                        swapSizeHover = DuccHandlerUtils.getSwapSizeHover(swapBytes);
                        title = "title=\"" + swapSizeHover + "\"";
                        if (swapBytes > 0.0) {
                            sb.append("<span " + title + " " + "class=\"health_red\"" + ">");
                        } else {
                            sb.append("<span " + title + " " + "class=\"health_black\"" + ">");
                        }
                        sb.append(swapSizeDisplay);
                    }
                }
                sb.append("</span>");
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                long size = service.getSize();
                if (size < 0L) {
                    size = 0L;
                }
                sb.append(size);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                ArrayList<String> dependentJobs = service.getDependentJobs();
                int countDependentJobs = dependentJobs.size();
                String titleJobs = "";
                if (countDependentJobs > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentJobs) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleJobs = "dependent Job Id list: " + idList;
                }
                String jobs = "<span title=\"" + titleJobs + "\">" + countDependentJobs + "</span>";
                sb.append(jobs);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                ArrayList<String> dependentServices = service.getDependentServices();
                int countDependentServices = dependentServices.size();
                String titleServices = "";
                if (countDependentServices > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentServices) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleServices = "dependent Service Name list: " + idList;
                }
                String services = "<span title=\"" + titleServices + "\">" + countDependentServices + "</span>";
                sb.append(services);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                ArrayList<String> dependentReservations = service.getDependentReservations();
                int countDependentReservations = dependentReservations.size();
                String titleReservations = "";
                if (countDependentReservations > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentReservations) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleReservations = "dependent Reservation Id list: " + idList;
                }
                String reservations = "<span title=\"" + titleReservations + "\">" + countDependentReservations + "</span>";
                sb.append(reservations);
                sb.append("</td>");
                sb.append("<td>");
                String description = service.getDescription();
                sb.append(description);
                sb.append("</td>");
                sb.append("</tr>");
            }
        } else {
            sb.append("<tr>");
            sb.append("<td>");
            if (DuccData.getInstance().isPublished()) {
                sb.append(messages.fetch("no services"));
            } else {
                sb.append(messages.fetch("no data"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemClasses(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletClassicSystemClasses";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String val = null;
        NodeConfiguration nc = this.getNodeConfiguration();
        DuccSchedulerClasses schedulerClasses = DuccSchedulerClasses.getInstance();
        Map clmap = schedulerClasses.getClasses();
        if (clmap != null) {
            DuccProperties[] class_set = clmap.values().toArray(new DuccProperties[clmap.size()]);
            Arrays.sort(class_set, new NodeConfiguration.ClassSorter());
            int i = 0;
            for (DuccProperties cl : class_set) {
                String v1;
                sb.append(this.trGet(i + 1));
                String class_name = cl.getProperty("name");
                sb.append("<td>");
                sb.append(class_name);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                val = cl.getProperty("nodepool");
                sb.append(val);
                sb.append("</td>");
                sb.append("<td>");
                String policy = cl.getProperty("policy");
                sb.append(policy);
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(this.getQuantum(nc, class_name));
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(cl.getStringProperty("weight", "-"));
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                sb.append(cl.getProperty("priority"));
                sb.append("</td>");
                sb.append("<td align=\"right\">");
                val = "-";
                if (schedulerClasses.isPreemptable(class_name) && !(v1 = cl.getStringProperty("debug", "")).equals("")) {
                    val = v1;
                }
                sb.append(val);
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemDaemons(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicSystemDaemons";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String wsHostIP = this.getWebServerHostIP();
        String wsHostName = this.getWebServerHostName();
        DuccDaemonsData duccDaemonsData = DuccDaemonsData.getInstance();
        DuccMachinesData duccMachinesData = DuccMachinesData.getInstance();
        int counter = 0;
        boolean brokerAlive = brokerHelper.isAlive();
        block14: for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            switch (daemonName) {
                case Database: {
                    if (databaseHelper.isDisabled()) continue block14;
                }
                default: {
                    String status = "";
                    String bootTime = "";
                    String hostIP = "";
                    String hostName = "";
                    String pid = "";
                    String pubSizeLast = "";
                    String pubSizeMax = "";
                    String heartbeatLast = "";
                    String heartbeatMax = "";
                    String heartbeatMaxTOD = "";
                    String jmxUrl = null;
                    Properties properties = DuccDaemonRuntimeProperties.getInstance().get(daemonName);
                    switch (daemonName) {
                        case Broker: {
                            status = brokerAlive ? DuccHandlerUtils.up() : DuccHandlerUtils.down();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), brokerHelper.getStartTime());
                            hostName = this.useWS(wsHostName, brokerHelper.getHost());
                            hostIP = this.useWS(wsHostName, hostName, wsHostIP);
                            pid = "" + brokerHelper.getPID();
                            pubSizeLast = "-";
                            pubSizeMax = "-";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = brokerHelper.getJmxUrl();
                            break;
                        }
                        case Database: {
                            status = databaseHelper.isAlive() ? DuccHandlerUtils.up() : DuccHandlerUtils.down();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), databaseHelper.getStartTime());
                            hostName = this.useWS(wsHostName, databaseHelper.getHost());
                            hostIP = this.useWS(wsHostName, hostName, wsHostIP);
                            pid = "" + databaseHelper.getPID();
                            pubSizeLast = "-";
                            pubSizeMax = "-";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = databaseHelper.getJmxUrl();
                            break;
                        }
                        case Webserver: {
                            status = DuccHandlerUtils.up();
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                            hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                            hostName = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "");
                            pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                            pubSizeLast = "*";
                            pubSizeMax = "*";
                            heartbeatLast = "";
                            heartbeatMax = "";
                            heartbeatMaxTOD = "";
                            jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                            break;
                        }
                        default: {
                            status = DuccHandlerUtils.unknown();
                            if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                            }
                            bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                            hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                            hostName = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "");
                            pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                            pubSizeLast = "" + duccDaemonsData.getEventSize(daemonName);
                            pubSizeMax = "" + duccDaemonsData.getEventSizeMax(daemonName);
                            heartbeatLast = DuccDaemonsData.getInstance().getHeartbeat(daemonName);
                            long timeout = DuccWebProperties.get_ducc_ws_monitored_daemon_down_millis_expiry() / 1000L;
                            if (timeout > 0L) {
                                try {
                                    long overtime = timeout - Long.parseLong(heartbeatLast);
                                    if (overtime < 0L) {
                                        if (brokerAlive) {
                                            status = DuccHandlerUtils.down();
                                        }
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                            String filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                            String hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                            String fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                            status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                                        }
                                    } else {
                                        int jdCount;
                                        if (brokerAlive) {
                                            status = DuccHandlerUtils.up();
                                        }
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && (jdCount = DuccData.getInstance().getLive().getJobDriverNodeCount()) == 0) {
                                            status = DuccHandlerUtils.up_provisional(", pending JD allocation");
                                        }
                                    }
                                }
                                catch (Throwable overtime) {
                                    // empty catch block
                                }
                            }
                            heartbeatMax = DuccDaemonsData.getInstance().getMaxHeartbeat(daemonName);
                            heartbeatMaxTOD = TimeStamp.simpleFormat((String)DuccDaemonsData.getInstance().getMaxHeartbeatTOD(daemonName));
                            try {
                                heartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), heartbeatMaxTOD);
                            }
                            catch (Exception overtime) {
                                // empty catch block
                            }
                            jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                        }
                    }
                    sb.append(this.trGet(counter));
                    sb.append("<td>");
                    sb.append(status);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(daemonName);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(bootTime);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(hostIP);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(hostName);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(pid);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append("" + pubSizeLast);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append(pubSizeMax);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append(heartbeatLast);
                    sb.append("</td>");
                    sb.append("<td align=\"right\">");
                    sb.append(heartbeatMax);
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(heartbeatMaxTOD);
                    sb.append("</td>");
                    sb.append("<td>");
                    if (jmxUrl != null) {
                        sb.append(this.buildjConsoleLink(jmxUrl));
                    }
                    sb.append("</td>");
                    sb.append("</tr>");
                    ++counter;
                }
            }
        }
        String cookie = DuccCookies.getCookie(request, "DUCCagents");
        if (cookie.equals("show")) {
            duccLogger.trace(methodName, jobid, new Object[]{"== show: " + cookie});
            Map<MachineInfo, NodeId> machines = duccMachinesData.getMachines();
            for (MachineInfo machineInfo : machines.keySet()) {
                DuccDaemonRuntimeProperties drp = DuccDaemonRuntimeProperties.getInstance();
                String machineName = machineInfo.getName();
                if (machineName.startsWith("=")) continue;
                Properties properties = drp.getAgent(machineName);
                sb.append(this.trGet(counter));
                StringBuffer status = new StringBuffer();
                if (brokerAlive) {
                    String machineStatus = machineInfo.getStatus();
                    if (machineStatus.equals("down")) {
                        status.append(DuccHandlerUtils.down());
                    } else if (machineStatus.equals("up")) {
                        status.append(DuccHandlerUtils.up());
                    } else {
                        status.append(DuccHandlerUtils.unknown());
                    }
                } else {
                    status.append(DuccHandlerUtils.unknown());
                }
                sb.append("<td>");
                sb.append(status);
                sb.append("</td>");
                sb.append("</td>");
                String daemonName = "Agent";
                sb.append("<td>");
                sb.append(daemonName);
                sb.append("</td>");
                String bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                sb.append("<td>");
                sb.append(bootTime);
                sb.append("</td>");
                String hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                sb.append("<td>");
                sb.append(hostIP);
                sb.append("</td>");
                String hostName = machineInfo.getName();
                sb.append("<td>");
                sb.append(hostName);
                sb.append("</td>");
                String pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                sb.append("<td>");
                sb.append(pid);
                sb.append("</td>");
                String publicationSizeLast = machineInfo.getPublicationSizeLast();
                sb.append("<td align=\"right\">");
                sb.append(publicationSizeLast);
                sb.append("</td>");
                String publicationSizeMax = machineInfo.getPublicationSizeMax();
                sb.append("<td align=\"right\">");
                sb.append(publicationSizeMax);
                sb.append("</td>");
                String heartbeatLast = machineInfo.getHeartbeatLast();
                sb.append("<td align=\"right\">");
                sb.append(heartbeatLast);
                sb.append("</td>");
                long heartbeatMax = machineInfo.getHeartbeatMax();
                sb.append("<td align=\"right\">");
                if (heartbeatMax > 0L) {
                    sb.append(heartbeatMax);
                }
                sb.append("</td>");
                String fmtHeartbeatMaxTOD = "";
                long heartbeatMaxTOD = machineInfo.getHeartbeatMaxTOD();
                if (heartbeatMaxTOD > 0L) {
                    fmtHeartbeatMaxTOD = TimeStamp.simpleFormat((String)("" + heartbeatMaxTOD));
                    try {
                        fmtHeartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), fmtHeartbeatMaxTOD);
                    }
                    catch (Exception hover) {
                        // empty catch block
                    }
                }
                sb.append("<td>");
                sb.append(fmtHeartbeatMaxTOD);
                sb.append("</td>");
                sb.append("<td>");
                String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                if (jmxUrl != null) {
                    sb.append(this.buildjConsoleLink(jmxUrl));
                }
                sb.append("</td>");
                sb.append("</tr>");
                ++counter;
            }
        } else {
            duccLogger.trace(methodName, jobid, new Object[]{"!= show: " + cookie});
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void buildRowForIndividualMachine(StringBuffer data, int counter, MachineInfo machineInfo, SizeBytes allocated) {
        StringBuffer row = new StringBuffer();
        row.append(this.trGet(counter));
        StringBuffer sb = new StringBuffer();
        String status = machineInfo.getStatus();
        if (status == null) {
            status = "?";
        }
        String hover = "title=\"" + machineInfo.getMachineStatusReason() + "\"";
        if (status.equals("down")) {
            sb.append("<span " + hover + " class=\"health_red\"" + ">");
            sb.append(status);
            sb.append("</span>");
        } else if (status.equals("up")) {
            sb.append("<span " + hover + "class=\"health_green\"" + ">");
            sb.append(status);
            sb.append("</span>");
        } else {
            sb.append(status);
        }
        row.append("<td>");
        row.append(sb);
        row.append("</td>");
        row.append("<td>");
        row.append(machineInfo.getIp());
        row.append("</td>");
        row.append("<td>");
        row.append(machineInfo.getName());
        row.append("</td>");
        row.append("<td>");
        String nodepool = DuccSchedulerClasses.getInstance().getNodepool(machineInfo.getName());
        row.append(nodepool);
        row.append("</td>");
        if (status.equals("up")) {
            sb = new StringBuffer();
            sb.append("total=" + machineInfo.getMemTotal());
            Integer quantum = machineInfo.getQuantum();
            if (quantum != null) {
                sb.append(" ");
                sb.append("quantum=" + quantum);
            }
            hover = "title=\"" + sb.toString() + "\"";
            row.append("<td align=\"right\" " + hover + ">");
            row.append(machineInfo.getMemReserve());
            row.append("</td>");
        } else if (status.equals("down")) {
            row.append("<td align=\"right\">");
            row.append("0");
            row.append("</td>");
        } else {
            row.append("<td align=\"right\">");
            row.append("</td>");
        }
        if (status.equals("up")) {
            long memFree = ConvertSafely.String2Long((String)machineInfo.getMemReserve());
            row.append("<td align=\"right\">");
            row.append(memFree -= allocated.getGBytes());
            row.append("</td>");
        } else if (status.equals("down")) {
            row.append("<td align=\"right\">");
            row.append("0");
            row.append("</td>");
        } else {
            row.append("<td align=\"right\">");
            row.append("</td>");
        }
        row.append("<td align=\"right\">");
        if (status.equals("up")) {
            String cpu = formatter1.format(machineInfo.getCpu());
            row.append(cpu);
        }
        row.append("</td>");
        sb = new StringBuffer();
        String swapping = machineInfo.getSwapInuse();
        if (swapping.equals("0")) {
            sb.append(swapping);
        } else {
            sb.append("<span class=\"health_red\">");
            sb.append(swapping);
            sb.append("</span>");
        }
        row.append("<td align=\"right\">");
        if (!status.equals("defined")) {
            row.append(sb);
        }
        row.append("</td>");
        row.append("<td align=\"right\">");
        if (!status.equals("defined")) {
            row.append(machineInfo.getSwapFree());
        }
        row.append("</td>");
        boolean isCgroupsEnabled = machineInfo.getCgroupsEnabled();
        boolean isCgroupsCpuReportingEnabled = machineInfo.getCgroupsCpuReportingEnabled();
        sb = new StringBuffer();
        if (status.equals("up")) {
            if (isCgroupsEnabled) {
                if (isCgroupsCpuReportingEnabled) {
                    sb.append("<span title=\"control groups active\" class=\"health_black\">");
                    sb.append("on");
                    sb.append("</span>");
                } else {
                    sb.append("<span title=\"control groups CPU reporting not configured\" class=\"health_red\">");
                    sb.append("noCPU%");
                    sb.append("</span>");
                }
            } else {
                sb.append("<span title=\"control groups inactive\" class=\"health_red\">");
                sb.append("off");
                sb.append("</span>");
            }
        }
        String cgroups = sb.toString();
        row.append("<td align=\"right\">");
        row.append("" + cgroups);
        row.append("</td>");
        sb = new StringBuffer();
        long aliens = machineInfo.getAliens().size();
        if (aliens == 0L) {
            sb.append(aliens);
        } else {
            StringBuffer title = new StringBuffer();
            title.append("title=");
            title.append("\"");
            for (String pid : machineInfo.getAliens()) {
                title.append(pid + " ");
            }
            title.append("\"");
            sb.append("<span class=\"health_red\" " + title + ">");
            sb.append(aliens);
            sb.append("</span>");
        }
        row.append("<td align=\"right\">");
        if (!status.equals("defined")) {
            row.append(sb);
        }
        row.append("</td>");
        row.append("<td align=\"right\">");
        if (!status.equals("defined")) {
            row.append(machineInfo.getHeartbeatLast());
        }
        row.append("</td>");
        row.append("</tr>");
        data.append(row);
    }

    private void handleServletClassicSystemMachines(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicSystemMachines";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        int counter = 0;
        long sumMemTotal = 0L;
        long sumMemFree = 0L;
        long sumMemReserve = 0L;
        long sumMemAllocated = 0L;
        double sumCPU = 0.0;
        long sumMachines = 0L;
        long sumSwapInuse = 0L;
        long sumSwapFree = 0L;
        long sumAliens = 0L;
        StringBuffer data = new StringBuffer();
        StringBuffer individualMachines = new StringBuffer();
        DuccMachinesData instance = DuccMachinesData.getInstance();
        Map<MachineInfo, NodeId> machines = instance.getMachines();
        if (!machines.isEmpty()) {
            Map<String, Long> allocatedMap = Distiller.getMap();
            for (Map.Entry<MachineInfo, NodeId> entry : machines.entrySet()) {
                MachineInfo machineInfo = entry.getKey();
                SizeBytes sb = new SizeBytes(SizeBytes.Type.Bytes, 0L);
                if (DuccMachinesDataHelper.isUp(machineInfo)) {
                    try {
                        sumMemTotal += ConvertSafely.String2Long((String)machineInfo.getMemTotal());
                        sumMemReserve += ConvertSafely.String2Long((String)machineInfo.getMemReserve());
                        sumSwapInuse += ConvertSafely.String2Long((String)machineInfo.getSwapInuse());
                        sumSwapFree += ConvertSafely.String2Long((String)machineInfo.getSwapFree());
                        sumCPU += machineInfo.getCpu();
                        ++sumMachines;
                        sumAliens += machineInfo.getAlienPidsCount();
                        String machineName = machineInfo.getName();
                        long bytes = allocatedMap.get(machineName);
                        sumMemAllocated += bytes;
                        sb = new SizeBytes(SizeBytes.Type.Bytes, bytes);
                        String text = "allocated " + machineName + "=" + sb.getGBytes();
                        duccLogger.trace(methodName, jobid, new Object[]{text});
                    }
                    catch (Exception e) {
                        duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
                    }
                }
                this.buildRowForIndividualMachine(individualMachines, counter, machineInfo, sb);
                ++counter;
            }
            SizeBytes sbAllocated = new SizeBytes(SizeBytes.Type.Bytes, sumMemAllocated);
            sumMemFree = sumMemReserve - sbAllocated.getGBytes();
            StringBuffer row = new StringBuffer();
            row.append("<tr>");
            row.append("<td>");
            row.append("Total");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            String hover = "title=\"total=" + sumMemTotal + "\"";
            row.append("<td align=\"right\" " + hover + ">");
            row.append("" + sumMemReserve);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumMemFree);
            row.append("</td>");
            row.append("<td align=\"right\">");
            String cpuTotal = formatter1.format(sumCPU / (double)sumMachines);
            row.append("" + cpuTotal);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumSwapInuse);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumSwapFree);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("");
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("" + sumAliens);
            row.append("</td>");
            row.append("<td align=\"right\">");
            row.append("");
            row.append("</td>");
            row.append("</tr>");
            data.append(row);
            data.append(individualMachines);
        } else {
            StringBuffer row = new StringBuffer();
            row.append(this.trGet(counter));
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("<td>");
            row.append("");
            row.append("</td>");
            row.append("</tr>");
            data.append(row);
        }
        duccLogger.debug(methodName, jobid, new Object[]{data});
        response.getWriter().println(data);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletClassicSystemBroker(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletClassicBroker";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        BrokerHelper brokerHelper = BrokerHelper.getInstance();
        StringBuffer topics = new StringBuffer();
        StringBuffer queues = new StringBuffer();
        Map<String, Map<String, String>> topicAttributes = brokerHelper.getEntityAttributes();
        if (topicAttributes.size() > 0) {
            for (Map.Entry<String, Map<String, String>> entry : topicAttributes.entrySet()) {
                String topic = entry.getKey();
                Map<String, String> map = entry.getValue();
                StringBuffer row = new StringBuffer();
                row.append(messages.fetch("<tr>"));
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"left\">"));
                row.append(messages.fetch(topic));
                row.append(messages.fetch("</td>"));
                String type = map.get(BrokerHelper.JmxKeyWord.Type.name());
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"left\">"));
                row.append(messages.fetch(type));
                row.append(messages.fetch("</td>"));
                String attrValue = map.get(BrokerHelper.FrameworkAttribute.ConsumerCount.name());
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"right\">"));
                row.append(messages.fetch(attrValue));
                row.append(messages.fetch("</td>"));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.QueueSize.name());
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"right\">"));
                row.append(messages.fetch(attrValue));
                row.append(messages.fetch("</td>"));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MaxEnqueueTime.name());
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"right\">"));
                row.append(messages.fetch(attrValue));
                row.append(messages.fetch("</td>"));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.AverageEnqueueTime.name());
                try {
                    Double d = Double.valueOf(attrValue);
                    attrValue = formatter3.format(d);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"right\">"));
                row.append(messages.fetch(attrValue));
                row.append(messages.fetch("</td>"));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MemoryPercentUsage.name());
                row.append(messages.fetch("<td style=\"font-family: monospace;\" align=\"right\">"));
                row.append(messages.fetch(attrValue));
                row.append(messages.fetch("</td>"));
                row.append(messages.fetch("</tr>"));
                if (type.equals(BrokerHelper.JmxKeyWord.Type.name())) {
                    topics.append(row);
                    continue;
                }
                queues.append(row);
            }
            sb.append(topics);
            sb.append(queues);
        } else {
            StringBuffer row = new StringBuffer();
            row.append(messages.fetch("<tr>"));
            row.append(messages.fetch("<td>"));
            row.append(messages.fetch("no data"));
            row.append(messages.fetch("</td>"));
            row.append(messages.fetch("<td>"));
            row.append(messages.fetch(""));
            row.append(messages.fetch("</td>"));
            row.append(messages.fetch("<td>"));
            row.append(messages.fetch(""));
            row.append(messages.fetch("</td>"));
            row.append(messages.fetch("<td>"));
            row.append(messages.fetch(""));
            row.append(messages.fetch("</td>"));
            row.append(messages.fetch("<td>"));
            row.append(messages.fetch(""));
            row.append(messages.fetch("</td>"));
            row.append(messages.fetch("</tr>"));
            sb.append(row);
        }
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/classic-jobs-data")) {
            this.handleServletClassicJobs(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-reservations-data")) {
            this.handleServletClassicReservations(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-services-data")) {
            this.handleServletClassicServices(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-classes-data")) {
            this.handleServletClassicSystemClasses(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-daemons-data")) {
            this.handleServletClassicSystemDaemons(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-machines-data")) {
            this.handleServletClassicSystemMachines(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/classic-system-broker-data")) {
            this.handleServletClassicSystemBroker(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/classic")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

