/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.authentication;

import java.io.File;
import org.apache.uima.ducc.common.authentication.AuthenticationResult;
import org.apache.uima.ducc.common.authentication.IAuthenticationManager;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.authentication.AbstractAuthenticator;
import org.apache.uima.ducc.ws.authentication.DuccAsUser;
import org.apache.uima.ducc.ws.utils.HandlersHelper;

public class SecureFileAuthenticator
extends AbstractAuthenticator {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)SecureFileAuthenticator.class.getName());
    private static DuccId jobid = null;
    private String version = "Secure File 1.0";
    private String pwfile = ".ducc/.login.pw";

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getNotes(String userid) {
        String location = "getNotes";
        String retVal = null;
        String filename = this.getPwFile(userid);
        if (filename != null) {
            retVal = "Specify password found here: " + filename;
        }
        duccLogger.debug(location, jobid, new Object[]{"userid:" + userid + " " + "filename:" + filename});
        return retVal;
    }

    public boolean isPasswordChecked() {
        return true;
    }

    private String getPwFile(String userid) {
        String location = "getPwFile";
        String retVal = null;
        String home = null;
        if (userid != null && (home = HandlersHelper.getSecurityHome(userid)) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(home);
            if (!home.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append(this.pwfile);
            retVal = sb.toString();
        }
        duccLogger.debug(location, jobid, new Object[]{"userid:" + userid + " " + "home:" + home + " " + "file:" + retVal});
        return retVal;
    }

    public IAuthenticationResult isAuthenticate(String userid, String domain, String password) {
        String methodName = "isAuthenticate";
        AuthenticationResult ar = new AuthenticationResult();
        ar.setFailure();
        try {
            String filename = this.getPwFile(userid);
            if (filename != null && password != null) {
                password = password.trim();
                duccLogger.info(methodName, jobid, new Object[]{"password: " + password});
                AlienFile af = new AlienFile(userid, filename);
                String contents = af.getString();
                if (contents != null) {
                    contents = contents.trim();
                }
                duccLogger.info(methodName, jobid, new Object[]{filename + ": " + contents});
                if (password.equals(contents)) {
                    ar.setSuccess();
                } else {
                    duccLogger.info(methodName, jobid, new Object[]{contents + "!=" + password});
                }
                String DUCC_HOME = System.getProperty("DUCC_HOME");
                String duccmon_pwgen = DUCC_HOME + "/admin/duccmon_pwgen.py";
                String[] args = new String[]{"-q", "-u", userid, "--", duccmon_pwgen};
                DuccAsUser.duckling(userid, args);
            }
        }
        catch (Exception e) {
            duccLogger.warn(methodName, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.info(methodName, jobid, new Object[]{"failure:" + ar.isFailure() + " " + "success:" + ar.isSuccess()});
        return ar;
    }

    @Override
    public IAuthenticationResult isGroupMember(String userid, String domain, IAuthenticationManager.Role role) {
        return super.isGroupMember(userid, domain, role);
    }
}

