/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;

public class PagingInfo {
    public long total = 0L;
    public long procs = 0L;
    public long timestamp = System.currentTimeMillis();

    PagingInfo() {
    }

    PagingInfo(long total, long procs) {
        this.total = total;
        this.procs = procs;
    }

    PagingInfo(IDuccWorkJob job) {
        if (job != null) {
            this.count(this, job.getProcessMap());
            DuccWorkPopDriver driver = job.getDriver();
            if (driver != null) {
                this.count(this, driver.getProcessMap());
            }
        }
    }

    private void count(PagingInfo pagingInfo, IDuccProcessMap pMap) {
        if (pMap != null) {
            for (DuccId pId : pMap.keySet()) {
                IDuccProcess process = (IDuccProcess)pMap.get((Object)pId);
                this.total += process.getMajorFaults();
                ++this.procs;
            }
        }
    }

    public void display() {
        System.out.println("total:" + this.total + " " + "procs:" + this.procs);
    }
}

