/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.JobProcessInfo;
import org.apache.uima.ducc.ws.registry.IServicesRegistry;

public class DuccDataHelper {
    private static DuccDataHelper duccDataHelper = new DuccDataHelper();

    public static DuccDataHelper getInstance() {
        return duccDataHelper;
    }

    public TreeMap<String, ArrayList<DuccId>> getServiceToJobsUsageMap() {
        TreeMap<String, ArrayList<DuccId>> map = new TreeMap<String, ArrayList<DuccId>>();
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> jobs = duccData.getSortedJobs();
        for (JobInfo jobInfo : jobs.descendingKeySet()) {
            DuccWorkJob job = jobInfo.getJob();
            if (!job.isOperational()) continue;
            DuccId duccId = job.getDuccId();
            String[] dependencies = job.getServiceDependencies();
            if (dependencies == null) continue;
            for (String dependency : dependencies) {
                ArrayList<DuccId> duccIds;
                if (!map.containsKey(dependency)) {
                    map.put(dependency, new ArrayList());
                }
                if ((duccIds = map.get(dependency)).contains(duccId)) continue;
                duccIds.add(duccId);
            }
        }
        return map;
    }

    public static String[] parseWorkInstances(Properties meta) {
        String stringArray = meta.getProperty(IServicesRegistry.work_instances);
        return DuccDataHelper.parseStringArray(stringArray);
    }

    public static String[] parseImplementors(Properties meta) {
        String stringArray = meta.getProperty(IServicesRegistry.implementors);
        return DuccDataHelper.parseStringArray(stringArray);
    }

    public static String[] parseStringArray(String stringArray) {
        String[] ret = new String[]{};
        if (stringArray != null && (stringArray = stringArray.trim()).length() > 0) {
            String[] tempArray = stringArray.trim().split("\\s+");
            ret = new String[tempArray.length];
            int i = 0;
            for (String s : tempArray) {
                if (s.indexOf(".") > 0) {
                    String[] id_inst = s.split("\\.");
                    ret[i++] = id_inst[0].trim();
                    continue;
                }
                ret[i++] = s;
            }
        }
        return ret;
    }

    public static ArrayList<String> parseImplementorsAsList(Properties meta) {
        String[] impls = DuccDataHelper.parseImplementors(meta);
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : impls) {
            ret.add(s);
        }
        return ret;
    }

    public static ArrayList<String> parseWorkInstancesAsList(Properties meta) {
        String[] impls = DuccDataHelper.parseWorkInstances(meta);
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : impls) {
            ret.add(s);
        }
        return ret;
    }

    public TreeMap<String, ArrayList<DuccId>> getServiceToReservationsUsageMap() {
        TreeMap<String, ArrayList<DuccId>> map = new TreeMap<String, ArrayList<DuccId>>();
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> services = duccData.getSortedServices();
        block3: for (JobInfo jobInfo : services.descendingKeySet()) {
            IDuccWorkService.ServiceDeploymentType type;
            DuccWorkJob service = jobInfo.getJob();
            if (!service.isOperational() || (type = service.getServiceDeploymentType()) == null) continue;
            switch (type) {
                case other: {
                    DuccId duccId = service.getDuccId();
                    String[] dependencies = service.getServiceDependencies();
                    if (dependencies == null) break;
                    for (String dependency : dependencies) {
                        ArrayList<DuccId> duccIds;
                        if (!map.containsKey(dependency)) {
                            map.put(dependency, new ArrayList());
                        }
                        if ((duccIds = map.get(dependency)).contains(duccId)) continue;
                        duccIds.add(duccId);
                    }
                    continue block3;
                }
            }
        }
        return map;
    }

    public ArrayList<JobProcessInfo> getJobProcessInfoList(String nodeName) {
        ArrayList<JobProcessInfo> list = new ArrayList<JobProcessInfo>();
        if (nodeName != null) {
            DuccData duccData = DuccData.getInstance();
            ConcurrentSkipListMap<JobInfo, JobInfo> jobs = duccData.getSortedJobs();
            for (JobInfo jobInfo : jobs.descendingKeySet()) {
                DuccWorkJob job = jobInfo.getJob();
                if (!job.isOperational()) continue;
                DuccId jobid = job.getDuccId();
                IDuccProcessMap map = job.getProcessMap();
                for (DuccId procid : map.keySet()) {
                    NodeIdentity nodeIdentity;
                    String procNodeName;
                    IDuccProcess proc = (IDuccProcess)map.get((Object)procid);
                    if (proc.isComplete() || (procNodeName = (nodeIdentity = proc.getNodeIdentity()).getName()) == null || !nodeName.equals(procNodeName)) continue;
                    JobProcessInfo jpi = new JobProcessInfo();
                    jpi.jobId = jobid;
                    jpi.procid = procid;
                    list.add(jpi);
                }
            }
        }
        return list;
    }

    public ArrayList<JobProcessInfo> getJobProcessIds(ArrayList<String> nodes) {
        ArrayList<JobProcessInfo> list = new ArrayList<JobProcessInfo>();
        if (nodes != null) {
            for (String node : nodes) {
                ArrayList<JobProcessInfo> listForNode = this.getJobProcessInfoList(node);
                for (JobProcessInfo jpi : listForNode) {
                    list.add(jpi);
                }
            }
        }
        return list;
    }
}

