/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server.nodeviz;

import org.apache.uima.ducc.ws.server.nodeviz.JobFragment;
import org.apache.uima.ducc.ws.server.nodeviz.VisualizedHost;

public class Markup {
    private int XSCALE = 8;
    private int YSCALE = 8;
    private StringBuffer out = new StringBuffer();

    String close() {
        return this.out.toString();
    }

    void svgStart(float width, float height) {
        this.out.append("<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"" + height * (float)this.YSCALE + "\" width=\"" + width * (float)this.XSCALE + "\">");
    }

    void svgEnd() {
        this.out.append("</svg>");
    }

    void divStart(String id, int mem) {
        this.out.append("<div style=\"display:inline-block\" id=\"" + id + "\" mem=\"" + mem + "\">");
    }

    void divEnd() {
        this.out.append("</div>");
    }

    void tooltipStart(String label) {
        this.out.append("<g>\n<title>" + label + "</title>");
    }

    void tooltipEnd() {
        this.out.append("</g>");
    }

    void rect(float x, float y, float width, float height, String color, String borderColor, float strokeWidth, String newAttr) {
        if (newAttr == null) {
            newAttr = "";
        }
        this.out.append("<rect x=\"");
        this.out.append(x * (float)this.XSCALE);
        this.out.append("\" y=\"");
        this.out.append(y * (float)this.YSCALE);
        this.out.append("\" width=\"");
        this.out.append(width * (float)this.XSCALE);
        this.out.append("\" height=\"");
        this.out.append(height * (float)this.YSCALE);
        this.out.append("\"  fill=\"");
        this.out.append(color);
        this.out.append("\" stroke=\"");
        this.out.append(borderColor);
        this.out.append("\" stroke-width=\"");
        this.out.append(strokeWidth * (float)this.XSCALE);
        this.out.append("\"");
        this.out.append(newAttr);
        this.out.append("/> ");
    }

    void nodeLabel(float x, float y, String label) {
        this.out.append("<text x=\"");
        this.out.append(x * (float)this.XSCALE);
        this.out.append("\" y=\"");
        this.out.append(y * (float)this.YSCALE);
        this.out.append("\" font-family=\"helvetica\" font-size=\"10\" font-weight=\"bold\"");
        this.out.append(" text-anchor=\"middle\"");
        this.out.append(" fill=\"black\">");
        this.out.append(label);
        this.out.append("</text>");
    }

    void centeredText(float x, float y, String label, String color, int fontsize) {
        this.out.append("<text x=\"");
        this.out.append(Float.toString(x * (float)this.XSCALE));
        this.out.append("\" y=\"");
        this.out.append(Float.toString(y * (float)this.YSCALE));
        this.out.append("\" font-family=\"helvetica\" font-size=\"");
        this.out.append(Integer.toString(fontsize));
        this.out.append("\"  fill=\"");
        this.out.append(color);
        this.out.append("\"");
        this.out.append(" text-anchor=\"middle\"");
        this.out.append(">");
        this.out.append(label);
        this.out.append("</text>");
    }

    void text(float x, float y, String label, String color, int fontsize) {
        this.out.append("<text x=\"");
        this.out.append(Float.toString(x * (float)this.XSCALE));
        this.out.append("\" y=\"");
        this.out.append(Float.toString(y * (float)this.YSCALE));
        this.out.append("\" font-family=\"helvetica\" font-size=\"");
        this.out.append(Integer.toString(fontsize));
        this.out.append("\"  fill=\"");
        this.out.append(color);
        this.out.append("\"");
        this.out.append(">");
        this.out.append(label);
        this.out.append("</text>");
    }

    void hyperlinkStart(VisualizedHost host, JobFragment j) {
        switch (j.type) {
            case Job: {
                this.out.append("<a xlink:href=job.details.jsp?id=");
                this.out.append(j.id);
                this.out.append(">");
                break;
            }
            case Service: {
                this.out.append("<a xlink:href=/service.details.jsp?name=");
                this.out.append(j.service_endpoint);
                this.out.append(">");
                break;
            }
            case Pop: {
                this.out.append("<a xlink:href=/reservation.details.jsp?id=");
                this.out.append(j.id);
                this.out.append(">");
                break;
            }
            case Reservation: {
                this.out.append("<a xlink:href=/reservations.jsp>");
                break;
            }
            case Undefined: {
                this.out.append("<a>");
            }
        }
    }

    void hyperlinkEnd() {
        this.out.append("</a>");
    }

    void titleForFragment(VisualizedHost h, JobFragment j) {
        String jobtype = "" + j.type;
        switch (j.type) {
            case Pop: {
                jobtype = "Managed Reservation";
            }
            case Job: 
            case Service: {
                this.out.append("<title>");
                this.out.append(jobtype);
                this.out.append(" ");
                this.out.append(j.user);
                this.out.append(":");
                this.out.append(j.id);
                this.out.append(" runs ");
                this.out.append(j.nprocesses);
                this.out.append(" process(es) of ");
                this.out.append(j.mem);
                this.out.append("GB on host ");
                this.out.append(h.name);
                this.out.append("(");
                this.out.append(h.mem);
                this.out.append("GB)</title>");
                break;
            }
            case Reservation: {
                this.out.append("<title>");
                this.out.append(jobtype);
                this.out.append(" ");
                this.out.append(j.user);
                this.out.append(":");
                this.out.append(j.id);
                this.out.append(" on host ");
                this.out.append(h.name);
                this.out.append("(");
                this.out.append(j.mem);
                this.out.append("GB)</title>");
                break;
            }
            case Undefined: {
                this.out.append("<title>");
                this.out.append("mem avail (");
                this.out.append(j.qshares * j.quantum);
                this.out.append("GB) on ");
                this.out.append(h.name);
                this.out.append("(");
                this.out.append(h.mem);
                this.out.append("GB)</title>");
            }
        }
    }

    String patternedFill(JobFragment j) {
        String color = j.fillColor;
        switch (j.type) {
            case Job: {
                return color;
            }
            case Pop: {
                return this.popFill(j, color);
            }
            case Service: {
                return this.serviceFill(j, color);
            }
            case Reservation: {
                return this.reservationFill(j, color);
            }
        }
        return color;
    }

    String popFill(JobFragment j, String color) {
        String id = "patP" + j.id;
        this.out.append("<pattern id=\"");
        this.out.append(id);
        this.out.append("\" patternUnits=\"userSpaceOnUse\" x=\"0\" y=\"0\" width=\"4\" height=\"4\">");
        this.out.append("<g>");
        this.out.append("<line x1=\"-2\" y1=\"4\" x2=\"4\" y2=\"-2\" stroke=\"");
        this.out.append(color);
        this.out.append("\" stroke-width=\"2\" />");
        this.out.append("<line x1=\"0\" y1=\"6\" x2=\"6\" y2=\"0\" stroke=\"");
        this.out.append(color);
        this.out.append("\" stroke-width=\"2\" />");
        this.out.append("</g>");
        this.out.append("</pattern>");
        return "url(#" + id + ")";
    }

    String serviceFill(JobFragment j, String color) {
        String id = "patS" + j.id;
        this.out.append("<pattern id=\"");
        this.out.append(id);
        this.out.append("\" patternUnits=\"userSpaceOnUse\" x=\"0\" y=\"0\" width=\"4\" height=\"4\">");
        this.out.append("<g>");
        this.out.append("<line x1=\"0\" y1=\"-2\" x2=\"6\" y2=\"4\" stroke=\"");
        this.out.append(color);
        this.out.append("\" stroke-width=\"2\" />");
        this.out.append("<line x1=\"-2\" y1=\"0\" x2=\"4\" y2=\"6\" stroke=\"");
        this.out.append(color);
        this.out.append("\" stroke-width=\"2\" />");
        this.out.append("</g>");
        this.out.append("</pattern>");
        return "url(#" + id + ")";
    }

    String reservationFill(JobFragment j, String color) {
        String id = "patR" + j.id;
        this.out.append("<pattern id=\"");
        this.out.append(id);
        this.out.append("\" patternUnits=\"userSpaceOnUse\" x=\"0\" y=\"0\" width=\"4\" height=\"4\">");
        this.out.append("<g><rect x=\"0\" y=\"0\" width=\"3.7\" height=\"3.7\" style=\"fill:");
        this.out.append(color);
        this.out.append("; stroke:none\"/></g></pattern>");
        return "url(#" + id + ")";
    }
}

