/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.text.DecimalFormat;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;

public class DuccHandlerUtils {
    private static DecimalFormat formatter = new DecimalFormat("###0.0");
    private static double GB = Math.pow(10.0, 9.0);
    private static double MB = Math.pow(10.0, 6.0);
    private static double KB = Math.pow(10.0, 3.0);

    public static String warn(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append(text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String down() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append("down");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_green\">");
        sb.append("up");
        sb.append("</span>");
        return sb.toString();
    }

    public static String disabled() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("disabled");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up_provisional(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("up" + text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String unknown() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("unknown");
        sb.append("</span>");
        return sb.toString();
    }

    public static double getSwapSizeBytes(IDuccWorkJob job) {
        double swapBytes = job.getSwapUsageGb() * GB;
        if (job.isCompleted()) {
            swapBytes = job.getSwapUsageGbMax() * GB;
        }
        return swapBytes;
    }

    public static String getSwapSizeDisplay(double swapBytes) {
        String retVal = formatter.format(swapBytes / GB);
        return retVal;
    }

    public static String getSwapSizeHover(double swapBytes) {
        String retVal = null;
        retVal = swapBytes == 0.0 ? formatter.format(swapBytes / GB) + " " + "GB" : (swapBytes >= GB / 10.0 ? formatter.format(swapBytes / GB) + " " + "GB" : (swapBytes >= MB / 10.0 ? formatter.format(swapBytes / MB) + " " + "MB" : (swapBytes >= KB / 10.0 ? formatter.format(swapBytes / KB) + " " + "KB" : formatter.format(swapBytes) + " " + "Bytes")));
        return retVal;
    }
}

