/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;

public class DuccFile {
    public static Properties getUserSpecifiedProperties(EffectiveUser eu, IDuccWorkJob job) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "specified-by-user.properties";
        Properties properties = null;
        try {
            properties = DuccFile.getProperties(eu, directory + name);
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    public static Properties getFileSpecifiedProperties(EffectiveUser eu, IDuccWorkJob job) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "specified-by-file.properties";
        Properties properties = null;
        try {
            properties = DuccFile.getProperties(eu, directory + name);
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    public static Properties getJobProperties(EffectiveUser eu, IDuccWorkJob job) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "job-specification.properties";
        Properties properties = DuccFile.getProperties(eu, directory + name);
        return properties;
    }

    public static Properties getManagedReservationProperties(EffectiveUser eu, IDuccWorkJob job) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        try {
            String hack_name = "process.properties";
            Properties hack_properties = DuccFile.getProperties(eu, directory + hack_name);
            if (!hack_properties.isEmpty()) {
                return hack_properties;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "managed-reservation.properties";
        Properties properties = DuccFile.getProperties(eu, directory + name);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(EffectiveUser eu, String path) throws Throwable {
        StringReader sr = null;
        try {
            AlienFile alienFile = new AlienFile(eu.get(), path);
            String data = alienFile.getString();
            sr = new StringReader(data);
            Properties properties = new Properties();
            properties.load(sr);
            sr.close();
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    public static InputStreamReader getInputStreamReader(EffectiveUser eu, String path) throws Throwable {
        AlienFile alienFile = new AlienFile(eu.get(), path);
        return alienFile.getInputStreamReader();
    }
}

