/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccWebSessionManager;

public class HandlersHelper {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)HandlersHelper.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    public static DuccWebAdministrators duccWebAdministrators = DuccWebAdministrators.getInstance();
    public static DuccWebSessionManager duccWebSessionManager = DuccWebSessionManager.getInstance();

    private static boolean match(String s1, String s2) {
        String methodName = "match";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        if (s1 != null && s2 != null && s1.trim().equals(s2.trim())) {
            retVal = true;
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static AuthorizationStatus getAuthorizationStatus(HttpServletRequest request, String resourceOwnerUserid) {
        String methodName = "getAuthorizationStatus";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        AuthorizationStatus retVal = AuthorizationStatus.NotLoggedIn;
        try {
            String text = "";
            boolean authenticated = duccWebSessionManager.isAuthentic(request);
            String userId = duccWebSessionManager.getUserId(request);
            if (authenticated) {
                if (HandlersHelper.match(resourceOwnerUserid, userId)) {
                    text = "user " + userId + " is resource owner";
                    retVal = AuthorizationStatus.LoggedInOwner;
                } else {
                    DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                    switch (requestRole) {
                        case User: {
                            text = "user " + userId + " is not resource owner " + resourceOwnerUserid;
                            retVal = AuthorizationStatus.LoggedInNotOwner;
                            break;
                        }
                        case Administrator: {
                            if (duccWebAdministrators.isAdministrator(userId)) {
                                text = "user " + userId + " is administrator";
                                retVal = AuthorizationStatus.LoggedInAdministrator;
                                break;
                            }
                            text = "user " + userId + " is not administrator ";
                            retVal = AuthorizationStatus.LoggedInNotAdministrator;
                        }
                    }
                }
            } else {
                text = "user " + userId + " is not authenticated";
                retVal = AuthorizationStatus.NotLoggedIn;
            }
            duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static boolean isUserAuthorized(HttpServletRequest request, String resourceOwnerUserid) {
        String methodName = "isUserAuthorized";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        try {
            AuthorizationStatus authorizationStatus = HandlersHelper.getAuthorizationStatus(request, resourceOwnerUserid);
            switch (authorizationStatus) {
                case LoggedInOwner: 
                case LoggedInAdministrator: {
                    retVal = true;
                    break;
                }
                case LoggedInNotOwner: 
                case LoggedInNotAdministrator: 
                case NotLoggedIn: {
                    break;
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static enum AuthorizationStatus {
        LoggedInOwner,
        LoggedInAdministrator,
        LoggedInNotOwner,
        LoggedInNotAdministrator,
        NotLoggedIn;

    }
}

