/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server.nodeviz;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.IListenerOrchestrator;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.server.DuccListeners;
import org.apache.uima.ducc.ws.server.nodeviz.Markup;
import org.apache.uima.ducc.ws.server.nodeviz.VisualizedHost;

public class NodeViz
implements IListenerOrchestrator {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)NodeViz.class.getName());
    private DuccMachinesData machineData;
    private String visualization;
    private long update_interval = 60000L;
    private String version = "1.1.0";
    static int quantum = 4;
    static String wshost = "";
    static String wsport = "42133";
    static boolean strip_domain = true;

    public NodeViz() {
        String methodName = "NodeViz";
        this.update_interval = SystemPropertyResolver.getLongProperty((String)"ducc.viz.update.interval", (long)this.update_interval);
        quantum = SystemPropertyResolver.getIntProperty((String)"ducc.rm.share.quantum", (int)quantum);
        wshost = SystemPropertyResolver.getStringProperty((String)"ducc.ws.node", (String)System.getProperty("ducc.head"));
        wsport = SystemPropertyResolver.getStringProperty((String)"ducc.ws.port", (String)wsport);
        strip_domain = SystemPropertyResolver.getBooleanProperty((String)"ducc.ws.visualization.strip.domain", (boolean)true);
        logger.info(methodName, null, new Object[]{"------------------------------------------------------------------------------------"});
        logger.info(methodName, null, new Object[]{"Node Visualization starting:"});
        logger.info(methodName, null, new Object[]{"    DUCC home               : ", System.getProperty("DUCC_HOME")});
        logger.info(methodName, null, new Object[]{"    ActiveMQ URL            : ", System.getProperty("ducc.broker.url")});
        logger.info(methodName, null, new Object[]{"Using Share Quantum         : ", quantum});
        logger.info(methodName, null, new Object[]{"Viz update Interval         : ", this.update_interval});
        logger.info(methodName, null, new Object[]{"Web Server Host             : ", wshost});
        logger.info(methodName, null, new Object[]{"Web Server Port             : ", wsport});
        logger.info(methodName, null, new Object[]{"Strip Domains               : ", strip_domain});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    JVM                     : ", System.getProperty("java.vendor") + " " + System.getProperty("java.version")});
        logger.info(methodName, null, new Object[]{"    JAVA_HOME               : ", System.getProperty("java.home")});
        logger.info(methodName, null, new Object[]{"    JVM Path                : ", System.getProperty("ducc.jvm")});
        logger.info(methodName, null, new Object[]{"    JMX URL                 : ", System.getProperty("ducc.jmx.url")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    OS Architecture         : ", System.getProperty("os.arch")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    DUCC Version            : ", Version.version()});
        logger.info(methodName, null, new Object[]{"    Vizualization Version   : ", this.version});
        logger.info(methodName, null, new Object[]{"------------------------------------------------------------------------------------"});
        DuccListeners.getInstance().register(this);
        this.machineData = DuccMachinesData.getInstance();
        this.visualization = "<html><p>Waiting for node updates ...</p></html>";
    }

    public String getVisualization() {
        String methodName = "getVisualization";
        logger.debug(methodName, null, new Object[]{"Request for visualization"});
        return this.visualization;
    }

    public void generateVisualization(OrchestratorStateDuccEvent ev) {
        String methodName = "generateVisualization";
        HashMap<String, VisualizedHost> hosts = new HashMap<String, VisualizedHost>();
        IDuccWorkMap jobmap = ev.getWorkMap();
        int job_shares = 0;
        int service_shares = 0;
        int pop_shares = 0;
        int reservation_shares = 0;
        block9: for (Object o : jobmap.values()) {
            IDuccWork w = (IDuccWork)o;
            IDuccTypes.DuccType type = w.getDuccType();
            String service_endpoint = null;
            String service_id = null;
            if (type == IDuccTypes.DuccType.Service) {
                IDuccWorkService dws = (IDuccWorkService)w;
                if (dws.getServiceDeploymentType() == IDuccWorkService.ServiceDeploymentType.other) {
                    type = IDuccTypes.DuccType.Pop;
                } else {
                    service_endpoint = dws.getServiceEndpoint();
                    service_id = dws.getServiceId();
                }
            }
            if (!w.isSchedulable()) {
                logger.debug(methodName, w.getDuccId(), new Object[]{"Ignoring unschedulable work:", w.getDuccType(), ":", w.getStateObject()});
                continue;
            }
            IDuccStandardInfo si = w.getStandardInfo();
            IDuccSchedulingInfo sti = w.getSchedulingInfo();
            String user = si.getUser();
            String duccid = service_id == null ? Long.toString(w.getDuccId().getFriendly()) : service_id;
            int jobmem = Integer.parseInt(sti.getShareMemorySize());
            int qshares = jobmem / quantum;
            if (jobmem % quantum != 0) {
                ++qshares;
            }
            switch (type) {
                case Job: 
                case Pop: 
                case Service: {
                    IDuccWorkExecutable de = (IDuccWorkExecutable)w;
                    IDuccProcessMap pm = de.getProcessMap();
                    logger.debug(methodName, w.getDuccId(), new Object[]{"Receive:", type, w.getStateObject(), "processes[", pm.size() + "]"});
                    for (IDuccProcess proc : pm.values()) {
                        String pid = proc.getPID();
                        IProcessState.ProcessState state = proc.getProcessState();
                        Node n = proc.getNode();
                        logger.debug(methodName, w.getDuccId(), new Object[]{n == null ? "N/A" : n.getNodeIdentity().getName(), "Process[", pid, "] state [", state, "] is complete[", proc.isComplete(), "]"});
                        if (proc.isComplete()) continue;
                        switch (type) {
                            case Job: {
                                job_shares += qshares;
                                break;
                            }
                            case Pop: {
                                pop_shares += qshares;
                                break;
                            }
                            case Service: {
                                service_shares += qshares;
                            }
                        }
                        if (n == null) continue;
                        String key = NodeViz.strip(n.getNodeIdentity().getName());
                        VisualizedHost vh = (VisualizedHost)hosts.get(key);
                        if (vh == null) {
                            vh = new VisualizedHost(n, quantum);
                            hosts.put(key, vh);
                        }
                        vh.addWork(type, user, duccid, jobmem, qshares, service_endpoint);
                    }
                    continue block9;
                }
                case Reservation: {
                    IDuccWorkExecutable de = (IDuccWorkReservation)w;
                    IDuccReservationMap rm = de.getReservationMap();
                    logger.debug(methodName, w.getDuccId(), new Object[]{"Receive:", type, w.getStateObject(), "processes[", rm.size(), "] Completed:", w.isCompleted()});
                    reservation_shares += qshares;
                    for (IDuccReservation r : rm.values()) {
                        Node n = r.getNode();
                        if (n == null) {
                            logger.debug(methodName, w.getDuccId(), new Object[]{"Node [N/A] mem[N/A"});
                            continue;
                        }
                        String key = NodeViz.strip(n.getNodeIdentity().getName());
                        VisualizedHost vh = (VisualizedHost)hosts.get(key);
                        if (vh == null) {
                            vh = new VisualizedHost(n, quantum);
                            hosts.put(key, vh);
                        }
                        vh.addWork(type, user, duccid, jobmem, qshares, null);
                    }
                    continue block9;
                }
                default: {
                    logger.warn(methodName, w.getDuccId(), new Object[]{"Received work of type ?", w.getDuccType()});
                }
            }
        }
        logger.debug(methodName, null, new Object[]{"Generateing visualizaiton"});
        ConcurrentSkipListMap<String, MachineInfo> m = this.machineData.getMachines();
        for (String s : m.keySet()) {
            String key;
            MachineInfo mi = m.get(s);
            if (mi == null || !mi.getStatus().equals("up") || hosts.containsKey(key = NodeViz.strip(s))) continue;
            VisualizedHost vh = new VisualizedHost(mi, quantum);
            hosts.put(key, vh);
        }
        int total_shares = 0;
        int total_ram = 0;
        Markup markup = new Markup();
        VisualizedHost[] sorted = hosts.values().toArray(new VisualizedHost[hosts.size()]);
        Arrays.sort(sorted, new HostSorter());
        for (VisualizedHost vh : sorted) {
            vh.toSvg(markup);
            total_shares += vh.countShares();
            total_ram += vh.countRam();
        }
        String page = markup.close();
        int unoccupied_shares = total_shares - (job_shares + pop_shares + service_shares + reservation_shares);
        this.visualization = "<html><div id=\"viz-header\" style=\"text-align:center\">Sort By <i onclick=\"ducc_viz_node_sorter('size')\" id=\"ducc-viz-sort-size\" style=\"color:red\">Size </i><i onclick=\"ducc_viz_node_sorter('name')\" id=\"ducc-viz-sort-name\"\">Name</i></br><b>Shares of size " + quantum + "GB: </b>" + total_shares + ", <b>Jobs: </b>" + job_shares + ", <b>Services: </b>" + service_shares + ", <b>Managed Reservations: </b>" + pop_shares + ", <b>Reservations: </b>" + reservation_shares + ", <b>Unoccupied: </b>" + unoccupied_shares + "<br><i><small>" + "<b>RAM Total:</b> " + total_ram + "GB, <b>For shares:</b> " + total_shares * quantum + "GB, <b>Jobs:</b> " + job_shares * quantum + "GB, <b>Services:</b> " + service_shares * quantum + "GB, <b>Managed Reservations:</b> " + pop_shares * quantum + "GB, <b>Reservations:</b> " + reservation_shares * quantum + "GB, <b>Unoccupied:</b> " + unoccupied_shares * quantum + "GB</small></i>" + "</div>" + "<br>" + "<div id=\"nodelist\" style=\"background-color:eeeeee;padding:3\">" + page + "</div>" + "<script>" + "ducc_viz_onreload();" + "</script>" + "</html>";
        hosts = null;
    }

    static String strip(String n) {
        int ndx;
        if (strip_domain && (ndx = n.indexOf(".")) >= 0) {
            n = n.substring(0, ndx);
        }
        return n;
    }

    @Override
    public void update(OrchestratorStateDuccEvent ev) {
        String methodName = "update";
        logger.debug(methodName, null, new Object[]{"Received Orchestrator Event"});
        this.generateVisualization(ev);
    }

    private static class HostSorter
    implements Comparator<VisualizedHost> {
        private HostSorter() {
        }

        @Override
        public int compare(VisualizedHost h1, VisualizedHost h2) {
            if (h1 == h2) {
                return 0;
            }
            if (h1.equals(h2)) {
                return 0;
            }
            if (h2.mem == h1.mem) {
                return h1.name.compareTo(h2.name);
            }
            return h2.mem - h1.mem;
        }
    }
}

