/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.standardize.WsStandardize;

public class DuccWebServerHelper {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccWebServerHelper.class.getName());
    private static DuccId jobid = null;
    public static String ducc_web_default = ".";

    public static String getDuccWeb() {
        String location = "getDuccWeb";
        String ducc_web = ducc_web_default;
        String ducc_web_property = System.getProperty("DUCC_WEB");
        String ducc_web_env = System.getenv("DUCC_WEB");
        if (ducc_web_property != null) {
            ducc_web = ducc_web_property;
            logger.debug(location, jobid, new Object[]{WsStandardize.Label.DUCC_WEB_PROPERTY.get() + ducc_web});
        } else if (ducc_web_env != null) {
            ducc_web = ducc_web_env;
            logger.debug(location, jobid, new Object[]{WsStandardize.Label.DUCC_WEB_ENV.get() + ducc_web});
        } else {
            logger.debug(location, jobid, new Object[]{WsStandardize.Label.DUCC_WEB.get() + ducc_web});
        }
        return ducc_web;
    }

    public static String getDuccWebRoot() {
        String rootDir = DuccWebServerHelper.getDuccWeb() + File.separator + "root";
        return rootDir;
    }

    public static String getDuccWebKeyStore() {
        String rootDir = DuccWebServerHelper.getDuccWeb() + File.separator + "etc" + File.separator + "keystore";
        return rootDir;
    }

    private static boolean exists(String fileName) {
        boolean retVal = false;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                retVal = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getImageFileName(String key) {
        String location = "getImageFileName";
        String retVal = null;
        if (key != null) {
            String relativeFileName = "resources" + File.separator + "image-map.properties";
            try {
                String relativeFilePath;
                String fileName = DuccWebServerHelper.getDuccWebRoot() + File.separator + relativeFileName;
                File file = new File(fileName);
                FileInputStream fis = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fis);
                fis.close();
                String rootFilePath = relativeFilePath = properties.getProperty(key);
                if (rootFilePath != null && rootFilePath.trim().length() > 0) {
                    rootFilePath = DuccWebServerHelper.getDuccWebRoot() + File.separator + rootFilePath;
                }
                if (DuccWebServerHelper.exists(rootFilePath)) {
                    retVal = relativeFilePath;
                    logger.debug(location, jobid, new Object[]{key + "=" + retVal});
                } else {
                    logger.debug(location, jobid, new Object[]{relativeFilePath + " not found"});
                }
            }
            catch (FileNotFoundException e) {
                logger.debug(location, jobid, new Object[]{relativeFileName + " not found"});
            }
            catch (IOException e) {
                logger.debug(location, jobid, new Object[]{relativeFileName + " load error"});
            }
        }
        return retVal;
    }
}

