/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.common.CancelReasons;
import org.apache.uima.ducc.common.json.MonitorInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.ws.authentication.DuccAsUser;
import org.apache.uima.ducc.ws.server.TrackingInfo;

public class DuccWebMonitorJob {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccWebMonitorJob.class.getName());
    private static DuccId jobid = null;
    private ConcurrentHashMap<DuccId, MonitorInfo> mMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DuccId, TrackingInfo> tMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DuccId, Long> cMap = new ConcurrentHashMap();
    private long millisPerMinute = 60000L;
    private long timeoutMillis;

    protected DuccWebMonitorJob(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    protected void monitor(OrchestratorStateDuccEvent duccEvent) {
        String location = "monitor";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        DuccWorkMap dwm = duccEvent.getWorkMap();
        int size = dwm.getJobKeySet().size();
        duccLogger.debug(location, jobid, new Object[]{"jobs: " + size});
        ArrayList<DuccId> gone = new ArrayList<DuccId>();
        for (DuccId duccId : this.mMap.keySet()) {
            gone.add(duccId);
        }
        long expiryMillis = System.currentTimeMillis() + this.timeoutMillis + 1L;
        for (DuccId duccId : dwm.getJobKeySet()) {
            String text;
            IRationale rationale;
            String state;
            ArrayList stateSequence;
            IDuccWork dw = dwm.findDuccWork(duccId);
            gone.remove(duccId);
            if (!this.mMap.containsKey(duccId)) {
                MonitorInfo monitorInfo = new MonitorInfo();
                this.mMap.put(duccId, monitorInfo);
                duccLogger.info(location, duccId, new Object[]{"monitor start"});
                if (!this.tMap.containsKey(duccId)) {
                    if (dw.isCancelOnInterrupt()) {
                        TrackingInfo ti = new TrackingInfo();
                        ti.time = expiryMillis;
                        ti.user = dw.getStandardInfo().getUser();
                        this.tMap.put(duccId, ti);
                        duccLogger.info(location, duccId, new Object[]{"auto-cancel on"});
                    } else {
                        duccLogger.info(location, duccId, new Object[]{"auto-cancel off"});
                    }
                }
            }
            DuccWorkJob dwj = (DuccWorkJob)dw;
            MonitorInfo monitorInfo = this.mMap.get(duccId);
            IDuccSchedulingInfo si = dw.getSchedulingInfo();
            monitorInfo.total = si.getWorkItemsTotal();
            monitorInfo.done = si.getWorkItemsCompleted();
            monitorInfo.error = "" + si.getIntWorkItemsError();
            monitorInfo.retry = si.getWorkItemsRetry();
            monitorInfo.lost = si.getWorkItemsLost();
            monitorInfo.procs = "" + dwj.getProcessMap().getAliveProcessCount();
            if (si.getIntWorkItemsError() > 0) {
                String logsjobdir = dwj.getUserLogsDir() + dwj.getDuccId().getFriendly() + File.separator;
                String logfile = "jd.err.log";
                ArrayList<String> errorLogs = new ArrayList<String>();
                errorLogs.add(logsjobdir + logfile);
                monitorInfo.errorLogs = errorLogs;
            }
            if (!(stateSequence = monitorInfo.stateSequence).contains(state = dwj.getJobState().toString())) {
                duccLogger.info(location, duccId, new Object[]{"state: " + state});
                stateSequence.add(state);
            }
            if ((rationale = dwj.getCompletionRationale()) == null || !rationale.isSpecified() || (text = rationale.getText()) == null) continue;
            monitorInfo.rationale = text;
        }
        for (DuccId duccId : gone) {
            this.mMap.remove(duccId);
            this.tMap.remove(duccId);
            duccLogger.info(location, duccId, new Object[]{"monitor stop"});
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    protected DuccId getKey(String jobId) {
        DuccId retVal = null;
        Enumeration<DuccId> keys = this.mMap.keys();
        while (keys.hasMoreElements()) {
            DuccId duccId = keys.nextElement();
            String mapId = "" + duccId.getFriendly();
            if (!mapId.equals(jobId)) continue;
            retVal = duccId;
            break;
        }
        return retVal;
    }

    public MonitorInfo renew(String jobId, AtomicInteger updateCounter) {
        int countAtArrival;
        String location = "renew";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        MonitorInfo monitorInfo = new MonitorInfo();
        int countAtPresent = countAtArrival = updateCounter.get();
        int sleepSecondsMax = 180;
        DuccId duccId = this.getKey(jobId);
        if (duccId == null) {
            int sleepSeconds = 0;
            duccLogger.info(location, duccId, new Object[]{"Waiting for update..."});
            while (duccId == null) {
                try {
                    duccLogger.debug(location, duccId, new Object[]{"Waiting continues..."});
                    Thread.sleep(1000L);
                    if (++sleepSeconds > sleepSecondsMax || (countAtPresent = updateCounter.get()) - countAtArrival > 2) break;
                    duccId = this.getKey(jobId);
                }
                catch (Exception e) {}
            }
            duccLogger.info(location, duccId, new Object[]{"Waiting complete."});
            duccId = this.getKey(jobId);
        }
        if (duccId != null) {
            monitorInfo = this.mMap.get(duccId);
            if (this.tMap.containsKey(duccId)) {
                long expiryMillis = System.currentTimeMillis() + this.timeoutMillis + 1L;
                TrackingInfo ti = this.tMap.get(duccId);
                ti.time = expiryMillis;
                duccLogger.info(location, duccId, new Object[]{"auto-cancel expiry extended"});
            }
        } else {
            try {
                int iJobId = Integer.parseInt(jobId);
                duccId = new DuccId((long)iJobId);
                duccLogger.info(location, duccId, new Object[]{"not found"});
            }
            catch (Exception e) {
                duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
        return monitorInfo;
    }

    protected Long getExpiry(DuccId duccId) {
        ConcurrentHashMap<DuccId, Long> eMap;
        String location = "getExpiry";
        duccLogger.trace(location, duccId, new Object[]{"enter"});
        Long retVal = null;
        if (!this.isCanceled(duccId) && this.isCancelable(duccId) && (eMap = this.getExpiryMap()).containsKey(duccId)) {
            retVal = eMap.get(duccId);
        }
        duccLogger.trace(location, duccId, new Object[]{"exit"});
        return retVal;
    }

    public ConcurrentHashMap<DuccId, Long> getExpiryMap() {
        String location = "getExpiryMap";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        ConcurrentHashMap<DuccId, Long> eMap = new ConcurrentHashMap<DuccId, Long>();
        long nowMillis = System.currentTimeMillis();
        Enumeration<DuccId> keys = this.tMap.keys();
        while (keys.hasMoreElements()) {
            long minutesLeft = 0L;
            DuccId duccId = keys.nextElement();
            TrackingInfo ti = this.tMap.get(duccId);
            long expiryMillis = ti.time;
            if (nowMillis < expiryMillis) {
                minutesLeft = (expiryMillis - nowMillis) / this.millisPerMinute;
            }
            eMap.put(duccId, minutesLeft);
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
        return eMap;
    }

    protected boolean isCanceled(DuccId duccId) {
        return this.cMap.containsKey(duccId);
    }

    private boolean isCancelable(DuccId duccId) {
        String location = "isCancelable";
        duccLogger.trace(location, duccId, new Object[]{"enter"});
        boolean retVal = false;
        if (!this.cMap.containsKey(duccId)) {
            MonitorInfo monitorInfo = this.mMap.get(duccId);
            if (monitorInfo != null) {
                ArrayList stateSequence = monitorInfo.stateSequence;
                if (stateSequence != null) {
                    if (stateSequence.contains(IDuccState.JobState.Completing.toString())) {
                        duccLogger.debug(location, duccId, new Object[]{"state: <uncancelable> " + stateSequence});
                    } else if (stateSequence.contains(IDuccState.JobState.Completed.toString())) {
                        duccLogger.debug(location, duccId, new Object[]{"state: <uncancelable> " + stateSequence});
                    } else {
                        duccLogger.debug(location, duccId, new Object[]{"state: <cancelable> " + stateSequence});
                        retVal = true;
                    }
                } else {
                    duccLogger.warn(location, duccId, new Object[]{"stateSequence: <null>"});
                }
            } else {
                duccLogger.warn(location, duccId, new Object[]{"monitorInfo: <null>"});
            }
        } else {
            duccLogger.debug(location, duccId, new Object[]{"already canceled"});
        }
        duccLogger.trace(location, duccId, new Object[]{"exit"});
        return retVal;
    }

    protected void cancel(DuccId duccId, String userId) {
        String location = "cancel";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        duccLogger.info(location, duccId, new Object[]{userId});
        String java = "/bin/java";
        String jhome = System.getProperty("java.home");
        String cp = System.getProperty("java.class.path");
        String jclass = "org.apache.uima.ducc.cli.DuccJobCancel";
        String arg1 = "--" + JobRequestProperties.key_id;
        String arg2 = "" + duccId;
        String arg3 = "--" + SpecificationProperties.key_reason;
        String reason = CancelReasons.CancelReason.MonitorPingOverdue.getText();
        String arg4 = "\"" + reason + "\"";
        String[] arglistUser = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3, arg4};
        String result = DuccAsUser.duckling(userId, arglistUser);
        duccLogger.warn(location, duccId, new Object[]{result});
        this.cMap.put(duccId, new Long(System.currentTimeMillis()));
        this.tMap.remove(duccId);
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    protected void canceler(long nowMillis) {
        String location = "canceler";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        Enumeration<DuccId> keys = this.tMap.keys();
        while (keys.hasMoreElements()) {
            DuccId duccId = keys.nextElement();
            TrackingInfo ti = this.tMap.get(duccId);
            long expiryMillis = ti.time;
            if (nowMillis <= expiryMillis) continue;
            if (this.isCancelable(duccId)) {
                this.cancel(duccId, ti.user);
                continue;
            }
            duccLogger.debug(location, duccId, new Object[]{"not cancelable"});
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }
}

