/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.cli.ws.json.ReservationFacts;
import org.apache.uima.ducc.cli.ws.json.ReservationFactsList;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.ComponentHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.Constants;
import org.apache.uima.ducc.transport.event.DbComponentPropertiesHelper;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.Info;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.ReservationInfo;
import org.apache.uima.ducc.ws.broker.BrokerHelper;
import org.apache.uima.ducc.ws.broker.EntityInfo;
import org.apache.uima.ducc.ws.registry.ServiceInterpreter;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.ServicesHelper;
import org.apache.uima.ducc.ws.registry.sort.ServicesSortCache;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccHandlerUtils;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.eclipse.jetty.server.Request;

public class DuccHandlerJsonFormat
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerJsonFormat.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    private final String jsonFormatJobsAaData = "/ducc-servlet/json-format-aaData-jobs";
    private final String jsonFormatReservationsAaData = "/ducc-servlet/json-format-aaData-reservations";
    private final String jsonFormatServicesAaData = "/ducc-servlet/json-format-aaData-services";
    private final String jsonFormatMachinesAaData = "/ducc-servlet/json-format-aaData-machines";
    private final String jsonFormatBrokerAaData = "/ducc-servlet/json-format-aaData-broker";
    private final String jsonFormatClassesAaData = "/ducc-servlet/json-format-aaData-classes";
    private final String jsonFormatDaemonsAaData = "/ducc-servlet/json-format-aaData-daemons";
    private final String jsonFormatMachines = "/ducc-servlet/json-format-machines";
    private final String jsonFormatReservations = "/ducc-servlet/json-format-reservations";
    private static DecimalFormat formatter = new DecimalFormat("##0.0");
    private static DecimalFormat formatter3 = new DecimalFormat("##0.000");
    private static String Topic = "Topic";

    public DuccHandlerJsonFormat(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    public String getFileName() {
        return this.dir_home + File.separator + this.dir_resources + File.separator + this.getDuccWebServer().getClassDefinitionFile();
    }

    private JsonArray buildJobRow(HttpServletRequest request, IDuccWorkJob job, DuccData duccData, long now, ServicesRegistry servicesRegistry) {
        String decoratedDuration;
        String duration;
        String type = "Job";
        JsonArray row = new JsonArray();
        DuccId duccId = job.getDuccId();
        StringBuffer sb = new StringBuffer();
        String id = this.normalize(duccId);
        sb.append("<span class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !job.isFinished()) {
            sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_job(" + id + ")\" value=\"Terminate\" " + this.getDisabledWithHover(request, (IDuccWork)job) + "/>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append("<a href=\"job.details.html?id=" + id + "\">" + id + "</a>");
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, job.getDuccId(), job.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        if (job.isCompleted()) {
            duration = this.getDuration(request, (IDuccWork)job, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span>");
            sb.append(decoratedDuration);
            sb.append("</span>");
        } else {
            duration = this.getDuration(request, (IDuccWork)job, now, FormatHelper.Precision.Whole);
            decoratedDuration = this.decorateDuration(request, job, duration, FormatHelper.Precision.Whole);
            sb.append("<span class=\"health_green\">");
            sb.append(decoratedDuration);
            sb.append("</span>");
            String projection = this.getProjection(request, job, FormatHelper.Precision.Whole);
            sb.append(projection);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String title = "";
        String submitter = job.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\" ";
        }
        sb.append("<span " + title + ">");
        sb.append(job.getStandardInfo().getUser());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String schedulingClass = this.stringNormalize(job.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"));
        long debugPortDriver = job.getDebugPortDriver();
        long debugPortProcess = job.getDebugPortProcess();
        title = "debug ports:";
        if (debugPortDriver >= 0L) {
            title = title + " driver=" + debugPortDriver;
        }
        if (debugPortProcess >= 0L) {
            title = title + " process=" + debugPortProcess;
        }
        switch (DuccCookies.getDisplayStyle(request)) {
            default: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\">DEBUG</div>");
                sb.append("</span>");
                break;
            }
            case Visual: {
                sb.append(schedulingClass);
                if (debugPortDriver < 0L && debugPortProcess < 0L) break;
                sb.append("<br>");
                if (job.isCompleted()) {
                    sb.append("<span class=\"health_red\">");
                } else {
                    sb.append("<span class=\"health_green\">");
                }
                sb.append("<div title=\"" + title + "\"><img src=\"./opensources/images/Delena-cancerides-huntsman-spider.jpg\"></div>");
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String state = job.getStateObject().toString();
        sb.append("<span>");
        if (duccData.isLive(duccId)) {
            if (job.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
            sb.append(state);
            sb.append("</span>");
        } else {
            sb.append("<span class=\"historic_state\">");
            sb.append(state);
            sb.append("</span>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = this.getReason(job, IDuccTypes.DuccType.Job);
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append(this.evaluateServices(job, servicesRegistry));
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (duccData.isLive(duccId)) {
            sb.append(job.getProcessMap().getAliveProcessCount());
        } else {
            sb.append("0");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        long initFails = job.getProcessInitFailureCount();
        if (initFails > 0L) {
            if (job.getSchedulingInfo().getLongSharesMax() < 0L) {
                switch (DuccCookies.getDisplayStyle(request)) {
                    default: {
                        sb.append(this.buildInitializeFailuresLink(job));
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<sup>");
                        sb.append("<small>");
                        sb.append("capped");
                        sb.append("</small>");
                        sb.append("<sup>");
                        sb.append("</span>");
                        sb.append("<br>");
                        break;
                    }
                    case Visual: {
                        sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                        sb.append("<img src=\"./opensources/images/propeller_hat_small.svg.png\">");
                        sb.append("</span>");
                        sb.append("<br>");
                        sb.append(this.buildInitializeFailuresLink(job));
                        break;
                    }
                }
            } else {
                sb.append(this.buildInitializeFailuresLink(job));
            }
        } else {
            sb.append("" + initFails);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(this.buildRuntimeFailuresLink(job));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        long pgin = job.getPgInCount();
        sb.append("" + pgin);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        DecimalFormat formatter = new DecimalFormat("###0.0");
        sb = new StringBuffer();
        sb.append("<span>");
        double swap = job.getSwapUsageGb();
        if (job.isCompleted()) {
            swap = job.getSwapUsageGbMax();
        }
        String displaySwapMax = formatter.format(swap);
        sb.append(displaySwapMax);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        String size = job.getSchedulingInfo().getShareMemorySize();
        IDuccUnits.MemoryUnits units = job.getSchedulingInfo().getShareMemoryUnits();
        sb.append(this.getProcessMemorySize(duccId, type, size, units));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsTotal());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        IDuccPerWorkItemStatistics perWorkItemStatistics = job.getSchedulingInfo().getPerWorkItemStatistics();
        String done = job.getSchedulingInfo().getWorkItemsCompleted();
        if (perWorkItemStatistics != null) {
            double max = (double)Math.round(perWorkItemStatistics.getMax() / 100.0) / 10.0;
            double min = (double)Math.round(perWorkItemStatistics.getMin() / 100.0) / 10.0;
            double avg = (double)Math.round(perWorkItemStatistics.getMean() / 100.0) / 10.0;
            double dev = (double)Math.round(perWorkItemStatistics.getStandardDeviation() / 100.0) / 10.0;
            done = "<span title=\"seconds-per-work-item Max:" + max + " " + "Min:" + min + " " + "Avg:" + avg + " " + "Dev:" + dev + "\"" + ">" + done + "</span>";
        }
        sb.append(done);
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(this.buildErrorLink(job));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String d0 = "<span>";
        String d1 = "0";
        String d2 = "</span>";
        if (duccData.isLive(duccId)) {
            int dispatch = 0;
            int unassigned = job.getSchedulingInfo().getCasQueuedMap().size();
            try {
                dispatch = Integer.parseInt(job.getSchedulingInfo().getWorkItemsDispatched()) - unassigned;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dispatch < 0) {
                d0 = "<span class=\"health_red\" title=\"unassigned location count: " + (0 - dispatch) + "\">";
            } else {
                d1 = "" + dispatch;
            }
        }
        sb.append(d0);
        sb.append(d1);
        sb.append(d2);
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsRetry());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(job.getSchedulingInfo().getWorkItemsPreempt());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String description = this.stringNormalize(job.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        return row;
    }

    private void handleServletJsonFormatJobsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatJobsAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        long now = System.currentTimeMillis();
        int maxRecords = this.getJobsMax(request);
        ArrayList<String> users = this.getJobsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> sortedJobs = duccData.getSortedJobs();
        if (sortedJobs.size() > 0) {
            Iterator<Map.Entry<JobInfo, JobInfo>> iterator = sortedJobs.entrySet().iterator();
            int counter = 0;
            while (iterator.hasNext()) {
                JobInfo jobInfo = iterator.next().getValue();
                DuccWorkJob job = jobInfo.getJob();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, (IDuccWork)job);
                if (!list) continue;
                ++counter;
                JsonArray row = this.buildJobRow(request, (IDuccWorkJob)job, duccData, now, servicesRegistry);
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            if (DuccData.getInstance().isPublished()) {
                row.add((JsonElement)new JsonPrimitive("no jobs"));
            } else {
                row.add((JsonElement)new JsonPrimitive("no data"));
            }
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private JsonArray buildReservationRow(HttpServletRequest request, IDuccWork duccwork, DuccData duccData, long now) {
        String node;
        Integer count;
        String decoratedDuration;
        String duration;
        String type = "Reservation";
        JsonArray row = new JsonArray();
        String reservationType = "Unmanaged";
        if (duccwork instanceof DuccWorkJob) {
            reservationType = "Managed";
        }
        DuccId duccId = duccwork.getDuccId();
        StringBuffer sb = new StringBuffer();
        String id = this.normalize(duccId);
        sb.append("<span class=\"ducc-col-terminate\">");
        if (this.terminateEnabled && !duccwork.isCompleted()) {
            DuccPropertiesResolver dpr;
            String jdHostUser;
            String disabled = this.getDisabledWithHover(request, duccwork);
            String user = duccwork.getStandardInfo().getUser();
            if (user != null && user.equals(jdHostUser = (dpr = DuccPropertiesResolver.getInstance()).getCachedProperty("ducc.jd.host.user"))) {
                disabled = "disabled=\"disabled\"";
            }
            sb.append("<input type=\"button\" onclick=\"ducc_confirm_terminate_reservation(" + id + ")\" value=\"Terminate\" " + disabled + "/>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        if (reservationType.equals("Managed")) {
            sb.append("<span>");
            sb.append("<a href=\"reservation.details.html?id=" + id + "\">" + id + "</a>");
            sb.append("</span>");
        } else {
            sb.append("<span>");
            sb.append(id);
            sb.append("</span>");
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span title=\"Hint: use Preferences -> Date Style to alter format\">");
        sb.append(this.getTimeStamp(request, duccwork.getDuccId(), duccwork.getStandardInfo().getDateOfSubmission()));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            switch (reservation.getReservationState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)reservation, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)reservation, now, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkReservation)reservation, duration);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
            }
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            switch (job.getJobState()) {
                case Completed: {
                    sb.append("<span>");
                    duration = this.getDuration(request, (IDuccWork)job, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job, duration, FormatHelper.Precision.Whole);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                    break;
                }
                default: {
                    sb.append("<span class=\"health_green\">");
                    duration = this.getDuration(request, (IDuccWork)job, now, FormatHelper.Precision.Whole);
                    decoratedDuration = this.decorateDuration(request, (IDuccWorkJob)job, duration, FormatHelper.Precision.Whole);
                    sb.append(decoratedDuration);
                    sb.append("</span>");
                }
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String title = "";
        String submitter = duccwork.getStandardInfo().getSubmitter();
        if (submitter != null) {
            title = "title=\"submitter PID@host: " + submitter + "\"";
        }
        sb.append("<span " + title + ">");
        UserId userId = new UserId(duccwork.getStandardInfo().getUser());
        sb.append(userId.toString());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        row.add((JsonElement)new JsonPrimitive(this.stringNormalize(duccwork.getSchedulingInfo().getSchedulingClass(), messages.fetch("default"))));
        sb = new StringBuffer();
        sb.append(reservationType);
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String state = duccwork.getStateObject().toString();
        sb.append("<span>");
        if (duccData.isLive(duccId)) {
            if (duccwork.isOperational()) {
                sb.append("<span class=\"active_state\">");
            } else {
                sb.append("<span class=\"completed_state\">");
            }
            sb.append(state);
            sb.append("</span>");
        } else {
            sb.append("<span class=\"historic_state\">");
            sb.append(state);
            sb.append("</span>");
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            switch (reservation.getCompletionType()) {
                case Undefined: {
                    break;
                }
                case CanceledByUser: 
                case CanceledByAdmin: {
                    IRationale rationale;
                    try {
                        String cancelUser = duccwork.getStandardInfo().getCancelUser();
                        if (cancelUser != null) {
                            sb.append("<span title=\"canceled by " + cancelUser + "\">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        rationale = reservation.getCompletionRationale();
                        if (rationale != null) {
                            sb.append("<span title=" + rationale.getTextQuoted() + ">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        sb.append(duccwork.getCompletionTypeObject().toString());
                    }
                    catch (Exception e) {
                        rationale = reservation.getCompletionRationale();
                        if (rationale != null) {
                            sb.append("<span title=" + rationale.getTextQuoted() + ">");
                            sb.append(duccwork.getCompletionTypeObject().toString());
                            sb.append("</span>");
                            break;
                        }
                        sb.append(duccwork.getCompletionTypeObject().toString());
                    }
                    break;
                }
                default: {
                    IRationale rationale = reservation.getCompletionRationale();
                    if (rationale != null) {
                        sb.append("<span title=" + rationale.getTextQuoted() + ">");
                        sb.append(duccwork.getCompletionTypeObject().toString());
                        sb.append("</span>");
                        break;
                    }
                    sb.append(duccwork.getCompletionTypeObject().toString());
                }
            }
        } else if (duccwork instanceof DuccWorkJob) {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            sb = this.getReason((IDuccWorkJob)job, IDuccTypes.DuccType.Reservation);
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        sb.append(duccwork.getSchedulingInfo().getInstancesCount());
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        TreeMap<String, Integer> nodeMap = new TreeMap<String, Integer>();
        if (duccwork instanceof DuccWorkReservation) {
            DuccWorkReservation reservation = (DuccWorkReservation)duccwork;
            if (!reservation.getReservationMap().isEmpty()) {
                IDuccReservationMap map = reservation.getReservationMap();
                for (DuccId key : map.keySet()) {
                    IDuccReservation value = (IDuccReservation)reservation.getReservationMap().get((Object)key);
                    String node2 = value.getNodeIdentity().getName();
                    if (!nodeMap.containsKey(node2)) {
                        nodeMap.put(node2, new Integer(0));
                    }
                    Integer n = count = (Integer)nodeMap.get(node2);
                    Integer n2 = count = Integer.valueOf(count + 1);
                    nodeMap.put(node2, count);
                }
            }
            boolean qualify = false;
            if (!nodeMap.isEmpty() && nodeMap.keySet().size() > 1) {
                qualify = true;
            }
            ArrayList<String> qualifiedPids = new ArrayList<String>();
            if (duccwork.isOperational()) {
                DuccMachinesData machinesData = DuccMachinesData.getInstance();
                for (String node2 : nodeMap.keySet()) {
                    NodeId nodeId = new NodeId(node2);
                    List<String> nodePids = machinesData.getPids(nodeId, userId);
                    for (String pid : nodePids) {
                        if (qualify) {
                            qualifiedPids.add(node2 + ":" + pid);
                            continue;
                        }
                        qualifiedPids.add(pid);
                    }
                }
            }
            if (qualifiedPids.size() > 0) {
                String list = "";
                for (String entry : qualifiedPids) {
                    list = list + entry + " ";
                }
                sb.append("<span title=\"" + list.trim() + "\">");
                sb.append("" + qualifiedPids.size());
                sb.append("</span>");
            } else {
                sb.append("" + qualifiedPids.size());
            }
        } else {
            DuccWorkJob job = (DuccWorkJob)duccwork;
            if (job.isOperational()) {
                sb.append(duccwork.getSchedulingInfo().getInstancesCount());
            } else {
                sb.append("0");
            }
            for (DuccId processId : job.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)job.getProcessMap().get((Object)processId);
                node = process.getNodeIdentity().getName();
                nodeMap.put(node, 1);
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        String size = duccwork.getSchedulingInfo().getShareMemorySize();
        IDuccUnits.MemoryUnits units = duccwork.getSchedulingInfo().getShareMemoryUnits();
        sb.append(this.getProcessMemorySize(duccId, type, size, units));
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        sb.append("<span>");
        if (!nodeMap.isEmpty()) {
            boolean useList = false;
            if (nodeMap.size() > 1) {
                useList = true;
            }
            if (useList) {
                sb.append("<select>");
            }
            Iterator i$ = nodeMap.keySet().iterator();
            while (i$.hasNext()) {
                String option = node = (String)i$.next();
                count = (Integer)nodeMap.get(node);
                if (count > 1) {
                    option = option + " [" + count + "]";
                }
                if (useList) {
                    sb.append("<option>");
                }
                sb.append(option);
                if (!useList) continue;
                sb.append("</option>");
            }
            if (useList) {
                sb.append("</select>");
            }
        }
        sb.append("</span>");
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        sb = new StringBuffer();
        String description = this.stringNormalize(duccwork.getStandardInfo().getDescription(), messages.fetch("none"));
        switch (DuccCookies.getDescriptionStyle(request)) {
            default: {
                sb.append("<span title=\"Hint: use Preferences -> Description Style [Short] to hide everything left of last /\">");
                sb.append(description);
                sb.append("</span>");
                break;
            }
            case Short: {
                String shortDescription = this.getShortDescription(description);
                if (shortDescription == null) {
                    sb.append("<span>");
                    sb.append(description);
                    sb.append("</span>");
                    break;
                }
                sb.append("<span title=\"" + description + "\">");
                sb.append(shortDescription);
                sb.append("</span>");
            }
        }
        row.add((JsonElement)new JsonPrimitive(sb.toString()));
        return row;
    }

    private void handleServletJsonFormatReservationsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatReservationsAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        int maxRecords = this.getReservationsMax(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<Info, Info> sortedCombinedReservations = duccData.getSortedCombinedReservations();
        ArrayList<String> users = this.getReservationsUsers(request);
        long now = System.currentTimeMillis();
        if (sortedCombinedReservations.size() > 0) {
            int counter = 0;
            Iterator<Map.Entry<Info, Info>> iR = sortedCombinedReservations.entrySet().iterator();
            while (iR.hasNext()) {
                JsonArray row;
                Info info = iR.next().getValue();
                IDuccWork dw = info.getDuccWork();
                boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, dw);
                if (!list) continue;
                ++counter;
                if (dw instanceof DuccWorkReservation) {
                    DuccWorkReservation reservation = (DuccWorkReservation)dw;
                    row = this.buildReservationRow(request, (IDuccWork)reservation, duccData, now);
                    data.add((JsonElement)row);
                    continue;
                }
                if (!(dw instanceof DuccWorkJob)) continue;
                DuccWorkJob job = (DuccWorkJob)dw;
                row = this.buildReservationRow(request, (IDuccWork)job, duccData, now);
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            if (DuccData.getInstance().isPublished()) {
                row.add((JsonElement)new JsonPrimitive("no reservations"));
            } else {
                row.add((JsonElement)new JsonPrimitive("no data"));
            }
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatServicesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatServicesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        ServicesSortCache servicesSortCache = ServicesSortCache.getInstance();
        Collection<IServiceAdapter> servicesSortedCollection = servicesSortCache.getSortedCollection();
        if (!servicesSortedCollection.isEmpty()) {
            for (IServiceAdapter service : servicesSortedCollection) {
                String shareClass;
                JsonArray row = new JsonArray();
                int sid = service.getId();
                String user = service.getUser();
                long deployments = service.getDeployments();
                long instances = service.getInstances();
                StringBuffer col = new StringBuffer();
                col.append("<span class=\"ducc-col-start\">");
                if (service.isRegistered() && this.buttonsEnabled && service.isDisabled()) {
                    col.append("<input type=\"button\" onclick=\"ducc_confirm_service_enable(" + sid + ")\" value=\"Enable\" " + this.getDisabledWithHover(request, user) + "/>");
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span class=\"ducc-col-stop\">");
                if (service.isRegistered() && this.buttonsEnabled) {
                    if (service.isPingOnly()) {
                        if (service.isPingActive()) {
                            col.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                        }
                    } else if (deployments != 0L) {
                        col.append("<input type=\"button\" onclick=\"ducc_confirm_service_stop(" + sid + ")\" value=\"Stop\" " + this.getDisabledWithHover(request, user) + "/>");
                    }
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String name = service.getName();
                col.append("<span>");
                String id = "<a href=\"service.details.html?name=" + name + "\">" + sid + "</a>";
                col.append("" + id);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("<span>");
                col.append(name);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String state = service.getState();
                boolean alert = service.isAlert();
                boolean available = service.isStateAvailable();
                if (alert) {
                    state = state + "+Alert";
                }
                String style = "class=\"health_black\";";
                if (alert) {
                    style = "class=\"health_red\"";
                } else if (available) {
                    style = "class=\"health_green\"";
                }
                String stateHover = ServicesHelper.getInstance().getStateHover(service);
                if (stateHover.length() > 0) {
                    stateHover = "title=\"" + stateHover + "\"";
                }
                col.append("<span " + style + " " + stateHover + ">");
                col.append(state);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                long lastUse = service.getLastUse();
                if (lastUse > 0L) {
                    col.append(this.getTimeStamp(request, jobid, "" + lastUse));
                }
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + instances);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + deployments);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ServiceInterpreter.StartState startState = service.getStartState();
                col.append("<span>");
                col.append(startState.name());
                if (service.isDisabled()) {
                    col.append("<br>");
                    String health = "class=\"health_red\"";
                    String reason = "title=\"" + service.getDisableReason() + "\"";
                    col.append("<span " + health + " " + reason + ">");
                    col.append("Disabled");
                    col.append("</span>");
                }
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                col.append("" + user);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                if (service.isPingOnly()) {
                    shareClass = "" + service.getShareClass();
                    col.append("<span title=\"" + shareClass + "\">");
                    String shareType = "ping-only";
                    col.append("<span>");
                    col.append(shareType);
                } else {
                    shareClass = service.getShareClass();
                    col.append("" + shareClass);
                }
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                long pgIn = service.getPgIn();
                col.append("" + pgIn);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                double rawSwap = service.getSwap();
                String swap = formatter.format(rawSwap /= (double)Constants.GB);
                double rawSwapMax = service.getSwapMax();
                rawSwapMax /= (double)Constants.GB;
                String swapMax = formatter.format(rawSwap);
                col.append("<span title=\"max=" + swapMax + "\" align=\"right\" " + ">");
                col.append(swap);
                col.append("</span>");
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                long size = service.getSize();
                if (size < 0L) {
                    size = 0L;
                }
                col.append(size);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentJobs = service.getDependentJobs();
                int countDependentJobs = dependentJobs.size();
                String titleJobs = "";
                if (countDependentJobs > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentJobs) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleJobs = "dependent Job Id list: " + idList;
                }
                String jobs = "<span title=\"" + titleJobs + "\">" + countDependentJobs + "</span>";
                col.append(jobs);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentServices = service.getDependentServices();
                int countDependentServices = dependentServices.size();
                String titleServices = "";
                if (countDependentServices > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentServices) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleServices = "dependent Service Name list: " + idList;
                }
                String services = "<span title=\"" + titleServices + "\">" + countDependentServices + "</span>";
                col.append(services);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                ArrayList<String> dependentReservations = service.getDependentReservations();
                int countDependentReservations = dependentReservations.size();
                String titleReservations = "";
                if (countDependentReservations > 0) {
                    StringBuffer idList = new StringBuffer();
                    for (String duccId : dependentReservations) {
                        if (idList.length() > 0) {
                            idList.append(",");
                        }
                        idList.append(duccId);
                    }
                    titleReservations = "dependent Reservation Id list: " + idList;
                }
                String reservations = "<span title=\"" + titleReservations + "\">" + countDependentReservations + "</span>";
                col.append(reservations);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                col = new StringBuffer();
                String description = service.getDescription();
                col.append(description);
                row.add((JsonElement)new JsonPrimitive(col.toString()));
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            String text = "";
            text = DuccData.getInstance().isPublished() ? messages.fetch("no services") : messages.fetch("no data");
            row.add((JsonElement)new JsonPrimitive(text));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatMachinesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatMachinesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        int sumMemoryEffective = 0;
        int sumMemoryTotal = 0;
        int sumSwapInuse = 0;
        int sumSwapFree = 0;
        int sumAliens = 0;
        int sumSharesTotal = 0;
        int sumSharesInuse = 0;
        DuccMachinesData instance = DuccMachinesData.getInstance();
        MachineFactsList factsList = instance.getMachineFactsList();
        if (factsList.size() > 0) {
            ListIterator listIterator = factsList.listIterator();
            while (listIterator.hasNext()) {
                MachineFacts facts = (MachineFacts)listIterator.next();
                try {
                    sumMemoryEffective += Integer.parseInt(facts.memoryEffective);
                    sumMemoryTotal += Integer.parseInt(facts.memoryTotal);
                    sumSwapInuse += Integer.parseInt(facts.swapInuse);
                    sumSwapFree += Integer.parseInt(facts.swapFree);
                    sumAliens += facts.aliens.size();
                    sumSharesTotal += Integer.parseInt(facts.sharesTotal);
                    sumSharesInuse += Integer.parseInt(facts.sharesInuse);
                }
                catch (Exception e) {
                    duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
                }
            }
            JsonArray row = new JsonArray();
            String releaseAll = this.buildReleaseAll(request, factsList);
            row.add((JsonElement)new JsonPrimitive(releaseAll));
            row.add((JsonElement)new JsonPrimitive("Total"));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive((Number)sumMemoryEffective));
            row.add((JsonElement)new JsonPrimitive((Number)sumMemoryTotal));
            row.add((JsonElement)new JsonPrimitive((Number)sumSwapInuse));
            row.add((JsonElement)new JsonPrimitive((Number)sumSwapFree));
            row.add((JsonElement)new JsonPrimitive((Number)sumAliens));
            row.add((JsonElement)new JsonPrimitive((Number)sumSharesTotal));
            row.add((JsonElement)new JsonPrimitive((Number)sumSharesInuse));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
            listIterator = factsList.listIterator();
            while (listIterator.hasNext()) {
                MachineFacts facts = (MachineFacts)listIterator.next();
                row = new JsonArray();
                String releaseMachine = this.buildReleaseMachine(request, facts);
                row.add((JsonElement)new JsonPrimitive(releaseMachine));
                StringBuffer sb = new StringBuffer();
                String status = facts.status;
                if (status.equals("down")) {
                    sb.append("<span class=\"health_red\">");
                    sb.append(status);
                    sb.append("</span>");
                } else if (status.equals("up")) {
                    sb.append("<span class=\"health_green\">");
                    sb.append(status);
                    sb.append("</span>");
                } else {
                    sb.append(status);
                }
                row.add((JsonElement)new JsonPrimitive(sb.toString()));
                row.add((JsonElement)new JsonPrimitive(facts.ip));
                row.add((JsonElement)new JsonPrimitive(facts.name));
                row.add((JsonElement)new JsonPrimitive(facts.memoryEffective));
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(facts.memoryTotal));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                sb = new StringBuffer();
                String swapping = facts.swapInuse;
                if (swapping.equals("0")) {
                    sb.append(swapping);
                } else {
                    sb.append("<span class=\"health_red\">");
                    sb.append(swapping);
                    sb.append("</span>");
                }
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(sb.toString()));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(facts.swapFree));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                sb = new StringBuffer();
                long aliens = facts.aliens.size();
                if (aliens == 0L) {
                    sb.append(aliens);
                } else {
                    StringBuffer title = new StringBuffer();
                    title.append("title=");
                    title.append("\"");
                    for (String pid : facts.aliens) {
                        title.append(pid + " ");
                    }
                    title.append("\"");
                    sb.append("<span class=\"health_red\" " + title + ">");
                    sb.append(aliens);
                    sb.append("</span>");
                }
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(sb.toString()));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                int sharesTotal = 0;
                int sharesInuse = 0;
                try {
                    int total = Integer.parseInt(facts.sharesTotal);
                    int inuse = Integer.parseInt(facts.sharesInuse);
                    sharesTotal = total;
                    sharesInuse = inuse;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(facts.sharesTotal));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                sb = new StringBuffer();
                String span0 = "<span class=\"health_black\">";
                String span1 = "</span>";
                if (sharesInuse > sharesTotal) {
                    span0 = "<span class=\"health_red\">";
                }
                sb.append(span0);
                sb.append(facts.sharesInuse);
                sb.append(span1);
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(sb.toString()));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                if (!status.equals("defined")) {
                    row.add((JsonElement)new JsonPrimitive(facts.heartbeat));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                data.add((JsonElement)row);
            }
        } else {
            JsonArray row = new JsonArray();
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            row.add((JsonElement)new JsonPrimitive(""));
            data.add((JsonElement)row);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatBrokerAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletJsonFormatBrokerAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        BrokerHelper brokerHelper = BrokerHelper.getInstance();
        ArrayList<EntityInfo> entityInfoList = brokerHelper.getFrameworkEntities();
        String[] attrNames = new String[]{BrokerHelper.FrameworkAttribute.ConsumerCount.name(), BrokerHelper.FrameworkAttribute.QueueSize.name(), BrokerHelper.FrameworkAttribute.MaxEnqueueTime.name(), BrokerHelper.FrameworkAttribute.AverageEnqueueTime.name(), BrokerHelper.FrameworkAttribute.MemoryPercentUsage.name()};
        JsonArray topics = new JsonArray();
        JsonArray queues = new JsonArray();
        if (entityInfoList.size() > 0) {
            for (EntityInfo entityInfo : entityInfoList) {
                String name = entityInfo.getName();
                String type = entityInfo.getType();
                TreeMap<String, String> map = brokerHelper.getAttributes(name, attrNames);
                String attrValue = "";
                JsonArray row = new JsonArray();
                row.add((JsonElement)new JsonPrimitive(name));
                row.add((JsonElement)new JsonPrimitive(type));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.ConsumerCount.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.QueueSize.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MaxEnqueueTime.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.AverageEnqueueTime.name());
                try {
                    Double d = Double.valueOf(attrValue);
                    attrValue = formatter3.format(d);
                }
                catch (Exception e) {
                    // empty catch block
                }
                row.add((JsonElement)new JsonPrimitive(attrValue));
                attrValue = map.get(BrokerHelper.FrameworkAttribute.MemoryPercentUsage.name());
                row.add((JsonElement)new JsonPrimitive(attrValue));
                if (type.equals(Topic)) {
                    topics.add((JsonElement)row);
                    continue;
                }
                queues.add((JsonElement)row);
            }
            data.addAll(topics);
            data.addAll(queues);
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatClassesAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleServletJsonFormatClassesAaData";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        JsonObject jsonResponse = new JsonObject();
        JsonArray data = new JsonArray();
        DuccSchedulerClasses schedulerClasses = new DuccSchedulerClasses();
        Map clmap = schedulerClasses.getClasses();
        if (clmap != null) {
            DuccProperties[] class_set = clmap.values().toArray(new DuccProperties[clmap.size()]);
            Arrays.sort(class_set, new NodeConfiguration.ClassSorter());
            for (DuccProperties cl : class_set) {
                String v1;
                JsonArray row = new JsonArray();
                String class_name = cl.getProperty("name");
                row.add((JsonElement)new JsonPrimitive(class_name));
                String policy = cl.getProperty("policy");
                row.add((JsonElement)new JsonPrimitive(policy));
                String weight = cl.getStringProperty("weight", "-");
                row.add((JsonElement)new JsonPrimitive(weight));
                String priority = cl.getProperty("priority");
                row.add((JsonElement)new JsonPrimitive(priority));
                String val = cl.getStringProperty("cap", "0");
                if (val == null || val.equals("0")) {
                    row.add((JsonElement)new JsonPrimitive("-"));
                    row.add((JsonElement)new JsonPrimitive("-"));
                } else if (val.endsWith("%")) {
                    row.add((JsonElement)new JsonPrimitive(val));
                    row.add((JsonElement)new JsonPrimitive("-"));
                } else {
                    row.add((JsonElement)new JsonPrimitive("-"));
                    row.add((JsonElement)new JsonPrimitive(val));
                }
                if (policy.equals("FAIR_SHARE")) {
                    String defaultInitializationCap = "2";
                    val = cl.getStringProperty("initialization-cap", System.getProperty("ducc.rm.initialization.cap", defaultInitializationCap));
                    row.add((JsonElement)new JsonPrimitive(val));
                    boolean bval = cl.getBooleanProperty("expand-by-doubling", true);
                    row.add((JsonElement)new JsonPrimitive(Boolean.valueOf(bval)));
                    String defaultUsePrediction = "true";
                    val = cl.getProperty("use-prediction", System.getProperty("ducc.rm.prediction", defaultUsePrediction));
                    row.add((JsonElement)new JsonPrimitive(val));
                    String defaultPredictionFudge = "10000";
                    val = cl.getStringProperty("prediction-fudge", System.getProperty("ducc.rm.prediction.fudge", defaultPredictionFudge));
                    row.add((JsonElement)new JsonPrimitive(val));
                } else {
                    row.add((JsonElement)new JsonPrimitive("-"));
                    row.add((JsonElement)new JsonPrimitive("-"));
                    row.add((JsonElement)new JsonPrimitive("-"));
                    row.add((JsonElement)new JsonPrimitive("-"));
                }
                if (policy.equals("RESERVE")) {
                    val = cl.getStringProperty("max-machines");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else if (policy.equals("FIXED_SHARE")) {
                    val = cl.getStringProperty("max-processes");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else {
                    val = "-";
                }
                if ((val = cl.getStringProperty("max-shares", "0")) == null || val.equals("0")) {
                    val = "-";
                }
                row.add((JsonElement)new JsonPrimitive(val));
                val = cl.getProperty("nodepool");
                row.add((JsonElement)new JsonPrimitive(val));
                val = "-";
                if (schedulerClasses.isPreemptable(class_name) && schedulerClasses.isPreemptable(class_name) && !(v1 = cl.getStringProperty("debug", "")).equals("")) {
                    val = v1;
                }
                row.add((JsonElement)new JsonPrimitive(val));
                data.add((JsonElement)row);
            }
        }
        jsonResponse.add("aaData", (JsonElement)data);
        String json = jsonResponse.toString();
        duccLogger.debug(methodName, jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    /*
     * Unable to fully structure code
     */
    private void handleServletJsonFormatDaemonsAaData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        methodName = "handleServletJsonFormatDaemonsAaData";
        DuccHandlerJsonFormat.duccLogger.trace(methodName, DuccHandlerJsonFormat.jobid, new Object[]{DuccHandlerJsonFormat.messages.fetch("enter")});
        jsonResponse = new JsonObject();
        data = new JsonArray();
        duccDaemonsData = DuccDaemonsData.getInstance();
        block12: for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            row = new JsonArray();
            status = "";
            heartbeat = "*";
            heartmax = "*";
            properties = DuccDaemonRuntimeProperties.getInstance().get(daemonName);
            if (!Version.version().startsWith("1.1.0")) ** GOTO lbl-1000
            switch (1.$SwitchMap$org$apache$uima$ducc$common$boot$DuccDaemonRuntimeProperties$DaemonName[daemonName.ordinal()]) {
                case 1: {
                    continue block12;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (1.$SwitchMap$org$apache$uima$ducc$common$boot$DuccDaemonRuntimeProperties$DaemonName[daemonName.ordinal()]) {
                        case 2: {
                            status = DuccHandlerUtils.up();
                            break;
                        }
                        default: {
                            status = DuccHandlerUtils.unknown();
                            if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                            }
                            heartbeat = DuccDaemonsData.getInstance().getHeartbeat(daemonName);
                            timeout = this.getMillisMIA(daemonName) / 1000L;
                            if (timeout > 0L) {
                                try {
                                    overtime = timeout - Long.parseLong(heartbeat);
                                    if (overtime < 0L) {
                                        status = DuccHandlerUtils.down();
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && ComponentHelper.isLocked((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator")) {
                                            filename = ComponentHelper.getLockFileName((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
                                            hover = "title=\"" + ComponentHelper.getLockFileNameWithPath((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator") + "\"";
                                            fileNameWithHover = "<span " + hover + " >" + filename + "</span>";
                                            status = status + ", " + DuccHandlerUtils.warn("warning: ") + fileNameWithHover + " found.";
                                        }
                                    } else {
                                        status = DuccHandlerUtils.up();
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.DbManager) && (properties = DuccDaemonsData.getInstance().getProperties(daemonName)) != null && (dcph = new DbComponentPropertiesHelper(properties)).isDisabled()) {
                                            status = DuccHandlerUtils.disabled();
                                        }
                                        if (daemonName.equals((Object)DuccDaemonRuntimeProperties.DaemonName.Orchestrator) && (jdCount = DuccData.getInstance().getLive().getJobDriverNodeCount()) == 0) {
                                            status = DuccHandlerUtils.up_provisional(", pending JD allocation");
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            heartmax = DuccDaemonsData.getInstance().getMaxHeartbeat(daemonName);
                        }
                    }
                    row.add((JsonElement)new JsonPrimitive(status));
                    name = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyDaemonName, daemonName.toString());
                    row.add((JsonElement)new JsonPrimitive(name));
                    boot = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                    row.add((JsonElement)new JsonPrimitive(boot));
                    ip = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                    row.add((JsonElement)new JsonPrimitive(ip));
                    node = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "");
                    row.add((JsonElement)new JsonPrimitive(node));
                    pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                    row.add((JsonElement)new JsonPrimitive(pid));
                    pubSize = duccDaemonsData.getEventSize(daemonName);
                    row.add((JsonElement)new JsonPrimitive("" + pubSize));
                    pubSizeMax = duccDaemonsData.getEventSizeMax(daemonName);
                    row.add((JsonElement)new JsonPrimitive("" + pubSizeMax));
                    row.add((JsonElement)new JsonPrimitive("" + heartbeat));
                    row.add((JsonElement)new JsonPrimitive("" + heartmax));
                    heartmaxTOD = TimeStamp.simpleFormat((String)DuccDaemonsData.getInstance().getMaxHeartbeatTOD(daemonName));
                    try {
                        heartmaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), heartmaxTOD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    row.add((JsonElement)new JsonPrimitive("" + heartmaxTOD));
                    jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                    jmxUrlLink = "";
                    if (jmxUrl != null) {
                        jmxUrlLink = this.buildjConsoleLink(jmxUrl);
                    }
                    row.add((JsonElement)new JsonPrimitive(jmxUrlLink));
                    data.add((JsonElement)row);
                }
            }
        }
        cookie = DuccCookies.getCookie(request, "ducc:agents");
        if (cookie.equals("show")) {
            DuccHandlerJsonFormat.duccLogger.trace(methodName, DuccHandlerJsonFormat.jobid, new Object[]{"== show: " + cookie});
            machines = DuccMachinesData.getInstance().getMachines();
            iterator = machines.keySet().iterator();
            while (iterator.hasNext()) {
                row = new JsonArray();
                key = (String)iterator.next();
                machineInfo = machines.get(key);
                properties = DuccDaemonRuntimeProperties.getInstance().getAgent(machineInfo.getName());
                status = new StringBuffer();
                machineStatus = machineInfo.getStatus();
                if (machineStatus.equals("down")) {
                    status.append(DuccHandlerUtils.down());
                } else if (machineStatus.equals("up")) {
                    status.append(DuccHandlerUtils.up());
                } else {
                    status.append(DuccHandlerUtils.unknown());
                }
                row.add((JsonElement)new JsonPrimitive(status.toString()));
                daemonName = "Agent";
                row.add((JsonElement)new JsonPrimitive(daemonName));
                bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                row.add((JsonElement)new JsonPrimitive(bootTime));
                hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                row.add((JsonElement)new JsonPrimitive(hostIP));
                hostName = machineInfo.getName();
                row.add((JsonElement)new JsonPrimitive(hostName));
                pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                row.add((JsonElement)new JsonPrimitive(pid));
                publicationSizeLast = machineInfo.getPublicationSizeLast();
                row.add((JsonElement)new JsonPrimitive(publicationSizeLast));
                publicationSizeMax = machineInfo.getPublicationSizeMax();
                row.add((JsonElement)new JsonPrimitive(publicationSizeMax));
                heartbeatLast = machineInfo.getHeartbeatLast();
                row.add((JsonElement)new JsonPrimitive(heartbeatLast));
                heartbeatMax = machineInfo.getHeartbeatMax();
                if (heartbeatMax > 0L) {
                    row.add((JsonElement)new JsonPrimitive((Number)heartbeatMax));
                } else {
                    row.add((JsonElement)new JsonPrimitive(""));
                }
                fmtHeartbeatMaxTOD = "";
                heartbeatMaxTOD = machineInfo.getHeartbeatMaxTOD();
                if (heartbeatMaxTOD > 0L) {
                    fmtHeartbeatMaxTOD = TimeStamp.simpleFormat((String)("" + heartbeatMaxTOD));
                    try {
                        fmtHeartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), fmtHeartbeatMaxTOD);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                row.add((JsonElement)new JsonPrimitive(fmtHeartbeatMaxTOD));
                jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                jmxUrlLink = "";
                if (jmxUrl != null) {
                    jmxUrlLink = this.buildjConsoleLink(jmxUrl);
                }
                row.add((JsonElement)new JsonPrimitive(jmxUrlLink));
                data.add((JsonElement)row);
            }
        } else {
            DuccHandlerJsonFormat.duccLogger.trace(methodName, DuccHandlerJsonFormat.jobid, new Object[]{"!= show: " + cookie});
        }
        jsonResponse.add("aaData", (JsonElement)data);
        json = jsonResponse.toString();
        DuccHandlerJsonFormat.duccLogger.debug(methodName, DuccHandlerJsonFormat.jobid, new Object[]{json});
        response.getWriter().println(json);
        response.setContentType("application/json");
        DuccHandlerJsonFormat.duccLogger.trace(methodName, DuccHandlerJsonFormat.jobid, new Object[]{DuccHandlerJsonFormat.messages.fetch("exit")});
    }

    private void handleServletJsonFormatMachines(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatMachines";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DuccMachinesData instance = DuccMachinesData.getInstance();
        MachineFactsList factsList = instance.getMachineFactsList();
        Gson gson = new Gson();
        String jSon = gson.toJson((Object)factsList);
        sb.append(jSon);
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonFormatReservations(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletJsonFormatReservations";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        ReservationFactsList factsList = new ReservationFactsList();
        int maxRecords = this.getReservationsMaxRecordsParameter(request);
        DuccAbstractHandler.RequestStateType requestStateType = this.getStateTypeParameter(request);
        ArrayList<String> users = this.getReservationsUsers(request);
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<ReservationInfo, ReservationInfo> sortedReservations = duccData.getSortedReservations();
        if (sortedReservations.size() > 0) {
            Iterator<Map.Entry<ReservationInfo, ReservationInfo>> iterator = sortedReservations.entrySet().iterator();
            int counter = 0;
            block11: while (iterator.hasNext()) {
                String reservationUser;
                ReservationInfo reservationInfo = iterator.next().getValue();
                DuccWorkReservation reservation = reservationInfo.getReservation();
                IDuccState.ReservationState reservationState = reservation.getReservationState();
                block0 : switch (requestStateType) {
                    case All: {
                        break;
                    }
                    case Active: {
                        switch (reservationState) {
                            case Completed: {
                                continue block11;
                            }
                        }
                        break;
                    }
                    case Inactive: {
                        switch (reservationState) {
                            case Completed: {
                                break block0;
                            }
                        }
                        continue block11;
                    }
                }
                if (!this.isIncludeUser(users, reservationUser = reservation.getStandardInfo().getUser().trim()) || maxRecords <= 0 || counter++ >= maxRecords) continue;
                String id = reservation.getId();
                String start = this.getTimeStamp(request, reservation.getDuccId(), reservation.getStandardInfo().getDateOfSubmission());
                String end = this.getTimeStamp(request, reservation.getDuccId(), reservation.getStandardInfo().getDateOfCompletion());
                String user = reservation.getStandardInfo().getUser();
                String rclass = reservation.getSchedulingInfo().getSchedulingClass();
                String state = reservation.getReservationState().toString();
                String reason = reservation.getCompletionType().toString();
                String allocation = reservation.getSchedulingInfo().getInstancesCount();
                List<Object> userProcesses = new ArrayList();
                List list = new ArrayList();
                if (!reservation.isCompleted()) {
                    userProcesses = DuccMachinesData.getInstance().getUserProcesses(reservation.getUniqueNodes(), user);
                    list = reservation.getNodes();
                }
                String size = this.getProcessMemorySize(reservation.getDuccId(), "Reservation", reservation.getSchedulingInfo().getShareMemorySize(), reservation.getSchedulingInfo().getShareMemoryUnits());
                String description = reservation.getStandardInfo().getDescription();
                ReservationFacts facts = new ReservationFacts(id, start, end, user, rclass, state, reason, allocation, userProcesses, size, list, description);
                factsList.add((Object)facts);
            }
        }
        Gson gson = new Gson();
        String jSon = gson.toJson((Object)factsList);
        sb.append(jSon);
        duccLogger.debug(methodName, jobid, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/json-format-aaData-jobs")) {
            this.handleServletJsonFormatJobsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-reservations")) {
            this.handleServletJsonFormatReservationsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-services")) {
            this.handleServletJsonFormatServicesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-machines")) {
            this.handleServletJsonFormatMachinesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-broker")) {
            this.handleServletJsonFormatBrokerAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-classes")) {
            this.handleServletJsonFormatClassesAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-aaData-daemons")) {
            this.handleServletJsonFormatDaemonsAaData(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-machines")) {
            this.handleServletJsonFormatMachines(target, baseRequest, request, response);
        } else if (reqURI.startsWith("/ducc-servlet/json-format-reservations")) {
            this.handleServletJsonFormatReservations(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/json-format")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

