/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry.sort;

import java.util.ArrayList;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;

public class ServicesHelper {
    private static ServicesHelper instance = new ServicesHelper();

    public static ServicesHelper getInstance() {
        return instance;
    }

    public String getStateHover(IServiceAdapter serviceAdapter) {
        String statistics;
        String errorText;
        StringBuffer retVal = new StringBuffer();
        String pingerStatus = serviceAdapter.getPingerStatus();
        if (pingerStatus != null && pingerStatus.length() > 0) {
            if (retVal.length() > 0) {
                retVal.append("\n");
            }
            retVal.append(pingerStatus);
        }
        if (!serviceAdapter.isPingActive() && serviceAdapter.isServiceIssue() && serviceAdapter.isStateActive()) {
            if (retVal.length() > 0) {
                retVal.append("\n");
            }
            retVal.append("Service not responding to pinger");
        }
        if ((errorText = serviceAdapter.getErrorText()) != null && errorText.length() > 0) {
            if (retVal.length() > 0) {
                retVal.append("\n");
            }
            retVal.append(errorText);
        }
        if ((statistics = serviceAdapter.getStatistics()) != null && !statistics.equals("N/A") && statistics.length() > 0) {
            if (retVal.length() > 0) {
                retVal.append("\n");
            }
            retVal.append(statistics);
        }
        return retVal.toString();
    }

    public ArrayList<DuccWorkJob> getServicesList(IServiceAdapter serviceAdapter) {
        ArrayList retVal = new ArrayList();
        ArrayList<String> implementors = serviceAdapter.getImplementors();
        DuccWorkMap duccWorkMap = DuccData.getInstance().get();
        retVal = duccWorkMap.getServices(implementors);
        return retVal;
    }

    public long getPgIn(IServiceAdapter serviceAdapter) {
        long retVal = 0L;
        ArrayList<DuccWorkJob> servicesList = this.getServicesList(serviceAdapter);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getMajorFaults();
            }
        }
        return retVal;
    }

    public long getSwap(IServiceAdapter serviceAdapter) {
        long retVal = 0L;
        ArrayList<DuccWorkJob> servicesList = this.getServicesList(serviceAdapter);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getSwapUsage();
            }
        }
        return retVal;
    }

    public long getSwapMax(IServiceAdapter serviceAdapter) {
        long retVal = 0L;
        ArrayList<DuccWorkJob> servicesList = this.getServicesList(serviceAdapter);
        for (DuccWorkJob service : servicesList) {
            IDuccProcessMap map = service.getProcessMap();
            for (DuccId key : map.keySet()) {
                IDuccProcess process = (IDuccProcess)map.get((Object)key);
                if (!process.isActive()) continue;
                retVal += process.getSwapUsageMax();
            }
        }
        return retVal;
    }
}

