/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry.sort;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.ws.DuccDataHelper;
import org.apache.uima.ducc.ws.registry.ServiceInterpreter;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.ServicesHelper;

public class ServiceAdapter
implements IServiceAdapter {
    private ServiceInterpreter si;
    private long pgIn = 0L;
    private long swap = 0L;
    private long swapMax = 0L;
    private ArrayList<String> dependentJobs = new ArrayList();
    private ArrayList<String> dependentServices = new ArrayList();
    private ArrayList<String> dependentReservations = new ArrayList();

    public ServiceAdapter(Properties svc, Properties meta) {
        this.si = new ServiceInterpreter(svc, meta);
        this.init();
    }

    private void init() {
        this.initPgIn();
        this.initSwap();
        this.initSwapMax();
        this.initDependentJobs();
        this.initDependentServices();
        this.initDependentReservations();
    }

    @Override
    public Properties getSvc() {
        return this.si.getSvc();
    }

    @Override
    public void setSvc(Properties properties) {
        this.si.setSvc(properties);
    }

    @Override
    public Properties getMeta() {
        return this.si.getMeta();
    }

    @Override
    public void setMeta(Properties properties) {
        this.si.setMeta(properties);
    }

    @Override
    public int getId() {
        Integer value = this.si.getId();
        return value;
    }

    @Override
    public long getLastUse() {
        long value = this.si.getLastUse();
        return value;
    }

    @Override
    public long getInstances() {
        long value = this.si.getInstances();
        return value;
    }

    @Override
    public long getDeployments() {
        long value = this.si.getDeployments();
        return value;
    }

    private void initPgIn() {
        this.pgIn = ServicesHelper.getInstance().getPgIn(this);
    }

    @Override
    public long getPgIn() {
        return this.pgIn;
    }

    private void initSwap() {
        this.swap = ServicesHelper.getInstance().getSwap(this);
    }

    @Override
    public long getSwap() {
        return this.swap;
    }

    private void initSwapMax() {
        this.swapMax = ServicesHelper.getInstance().getSwapMax(this);
    }

    @Override
    public long getSwapMax() {
        return this.swapMax;
    }

    @Override
    public long getSize() {
        long value = this.si.getSize();
        return value;
    }

    private boolean isFaultError() {
        boolean retVal = false;
        String value = this.getErrorText();
        if (value != null && value.trim().length() > 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isHealthRelevant() {
        String value;
        boolean retVal = false;
        if (this.isPingActive() && (value = this.getState()) != null) {
            if (value.equalsIgnoreCase(IService.ServiceState.Available.name())) {
                retVal = true;
            } else if (value.equalsIgnoreCase(IService.ServiceState.Waiting.name())) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isFaultHealth() {
        boolean retVal = false;
        boolean value = this.isServiceHealthy();
        if (!value && !(value = this.isServiceAlive()) && this.isHealthRelevant()) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isPingerRelevant() {
        boolean retVal = false;
        String value = this.getState();
        if (value != null) {
            if (value.equalsIgnoreCase(IService.ServiceState.Available.name())) {
                retVal = true;
            } else if (value.equalsIgnoreCase(IService.ServiceState.Waiting.name())) {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean isFaultPinger() {
        boolean retVal = false;
        boolean value = this.isPingActive();
        if (!value && this.isPingerRelevant()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isPingOnly() {
        boolean retVal = false;
        Boolean value = this.si.getPingOnly();
        if (value != null && value.booleanValue()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isPingActive() {
        boolean retVal = false;
        Boolean value = this.si.getPingActive();
        if (value != null && value.booleanValue()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isRegistered() {
        boolean retVal = false;
        String value = this.getServiceClass();
        if (value != null && value.trim().equalsIgnoreCase("Registered")) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isStateAvailable() {
        boolean retVal = false;
        String value = this.getState();
        if (value != null && value.equalsIgnoreCase(IService.ServiceState.Available.name())) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isStateActive() {
        boolean retVal = false;
        String value = this.getState();
        if (value != null) {
            if (value.equalsIgnoreCase(IService.ServiceState.Available.name())) {
                retVal = true;
            } else if (value.equalsIgnoreCase(IService.ServiceState.Waiting.name())) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isAlert() {
        boolean retVal = false;
        if (this.isFaultError()) {
            retVal = true;
        } else if (this.isFaultHealth()) {
            retVal = true;
        } else if (this.isFaultPinger()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Boolean getServiceAlive() {
        return this.si.getServiceAlive();
    }

    @Override
    public boolean isServiceAlive() {
        boolean retVal = this.si.isServiceAlive();
        return retVal;
    }

    @Override
    public Boolean getServiceHealthy() {
        Boolean value = this.si.getServiceHealthy();
        return value;
    }

    @Override
    public boolean isServiceHealthy() {
        boolean retVal = this.si.isServiceHealthy();
        return retVal;
    }

    @Override
    public boolean isServiceIssue() {
        boolean retVal = false;
        if (!this.isServiceHealthy()) {
            retVal = true;
        } else if (!this.isServiceAlive()) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isDisabled() {
        boolean retVal = this.si.isDisabled();
        return retVal;
    }

    private String getServiceClass() {
        String value = this.si.getServiceClass();
        return value;
    }

    @Override
    public String getPingerStatus() {
        String value = this.si.getPingerStatus();
        return value;
    }

    @Override
    public String getErrorText() {
        String value = this.si.getErrorText();
        return value;
    }

    @Override
    public String getName() {
        String value = this.si.getName();
        return value;
    }

    @Override
    public String getState() {
        String value = this.si.getState();
        return value;
    }

    @Override
    public String getStatistics() {
        String value = this.si.getStatistics();
        return value;
    }

    @Override
    public String getUser() {
        String value = this.si.getUser();
        return value;
    }

    @Override
    public String getShareClass() {
        String value = this.si.getSchedulingClass();
        return value;
    }

    @Override
    public String getDescription() {
        String value = this.si.getDescription();
        return value;
    }

    @Override
    public String getDisableReason() {
        String value = this.si.getDisableReason();
        return value;
    }

    @Override
    public ServiceInterpreter.StartState getStartState() {
        ServiceInterpreter.StartState value = this.si.getStartState();
        return value;
    }

    @Override
    public ArrayList<String> getImplementors() {
        ArrayList<String> value = this.si.getImplementors();
        return value;
    }

    public void initDependentJobs() {
        ArrayList<DuccId> duccIds;
        int size;
        String name;
        DuccDataHelper duccDataHelper = DuccDataHelper.getInstance();
        TreeMap<String, ArrayList<DuccId>> serviceToJobsMap = duccDataHelper.getServiceToJobsUsageMap();
        if (serviceToJobsMap.containsKey(name = this.getName()) && (size = (duccIds = serviceToJobsMap.get(name)).size()) > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (DuccId duccId : duccIds) {
                list.add(duccId.toString());
            }
            this.dependentJobs = list;
        }
    }

    @Override
    public ArrayList<String> getDependentJobs() {
        return this.dependentJobs;
    }

    public void initDependentServices() {
        ArrayList<String> list;
        String name = this.getName();
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        if (servicesRegistry != null && (list = servicesRegistry.getServiceDependencies(name)).size() > 0) {
            this.dependentServices = list;
        }
    }

    @Override
    public ArrayList<String> getDependentServices() {
        return this.dependentServices;
    }

    public void initDependentReservations() {
        ArrayList<DuccId> duccIds;
        int size;
        String name;
        DuccDataHelper duccDataHelper = DuccDataHelper.getInstance();
        TreeMap<String, ArrayList<DuccId>> serviceToReservationsMap = duccDataHelper.getServiceToReservationsUsageMap();
        if (serviceToReservationsMap.containsKey(name = this.getName()) && (size = (duccIds = serviceToReservationsMap.get(name)).size()) > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (DuccId duccId : duccIds) {
                list.add(duccId.toString());
            }
            this.dependentReservations = list;
        }
    }

    @Override
    public ArrayList<String> getDependentReservations() {
        return this.dependentReservations;
    }
}

