/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.ws.registry.ServiceName;
import org.springframework.util.StringUtils;

public class ServiceInterpreter {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)ServiceInterpreter.class.getName());
    private static DuccId jobid = null;
    protected Properties svc;
    protected Properties meta;
    private String placeholderPingerStatus = "";
    private Integer placeholderId = new Integer(-1);
    private String placeholderName = "";
    private Long placeholderLastUse = new Long(-1L);
    private Long placeholderInstances = new Long(-1L);
    private Long placeholderDeployments = new Long(-1L);
    private String placeholderUser = "";
    private String placeholderSchedulingClass = "";
    private Long placeholderSize = new Long(-1L);
    private String placeholderDescription = "";
    private String placeholderDisableReason = "";

    public ServiceInterpreter(Properties propertiesSvc, Properties propertiesMeta) {
        this.setSvc(propertiesSvc);
        this.setMeta(propertiesMeta);
    }

    public void setSvc(Properties value) {
        this.svc = value;
    }

    public Properties getSvc() {
        return this.svc;
    }

    public void setMeta(Properties value) {
        this.meta = value;
    }

    public Properties getMeta() {
        return this.meta;
    }

    private static String getUninterpreted(Properties properties, String key) {
        String retVal = ServiceInterpreter.getValue(properties, key, "");
        return retVal;
    }

    private static String getValue(Properties properties, String key, String defaultValue) {
        String retVal = defaultValue;
        if (properties != null && key != null) {
            retVal = properties.getProperty(key, defaultValue);
        }
        return retVal.trim();
    }

    private static String[] getList(String string) {
        String[] retVal = new String[]{};
        if (string != null && (string = string.trim()).length() > 0) {
            retVal = StringUtils.delimitedListToStringArray((String)string, (String)" ");
        }
        return retVal;
    }

    public String getPingerStatus() {
        String location = "getPingerStatus";
        String retVal = this.placeholderPingerStatus;
        try {
            Boolean value;
            String state = this.getState();
            retVal = "The service is " + state;
            if (state.equalsIgnoreCase(IService.ServiceState.Waiting.name())) {
                boolean pingActive = this.getPingActive();
                retVal = pingActive ? "Pinger is starting" : "Pinger is unable to start";
            } else if (state.equalsIgnoreCase(IService.ServiceState.Available.name()) && !(value = this.getPingActive()).booleanValue()) {
                retVal = "Pinger is not active";
            }
        }
        catch (Exception e) {
            duccLogger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Boolean getServiceAlive() {
        String location = "getServiceAlive";
        boolean retVal = true;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "service-alive", Boolean.valueOf(retVal).toString());
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public boolean isServiceAlive() {
        return this.getServiceAlive();
    }

    public Boolean getServiceHealthy() {
        String location = "getServiceHealthy";
        boolean retVal = true;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "service-healthy", Boolean.valueOf(retVal).toString());
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public boolean isServiceHealthy() {
        return this.getServiceHealthy();
    }

    public Integer getId() {
        String location = "getId";
        Integer retVal = this.placeholderId;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "numeric_id", "");
            int id = Integer.valueOf(value);
            retVal = id;
        }
        catch (Exception e) {
            duccLogger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getName() {
        String location = "getName";
        String retVal = this.placeholderName;
        try {
            String name;
            ServiceName serviceName = new ServiceName(ServiceInterpreter.getValue(this.meta, "endpoint", ""));
            retVal = name = serviceName.getNormalized();
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getState() {
        String location = "getState";
        String retVal = "";
        try {
            String state;
            retVal = state = ServiceInterpreter.getValue(this.meta, "service-state", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getStatistics() {
        String location = "getStatistics";
        String retVal = "";
        try {
            String statistics;
            retVal = statistics = ServiceInterpreter.getValue(this.meta, "service-statistics", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Boolean getPingOnly() {
        String location = "getPingOnly";
        boolean retVal = false;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "ping-only", Boolean.valueOf(retVal).toString());
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Boolean getPingActive() {
        String location = "getPingActive";
        boolean retVal = false;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "ping-active", Boolean.valueOf(retVal).toString());
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Boolean getPingerReportedServiceHealth() {
        String location = "getPingerReportedServiceHealth";
        boolean retVal = true;
        try {
            String value = ServiceInterpreter.getValue(this.meta, "service-healthy", Boolean.valueOf(retVal).toString());
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getServiceClass() {
        String location = "getServiceClass";
        String retVal = "";
        try {
            String serviceClass;
            retVal = serviceClass = ServiceInterpreter.getValue(this.meta, "service-class", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getErrorText() {
        String location = "getErrorText";
        String retVal = "";
        try {
            String errorText;
            retVal = errorText = ServiceInterpreter.getValue(this.meta, "submit-error", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Long getLastUse() {
        String location = "getLastUse";
        Long retVal = this.placeholderLastUse;
        try {
            String value = ServiceInterpreter.getUninterpreted(this.meta, "last-use");
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Long getInstances() {
        String location = "getInstances";
        Long retVal = this.placeholderInstances;
        try {
            String value = ServiceInterpreter.getUninterpreted(this.meta, "instances");
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public ArrayList<String> getImplementors() {
        String location = "getImplementors";
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            String[] implementors;
            String value = ServiceInterpreter.getUninterpreted(this.meta, "implementors");
            for (String implementor : implementors = ServiceInterpreter.getList(value)) {
                retVal.add(implementor);
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Long getDeployments() {
        String location = "getDeployments";
        Long retVal = this.placeholderDeployments;
        try {
            Long deployments;
            ArrayList<String> implementors = this.getImplementors();
            retVal = deployments = new Long(implementors.size());
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getUser() {
        String location = "getUser";
        String retVal = this.placeholderUser;
        try {
            String user;
            retVal = user = ServiceInterpreter.getValue(this.meta, "user", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getSchedulingClass() {
        String location = "getSchedulingClass";
        String retVal = this.placeholderSchedulingClass;
        try {
            String schedulingClass;
            retVal = schedulingClass = ServiceInterpreter.getValue(this.svc, "scheduling_class", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Long getSize() {
        String location = "getSize";
        Long retVal = this.placeholderSize;
        String value = "?";
        try {
            value = ServiceInterpreter.getUninterpreted(this.svc, "process_memory_size");
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            duccLogger.debug(location, jobid, new Object[]{"id:" + this.getId() + " " + "size:" + value});
        }
        return retVal;
    }

    public String getDescription() {
        String location = "getDescription";
        String retVal = this.placeholderDescription;
        try {
            String description;
            retVal = description = ServiceInterpreter.getValue(this.svc, "description", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private Boolean getAutostart() {
        String location = "getAutostart";
        Boolean retVal = new Boolean(false);
        try {
            String value = ServiceInterpreter.getValue(this.meta, "autostart", "false");
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private boolean isAutostart() {
        return this.getAutostart();
    }

    private Boolean getReference() {
        String location = "getReference";
        Boolean retVal = new Boolean(true);
        try {
            Boolean implementors;
            String value = ServiceInterpreter.getValue(this.meta, "reference", "true");
            retVal = Boolean.valueOf(value);
            if (!retVal.booleanValue() && !(implementors = this.isImplementers()).booleanValue()) {
                retVal = new Boolean(true);
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private boolean isReference() {
        return this.getReference();
    }

    private Boolean isImplementers() {
        String location = "isImplementers";
        Boolean retVal = new Boolean(false);
        try {
            String value = ServiceInterpreter.getValue(this.meta, "implementors", "");
            String implementors = value.trim();
            if (implementors.length() > 0) {
                retVal = new Boolean(true);
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private Boolean getEnabled() {
        String location = "getEnabled";
        Boolean retVal = new Boolean(true);
        try {
            String value = ServiceInterpreter.getValue(this.meta, "enabled", "true");
            retVal = Boolean.valueOf(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public String getDisableReason() {
        String location = "getDisableReason";
        String retVal = this.placeholderDisableReason;
        try {
            String value;
            retVal = value = ServiceInterpreter.getValue(this.meta, "disable-reason", "");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private int getStateOrdinality() {
        String location = "getStateOrdinality";
        int retVal = 0;
        try {
            String state = this.getState();
            IService.ServiceState serviceState = IService.ServiceState.valueOf((String)state);
            retVal = serviceState.ordinality();
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public StartState getStartState() {
        StartState retVal = StartState.Unknown;
        if (this.isAutostart()) {
            retVal = StartState.Autostart;
        } else {
            int ordinality = this.getStateOrdinality();
            if (ordinality > 3) {
                retVal = this.isReference() ? StartState.Reference : StartState.Manual;
            } else if (ordinality < 4) {
                retVal = StartState.Stopped;
            }
        }
        return retVal;
    }

    public boolean isDisabled() {
        Boolean enabled = this.getEnabled();
        boolean retVal = true;
        if (enabled.booleanValue()) {
            retVal = false;
        }
        return retVal;
    }

    public static enum StartState {
        Autostart,
        Reference,
        Manual,
        Stopped,
        Unknown;

    }
}

