/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.FileHelper;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;

public class DuccFile {
    private static String ducc_ling = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());

    public static TreeMap<String, File> getFilesInLogDirectory(IDuccWorkJob job, String user) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        TreeMap<String, File> map = new TreeMap<String, File>();
        try {
            File[] filelist;
            File filedir = new File(directory);
            for (File file : filelist = filedir.listFiles()) {
                map.put(file.getName(), file);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return map;
    }

    public static Properties getUserSpecifiedProperties(IDuccWorkJob job, String user) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "specified-by-user.properties";
        Properties properties = null;
        try {
            properties = DuccFile.getProperties(directory + name, user);
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    public static Properties getFileSpecifiedProperties(IDuccWorkJob job, String user) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "specified-by-file.properties";
        Properties properties = null;
        try {
            properties = DuccFile.getProperties(directory + name, user);
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    public static Properties getJobProperties(IDuccWorkJob job, String user) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        String name = "job-specification.properties";
        Properties properties = DuccFile.getProperties(directory + name, user);
        return properties;
    }

    public static Properties getManagedReservationProperties(IDuccWorkJob job, String user) throws Throwable {
        String directory = job.getUserLogsDir() + job.getDuccId().getFriendly() + File.separator;
        try {
            String hack_name = "process.properties";
            Properties hack_properties = DuccFile.getProperties(directory + hack_name, user);
            if (!hack_properties.isEmpty()) {
                return hack_properties;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "managed-reservation.properties";
        Properties properties = DuccFile.getProperties(directory + name);
        return properties;
    }

    private static Properties getProperties(String path) throws IOException {
        FileInputStream fis = null;
        try {
            File file = new File(path);
            fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            return properties;
        }
        catch (IOException e) {
            if (fis != null) {
                fis.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String path, String user) throws Throwable {
        if (user == null) {
            return DuccFile.getProperties(path);
        }
        StringReader sir = null;
        try {
            AlienFile alienFile = new AlienFile(user, path, ducc_ling);
            String data = alienFile.getString();
            sir = new StringReader(data);
            Properties properties = new Properties();
            properties.load(sir);
            sir.close();
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                if (sir != null) {
                    sir.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    private static InputStreamReader getInputStreamReader(String path) throws IOException {
        InputStreamReader isr = null;
        FileInputStream fis = new FileInputStream(path);
        DataInputStream dis = new DataInputStream(fis);
        if (FileHelper.isGzFileType((String)path)) {
            GZIPInputStream gis = new GZIPInputStream(dis);
            isr = new InputStreamReader((InputStream)gis, FileHelper.encoding);
        } else {
            isr = new InputStreamReader(dis);
        }
        return isr;
    }

    public static InputStreamReader getInputStreamReader(String path, String user) throws Throwable {
        if (user == null) {
            return DuccFile.getInputStreamReader(path);
        }
        AlienFile alienFile = new AlienFile(user, path, ducc_ling);
        return alienFile.getInputStreamReader();
    }
}

